/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.statistics.impl;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.entity.work.statistics.CompanyClassCCount;
import cn.smarthse.modules.health.supervise.dao.statistics.ICompanyClassCCountMapper;
import cn.smarthse.modules.health.supervise.model.grade.ClassCCountParamter;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RecService;
import cn.smarthse.modules.health.supervise.service.statistics.ICompanyClassCCountService;
import cn.smarthse.modules.health.supervise.vo.statistics.ComClassCGraphViewModel;
import cn.smarthse.modules.health.supervise.vo.statistics.CompanyClassCCountModel;
import cn.smarthse.modules.health.supervise.vo.statistics.CompanyClassCCountSearchVo;
import cn.smarthse.modules.platform.model.AreaModel;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class ICompanyClassCCountServiceImpl
extends BaseServiceImpl<ICompanyClassCCountMapper, CompanyClassCCount>
implements ICompanyClassCCountService {
    @Autowired
    private ICompanyGradeV3RecService companyGradeV3RecService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;

    public PageInfo<CompanyClassCCountModel> listData(JqGridParam jParam, CompanyClassCCountSearchVo searchVo) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        List<CompanyClassCCountModel> list = this.getListBySearchVo(searchVo);
        return new PageInfo(list);
    }

    public List<CompanyClassCCountModel> getListBySearchVo(CompanyClassCCountSearchVo searchVo) {
        if (searchVo.getAreaLevel() >= 3) {
            return new ArrayList<CompanyClassCCountModel>();
        }
        String groupby = "";
        String groupbyName = "";
        if (searchVo != null) {
            if (Objects.equals(searchVo.getShowCity(), true)) {
                groupby = "city_id";
                groupbyName = "city_name";
            } else if (Objects.equals(searchVo.getShowArea(), true)) {
                groupby = "area_id";
                groupbyName = "area_name";
            } else {
                Byte areaLevel = searchVo.getAreaLevel();
                if (Objects.equals(areaLevel, (byte)0)) {
                    groupby = "province_id";
                    groupbyName = "province_name";
                } else if (Objects.equals(areaLevel, (byte)1)) {
                    groupby = "city_id";
                    groupbyName = "city_name";
                } else if (Objects.equals(areaLevel, (byte)2)) {
                    groupby = "area_id";
                    groupbyName = "area_name";
                } else if (Objects.equals(areaLevel, (byte)3)) {
                    groupby = "street_id";
                    groupbyName = "street_name";
                } else if (Objects.equals(areaLevel, (byte)4)) {
                    groupby = "street_id";
                    groupbyName = "street_name";
                }
            }
        }
        searchVo.setGroupBy(groupby);
        searchVo.setGroupByName(groupbyName);
        searchVo.setDataYear(Integer.valueOf(DateUtils.getGradeYear()));
        List<CompanyClassCCountModel> listBySearchVo = ((ICompanyClassCCountMapper)this.dao).getListBySearchVo(searchVo);
        if (CollectionUtils.isNotEmpty(listBySearchVo)) {
            for (CompanyClassCCountModel companyClassCCountModel : listBySearchVo) {
                Integer nowTotal = companyClassCCountModel.getNowTotal();
                Integer lastYearTotal = companyClassCCountModel.getLastYearTotal();
                if (nowTotal == null) {
                    nowTotal = 0;
                }
                if (lastYearTotal == null) {
                    lastYearTotal = 0;
                }
                companyClassCCountModel.setChangeCount(Integer.valueOf(nowTotal - lastYearTotal));
                if (lastYearTotal == 0) continue;
                BigDecimal a = new BigDecimal(String.valueOf(nowTotal));
                BigDecimal b = new BigDecimal(String.valueOf(lastYearTotal));
                double subtract = a.subtract(b).divide(b, 4, 4).multiply(new BigDecimal("100")).doubleValue();
                companyClassCCountModel.setChangeRate(Double.valueOf(subtract));
            }
        }
        return listBySearchVo;
    }

    public CompanyClassCCountModel getByAreaId(CompanyClassCCountSearchVo searchVo) {
        if (searchVo.getAreaId() == null) {
            return null;
        }
        searchVo.setDataYear(Integer.valueOf(DateUtils.getGradeYear()));
        CompanyClassCCountModel model = ((ICompanyClassCCountMapper)this.dao).getByAreaId(searchVo);
        AreaModel area = this.sysAreaProvideService.getAreaById(searchVo.getAreaId());
        model.setAreaId(area.getId());
        model.setAreaName(area.getName());
        model.setAreaLevel(area.getLevel());
        Integer nowTotal = model.getNowTotal();
        Integer lastYearTotal = model.getLastYearTotal();
        if (nowTotal == null) {
            nowTotal = 0;
        }
        if (lastYearTotal == null) {
            lastYearTotal = 0;
        }
        model.setChangeCount(Integer.valueOf(nowTotal - lastYearTotal));
        if (lastYearTotal != 0) {
            BigDecimal a = new BigDecimal(String.valueOf(nowTotal));
            BigDecimal b = new BigDecimal(String.valueOf(lastYearTotal));
            double subtract = a.subtract(b).divide(b, 4, 4).multiply(new BigDecimal("100")).doubleValue();
            model.setChangeRate(Double.valueOf(subtract));
        }
        return model;
    }

    @Transactional(readOnly=false)
    public void companyClassCCountTask() {
        List list = this.companyGradeV3RecService.getAllComClassCCountData();
        if (list == null || list.size() == 0) {
            return;
        }
        Integer year = DateUtils.getGradeYear();
        Integer dataYear = ((ICompanyClassCCountMapper)this.dao).getLastDataYear();
        Map<Object, Object> map = new HashMap();
        map = !year.equals(dataYear) ? ((ICompanyClassCCountMapper)this.dao).getListByDataYear(dataYear) : ((ICompanyClassCCountMapper)this.dao).getListByDataYear(year);
        ((ICompanyClassCCountMapper)this.dao).deleteByDataYear(year);
        this.handBatch(map, year, list, l -> ((ICompanyClassCCountMapper)this.dao).batchInsertData((List<CompanyClassCCount>)l));
    }

    private int handBatch(Map<Long, CompanyClassCCount> map, Integer year, List<CompanyClassCCount> dataList, Function<List<CompanyClassCCount>, Integer> consumer) {
        if (year == null) {
            return 0;
        }
        int pointsDataLimit = 1000;
        int listSize = dataList.size();
        int maxSize = listSize - 1;
        int n = 0;
        ArrayList<CompanyClassCCount> newList = new ArrayList<CompanyClassCCount>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int i = 0; i < dataList.size(); ++i) {
            CompanyClassCCount item = dataList.get(i);
            if (item == null) continue;
            item.setId(Long.valueOf(this.idworker.nextId()));
            item.setDataYear(year);
            item.setCreateDate(new Date());
            item.setUpdateDate(new Date());
            CompanyClassCCount before = map.get(item.getCid());
            if (before != null) {
                if (StringUtils.isEmpty((CharSequence)before.getHistoryGrade()) && before.getGrade() != null) {
                    item.setHistoryGrade(before.getGrade() + ",");
                    item.setHistoryGradeTime(dateFormat.format(before.getGradeTime()) + ",");
                } else if (before.getGrade() != null && !before.getGrade().equals(item.getGrade())) {
                    item.setHistoryGrade(before.getHistoryGrade() + item.getGrade() + ",");
                    item.setHistoryGradeTime(before.getHistoryGradeTime() + dateFormat.format(item.getGradeTime()) + ",");
                } else {
                    item.setHistoryGrade(before.getHistoryGrade());
                    item.setHistoryGradeTime(before.getHistoryGradeTime());
                }
            } else {
                item.setHistoryGrade(item.getGrade() + ",");
                if (item.getGradeTime() != null) {
                    item.setHistoryGradeTime(dateFormat.format(item.getGradeTime()) + ",");
                }
            }
            newList.add(item);
            if (pointsDataLimit != newList.size() && i != maxSize) continue;
            int count = consumer.apply(newList);
            n += count;
            newList.clear();
        }
        return n;
    }

    public ComClassCGraphViewModel graphView(CompanyClassCCountSearchVo searchVo) {
        ComClassCGraphViewModel model = new ComClassCGraphViewModel();
        if (searchVo.getAreaId() == null) {
            return null;
        }
        AreaModel area = this.sysAreaProvideService.getAreaById(searchVo.getAreaId());
        List<ComClassCGraphViewModel> list = ((ICompanyClassCCountMapper)this.dao).getGraphViewByAreaId(searchVo);
        model.setAreaId(area.getId());
        model.setAreaName(area.getName());
        model.setDataYears(list.stream().map(ComClassCGraphViewModel::getDataYear).map(String::valueOf).collect(Collectors.joining(",")));
        model.setTotals(list.stream().map(ComClassCGraphViewModel::getComTotal).map(String::valueOf).collect(Collectors.joining(",")));
        return model;
    }

    public List<CompanyClassCCountModel> getListByAreaIds(List<Long> areaIds, Boolean containUnEvaluate, Boolean containLess3Result) {
        ArrayList<CompanyClassCCountModel> list = new ArrayList<CompanyClassCCountModel>();
        if (areaIds == null || areaIds.size() == 0) {
            return list;
        }
        Byte areaLevel = null;
        for (Long areaId : areaIds) {
            AreaModel area = this.sysAreaProvideService.getAreaById(areaId);
            if (area == null) continue;
            areaLevel = area.getLevel();
            break;
        }
        if (containUnEvaluate == null || containUnEvaluate.booleanValue()) {
            // empty if block
        }
        String groupby = "";
        String groupbyName = "";
        if (Objects.equals(areaLevel, (byte)1)) {
            groupby = "province_id";
            groupbyName = "province_name";
        } else if (Objects.equals(areaLevel, (byte)2)) {
            groupby = "city_id";
            groupbyName = "city_name";
        } else if (Objects.equals(areaLevel, (byte)3)) {
            groupby = "area_id";
            groupbyName = "area_name";
        } else if (Objects.equals(areaLevel, (byte)4)) {
            groupby = "street_id";
            groupbyName = "street_name";
        } else {
            groupby = "id";
            groupbyName = "name";
        }
        Integer year = DateUtils.getGradeYear();
        int maxSize = 500;
        int page = (int)Math.ceil((double)areaIds.size() * 1.0 / (double)maxSize);
        for (int i = 0; i < page; ++i) {
            List subIds = areaIds.stream().skip(i * maxSize).limit(maxSize).collect(Collectors.toList());
            ClassCCountParamter paramter = new ClassCCountParamter();
            paramter.setSubIds(subIds);
            paramter.setGroupby(groupby);
            paramter.setGroupbyName(groupbyName);
            paramter.setYear(year);
            paramter.setContainLess3Result(containLess3Result);
            paramter.setContainLess3Result(containLess3Result);
            List<CompanyClassCCountModel> modelList = ((ICompanyClassCCountMapper)this.dao).getListByAreaIds(paramter);
            list.addAll(modelList);
        }
        return list;
    }
}

