/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.staff.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.IDCardUtil;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.system.SysParamModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysParamProvideService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.enums.check.ExamResultEnum;
import cn.smarthse.modules.health.enums.staff.StaffMaritalStatusEnum;
import cn.smarthse.modules.health.supervise.dao.staff.SuperviseStaffInfoMapper;
import cn.smarthse.modules.health.supervise.service.check.ISupervisePhcPhysicalCheckService;
import cn.smarthse.modules.health.supervise.service.company.IThirdCompanyService;
import cn.smarthse.modules.health.supervise.service.harmFactor.IWorkHarmFactorService;
import cn.smarthse.modules.health.supervise.service.staff.ISuperviseStaffInfoService;
import cn.smarthse.modules.health.supervise.vo.staff.ThirdOrgInfo;
import cn.smarthse.modules.health.supervise.vo.staff.ThirdStaffInfoVo;
import cn.smarthse.modules.health.supervise.vo.staff.ThirdStaffSearchVo;
import cn.smarthse.modules.health.supervise.vo.staff.ThirdStaffVo;
import cn.smarthse.modules.health.supervise.vo.staff.ThirdWorkHarmInfo;
import cn.smarthse.modules.health.supervise.vo.staff.ThirdWorkInfo;
import cn.smarthse.modules.health.supervise.vo.staff.VictimsVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class SuperviseStaffInfoServiceImpl
implements ISuperviseStaffInfoService {
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService companyProvideByHSEService;
    @Autowired
    IWorkHarmFactorService workHarmFactorService;
    @DubboReference(version="1.0.0")
    ISysAreaProvideService sysAreaProvideService;
    @Autowired
    private SuperviseStaffInfoMapper superviseStaffInfoMapper;
    @DubboReference(version="1.0.0")
    private ISysParamProvideService sysParamProvideService;
    @Autowired
    private ISupervisePhcPhysicalCheckService supervisePhcPhysicalCheckService;
    @DubboReference(version="1.0.0")
    private IHarmFactorService harmFactorService;
    @Autowired
    private IThirdCompanyService thirdCompanyService;
    private static final String VICTIMS_STAFF_NUM = "victims_staff_num";

    public Integer getSuperviseStaffInfoCountByCids(List<Long> cids) {
        return this.superviseStaffInfoMapper.getSuperviseStaffInfoCountByCids(cids);
    }

    public Map<Long, Integer> collectVictimsNum() {
        List<VictimsVo> datalist = this.superviseStaffInfoMapper.collectVictimsNum();
        HashMap<Long, Integer> staffCache = new HashMap<Long, Integer>();
        if (CollectionUtils.isNotEmpty(datalist)) {
            for (VictimsVo vo : datalist) {
                staffCache.put(vo.getCid(), vo.getStaffNum());
            }
        }
        return staffCache;
    }

    public ThirdStaffInfoVo getThirdStaffInfoVoByStaffId(Long staffId) {
        SysParamModel sysParam;
        ThirdStaffInfoVo vo = this.superviseStaffInfoMapper.getStaffDetailById(staffId);
        if (vo == null) {
            vo = new ThirdStaffInfoVo();
            vo.setStaffId(staffId);
            return vo;
        }
        vo.setIdCard(SpringEncryptUtils.decrypt((String)vo.getIdCard()));
        vo.setRealName(SpringEncryptUtils.decrypt((String)vo.getRealName()));
        vo.setMobile(SpringEncryptUtils.decrypt((String)vo.getMobile()));
        if (vo.getEducation() != null && (sysParam = this.sysParamProvideService.getById(vo.getEducation())) != null) {
            vo.setEducationName(sysParam.getParamValue());
        }
        if (vo.getGender() == null) {
            vo.setGenderName("");
        } else if (vo.getGender() == 1) {
            vo.setGenderName("\u7537");
        } else if (vo.getGender() == 0) {
            vo.setGenderName("\u5973");
        }
        if (vo.getMaritalStatus() != null) {
            if (vo.getMaritalStatus() == StaffMaritalStatusEnum.DISSOCIATON.getCode()) {
                vo.setMaritalName(StaffMaritalStatusEnum.DISSOCIATON.getName());
            } else if (vo.getMaritalStatus() == StaffMaritalStatusEnum.MARRIED.getCode()) {
                vo.setMaritalName(StaffMaritalStatusEnum.MARRIED.getName());
            } else if (vo.getMaritalStatus() == StaffMaritalStatusEnum.UNMARRIED.getCode()) {
                vo.setMaritalName(StaffMaritalStatusEnum.UNMARRIED.getName());
            }
        }
        return vo;
    }

    public ThirdStaffVo getStaffInfoByIdCard(String idCard) {
        ThirdStaffVo staff = this.superviseStaffInfoMapper.getStaffInfoByIdCard(idCard);
        return staff;
    }

    public List<ThirdWorkHarmInfo> getStaffWorkHarmInfoByStaffId(Long staffId) {
        List<ThirdWorkHarmInfo> list = this.superviseStaffInfoMapper.getStaffWorkHarmInfoByStaffId(staffId);
        for (ThirdWorkHarmInfo vo : list) {
            ThirdOrgInfo org;
            vo.setWorkName("");
            if (vo.getWorkRoleId() == null) continue;
            vo.setHarmNames(this.workHarmFactorService.getHarmNameByWorkId(vo.getWorkRoleId()));
            ThirdWorkInfo work = this.superviseStaffInfoMapper.getThirdWorkInfoById(vo.getWorkRoleId());
            if (work == null) continue;
            vo.setWorkName(work.getWorkName() + "/");
            if (work.getOrgId() == null || (org = this.superviseStaffInfoMapper.getThirdOrgInfoById(work.getOrgId())) == null) continue;
            vo.setWorkName(vo.getWorkName() + org.getOrgName());
        }
        return list;
    }

    public PageInfo<ThirdWorkHarmInfo> getStaffWorkHarmInfoPageByStaffId(JqGridParam jParam, Long staffId) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        Page list = (Page)this.getStaffWorkHarmInfoByStaffId(staffId);
        PageInfo finalPageInfo = new PageInfo((List)list);
        return finalPageInfo;
    }

    public PageInfo<ThirdWorkHarmInfo> getStaffWorkHarmInfoPageByIdCard(JqGridParam jParam, String idCard) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        List<ThirdWorkHarmInfo> list = this.superviseStaffInfoMapper.getStaffWorkHarmInfoByIdCard(SpringEncryptUtils.encrypt((String)idCard));
        for (ThirdWorkHarmInfo vo : list) {
            ThirdOrgInfo org;
            vo.setWorkName("");
            if (vo.getWorkRoleId() == null) continue;
            vo.setHarmNames(this.workHarmFactorService.getHarmNameByWorkId(vo.getWorkRoleId()));
            ThirdWorkInfo work = this.superviseStaffInfoMapper.getThirdWorkInfoById(vo.getWorkRoleId());
            if (work == null) continue;
            vo.setWorkName(work.getWorkName() + "/");
            if (work.getOrgId() == null || (org = this.superviseStaffInfoMapper.getThirdOrgInfoById(work.getOrgId())) == null) continue;
            vo.setWorkName(vo.getWorkName() + org.getOrgName());
        }
        PageInfo finalPageInfo = new PageInfo(list);
        return finalPageInfo;
    }

    public PageInfo<ThirdStaffVo> pageEmployeeVoBySearch(JqGridParam jParam, ThirdStaffSearchVo searchVo) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        searchVo.setSearchKeyEncrypt(searchVo.getSearchKey());
        List<ThirdStaffVo> list = this.superviseStaffInfoMapper.listStaffVoBySearch(searchVo);
        String idCard = "";
        for (ThirdStaffVo vo : list) {
            vo.setIdCard(SpringEncryptUtils.decrypt((String)vo.getIdCard()));
            vo.setRealName(SpringEncryptUtils.decrypt((String)vo.getRealName()));
            if (vo != null) {
                idCard = vo.getIdCard();
                vo.setGenderName(IDCardUtil.getGenderName((String)idCard));
                DesensitizationUtils.setDesensitizationFieldFromObject((Object)vo);
            }
            if (vo.getHarmIds() != null) {
                vo.setHarmNames(this.harmFactorService.getHarmNames(vo.getHarmIds()));
            }
            if (vo.getPhysicalResult() == null) continue;
            vo.setPhysicalResultName(ExamResultEnum.getName((String)vo.getPhysicalResult()));
        }
        PageInfo finalPageInfo = new PageInfo(list);
        return finalPageInfo;
    }

    public List<ThirdStaffVo> employeeVoAllList() {
        ThirdStaffSearchVo searchVo = new ThirdStaffSearchVo();
        List<ThirdStaffVo> list = this.superviseStaffInfoMapper.listStaffVoBySearch(searchVo);
        for (ThirdStaffVo vo : list) {
            vo.setRealName(SpringEncryptUtils.decrypt((String)vo.getRealName()));
            vo.setIdCard(SpringEncryptUtils.decrypt((String)vo.getIdCard()));
            if (vo.getHarmIds() != null) {
                vo.setHarmNames(this.harmFactorService.getHarmNames(vo.getHarmIds()));
            }
            if (vo.getPhysicalResult() == null) continue;
            vo.setPhysicalResultName(ExamResultEnum.getName((String)vo.getPhysicalResult()));
        }
        return list;
    }

    public List<ThirdStaffVo> listStaffVoDataBySearch(ThirdStaffSearchVo searchVo) {
        searchVo.setSearchKeyEncrypt(searchVo.getSearchKey());
        List<ThirdStaffVo> list = this.superviseStaffInfoMapper.listStaffVoBySearch(searchVo);
        Map allIdAndNameMap = this.harmFactorService.getAllIdAndNameMap();
        for (ThirdStaffVo vo : list) {
            vo.setIdCard(SpringEncryptUtils.decrypt((String)vo.getIdCard()));
            vo.setRealName(SpringEncryptUtils.decrypt((String)vo.getRealName()));
            if (vo.getGenderName() == null) {
                vo.setGenderName(IDCardUtil.getGenderName((String)vo.getIdCard()));
            }
            vo.setHarmNames(this.getHarmNamesByIds(vo.getHarmIds(), allIdAndNameMap));
            vo.setOccHarmNames(this.getHarmNamesByIds(vo.getOccHarmIds(), allIdAndNameMap));
            vo.setCheckHarmNames(this.getHarmNamesByIds(vo.getCheckHarmIds(), allIdAndNameMap));
            if (vo.getPhysicalResult() == null) continue;
            vo.setPhysicalResultName(ExamResultEnum.getName((String)vo.getPhysicalResult()));
        }
        return list;
    }

    public Map<Long, Long> getStaffInfoRadiationCountByCids(List<Long> cidList) {
        HashMap<Long, Long> staffInfoRadiation = new HashMap<Long, Long>();
        if (CollectionUtils.isEmpty(cidList)) {
            return staffInfoRadiation;
        }
        List<CompanyBaseInfoModel> staffList = this.superviseStaffInfoMapper.selectStaffInfoRadiationCountByCids(cidList);
        if (CollectionUtils.isEmpty(staffList)) {
            return staffInfoRadiation;
        }
        return staffList.stream().filter(s -> ObjectUtil.isNotNull((Object)s.getCid())).collect(Collectors.groupingBy(CompanyBaseInfoModel::getCid, Collectors.counting()));
    }

    private String getHarmNamesByIds(String checkHarmIds, Map<String, String> allIdAndNameMap) {
        if (checkHarmIds == null || checkHarmIds.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : checkHarmIds.split(",")) {
            String factorName = allIdAndNameMap.get(s);
            if (factorName == null || factorName.isEmpty()) continue;
            sb.append(factorName);
            sb.append(",");
        }
        if (sb.length() == 0) {
            return "";
        }
        return sb.substring(0, sb.length() - 1);
    }

    public PageInfo<ThirdStaffVo> pageCompanyStaffVoBySearch(JqGridParam jParam, ThirdStaffSearchVo searchVo) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        searchVo.setSearchKeyEncrypt(searchVo.getSearchKey());
        List<ThirdStaffVo> list = this.superviseStaffInfoMapper.listCompanyStaffVoBySearch(searchVo);
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(l -> {
                l.setRealName(SpringEncryptUtils.decrypt((String)l.getRealName()));
                l.setIdCard(SpringEncryptUtils.decrypt((String)l.getIdCard()));
            });
        }
        PageInfo finalPageInfo = new PageInfo(list);
        return finalPageInfo;
    }

    public List<ThirdStaffInfoVo> getStaffByCompanyAndArea(ThirdStaffSearchVo thirdStaffSearchVo) {
        return this.superviseStaffInfoMapper.getStaffByCompanyAndArea(thirdStaffSearchVo);
    }
}

