/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.servicedemand;

import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.entity.work.servicedemand.vo.EducationTrainServiceDemandVo;
import cn.smarthse.modules.health.entity.work.servicedemand.vo.EvaluateWorkServiceDemandVo;
import cn.smarthse.modules.health.entity.work.servicedemand.vo.HarmInspectServiceDemandVo;
import cn.smarthse.modules.health.entity.work.servicedemand.vo.HealthCheckServiceDemandVo;
import cn.smarthse.modules.health.enums.servicedemand.ServiceDemandTypeEnum;
import cn.smarthse.modules.health.service.work.servicedemand.IEducationTrainServiceDemandService;
import cn.smarthse.modules.health.service.work.servicedemand.IEvaluateWorkServiceDemandService;
import cn.smarthse.modules.health.service.work.servicedemand.IHarmInspectServiceDemandService;
import cn.smarthse.modules.health.service.work.servicedemand.IHealthCheckServiceDemandService;
import cn.smarthse.modules.health.supervise.service.servicedemand.IThirdServiceDemandService;
import cn.smarthse.modules.health.supervise.vo.servicedemand.ThirdServiceDemandVo;
import cn.smarthse.modules.platform.model.AreaModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class ThirdServiceDemandServiceImpl
implements IThirdServiceDemandService {
    @DubboReference
    private IEducationTrainServiceDemandService educationTrainServiceDemandService;
    @DubboReference
    private IEvaluateWorkServiceDemandService evaluateWorkServiceDemandService;
    @DubboReference
    private IHarmInspectServiceDemandService harmInspectServiceDemandService;
    @DubboReference
    private IHealthCheckServiceDemandService healthCheckServiceDemandService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;

    public List<ThirdServiceDemandVo> getList() {
        List<Object> list = new ArrayList();
        list.addAll(this.healthCheckServiceDemandService.getNoExpireList().stream().map(s -> {
            ThirdServiceDemandVo vo = new ThirdServiceDemandVo();
            vo.setType(ServiceDemandTypeEnum.check);
            BeanUtils.copyProperties((Object)s, (Object)vo);
            return vo;
        }).collect(Collectors.toList()));
        list.addAll(this.harmInspectServiceDemandService.getNoExpireList().stream().map(s -> {
            ThirdServiceDemandVo vo = new ThirdServiceDemandVo();
            vo.setType(ServiceDemandTypeEnum.inspect);
            BeanUtils.copyProperties((Object)s, (Object)vo);
            return vo;
        }).collect(Collectors.toList()));
        list.addAll(this.educationTrainServiceDemandService.getNoExpireList().stream().map(s -> {
            ThirdServiceDemandVo vo = new ThirdServiceDemandVo();
            vo.setType(ServiceDemandTypeEnum.education);
            BeanUtils.copyProperties((Object)s, (Object)vo);
            return vo;
        }).collect(Collectors.toList()));
        list.addAll(this.evaluateWorkServiceDemandService.getNoExpireList().stream().map(s -> {
            ThirdServiceDemandVo vo = new ThirdServiceDemandVo();
            vo.setType(ServiceDemandTypeEnum.evaluate);
            BeanUtils.copyProperties((Object)s, (Object)vo);
            return vo;
        }).collect(Collectors.toList()));
        list = list.stream().sorted(Comparator.comparing(ThirdServiceDemandVo::getPublishingDate).reversed()).collect(Collectors.toList());
        list.forEach(s -> {
            CompanyBaseInfoModel cbm;
            AreaModel am = this.sysAreaProvideService.getAreaById(s.getLocationAreaId());
            if (am != null) {
                s.setLocationName(am.getProvinceName() + "/" + am.getCityName());
            }
            if ((cbm = this.companyProvideByHSEService.getCompanyById(s.getCid())) != null) {
                s.setCompanyName(cbm.getName());
                s.setIndustryName(cbm.getIndustryCategoryName());
            }
        });
        return list;
    }

    public HealthCheckServiceDemandVo getHealthCheckServiceDemandVoById(Long id) {
        AreaModel am;
        HealthCheckServiceDemandVo vo = this.healthCheckServiceDemandService.getVoById(id);
        if (vo != null && vo.getLocationAreaId() != null && (am = this.sysAreaProvideService.getAreaById(vo.getLocationAreaId())) != null) {
            vo.setLocationName(am.getFullname() + vo.getLocationDetail());
        }
        return vo;
    }

    public HarmInspectServiceDemandVo getHarmInspectServiceDemandVoById(Long id) {
        AreaModel am;
        HarmInspectServiceDemandVo vo = this.harmInspectServiceDemandService.getVoById(id);
        if (vo != null && vo.getLocationAreaId() != null && (am = this.sysAreaProvideService.getAreaById(vo.getLocationAreaId())) != null) {
            vo.setLocationName(am.getFullname() + vo.getLocationDetail());
        }
        return vo;
    }

    public EducationTrainServiceDemandVo getEducationTrainServiceDemandVoById(Long id) {
        AreaModel am;
        EducationTrainServiceDemandVo vo = this.educationTrainServiceDemandService.getVoById(id);
        if (vo != null && vo.getLocationAreaId() != null && (am = this.sysAreaProvideService.getAreaById(vo.getLocationAreaId())) != null) {
            vo.setLocationName(am.getFullname() + vo.getLocationDetail());
        }
        return vo;
    }

    public EvaluateWorkServiceDemandVo getEvaluateWorkServiceDemandVoById(Long id) {
        AreaModel am;
        EvaluateWorkServiceDemandVo vo = this.evaluateWorkServiceDemandService.getVoById(id);
        if (vo != null && vo.getLocationAreaId() != null && (am = this.sysAreaProvideService.getAreaById(vo.getLocationAreaId())) != null) {
            vo.setLocationName(am.getFullname() + vo.getLocationDetail());
        }
        return vo;
    }
}

