/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.selfjudge.impl;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.entity.base.selfjudge.CompanyHsePreventionControlSelfJudge;
import cn.smarthse.modules.health.entity.base.selfjudge.OccupationalSelfJudgeRecord;
import cn.smarthse.modules.health.entity.base.selfjudge.OccupationalSelfJudgeTermV308;
import cn.smarthse.modules.health.entity.base.selfjudge.OccupationalSelfJudgeV308;
import cn.smarthse.modules.health.entity.base.selfjudge.SelfInspectionRiskAssessmentReportInfo;
import cn.smarthse.modules.health.entity.base.selfjudge.bo.JudgeLevelComNumBo;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.SelfjudgeSearchVo;
import cn.smarthse.modules.health.entity.sys.SysArea;
import cn.smarthse.modules.health.enums.selfjudge.HazardsExposureRiskLevelEnum;
import cn.smarthse.modules.health.enums.selfjudge.HazardsRiskClassifyEnum;
import cn.smarthse.modules.health.enums.selfjudge.JudgeResultLevelEnum;
import cn.smarthse.modules.health.service.base.selfjudge.IOccupationalSelfJudgeTermV308Service;
import cn.smarthse.modules.health.service.base.selfjudge.IOccupationalSelfJudgeV308Service;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionRiskAssessmentReportInfoService;
import cn.smarthse.modules.health.supervise.dao.selfjudge.OccupationalSelfJudgeStatisticMapper;
import cn.smarthse.modules.health.supervise.entity.operate.WorkOperateLog;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogEnum;
import cn.smarthse.modules.health.supervise.model.selfreport.SelfJudgeExposeReportStat;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3Service;
import cn.smarthse.modules.health.supervise.service.operate.IWorkOperateLogService;
import cn.smarthse.modules.health.supervise.service.selfjudge.IOccupationalSelfJudgeStatisticService;
import cn.smarthse.modules.health.supervise.service.sys.ISysAreaService;
import cn.smarthse.modules.health.vo.base.company.gradev3.CompanyGradeVoV314;
import cn.smarthse.modules.health.vo.base.company.gradev3.GradeSearchV314;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class OccupationalSelfJudgeStatisticServiceImp
extends BaseServiceImpl<OccupationalSelfJudgeStatisticMapper, OccupationalSelfJudgeRecord>
implements IOccupationalSelfJudgeStatisticService {
    @Autowired(required=false)
    private OccupationalSelfJudgeStatisticMapper judgeStatisticMapper;
    @Autowired
    private ISysAreaService sysAreaService;
    @DubboReference
    IOccupationalSelfJudgeV308Service occupationalSelfJudgeV308Service;
    @DubboReference
    IOccupationalSelfJudgeTermV308Service occupationalSelfJudgeTermV308Service;
    @Autowired
    private IWorkOperateLogService workOperateLogService;
    @Autowired
    private ICompanyGradeV3Service companyGradeV3Service;
    @DubboReference
    private ISelfInspectionRiskAssessmentReportInfoService selfInspectionRiskAssessmentReportInfoService;

    public String getLastJudgeResultLevel(Long cid) {
        Integer level = 0;
        Example example = new Example(OccupationalSelfJudgeRecord.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("judgeStatus", (Object)2);
        example.setOrderByClause("update_date desc");
        List list = ((OccupationalSelfJudgeStatisticMapper)this.dao).selectByExample(example);
        if (list != null && list.size() > 0) {
            level = ((OccupationalSelfJudgeRecord)list.get(0)).getResultLevel().intValue();
        }
        return level.equals(0) ? "\u672a\u8bc4\u5b9a" : String.valueOf((char)(level + 64));
    }

    public Integer[] countCompanyNum(Long areaId, Byte ownLevel) {
        Integer[] results = new Integer[]{0, 0, 0, 0};
        SysArea area = (SysArea)this.sysAreaService.getById(areaId);
        Integer level = 0;
        if (area != null) {
            level = area.getLevel().intValue();
        }
        int totalComNum = 0;
        totalComNum = areaId.equals(0L) ? this.judgeStatisticMapper.totalCompanyNum().intValue() : this.judgeStatisticMapper.countCompanyNum(areaId, level, ownLevel).intValue();
        List<JudgeLevelComNumBo> list = this.judgeStatisticMapper.queryJudgeLevelComNum(areaId, level, ownLevel);
        int judgeTotalNum = 0;
        for (JudgeLevelComNumBo bo : list) {
            switch (bo.getJudgeLevel().intValue()) {
                case 1: {
                    results[0] = bo.getNum().intValue();
                    judgeTotalNum += results[0].intValue();
                    break;
                }
                case 2: {
                    results[1] = bo.getNum().intValue();
                    judgeTotalNum += results[1].intValue();
                    break;
                }
                case 3: {
                    results[2] = bo.getNum().intValue();
                    judgeTotalNum += results[2].intValue();
                    break;
                }
            }
        }
        results[3] = totalComNum - judgeTotalNum;
        return results;
    }

    public List<Long> getCidByJudgeLevel(Long areaId, Integer judgeLevel) {
        SysArea area = (SysArea)this.sysAreaService.getById(areaId);
        Integer level = 0;
        if (area != null) {
            level = area.getLevel().intValue();
        }
        return ((OccupationalSelfJudgeStatisticMapper)this.dao).getCidByJudgeLevel(judgeLevel, areaId, level);
    }

    public List<Long> getCidHaveJudge(Long areaId) {
        SysArea area = (SysArea)this.sysAreaService.getById(areaId);
        Integer level = 0;
        if (area != null) {
            level = area.getLevel().intValue();
        }
        return ((OccupationalSelfJudgeStatisticMapper)this.dao).getCidHaveJudge(areaId, level);
    }

    public Long countJudgeOutDateComNum(Long areaId, Integer level) {
        return this.judgeStatisticMapper.countJudgeOutDateOrNoJudgeComNum(areaId, level);
    }

    public Long countJudgeWillOutDateComNum(Long areaId, Integer level, Integer days) {
        return this.judgeStatisticMapper.countJudgeWillOutDateComNum(areaId, level, days);
    }

    public PageInfo<OccupationalSelfJudgeRecord> getHistoryList(JqGridParam jqGridParam, Long cid) {
        Example example = new Example(OccupationalSelfJudgeRecord.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("judgeStatus", (Object)2);
        example.setOrderByClause("create_date desc");
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List list = ((OccupationalSelfJudgeStatisticMapper)this.dao).selectByExample(example);
        return new PageInfo(list);
    }

    public PageInfo<OccupationalSelfJudgeV308> getSelfjudgeList(JqGridParam jqGridParam, SelfjudgeSearchVo vo) {
        return this.occupationalSelfJudgeV308Service.getSelfjudgeList(jqGridParam, vo);
    }

    public List<OccupationalSelfJudgeTermV308> getListBySelfId(Long selfId) {
        return this.occupationalSelfJudgeTermV308Service.getListBySelfId(selfId);
    }

    public OccupationalSelfJudgeV308 getOccupationalSelfJudgeV308ById(Long recordId) {
        return this.occupationalSelfJudgeV308Service.getOccupationalSelfJudgeV308ById(recordId);
    }

    @Transactional(readOnly=false)
    public void saveOrgSelfJudge(OccupationalSelfJudgeV308 selfJudgeV308) {
        if (selfJudgeV308.getJudgeStatus() != null && selfJudgeV308.getJudgeStatus() == 2) {
            this.workOperateLogService.report(selfJudgeV308.getId(), WorkOperateLogEnum.selfJudge.getTypeVal(), selfJudgeV308.getCreateBy(), selfJudgeV308.getRegistrant(), selfJudgeV308.getCompanyName());
            selfJudgeV308.setReportDate(new Date());
        }
        this.occupationalSelfJudgeV308Service.saveOrgSelfJudge(selfJudgeV308);
    }

    @Transactional(readOnly=false)
    public void importOccupationalSelfJudgeV308Datas(List<OccupationalSelfJudgeV308> records) {
        List results = this.occupationalSelfJudgeV308Service.importOccupationalSelfJudgeV308Datas(records);
        for (OccupationalSelfJudgeV308 v308 : results) {
            this.workOperateLogService.report(v308.getId(), WorkOperateLogEnum.selfJudge.getTypeVal(), v308.getCreateBy(), v308.getRegistrant(), v308.getJudgeStaffOrgName());
        }
    }

    @Transactional(readOnly=false)
    public void backToThirdOrg(WorkOperateLog log) {
        if (log == null || log.getWorkId() == null) {
            return;
        }
        this.workOperateLogService.back(log.getWorkId(), log.getWorkModule(), log.getReason(), log.getCreateBy(), log.getOperater(), log.getCompanyName());
        this.reback(log.getWorkId(), log.getCreateBy());
    }

    public List<Long> getDifferentCompanyIds() {
        return this.judgeStatisticMapper.getDifferentCompanyIds();
    }

    public String getLastJudgeResultLevelV308(Long cid) {
        Example example = new Example(OccupationalSelfJudgeRecord.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("judgeStatus", (Object)2);
        example.setOrderByClause("update_date desc");
        OccupationalSelfJudgeV308 v308 = this.occupationalSelfJudgeV308Service.getCompleteLastJudge(cid);
        if (v308 != null) {
            return v308.getResultLevelName();
        }
        return "\u672a\u8bc4\u7ea7";
    }

    public OccupationalSelfJudgeV308 getlastJudgeResultV308(Long cid) {
        return this.occupationalSelfJudgeV308Service.getCompleteLastJudge(cid);
    }

    public Map<Long, Long> getSelfJudgeLevelMapByJudgeIds(List<Long> judgeIds) {
        List<CompanyHsePreventionControlSelfJudge> list = ((OccupationalSelfJudgeStatisticMapper)this.dao).getSelfJudgesByJudgeIds(judgeIds);
        Map<Long, Long> map = new HashMap<Long, Long>();
        if (list != null && list.size() > 0) {
            map = list.stream().collect(Collectors.toMap(CompanyHsePreventionControlSelfJudge::getCid, CompanyHsePreventionControlSelfJudge::getJudgeLevel));
        }
        return map;
    }

    public Map<Long, Long> getSelfIdJudgeLevelMapByJudgeIds(List<Long> judgeIds) {
        List<CompanyHsePreventionControlSelfJudge> list = ((OccupationalSelfJudgeStatisticMapper)this.dao).getSelfJudgesByJudgeIds(judgeIds);
        Map<Long, Long> map = new HashMap<Long, Long>();
        if (list != null && list.size() > 0) {
            map = list.stream().distinct().collect(Collectors.toMap(CompanyHsePreventionControlSelfJudge::getId, CompanyHsePreventionControlSelfJudge::getJudgeLevel));
        }
        return map;
    }

    public List<SelfInspectionRiskAssessmentReportInfo> getLatestSelfReportInfos() {
        int num = ((OccupationalSelfJudgeStatisticMapper)this.dao).getReportInfoCount();
        return ((OccupationalSelfJudgeStatisticMapper)this.dao).getLatestSelfReportInfos(num);
    }

    public List<SelfJudgeExposeReportStat> getSelfJudgeExposeReportStatByAreaId(GradeSearchV314 search) {
        List resultList = this.companyGradeV3Service.caegoryListDataV314(search);
        List<SelfJudgeExposeReportStat> list = this.getSelfJudgeExposeReportStatList();
        Map<String, SelfJudgeExposeReportStat> reportStatMap = list.stream().collect(Collectors.toMap(SelfJudgeExposeReportStat::getTypeName, s -> s));
        for (CompanyGradeVoV314 voV314 : resultList) {
            HazardsRiskClassifyEnum hazardsRiskClassifyEnum;
            HazardsExposureRiskLevelEnum exposureRiskLevelEnum;
            JudgeResultLevelEnum judgeResultLevelEnum = JudgeResultLevelEnum.getThisEnumByCode((Integer)voV314.getJudgeLevel());
            if (judgeResultLevelEnum != null) {
                String levelName = judgeResultLevelEnum.getName() + "\u7ea7";
                reportStatMap.get(levelName).setCount(reportStatMap.get(levelName).getCount() + 1);
            }
            if ((exposureRiskLevelEnum = HazardsExposureRiskLevelEnum.getThisEnumByCode((Integer)voV314.getRiskLevel())) != null) {
                String ExposureLevelName = exposureRiskLevelEnum.getName();
                reportStatMap.get(ExposureLevelName).setCount(reportStatMap.get(ExposureLevelName).getCount() + 1);
            }
            if ((hazardsRiskClassifyEnum = HazardsRiskClassifyEnum.getThisEnumByCode((Integer)voV314.getRiskClassify())) == null) continue;
            String riskClassifyName = hazardsRiskClassifyEnum.getName();
            reportStatMap.get(riskClassifyName).setCount(reportStatMap.get(riskClassifyName).getCount() + 1);
        }
        return list;
    }

    private List<SelfJudgeExposeReportStat> getSelfJudgeExposeReportStatList() {
        ArrayList<SelfJudgeExposeReportStat> list = new ArrayList<SelfJudgeExposeReportStat>();
        SelfJudgeExposeReportStat stat = new SelfJudgeExposeReportStat();
        stat.setTitleName("\u7528\u4eba\u5355\u4f4d\u804c\u4e1a\u75c5\u66b4\u9732\u98ce\u9669\u7ea7\u522b");
        stat.setTypeName("\u2162\u7ea7");
        list.add(stat);
        stat = new SelfJudgeExposeReportStat();
        stat.setTitleName("\u7528\u4eba\u5355\u4f4d\u804c\u4e1a\u75c5\u66b4\u9732\u98ce\u9669\u7ea7\u522b");
        stat.setTypeName("\u2161\u7ea7");
        list.add(stat);
        stat = new SelfJudgeExposeReportStat();
        stat.setTitleName("\u7528\u4eba\u5355\u4f4d\u804c\u4e1a\u75c5\u66b4\u9732\u98ce\u9669\u7ea7\u522b");
        stat.setTypeName("\u2160\u7ea7");
        list.add(stat);
        stat = new SelfJudgeExposeReportStat();
        stat.setTitleName("\u804c\u4e1a\u5065\u5eb7\u7ba1\u7406\u72b6\u51b5\u7b49\u7ea7");
        stat.setTypeName("A\u7ea7");
        list.add(stat);
        stat = new SelfJudgeExposeReportStat();
        stat.setTitleName("\u804c\u4e1a\u5065\u5eb7\u7ba1\u7406\u72b6\u51b5\u7b49\u7ea7");
        stat.setTypeName("B\u7ea7");
        list.add(stat);
        stat = new SelfJudgeExposeReportStat();
        stat.setTitleName("\u804c\u4e1a\u5065\u5eb7\u7ba1\u7406\u72b6\u51b5\u7b49\u7ea7");
        stat.setTypeName("C\u7ea7");
        list.add(stat);
        stat = new SelfJudgeExposeReportStat();
        stat.setTitleName("\u804c\u4e1a\u75c5\u5371\u5bb3\u7efc\u5408\u98ce\u9669\u5206\u7c7b");
        stat.setTypeName("\u7532\u7c7b");
        list.add(stat);
        stat = new SelfJudgeExposeReportStat();
        stat.setTitleName("\u804c\u4e1a\u75c5\u5371\u5bb3\u7efc\u5408\u98ce\u9669\u5206\u7c7b");
        stat.setTypeName("\u4e59\u7c7b");
        list.add(stat);
        stat = new SelfJudgeExposeReportStat();
        stat.setTitleName("\u804c\u4e1a\u75c5\u5371\u5bb3\u7efc\u5408\u98ce\u9669\u5206\u7c7b");
        stat.setTypeName("\u4e19\u7c7b");
        list.add(stat);
        return list;
    }

    private void reback(Long id, Long createBy) {
        if (id == null) {
            return;
        }
        SelfInspectionRiskAssessmentReportInfo reportInfo = new SelfInspectionRiskAssessmentReportInfo();
        reportInfo.setId(id);
        reportInfo.setStatus(Byte.valueOf((byte)3));
        reportInfo.setUpdateBy(createBy);
        this.selfInspectionRiskAssessmentReportInfoService.update((Object)reportInfo);
    }
}

