/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.reform;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.entity.work.reform.CheckPlanReformItem;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.enums.reform.ReformSourceEnum;
import cn.smarthse.modules.health.enums.sys.StatusEnum;
import cn.smarthse.modules.health.pojo.CompanyRiskStatus;
import cn.smarthse.modules.health.pojo.OccupationalStaffListVo;
import cn.smarthse.modules.health.pojo.ReformCheckPlanParam;
import cn.smarthse.modules.health.pojo.ReformCheckPlanVo;
import cn.smarthse.modules.health.pojo.ReformCount;
import cn.smarthse.modules.health.pojo.ReformGenerationSourceCount;
import cn.smarthse.modules.health.supervise.dao.reform.ReformItemBasicMapper;
import cn.smarthse.modules.health.supervise.entity.reform.DyBigCenterParam;
import cn.smarthse.modules.health.supervise.entity.reform.DyComRiskCompletionModel;
import cn.smarthse.modules.health.supervise.entity.reform.DyCompany;
import cn.smarthse.modules.health.supervise.entity.reform.DyCompanyGuide;
import cn.smarthse.modules.health.supervise.entity.reform.DyCompanyPatrol;
import cn.smarthse.modules.health.supervise.entity.reform.DyCompanyReform;
import cn.smarthse.modules.health.supervise.entity.reform.DyPatrolInfo;
import cn.smarthse.modules.health.supervise.entity.reform.HarmFactorReformSummaryVO;
import cn.smarthse.modules.health.supervise.model.AbnormalOrgComResult;
import cn.smarthse.modules.health.supervise.service.hccheckplan.IHcCheckPlanCompService;
import cn.smarthse.modules.health.supervise.service.reform.IReformService;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional(readOnly=true)
@DubboService
public class ReformServiceImpl
extends BaseServiceImpl<ReformItemBasicMapper, ReformItemBasic>
implements IReformService {
    @Autowired
    private IHcCheckPlanCompService checkPlanService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;

    public HarmFactorReformSummaryVO getReformFinishedInfo(Long cid, List<Long> harmfactorTestId) {
        List reformIds;
        HarmFactorReformSummaryVO vo = new HarmFactorReformSummaryVO();
        if (cid == null) {
            return vo;
        }
        Example exampleFinished = new Example(ReformItemBasic.class);
        Example.Criteria criteria = exampleFinished.createCriteria();
        criteria.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("businessStatus", (Object)StatusEnum.finished.getValue()).andEqualTo("reformItemSource", (Object)ReformSourceEnum.harmFactorInspection.getValue()).andEqualTo("isShowInReformModular", (Object)true);
        Example exampleUnfinished = new Example(ReformItemBasic.class);
        Example.Criteria criteriaUnfinished = exampleUnfinished.createCriteria();
        criteriaUnfinished.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andNotEqualTo("businessStatus", (Object)StatusEnum.finished.getValue()).andEqualTo("reformItemSource", (Object)ReformSourceEnum.harmFactorInspection.getValue()).andEqualTo("isShowInReformModular", (Object)true);
        if (harmfactorTestId != null && !harmfactorTestId.isEmpty()) {
            reformIds = this.checkPlanService.getReformIdsByHcIds(harmfactorTestId);
            if (reformIds == null || reformIds.isEmpty()) {
                return vo;
            }
        } else {
            return vo;
        }
        criteria.andIn("id", (Iterable)reformIds);
        criteriaUnfinished.andIn("id", (Iterable)reformIds);
        vo.setFinishedReformNum(((ReformItemBasicMapper)this.dao).selectCountByExample(exampleFinished));
        vo.setUnfinishedReformNum(((ReformItemBasicMapper)this.dao).selectCountByExample(exampleUnfinished));
        return vo;
    }

    public ReformCount queryReportReformCount(Long areaId, Byte level) {
        List<ReformGenerationSourceCount> list = ((ReformItemBasicMapper)this.dao).generationSourceCount(areaId, level);
        ReformCount reformCount = new ReformCount();
        for (ReformGenerationSourceCount count : list) {
            if (count.getGenerationSource() == null) continue;
            if (count.getGenerationSource().equals(3)) {
                reformCount.setCheckPlanReportCount(count.getNum());
                continue;
            }
            if (count.getGenerationSource().equals(4)) {
                reformCount.setJjzReportCount(count.getNum());
                continue;
            }
            if (count.getGenerationSource().equals(5)) {
                reformCount.setYszybReportCount(count.getNum());
                continue;
            }
            if (!count.getGenerationSource().equals(6)) continue;
            reformCount.setFcReportCount(count.getNum());
        }
        return reformCount;
    }

    public Integer queryReportFeedBackCount(Long areaId, Byte level) {
        return ((ReformItemBasicMapper)this.dao).queryReportFeedBackCount(areaId, level);
    }

    @Transactional(readOnly=false)
    public void updateStatus(Long reformId, Integer status, Long updateBy) {
        ((ReformItemBasicMapper)this.dao).updateStatus(reformId, status, updateBy);
    }

    @Transactional(readOnly=false)
    public void superviseBack(Long reformId, String reason, Long updateBy) {
        ((ReformItemBasicMapper)this.dao).superviseBack(reformId, reason, updateBy);
    }

    public PageInfo<ReformCheckPlanVo> queryReformCheckPlanVo(JqGridParam jparam, ReformCheckPlanParam param) {
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        List<ReformCheckPlanVo> list = ((ReformItemBasicMapper)this.dao).queryReformCheckPlanVo(param);
        return new PageInfo(list);
    }

    public CheckPlanReformItem queryByResultId(Long resultId) {
        return ((ReformItemBasicMapper)this.dao).queryByResultId(resultId);
    }

    public List<Long> queryNoReportCids(Integer threshold, int generationSource) {
        return ((ReformItemBasicMapper)this.dao).queryNoReportCids(threshold, generationSource);
    }

    public List<AbnormalOrgComResult> queryNoReportPhcCheckCidProjects(Integer threshold, int generationSource) {
        return ((ReformItemBasicMapper)this.dao).queryNoReportPhcCheckCidProjects(threshold, generationSource);
    }

    public List<AbnormalOrgComResult> queryNoReportCheckPlanCidProjects(Integer threshold, int generationSource) {
        return ((ReformItemBasicMapper)this.dao).queryNoReportCheckPlanCidProjects(threshold, generationSource);
    }

    public PageInfo<OccupationalStaffListVo> getOccupationalStaffListByArea(JqGridParam param, Long areaId, Byte level, String keyWord) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<OccupationalStaffListVo> list = ((ReformItemBasicMapper)this.dao).getOccupationalStaffListByArea(areaId, level, keyWord, SpringEncryptUtils.encrypt((String)keyWord));
        PageInfo page = new PageInfo(list);
        return page;
    }

    private void setTime(Integer year, int yearNum, Example.Criteria criteria) {
        if (year == null) {
            return;
        }
        Calendar start = Calendar.getInstance();
        start.set(year, 0, 0, 0, 0, 0);
        Calendar end = Calendar.getInstance();
        end.set(year + yearNum, 0, 0, 0, 0, 0);
        criteria.andGreaterThanOrEqualTo("findTime", (Object)start.getTime()).andLessThanOrEqualTo("findTime", (Object)end.getTime());
    }

    public List<CompanyRiskStatus> getCompanyRiskStatus(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        List<CompanyRiskStatus> list = ((ReformItemBasicMapper)this.dao).getCompanyRiskStatus(idList);
        Set already = list.stream().filter(Objects::nonNull).map(CompanyRiskStatus::getDataSourceId).collect(Collectors.toSet());
        for (String dataSourceId : idList) {
            if (dataSourceId == null || already.contains(dataSourceId)) continue;
            CompanyRiskStatus status = new CompanyRiskStatus();
            status.setDataSourceId(dataSourceId);
            status.setPullState(Integer.valueOf(0));
            status.setReason("\u6ca1\u6709\u5728\u6211\u4eec\u7cfb\u7edf\u67e5\u5230\u8be5\u4f01\u4e1a");
            list.add(status);
        }
        return list;
    }

    public PageInfo<DyCompany> getDyCompanyList(DyBigCenterParam param) {
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        List<DyComRiskCompletionModel> list = ((ReformItemBasicMapper)this.dao).getDyComRiskCompletion(param);
        PageInfo pageInfo = new PageInfo(list);
        ArrayList<DyCompany> companyList = new ArrayList<DyCompany>();
        for (DyComRiskCompletionModel model : list) {
            if (model == null) continue;
            DyCompany company = new DyCompany();
            company.setId(model.getId());
            company.setCid(model.getCid());
            company.setComName(model.getComName());
            company.setUnifiedSocialCc(model.getUnifiedSocialCc());
            company.setAreaId(model.getAreaId());
            company.setBusinessState(Byte.valueOf(model.getBusinessState().byteValue()));
            company.setGrade(model.getGrade());
            if (model.getPickupCount() == null || model.getPickupCount() >= 3) {
                company.setIsPickUp(Byte.valueOf((byte)1));
            } else {
                company.setIsPickUp(Byte.valueOf((byte)0));
            }
            company.setStatisticsTime(DateUtil.getFromDate((Date)model.getCreateDate()));
            companyList.add(company);
        }
        PageInfo companyPageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)pageInfo, (Object)companyPageInfo, (String[])new String[]{"list"});
        companyPageInfo.setList(companyList);
        return companyPageInfo;
    }

    public PageInfo<DyCompanyGuide> getDyCompanyGuideList(DyBigCenterParam param) {
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        List<DyComRiskCompletionModel> list = ((ReformItemBasicMapper)this.dao).getDyComRiskCompletion(param);
        PageInfo pageInfo = new PageInfo(list);
        ArrayList<DyCompanyGuide> companyList = new ArrayList<DyCompanyGuide>();
        for (DyComRiskCompletionModel model : list) {
            if (model == null) continue;
            DyCompanyGuide company = new DyCompanyGuide();
            company.setId(model.getId());
            company.setCid(model.getCid());
            company.setIsGuide(model.getComGuidanceNum());
            company.setGuidanceTimeNum(model.getComGuidanceNum());
            company.setStatisticsTime(DateUtil.getFromDate((Date)model.getCreateDate()));
            companyList.add(company);
        }
        PageInfo companyPageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)pageInfo, (Object)companyPageInfo, (String[])new String[]{"list"});
        companyPageInfo.setList(companyList);
        return companyPageInfo;
    }

    public PageInfo<DyCompanyPatrol> getDyCompanyPatrolList(DyBigCenterParam param) {
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        List<DyComRiskCompletionModel> list = ((ReformItemBasicMapper)this.dao).getDyComRiskCompletion(param);
        PageInfo pageInfo = new PageInfo(list);
        ArrayList<DyCompanyPatrol> companyList = new ArrayList<DyCompanyPatrol>();
        for (DyComRiskCompletionModel model : list) {
            if (model == null) continue;
            DyCompanyPatrol company = new DyCompanyPatrol();
            company.setId(model.getId());
            company.setCid(model.getCid());
            company.setIsPatrol(model.getComPatrolNum());
            company.setStatisticsTime(DateUtil.getFromDate((Date)model.getCreateDate()));
            companyList.add(company);
        }
        PageInfo companyPageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)pageInfo, (Object)companyPageInfo, (String[])new String[]{"list"});
        companyPageInfo.setList(companyList);
        return companyPageInfo;
    }

    public PageInfo<DyCompanyReform> getDyCompanyReformList(DyBigCenterParam param) {
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        List<DyComRiskCompletionModel> list = ((ReformItemBasicMapper)this.dao).getDyComRiskCompletion(param);
        PageInfo pageInfo = new PageInfo(list);
        ArrayList<DyCompanyReform> companyList = new ArrayList<DyCompanyReform>();
        for (DyComRiskCompletionModel model : list) {
            if (model == null) continue;
            DyCompanyReform company = new DyCompanyReform();
            company.setId(model.getId());
            company.setCid(model.getCid());
            company.setRiskTotalNum(model.getRiskTotalNum());
            company.setRiskCompleted(model.getRiskCompleted());
            company.setStatus(Byte.valueOf(model.getComAllCompleted().byteValue()));
            company.setStatisticsTime(DateUtil.getFromDate((Date)model.getCreateDate()));
            companyList.add(company);
        }
        PageInfo companyPageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)pageInfo, (Object)companyPageInfo, (String[])new String[]{"list"});
        companyPageInfo.setList(companyList);
        return companyPageInfo;
    }

    public PageInfo<DyPatrolInfo> getDyPatrolInfoList(DyBigCenterParam param) {
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        List<DyComRiskCompletionModel> list = ((ReformItemBasicMapper)this.dao).getDyPatrolInfoList(param);
        PageInfo pageInfo = new PageInfo(list);
        ArrayList<DyPatrolInfo> companyList = new ArrayList<DyPatrolInfo>();
        for (DyComRiskCompletionModel model : list) {
            if (model == null) continue;
            DyPatrolInfo company = new DyPatrolInfo();
            company.setId(model.getId());
            company.setCid(model.getCid());
            company.setPatrolName(model.getPatrolName());
            company.setYear(model.getYear());
            company.setPatrolTime(model.getPatrolTime());
            company.setPatrolStatus(model.getPatrolStatus());
            company.setStatisticsTime(DateUtil.getFromDate((Date)model.getCreateDate()));
            companyList.add(company);
        }
        PageInfo companyPageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)pageInfo, (Object)companyPageInfo, (String[])new String[]{"list"});
        companyPageInfo.setList(companyList);
        return companyPageInfo;
    }

    @Transactional
    public void resetRiskEv(Long cid) {
        ((ReformItemBasicMapper)this.dao).resetRiskEv();
        ((ReformItemBasicMapper)this.dao).deleteOperateLog();
    }

    @Transactional
    public void resetReport(Long cid) {
        ((ReformItemBasicMapper)this.dao).resetReport();
    }

    @Transactional
    public void resetTrain(Long cid) {
        ((ReformItemBasicMapper)this.dao).resetTrain();
    }

    @Transactional
    public void resetProtect(Long cid) {
        ((ReformItemBasicMapper)this.dao).resetProtect();
    }

    @Transactional
    public void resetWarn(Long cid) {
        ((ReformItemBasicMapper)this.dao).resetWarn();
    }

    @Transactional
    public void delEightRisk(Long cid) {
        ((ReformItemBasicMapper)this.dao).delEightRisk();
    }

    @Transactional
    public void addEightRisk(Long cid) {
        ((ReformItemBasicMapper)this.dao).addEightRisk();
    }

    @Transactional
    public void delAbnormalRisk(Long cid) {
        ((ReformItemBasicMapper)this.dao).delAbnormalRisk();
    }

    @Transactional
    public void addAbnormalRisk(Long cid) {
        ((ReformItemBasicMapper)this.dao).addAbnormalRisk();
    }
}

