/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.reform;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.PageUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.work.reform.DyComRiskCompletion;
import cn.smarthse.modules.health.entity.work.reform.param.DyAreaRiskParam;
import cn.smarthse.modules.health.entity.work.reform.vo.DyAreaRiskCompletionVo;
import cn.smarthse.modules.health.service.work.reform.ICompanyRiskCompletionService;
import cn.smarthse.modules.health.supervise.dao.reform.DyAreaRiskCompletionMapper;
import cn.smarthse.modules.health.supervise.service.reform.IDyAreaRiskCompletionService;
import cn.smarthse.util.common.ListUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.github.pagehelper.PageInfo;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class DyAreaRiskCompletionServiceImpl
extends BaseServiceImpl<DyAreaRiskCompletionMapper, DyComRiskCompletion>
implements IDyAreaRiskCompletionService {
    @DubboReference
    ICompanyRiskCompletionService companyRiskCompletionService;

    @Transactional
    public void generateDyAreaRiskCompletion(List<Long> idList) {
        String ids = "";
        if (CollectionUtils.isNotEmpty(idList)) {
            ids = idList.stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.joining(","));
        }
        Date date = new Date();
        Example example = new Example(DyComRiskCompletion.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andCondition("create_date >= '" + DateUtils.format((Date)date, (String)"yyyy-MM-dd") + " 00:00:00'");
        if (CollectionUtils.isNotEmpty(idList)) {
            criteria.andIn("cid", idList);
        }
        int i = ((DyAreaRiskCompletionMapper)this.dao).deleteByExample(example);
        List<DyComRiskCompletion> list = ((DyAreaRiskCompletionMapper)this.dao).getGenerateDyComRiskCompletion(idList);
        for (DyComRiskCompletion item : list) {
            if (item == null) continue;
            item.setId(Long.valueOf(this.idworker.nextId()));
            item.setCreateDate(date);
            item.setIsValid(Boolean.valueOf(true));
        }
        List split = ListUtils.split(list, (int)2000);
        split.stream().filter(CollectionUtils::isNotEmpty).forEachOrdered(dyComRiskCompletions -> ((DyAreaRiskCompletionMapper)this.dao).insertList2((List)dyComRiskCompletions));
    }

    public DyAreaRiskCompletionVo getDyAreaRiskCompletionVo(DyAreaRiskParam param) {
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank((CharSequence)param.getBusinessStateStr())) {
            param.setBusinessStateList(StringUtils.parseToIntegerList((String)param.getBusinessStateStr()));
        }
        DyAreaRiskCompletionVo vo = ((DyAreaRiskCompletionMapper)this.dao).getDyAreaRiskCompletionVo(param);
        this.CalculationRate(vo, param);
        return vo;
    }

    public List<DyAreaRiskCompletionVo> getDyAreaRiskList(DyAreaRiskParam param) {
        if (param.getAreaLevel().equals((byte)4) || param.getAreaId() == null) {
            return Collections.emptyList();
        }
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank((CharSequence)param.getBusinessStateStr())) {
            param.setBusinessStateList(StringUtils.parseToIntegerList((String)param.getBusinessStateStr()));
        }
        List<DyAreaRiskCompletionVo> list = ((DyAreaRiskCompletionMapper)this.dao).getDyAreaRiskList(param);
        int i = 1;
        for (DyAreaRiskCompletionVo vo : list) {
            if (vo == null) continue;
            vo.setIdx(Integer.valueOf(i));
            this.CalculationRate(vo, param);
            ++i;
        }
        return list;
    }

    public PageInfo<DyAreaRiskCompletionVo> getPageDyAreaRisk(JqGridParam jqGridParam, DyAreaRiskParam param) {
        List<DyAreaRiskCompletionVo> list = this.getDyAreaRiskList(param);
        return PageUtil.getPageInfo(list, (int)jqGridParam.getPage(), (int)jqGridParam.getRows());
    }

    public DyAreaRiskCompletionVo getDyRiskVisualVo(DyAreaRiskParam param) {
        DyAreaRiskCompletionVo voThisDayMonth;
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        param.setMonthFirstDate(calendar.getTime());
        param.setCurrDate(new Date());
        DyAreaRiskCompletionVo vo = new DyAreaRiskCompletionVo();
        DyAreaRiskCompletionVo voThisYear = this.getDyAreaRiskCompletionVo(param);
        if (voThisYear != null) {
            vo.setComAllCompleted1(voThisYear.getComAllCompleted());
            vo.setComRiskNumRate(voThisYear.getComRiskNumRate());
        }
        if ((voThisDayMonth = ((DyAreaRiskCompletionMapper)this.dao).getRiskCompletedThisDayMonth(param)) != null) {
            vo.setRiskNumThisDay(voThisDayMonth.getRiskNumThisDay());
            vo.setRiskNumThisMonth(voThisDayMonth.getRiskNumThisMonth());
        }
        return vo;
    }

    private void CalculationRate(DyAreaRiskCompletionVo vo, DyAreaRiskParam param) {
        if (vo == null) {
            return;
        }
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isBlank((CharSequence)vo.getAreaName())) {
            vo.setAreaName("\u672a\u660e\u786e");
        }
        if (vo.getUpdateDate() != null) {
            vo.setUpdateDateStr(DateUtils.format((Date)vo.getUpdateDate(), (String)"yyyy-MM-dd"));
        }
        vo.setComRiskNumRate(vo.getComNum() == 0 ? "0.00" : String.format("%.2f", (double)vo.getComAllCompleted().intValue() / (double)vo.getComNum().intValue() * 100.0));
        vo.setComPatrolRate(vo.getComNum() == 0 ? "0.00" : String.format("%.2f", (double)vo.getComPatrolNum().intValue() / (double)vo.getComNum().intValue() * 100.0));
        vo.setComPatrolRiskDefuseRate(vo.getComNum() == 0 ? "0.00" : String.format("%.2f", (double)vo.getComPatrolRiskDefuseNum().intValue() / (double)vo.getComNum().intValue() * 100.0));
        if (param.getIsRateInNormal().booleanValue()) {
            vo.setComRiskNumRate(vo.getComNum1() == 0 ? "0.00" : String.format("%.2f", (double)vo.getComAllCompleted1().intValue() / (double)vo.getComNum1().intValue() * 100.0));
            vo.setComPatrolRate(vo.getComNum1() == 0 ? "0.00" : String.format("%.2f", (double)vo.getComPatrolNum1().intValue() / (double)vo.getComNum1().intValue() * 100.0));
            vo.setComPatrolRiskDefuseRate(vo.getComNum1() == 0 ? "0.00" : String.format("%.2f", (double)vo.getComPatrolRiskDefuseNum1().intValue() / (double)vo.getComNum1().intValue() * 100.0));
        }
    }
}

