/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.projectTrain.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.IDCardUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.common.util.excel.ExcelContent;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffBasicVo;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaff;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaffDetail;
import cn.smarthse.modules.health.entity.work.train.TrainPlan;
import cn.smarthse.modules.health.enums.certificate.CertificateStaffTypeEnum;
import cn.smarthse.modules.health.enums.sys.coreWork.CoreWorkEnum;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffDetailService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffService;
import cn.smarthse.modules.health.service.work.train.ITrainPlanService;
import cn.smarthse.modules.health.supervise.dao.projectTrain.TrainProjReportMapper;
import cn.smarthse.modules.health.supervise.entity.operate.WorkOperateLog;
import cn.smarthse.modules.health.supervise.entity.projectTrain.TrainProjReport;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogEnum;
import cn.smarthse.modules.health.supervise.service.check.ISuperviseCheckThirdOrganizationService;
import cn.smarthse.modules.health.supervise.service.operate.IWorkOperateLogService;
import cn.smarthse.modules.health.supervise.service.projectTrain.ITrainProjReportService;
import cn.smarthse.modules.health.supervise.service.projectTrain.ITrainProjStaffService;
import cn.smarthse.modules.health.supervise.service.staff.ISuperviseStaffInfoService;
import cn.smarthse.modules.health.supervise.vo.projectTrain.TrainProjImportResultVo;
import cn.smarthse.modules.health.supervise.vo.projectTrain.TrainProjReportErrorVo;
import cn.smarthse.modules.health.supervise.vo.projectTrain.TrainProjReportSearchVo;
import cn.smarthse.modules.health.supervise.vo.projectTrain.TrainProjReportStaffVo;
import cn.smarthse.modules.health.supervise.vo.projectTrain.TrainProjReportVo;
import cn.smarthse.modules.health.vo.work.staffCert.StaffCertDetailVo;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.util.common.http.HttpUtil;
import cn.smarthse.util.common.http.HttpsUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.lang.invoke.CallSite;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.poi.ss.usermodel.CellType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class TrainProjReportServiceImpl
extends BaseServiceImpl<TrainProjReportMapper, TrainProjReport>
implements ITrainProjReportService {
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private DateFormat dateFormat1 = new SimpleDateFormat("yyyy-MM-dd");
    @Autowired
    private IWorkOperateLogService workOperateLogService;
    @DubboReference
    private IStaffInfoService staffInfoService;
    @Autowired
    private ISuperviseStaffInfoService superviseStaffInfoService;
    @DubboReference
    private IStaffBasicInfoService staffBasicInfoService;
    @DubboReference
    private ICertificateStaffService certificateStaffService;
    @DubboReference
    private ICertificateStaffDetailService certificateStaffDetailService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference
    private ITrainPlanService trainPlanService;
    @DubboReference
    private ISysCoreWorkModuleCorrelationService sysCoreWorkModuleCorrelationService;
    @Autowired
    private ISuperviseCheckThirdOrganizationService checkThirdOrganizationService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @Autowired
    private ITrainProjStaffService trainProjStaffService;
    @Autowired
    private ThreadPoolExecutor threadPoolExecutor;
    @Value(value="${train_project_import_callback_url}")
    private String train_project_import_callback_url;

    @Transactional(readOnly=false)
    public TrainProjReport getNotValidTrainProjReport(Long thirdOrgId, Long createBy) {
        TrainProjReport tpr = new TrainProjReport();
        tpr.setIsValid(Boolean.valueOf(false));
        tpr.setReportStatus(Byte.valueOf("1"));
        tpr.setCreateBy(createBy);
        tpr.setUpdateBy(createBy);
        tpr.setCreateDate(new Date());
        tpr.setUpdateDate(new Date());
        tpr.setThirdOrgId(thirdOrgId);
        ((TrainProjReportMapper)this.dao).insertSelective(tpr);
        return tpr;
    }

    public List<TrainProjReportVo> getTrainProjReportVos(TrainProjReportSearchVo searchVo) {
        List<TrainProjReportVo> list = ((TrainProjReportMapper)this.dao).getTrainProjReportVo(searchVo);
        list.forEach(s -> {
            if (s.getTrainBeginDate() != null && s.getTrainEndDate() != null) {
                s.setTrainTime(DateUtil.formatDate((LocalDateTime)DateUtil.getFromDate((Date)s.getTrainBeginDate()), (String)"yyyy-MM-dd") + "\u81f3" + DateUtil.formatDate((LocalDateTime)DateUtil.getFromDate((Date)s.getTrainEndDate()), (String)"yyyy-MM-dd"));
            }
        });
        return list;
    }

    public PageInfo<TrainProjReportVo> getTrainProjReportVos(JqGridParam jParam, TrainProjReportSearchVo searchVo) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows(), (boolean)jParam.getCount());
        List<TrainProjReportVo> list = ((TrainProjReportMapper)this.dao).getTrainProjReportVo(searchVo);
        list.forEach(s -> {
            if (s.getTrainBeginDate() != null && s.getTrainEndDate() != null) {
                s.setTrainTime(DateUtil.formatDate((LocalDateTime)DateUtil.getFromDate((Date)s.getTrainBeginDate()), (String)"yyyy-MM-dd") + "\u81f3" + DateUtil.formatDate((LocalDateTime)DateUtil.getFromDate((Date)s.getTrainEndDate()), (String)"yyyy-MM-dd"));
            }
        });
        return new PageInfo(list);
    }

    public Long getTrainProjReportVosCount(TrainProjReportSearchVo searchVo) {
        searchVo.setSearchKeyEncrypt(searchVo.getSearchKey());
        return ((TrainProjReportMapper)this.dao).getTrainProjReportVoCount(searchVo);
    }

    @Transactional(readOnly=false)
    public void saveTrainProjReportSubmit(TrainProjReport trainProjReport, Long userId, String companyName) {
        TrainProjReport dbTpr;
        if (trainProjReport == null || trainProjReport.getId() == null) {
            return;
        }
        if (trainProjReport.getReportStatus() != null && trainProjReport.getReportStatus() == 2) {
            trainProjReport.setOrgReportTime(new Date());
            this.workOperateLogService.report(trainProjReport.getId(), WorkOperateLogEnum.trainProj.getTypeVal(), userId, trainProjReport.getRegistrant(), companyName);
        }
        if ((dbTpr = (TrainProjReport)this.getById(trainProjReport.getId())) != null) {
            trainProjReport.setCreateBy(dbTpr.getCreateBy());
            trainProjReport.setCreateDate(dbTpr.getCreateDate());
            trainProjReport.setUpdateDate(dbTpr.getUpdateDate());
            trainProjReport.setThirdOrgId(dbTpr.getThirdOrgId());
            this.updateByPrimaryKey(trainProjReport, userId);
        }
    }

    @Transactional(readOnly=false)
    public void saveTrainProjReportStaffSubmit(TrainProjReportStaffVo vo) {
        CertificateStaffDetail sd;
        StaffInfo stafInfo;
        if (vo == null || vo.getStaffInfo() == null || vo.getStaffInfo().getStaffBasicInfo() == null) {
            return;
        }
        if (vo.getStaffInfo().getCid() == null) {
            return;
        }
        Integer staffType = vo.getCertificateStaffDetail().getStaffType();
        CertificateStaff cert = null;
        cert = staffType != null && staffType == 1 ? this.certificateStaffService.getHseTrainCert(vo.getStaffInfo().getCid(), Long.valueOf(12L)) : this.certificateStaffService.getHseTrainCert(vo.getStaffInfo().getCid(), Long.valueOf(13L));
        if (cert == null) {
            cert = new CertificateStaff();
            cert.setCid(vo.getStaffInfo().getCid());
            if (staffType != null && staffType == 1) {
                cert.setNameId(CertificateStaffTypeEnum.SaftyTrain.getId());
                cert.setName(CertificateStaffTypeEnum.SaftyTrain.getName());
            } else {
                cert.setNameId(CertificateStaffTypeEnum.OccTrain.getId());
                cert.setName(CertificateStaffTypeEnum.OccTrain.getName());
            }
            if (vo.getCertificateStaff() != null) {
                cert.setWorkAddAreaId(vo.getCertificateStaff().getWorkAddAreaId());
                cert.setWorkAddDetail(vo.getCertificateStaff().getWorkAddDetail());
            }
            cert = (CertificateStaff)this.certificateStaffService.add((Object)cert, vo.getStaffInfo().getCreateBy(), cert.getCid());
        } else if (vo.getCertificateStaff() != null) {
            if (vo.getCertificateStaff().getId() == null) {
                vo.getCertificateStaff().setId(cert.getId());
            }
            this.certificateStaffService.update((Object)vo.getCertificateStaff(), vo.getStaffInfo().getCreateBy());
        }
        StaffBasicVo staff = null;
        if (vo.getStaffInfo().getId() != null) {
            staff = new StaffBasicVo();
            staff.setStaffId(vo.getStaffInfo().getId());
        } else {
            staff = this.staffInfoService.getStaffBasicVoByIdCardNotSelfId(vo.getStaffInfo().getStaffBasicInfo().getIdCard(), vo.getStaffInfo().getId(), vo.getStaffInfo().getCid());
            if (staff == null) {
                staff = this.staffInfoService.addStaffInfoFromOrg(vo.getStaffInfo());
            }
        }
        if (staff != null && staff.getStaffId() != null && vo.getIsUpdateStaff() != null && vo.getIsUpdateStaff().booleanValue() && (stafInfo = (StaffInfo)this.staffInfoService.getById(staff.getStaffId())) != null) {
            vo.getStaffInfo().getStaffBasicInfo().setId(stafInfo.getStaffBasicId());
            this.staffBasicInfoService.update((Object)vo.getStaffInfo().getStaffBasicInfo(), vo.getStaffInfo().getCreateBy());
        }
        if ((sd = this.certificateStaffDetailService.getCertForOrgByStaffIdAndCertType(staff.getStaffId(), vo.getCertificateStaffDetail().getStaffType(), vo.getStaffInfo().getCid())) == null) {
            vo.getCertificateStaffDetail().setCid(vo.getStaffInfo().getCid());
            if (staffType != null && staffType == 1) {
                vo.getCertificateStaffDetail().setCertId(Long.valueOf(12L));
            } else {
                vo.getCertificateStaffDetail().setCertId(Long.valueOf(13L));
            }
            vo.getCertificateStaffDetail().setStaffName(vo.getStaffInfo().getStaffBasicInfo().getRealName());
            vo.getCertificateStaffDetail().setStaffId(staff.getStaffId());
            if (vo.getCertificateStaffDetail().getId() != null) {
                this.certificateStaffDetailService.update((Object)vo.getCertificateStaffDetail(), vo.getStaffInfo().getCreateBy());
                if (vo.getCertificateStaffDetail().getRepeatData() == null) {
                    CertificateStaffDetail certificateStaff = (CertificateStaffDetail)this.certificateStaffDetailService.getById(vo.getCertificateStaffDetail().getId());
                    certificateStaff.setRepeatData(null);
                    this.certificateStaffDetailService.updateByPrimaryKey((Object)certificateStaff, vo.getStaffInfo().getCreateBy());
                }
                sd = vo.getCertificateStaffDetail();
            } else {
                vo.getCertificateStaffDetail().setCreateBy(vo.getStaffInfo().getCreateBy());
                sd = this.certificateStaffDetailService.addCertStaffForOrg(vo.getCertificateStaffDetail());
            }
        } else if (vo.getCertificateStaffDetail() != null && vo.getCertificateStaffDetail().getId() != null) {
            if (vo.getCertificateStaffDetail().getRepeatData() == null) {
                CertificateStaffDetail certificateStaff = (CertificateStaffDetail)this.certificateStaffDetailService.getById(vo.getCertificateStaffDetail().getId());
                certificateStaff.setRepeatData(null);
                this.certificateStaffDetailService.updateByPrimaryKey((Object)certificateStaff, vo.getStaffInfo().getCreateBy());
            }
            this.certificateStaffDetailService.update((Object)vo.getCertificateStaffDetail(), vo.getStaffInfo().getCreateBy());
        } else {
            vo.getCertificateStaffDetail().setCreateBy(vo.getStaffInfo().getCreateBy());
            sd = this.certificateStaffDetailService.addCertStaffForOrg(vo.getCertificateStaffDetail());
        }
        this.certificateStaffDetailService.addOrUpdateFileForOrg(vo.getCertStaffFileIdArr(), sd.getId(), vo.getStaffInfo().getCid(), vo.getStaffInfo().getCreateBy());
    }

    public PageInfo<StaffCertDetailVo> getStaffCertListPageForOrg(CertificateStaffDetail info, JqGridParam param) {
        return this.certificateStaffDetailService.getStaffCertListPageForOrg(info, param);
    }

    public PageInfo<StaffCertDetailVo> getStaffCertListPageForSup(CertificateStaffDetail info, JqGridParam param) {
        return this.certificateStaffDetailService.getStaffCertListPageForSup(info, param);
    }

    public TrainProjReportStaffVo getCertificateStaffDetailById(Long id) {
        TrainProjReportStaffVo vo = new TrainProjReportStaffVo();
        CertificateStaffDetail certStaff = this.certificateStaffDetailService.getByIdWithFile(id);
        vo.setCertificateStaffDetail(certStaff);
        if (vo.getCertificateStaffDetail() != null) {
            CompanyBaseInfoModel model;
            StaffInfo newSi = new StaffInfo();
            StaffBasicInfo newSbi = new StaffBasicInfo();
            this.useOnlineTrainStaffInfoCoverage(certStaff, newSbi);
            newSi.setStaffBasicInfo(newSbi);
            vo.setStaffInfo(newSi);
            List cfiles = vo.getCertificateStaffDetail().getFiles();
            if (cfiles != null && cfiles.size() > 0) {
                vo.setCertStaffFileIdsStr(String.join((CharSequence)",", cfiles.stream().filter(s -> s.getFileId() != null).map(s -> String.valueOf(s.getFileId())).collect(Collectors.toList())));
            }
            if ((model = this.companyProvideByHSEService.getCompanyById(vo.getCertificateStaffDetail().getCid())).getIsValid() != null && model.getIsValid().booleanValue()) {
                vo.setCompanyName(model.getName());
            }
            if (vo.getCertificateStaffDetail().getCertId() != null) {
                AreaModel area;
                vo.setCertificateStaff(this.certificateStaffService.getHseTrainCert(vo.getCertificateStaffDetail().getCid(), vo.getCertificateStaffDetail().getCertId()));
                if (vo.getCertificateStaff() != null && vo.getCertificateStaff().getWorkAddAreaId() != null && (area = this.sysAreaProvideService.getAreaById(vo.getCertificateStaff().getWorkAddAreaId())) != null) {
                    vo.setFullWorkAddressDetail(area.getFullname() + vo.getCertificateStaff().getWorkAddDetail());
                }
            }
        }
        DesensitizationUtils.setDesensitizationFieldFromObject((Object)vo.getCertificateStaffDetail());
        DesensitizationUtils.setDesensitizationFieldFromObject((Object)vo.getStaffInfo().getStaffBasicInfo());
        return vo;
    }

    private void useOnlineTrainStaffInfoCoverage(CertificateStaffDetail certStaff, StaffBasicInfo sbi) {
        boolean noneNull;
        boolean bl = noneNull = certStaff != null && certStaff.getId() != null && certStaff.getCid() != null && StrUtil.isNotBlank((CharSequence)certStaff.getStaffName());
        if (noneNull) {
            sbi.setRealName(certStaff.getStaffName());
            Map<String, Object> userInfo = ((TrainProjReportMapper)this.dao).getTrainUserInfoByCertStaffInfo(certStaff);
            if (userInfo != null) {
                if (userInfo.get("sex") != null) {
                    String sex = Convert.toStr((Object)userInfo.get("sex"));
                    if ("\u7537".equals(sex)) {
                        sbi.setGender(Byte.valueOf((byte)1));
                    }
                    if ("\u5973".equals(sex)) {
                        sbi.setGender(Byte.valueOf((byte)0));
                    }
                }
                if (userInfo.get("idcard") != null) {
                    String idcard = Convert.toStr((Object)userInfo.get("idcard"));
                    sbi.setAge(Integer.valueOf(DateUtils.getAgeByDate((Date)TrainProjReportServiceImpl.getBirthDateFromIdCard(idcard))));
                    if (TrainProjReportServiceImpl.isValidIdCard(idcard)) {
                        sbi.setIdCard(DesensitizationUtils.desensitized((CharSequence)idcard, (int)3, (int)3, (String)"*"));
                    } else {
                        sbi.setIdCard(DesensitizationUtils.desensitized((CharSequence)idcard, (int)1, (int)1, (String)"*"));
                    }
                } else {
                    sbi.setAge(null);
                    sbi.setIdCard(null);
                }
                if (userInfo.get("phone") != null) {
                    String phone = Convert.toStr((Object)userInfo.get("phone"));
                    if (phone.length() == 11) {
                        sbi.setMobile(phone);
                    }
                } else {
                    sbi.setMobile(null);
                }
            }
        }
    }

    public static Date getBirthDateFromIdCard(String idCard) {
        String birthDateStr;
        if (!TrainProjReportServiceImpl.isValidIdCard((String)idCard)) {
            return null;
        }
        if (((String)idCard).length() == 18) {
            birthDateStr = ((String)idCard).substring(6, 14);
        } else if (((String)idCard).length() == 15) {
            idCard = ((String)idCard).substring(0, 6) + "19" + ((String)idCard).substring(6);
            birthDateStr = ((String)idCard).substring(6, 14);
        } else {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            return sdf.parse(birthDateStr);
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u6790\u51fa\u751f\u65e5\u671f\u5931\u8d25", e);
        }
    }

    public static boolean isValidIdCard(String idCard) {
        String regex15 = "^[1-9]\\d{5}(\\d{2})(\\d{2})(\\d{2})\\d{3}$";
        String regex18 = "^[1-9]\\d{5}(\\d{4})(\\d{2})(\\d{2})\\d{3}[0-9X]$";
        return idCard.matches(regex15) || idCard.matches(regex18);
    }

    @Transactional(readOnly=false)
    public void deleteStaffCertById(CertificateStaffDetail staffCert, Long createBy) {
        if (staffCert == null || staffCert.getId() == null) {
            return;
        }
        this.certificateStaffDetailService.delete((Object)staffCert, createBy);
    }

    public List<Long> trainProOrgIds(Long areaId, Byte ownLevel) {
        return ((TrainProjReportMapper)this.dao).trainReportOrgIds(areaId, ownLevel);
    }

    @Transactional(readOnly=false)
    public void deleteTrainProjById(Long id, Long createBy) {
        if (id == null) {
            return;
        }
        TrainProjReport vo = new TrainProjReport();
        vo.setId(id);
        this.delete(vo, createBy);
    }

    public TrainProjReportVo getTrainProjReportVoById(Long id) {
        if (id == null) {
            return null;
        }
        TrainProjReportSearchVo searchVo = new TrainProjReportSearchVo();
        searchVo.setId(id);
        List<TrainProjReportVo> list = this.getTrainProjReportVos(searchVo);
        if (list != null && list.size() != 0) {
            return list.get(0);
        }
        return null;
    }

    public TrainProjReportVo getTrainProjReportVoBySearchVo(TrainProjReportSearchVo searchVo) {
        if (searchVo == null) {
            return null;
        }
        List<TrainProjReportVo> list = this.getTrainProjReportVos(searchVo);
        if (list != null && list.size() != 0) {
            return list.get(0);
        }
        return null;
    }

    @Transactional(readOnly=false)
    public void backToThirdOrg(WorkOperateLog log) {
        if (log == null || log.getWorkId() == null) {
            return;
        }
        this.workOperateLogService.back(log.getWorkId(), log.getWorkModule(), log.getReason(), log.getCreateBy(), log.getOperater(), log.getCompanyName());
        this.reback(log.getWorkId(), log.getCreateBy());
    }

    private void reback(Long id, Long createBy) {
        if (id == null) {
            return;
        }
        TrainProjReport report = new TrainProjReport();
        report.setId(id);
        report.setReportStatus(Byte.valueOf((byte)3));
        this.update(report, createBy);
    }

    @Transactional(readOnly=false)
    public StaffBasicVo getStaffBasicVoByIdCardNotSelfId(String idCard, Long id, Long cid) {
        return this.staffInfoService.getStaffBasicVoByIdCardNotSelfId(idCard, id, cid);
    }

    @Transactional(readOnly=false)
    public TrainProjImportResultVo importProjectTrainDataSubmit(Long reportId, String ossfile, Long userId) throws Exception {
        TrainProjImportResultVo errVos = new TrainProjImportResultVo();
        ArrayList<TrainProjReportErrorVo> errs = new ArrayList<TrainProjReportErrorVo>();
        if (StringUtils.isEmpty((CharSequence)ossfile)) {
            errVos.setCode(Integer.valueOf(2));
            errVos.setErrors(new ArrayList());
            return errVos;
        }
        HashMap<Integer, CellType> colTypeMap = new HashMap<Integer, CellType>();
        colTypeMap.put(5, CellType.STRING);
        colTypeMap.put(3, CellType.STRING);
        List excelContentMap = ExcelUtil.getInstance().getSingleExcelContentHasExcelInfo(ossfile, Integer.valueOf(9), Integer.valueOf(1), colTypeMap);
        ArrayList<TrainProjReportStaffVo> finalList = new ArrayList<TrainProjReportStaffVo>();
        HashMap<String, CompanyBaseInfoModel> comMap = new HashMap<String, CompanyBaseInfoModel>();
        for (List row : excelContentMap) {
            TrainProjReportStaffVo vo = new TrainProjReportStaffVo();
            vo.setStaffInfo(new StaffInfo());
            vo.getStaffInfo().setStaffBasicInfo(new StaffBasicInfo());
            vo.getStaffInfo().setCreateBy(userId);
            vo.setCertificateStaff(new CertificateStaff());
            vo.setCertificateStaffDetail(new CertificateStaffDetail());
            vo.getCertificateStaffDetail().setReportId(reportId);
            finalList.add(vo);
            for (int i = 0; i < row.size(); ++i) {
                Date date;
                ExcelContent cc = (ExcelContent)row.get(i);
                if (i == 0) {
                    if (StringUtils.isEmpty((CharSequence)cc.getContent())) {
                        errs.add(this.createTrainProjReportErrorVo("\u59d3\u540d\uff08\u5fc5\u586b\uff09", cc.getRowNum(), Long.valueOf(i + 1), "\u59d3\u540d", 1));
                        continue;
                    }
                    vo.getStaffInfo().getStaffBasicInfo().setRealName(cc.getContent());
                    continue;
                }
                if (i == 1) {
                    if (StringUtils.isEmpty((CharSequence)cc.getContent())) {
                        errs.add(this.createTrainProjReportErrorVo("\u8eab\u4efd\u8bc1\u53f7\uff08\u5fc5\u586b\uff09", cc.getRowNum(), Long.valueOf(i + 1), "\u8eab\u4efd\u8bc1\u53f7", 1));
                        continue;
                    }
                    if (!IDCardUtil.isIDCard((String)cc.getContent().trim())) {
                        errs.add(this.createTrainProjReportErrorVo("\u8eab\u4efd\u8bc1\u53f7\u4e0d\u6b63\u786e", cc.getRowNum(), Long.valueOf(i + 1), "\u8eab\u4efd\u8bc1\u53f7", 1));
                        continue;
                    }
                    vo.getStaffInfo().getStaffBasicInfo().setIdCard(cc.getContent());
                    continue;
                }
                if (i == 2) {
                    CompanyBaseInfoModel cbim;
                    if (StringUtils.isEmpty((CharSequence)cc.getContent())) {
                        errs.add(this.createTrainProjReportErrorVo("\u6240\u5728\u5355\u4f4d\uff08\u5fc5\u586b\uff09", cc.getRowNum(), Long.valueOf(i + 1), "\u6240\u5728\u5355\u4f4d", 1));
                        continue;
                    }
                    CompanyBaseInfoModel companyBaseInfoModel = cbim = comMap.get(cc.getContent().trim()) == null ? this.companyProvideByHSEService.getByName(cc.getContent().trim()) : (CompanyBaseInfoModel)comMap.get(cc.getContent().trim());
                    if (cbim == null || cbim.getId() == null) {
                        errs.add(this.createTrainProjReportErrorVo("\u6240\u5728\u5355\u4f4d\u4e0d\u5728\u7cfb\u7edf\u4e2d", cc.getRowNum(), Long.valueOf(i + 1), "\u6240\u5728\u5355\u4f4d", 1));
                        continue;
                    }
                    if (comMap.get(cc.getContent().trim()) == null) {
                        comMap.put(cc.getContent().trim(), cbim);
                    }
                    vo.setCompanyName(cc.getContent().trim());
                    vo.getCertificateStaff().setCid(cbim.getId());
                    vo.getStaffInfo().setCid(cbim.getId());
                    vo.getCertificateStaff().setWorkAddAreaId(cbim.getAreaDetailId());
                    vo.getCertificateStaff().setWorkAddDetail(cbim.getWorkAddress());
                    continue;
                }
                if (i == 3) {
                    vo.getStaffInfo().getStaffBasicInfo().setMobile(cc.getContent());
                    continue;
                }
                if (i == 4) {
                    if (StringUtils.isEmpty((CharSequence)cc.getContent())) {
                        errs.add(this.createTrainProjReportErrorVo("\u8bc1\u4e66\u7c7b\u578b\uff08\u5fc5\u586b\uff09 ", cc.getRowNum(), Long.valueOf(i + 1), "\u8bc1\u4e66\u7c7b\u578b", 1));
                        continue;
                    }
                    if ("\u4e3b\u8981\u8d1f\u8d23\u4eba".equals(cc.getContent().trim())) {
                        vo.getCertificateStaffDetail().setStaffType(Integer.valueOf(1));
                        continue;
                    }
                    if (!"\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u4eba\u5458".equals(cc.getContent().trim())) continue;
                    vo.getCertificateStaffDetail().setStaffType(Integer.valueOf(2));
                    continue;
                }
                if (i == 5) {
                    if (StringUtils.isEmpty((CharSequence)cc.getContent())) {
                        errs.add(this.createTrainProjReportErrorVo("\u8bc1\u4e66\u7f16\u53f7\uff08\u5fc5\u586b\uff09", cc.getRowNum(), Long.valueOf(i + 1), "\u8bc1\u4e66\u7f16\u53f7", 1));
                        continue;
                    }
                    vo.getCertificateStaffDetail().setCertNo(cc.getContent());
                    continue;
                }
                if (i == 6) {
                    if (StringUtils.isEmpty((CharSequence)cc.getContent())) {
                        errs.add(this.createTrainProjReportErrorVo("\u53d1\u8bc1\u65e5\u671f\uff08\u5fc5\u586b\uff09", cc.getRowNum(), Long.valueOf(i + 1), "\u53d1\u8bc1\u65e5\u671f", 1));
                        continue;
                    }
                    date = DateUtils.parseDate((Object)cc.getContent().trim());
                    if (date == null) {
                        errs.add(this.createTrainProjReportErrorVo("\u53d1\u8bc1\u65e5\u671f\u683c\u5f0f\u9519\u8bef", cc.getRowNum(), Long.valueOf(i + 1), "\u53d1\u8bc1\u65e5\u671f", 1));
                        continue;
                    }
                    vo.getCertificateStaffDetail().setCertCreateDate(date);
                    continue;
                }
                if (i == 7) {
                    if (StringUtils.isEmpty((CharSequence)cc.getContent())) continue;
                    date = DateUtils.parseDate((Object)cc.getContent().trim());
                    if (date == null) {
                        errs.add(this.createTrainProjReportErrorVo("\u590d\u5ba1\u65e5\u671f\u683c\u5f0f\u9519\u8bef", cc.getRowNum(), Long.valueOf(i + 1), "\u590d\u5ba1\u65e5\u671f", 1));
                        continue;
                    }
                    vo.getCertificateStaffDetail().setRepeatData(date);
                    continue;
                }
                if (i != 8) continue;
                if (StringUtils.isEmpty((CharSequence)cc.getContent())) {
                    errs.add(this.createTrainProjReportErrorVo("\u6709\u6548\u671f\uff08\u5fc5\u586b\uff09", cc.getRowNum(), Long.valueOf(i + 1), "\u6709\u6548\u671f", 1));
                    continue;
                }
                date = DateUtils.parseDate((Object)cc.getContent().trim());
                if (date == null) {
                    errs.add(this.createTrainProjReportErrorVo("\u6709\u6548\u671f\u683c\u5f0f\u9519\u8bef", cc.getRowNum(), Long.valueOf(i + 1), "\u6709\u6548\u671f", 1));
                    continue;
                }
                vo.getCertificateStaffDetail().setValidityDate(date);
            }
        }
        if (errs.size() == 0) {
            HashMap nameIdCidMap = new HashMap();
            ArrayList<CallSite> nameIdCidList = new ArrayList<CallSite>();
            for (TrainProjReportStaffVo vo : finalList) {
                Long cid;
                String idCard;
                String realName = vo.getStaffInfo().getStaffBasicInfo().getRealName();
                if (nameIdCidMap.get(realName + (idCard = vo.getStaffInfo().getStaffBasicInfo().getIdCard()) + (cid = vo.getStaffInfo().getCid())) != null || nameIdCidList.contains(realName + idCard + cid)) continue;
                nameIdCidList.add((CallSite)((Object)(realName + idCard + cid)));
                StaffBasicVo s = this.checkThirdOrganizationService.getNotSameStaff(idCard, realName, cid);
                if (s == null) continue;
                TrainProjReportErrorVo staffErrvo = new TrainProjReportErrorVo();
                staffErrvo.setErrorType(Integer.valueOf(5));
                staffErrvo.setStaff(s);
                s.setCompanyName(vo.getCompanyName());
                errs.add(staffErrvo);
            }
            if (errs.size() != 0) {
                errVos.setCode(Integer.valueOf(6));
                errVos.setFinalList(finalList);
            } else {
                this.importDataFromExcel(finalList, false);
                errVos.setCode(Integer.valueOf(1));
            }
        } else {
            errVos.setCode(Integer.valueOf(5));
        }
        errVos.setErrors(errs);
        return errVos;
    }

    private TrainProjReportErrorVo createTrainProjReportErrorVo(String message, Long rowNum, Long colNum, String titleName, Integer errorType) {
        TrainProjReportErrorVo vo = new TrainProjReportErrorVo();
        vo.setRowNum(rowNum);
        vo.setColNum(colNum);
        vo.setTitleName("\"" + titleName + "\"");
        vo.setErrorType(errorType);
        vo.setMessage(message);
        return vo;
    }

    public void importDataFromExcel(List<TrainProjReportStaffVo> list, Boolean isOverUpdate) {
        for (TrainProjReportStaffVo vo : list) {
            CertificateStaffDetail sd;
            StaffInfo stafInfo;
            CertificateStaff cert = this.certificateStaffService.getHseTrainCert(vo.getStaffInfo().getCid(), Long.valueOf(12L));
            if (cert == null) {
                cert = new CertificateStaff();
                cert.setCid(vo.getStaffInfo().getCid());
                cert.setNameId(CertificateStaffTypeEnum.OccTrain.getId());
                cert.setName(CertificateStaffTypeEnum.OccTrain.getName());
                if (vo.getCertificateStaff() != null) {
                    cert.setWorkAddAreaId(vo.getCertificateStaff().getWorkAddAreaId());
                    cert.setWorkAddDetail(vo.getCertificateStaff().getWorkAddDetail());
                }
                cert = (CertificateStaff)this.certificateStaffService.add((Object)cert, vo.getStaffInfo().getCreateBy(), cert.getCid());
            } else if (vo.getCertificateStaff() != null) {
                if (vo.getCertificateStaff().getId() == null) {
                    vo.getCertificateStaff().setId(cert.getId());
                }
                this.certificateStaffService.update((Object)vo.getCertificateStaff(), vo.getStaffInfo().getCreateBy());
            }
            StaffBasicVo staff = null;
            if (vo.getStaffInfo().getId() != null) {
                staff = new StaffBasicVo();
                staff.setStaffId(vo.getStaffInfo().getId());
            } else {
                staff = this.staffInfoService.getStaffBasicVoByIdCardNotSelfId(vo.getStaffInfo().getStaffBasicInfo().getIdCard(), vo.getStaffInfo().getId(), vo.getStaffInfo().getCid());
                if (staff == null) {
                    staff = this.staffInfoService.addStaffInfoFromOrg(vo.getStaffInfo());
                }
            }
            if (staff != null && staff.getStaffId() != null && (stafInfo = (StaffInfo)this.staffInfoService.getById(staff.getStaffId())) != null) {
                vo.getStaffInfo().getStaffBasicInfo().setId(stafInfo.getStaffBasicId());
                if (isOverUpdate != null && isOverUpdate.booleanValue()) {
                    this.staffBasicInfoService.update((Object)vo.getStaffInfo().getStaffBasicInfo(), vo.getStaffInfo().getCreateBy());
                }
            }
            if ((sd = this.certificateStaffDetailService.getCertForOrgByStaffId(staff.getStaffId(), cert.getId(), vo.getStaffInfo().getCid(), vo.getCertificateStaffDetail().getReportId())) == null) {
                vo.getCertificateStaffDetail().setCid(vo.getStaffInfo().getCid());
                vo.getCertificateStaffDetail().setCertId(cert.getId());
                vo.getCertificateStaffDetail().setStaffId(staff.getStaffId());
                vo.getCertificateStaffDetail().setCreateBy(vo.getStaffInfo().getCreateBy());
                sd = this.certificateStaffDetailService.addCertStaffForOrg(vo.getCertificateStaffDetail());
                continue;
            }
            vo.getCertificateStaffDetail().setId(sd.getId());
            if (vo.getCertificateStaffDetail() == null || vo.getCertificateStaffDetail().getId() == null) continue;
            this.certificateStaffDetailService.update((Object)vo.getCertificateStaffDetail(), vo.getStaffInfo().getCreateBy());
        }
    }

    public Map<Long, Integer> getTrainProjReportCountByYear(Integer year) {
        List<String> list = ((TrainProjReportMapper)this.dao).getTrainProjReportCountByYear(year);
        if (list == null || list.size() == 0) {
            return null;
        }
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        for (String str : list) {
            String[] arr = str.split("-");
            map.put(Long.valueOf(arr[0]), Integer.valueOf(arr[1]));
        }
        return map;
    }

    public List<Long> getCerFileIds(List<Long> reportIds) {
        return this.certificateStaffDetailService.getCerFileIds(reportIds);
    }

    public List<StaffCertDetailVo> getStaffCertListForOrg(CertificateStaffDetail info) {
        return this.certificateStaffDetailService.getStaffCertListForOrg(info);
    }

    @Transactional(readOnly=false)
    public void syncTrainProjReportToTrainPlan(TrainProjReport trainProjReport) {
        if (trainProjReport.getId() != null) {
            List<Long> cids;
            TrainProjReportVo tpr = this.getTrainProjReportVoById(trainProjReport.getId());
            CertificateStaffDetail searchVo = new CertificateStaffDetail();
            searchVo.setReportId(trainProjReport.getId());
            List<StaffCertDetailVo> list = this.getStaffCertListForOrg(searchVo);
            if (list != null && list.size() > 0 && (cids = list.stream().filter(s -> s.getCid() != null).mapToLong(StaffCertDetailVo::getCid).boxed().distinct().collect(Collectors.toList())) != null) {
                cids.forEach(s -> {
                    List staffIds;
                    TrainPlan trainPlan = new TrainPlan();
                    trainPlan.setCid(s);
                    trainPlan.setName(trainProjReport.getProjName());
                    trainPlan.setThirdOrgId(trainProjReport.getThirdOrgId());
                    trainPlan.setDataSource(Byte.valueOf((byte)2));
                    trainPlan.setReportId(trainProjReport.getId());
                    trainPlan.setRegisterTime(trainProjReport.getTrainBeginDate());
                    trainPlan.setWay(Byte.valueOf((byte)2));
                    trainPlan.setRegistrant(trainProjReport.getRegistrant());
                    trainPlan.setHsType("1");
                    trainPlan.setIsFinish(Boolean.valueOf(true));
                    trainPlan.setOrganizeDept(tpr == null ? "" : tpr.getThirdOrgName());
                    List types = list.stream().filter(x -> s.equals(x.getCid())).map(x -> {
                        if (x.getStaffType() != null) {
                            if (x.getStaffType() == 1) {
                                return "9";
                            }
                            if (x.getStaffType() == 2) {
                                return "10";
                            }
                        }
                        return "";
                    }).distinct().collect(Collectors.toList());
                    if (types != null && types.size() > 0) {
                        trainPlan.setType("," + String.join((CharSequence)",", types) + ",");
                    }
                    if ((staffIds = list.stream().filter(x -> s.equals(x.getCid())).map(x -> "" + x.getStaffId()).distinct().collect(Collectors.toList())) != null && staffIds.size() > 0) {
                        trainPlan.setTrainAttend(String.join((CharSequence)",", staffIds));
                    }
                    trainPlan = (TrainPlan)this.trainPlanService.add((Object)trainPlan, trainProjReport.getCreateBy(), s);
                    this.sysCoreWorkModuleCorrelationService.appearOrgTrainPlan(CoreWorkEnum.trainPlan, trainPlan.getId(), trainPlan.getName(), trainProjReport.getCreateBy(), s);
                });
            }
        }
    }

    public List<StaffCertDetailVo> exportStaffCertListForOrg(CertificateStaffDetail info) {
        List<StaffCertDetailVo> list = this.getStaffCertListForOrg(info);
        if (list == null) {
            list = new ArrayList<StaffCertDetailVo>();
        }
        list.forEach(s -> {
            AreaModel area;
            String idCard;
            if (s.getStaffType() != null) {
                if (s.getStaffType() == 1) {
                    s.setStaffTypeName("\u4e3b\u8981\u8d1f\u8d23\u4eba");
                } else if (s.getStaffType() == 2) {
                    s.setStaffTypeName("\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u4eba\u5458");
                }
            }
            if (IdcardUtil.isValidCard((String)(idCard = s.getIdCard()))) {
                int age = IdcardUtil.getAgeByIdCard((String)idCard);
                int gender = IdcardUtil.getGenderByIdCard((String)idCard);
                String genderStr = gender == 1 ? "\u7537" : "\u5973";
                s.setAge(Integer.valueOf(age));
                s.setGenderName(genderStr);
            }
            if (s.getAreaId() != null && (area = this.sysAreaProvideService.getAreaById(s.getAreaId())) != null) {
                s.setWorkLocationAddress(area.getFullname() + s.getAddDetail());
            }
            if (s.getCertId() != null) {
                switch (s.getCertId().toString()) {
                    case "12": {
                        s.setStaffTypeName("\u4f01\u4e1a\u4e3b\u8981\u8d1f\u8d23\u4eba\u8bc1\u4e66");
                        break;
                    }
                    case "13": {
                        s.setStaffTypeName("\u7ba1\u7406\u4eba\u5458\u8bc1\u4e66");
                        break;
                    }
                    default: {
                        s.setStaffTypeName("\u5176\u4ed6");
                    }
                }
            }
        });
        return list;
    }

    public Map<Long, Integer> getTrainProjCountMapByAreaIdAndOrgIds(Long areaId, Byte arealevel, List<Long> orgIds) {
        List<String> list = ((TrainProjReportMapper)this.dao).getTrainProjCountMapByAreaIdAndOrgIds(areaId, arealevel, orgIds);
        if (list == null || list.size() == 0) {
            return null;
        }
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        for (String str : list) {
            String[] arr = str.split("-");
            map.put(Long.valueOf(arr[0]), Integer.valueOf(arr[1]));
        }
        return map;
    }

    public int getTrainProjCountByAreaId(Long areaId, Byte arealevel) {
        Integer num = ((TrainProjReportMapper)this.dao).getTrainProjTotalByAreaId(areaId, arealevel);
        if (num != null) {
            return num;
        }
        return 0;
    }

    @Transactional(readOnly=false)
    public void deleteByProjNo(String projNo) {
        ((TrainProjReportMapper)this.dao).deleteByProjNo(projNo);
    }

    public TrainProjReport getByProjNo(String projNo) {
        Example example = new Example(TrainProjReport.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("projNo", (Object)projNo);
        List list = this.getListByExample(example);
        return list != null && !list.isEmpty() ? (TrainProjReport)list.get(0) : null;
    }

    public void asyncCallNotice(List<String> codes, Integer flag) {
        if (codes == null || codes.isEmpty()) {
            return;
        }
        if (this.train_project_import_callback_url == null || this.train_project_import_callback_url.isEmpty()) {
            this.logger.warn("\u57f9\u8bad\u9879\u76ee\u5916\u90e8\u5bfc\u5165\u56de\u8c03\u5730\u5740\u672a\u914d\u7f6e");
            return;
        }
        this.logger.info("\u57f9\u8bad\u9879\u76ee\u5916\u90e8\u5bfc\u5165\u56de\u8c03\u5730\u5740:{}", (Object)this.train_project_import_callback_url);
        this.threadPoolExecutor.execute(() -> {
            this.logger.info("\u901a\u77e5\u4fe1\u7528\u4ee3\u7801:{},flag:{}", (Object)codes, (Object)flag);
            JSONArray jsonArray = new JSONArray();
            for (String errorCode : codes) {
                JSONObject obj = new JSONObject();
                obj.put("companyCode", (Object)errorCode);
                obj.put("isCorrect", (Object)flag);
                jsonArray.add((Object)obj);
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("callBackVoList", (Object)jsonArray);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            String s = "";
            if (this.train_project_import_callback_url.startsWith("https")) {
                this.logger.info("https\u5730\u5740");
                s = HttpsUtil.doPost((String)this.train_project_import_callback_url, (String)JSON.toJSONString((Object)jsonObject), (String)"utf-8", headers);
            } else {
                this.logger.info("http\u5730\u5740");
                s = HttpUtil.doPostString((String)this.train_project_import_callback_url, (String)JSON.toJSONString((Object)jsonObject), headers, (String)"utf-8");
            }
            this.logger.info("\u57f9\u8bad\u9879\u76ee\u5bfc\u5165\uff0c\u63d0\u4ea4\u4f01\u4e1a:{},\u56de\u8c03\u7ed3\u679c:{}", (Object)codes, (Object)s);
        });
    }

    public TrainProjReport getByOnlineTrainId(Long trainId) {
        PageHelper.startPage((int)1, (int)1);
        Example example = new Example(TrainProjReport.class);
        example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("onlineTrainId", (Object)trainId).andEqualTo("type", (Object)2);
        return (TrainProjReport)this.getOneByExample(example);
    }

    private Date parseDateTime(String dateTime) throws ParseException {
        if (dateTime == null || dateTime.isEmpty()) {
            return null;
        }
        return this.dateFormat.parse(dateTime);
    }

    private void sendEmailNotice(List<String> codes) {
    }

    public Map<Long, TrainProjReport> getByOnlineTrainIds(String onlineTrainIds) {
        if (StringUtils.isEmpty((CharSequence)onlineTrainIds)) {
            return null;
        }
        List<String> list = Arrays.asList(onlineTrainIds.split(","));
        return ((TrainProjReportMapper)this.dao).getByOnlineTrainIds(list);
    }

    public List<Long> getAllOnlineTrainId() {
        return ((TrainProjReportMapper)this.dao).getAllOnlineTrainId();
    }
}

