/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.operate.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.map.MapUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.supervise.dao.operate.WorkOperateLogMapper;
import cn.smarthse.modules.health.supervise.entity.operate.WorkOperateLog;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogEnum;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogStatusEnum;
import cn.smarthse.modules.health.supervise.service.operate.IWorkOperateLogService;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateService;
import cn.smarthse.snowflake.IdWorker;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class WorkOperateLogServiceImpl
extends BaseServiceImpl<WorkOperateLogMapper, WorkOperateLog>
implements IWorkOperateLogService {
    @Autowired
    protected IdWorker idworker;
    @DubboReference
    private IRiskExposeEvaluateService riskExposeEvaluateService;

    public PageInfo<WorkOperateLog> getPage(JqGridParam gparam, Long workId) {
        if (gparam == null || workId == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<WorkOperateLog> list = this.getList(workId, null);
        return new PageInfo(list);
    }

    public PageInfo<WorkOperateLog> getPageList(JqGridParam jparam, Long workId, Byte workModule) {
        if (jparam == null || workId == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        List<WorkOperateLog> list = this.getList(workId, workModule);
        return new PageInfo(list);
    }

    private List<WorkOperateLog> getList(Long workId, Byte workModule) {
        Example example = new Example(WorkOperateLog.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("workId", (Object)workId);
        criteria.andEqualTo("isValid", (Object)true);
        if (workModule != null) {
            criteria.andEqualTo("workModule", (Object)workModule);
        }
        example.setOrderByClause("create_date desc");
        return ((WorkOperateLogMapper)this.dao).selectByExample(example);
    }

    private List<WorkOperateLog> getListByWorkIds(Set<Long> workIds, Byte workModule) {
        Example example = new Example(WorkOperateLog.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)true).andIn("workId", workIds);
        if (workModule != null) {
            criteria.andEqualTo("workModule", (Object)workModule);
        }
        example.setOrderByClause("create_date desc");
        return ((WorkOperateLogMapper)this.dao).selectByExample(example);
    }

    public PageInfo<WorkOperateLog> getPageByWorkIds(JqGridParam gparam, Set<Long> workIds, Byte workModule) {
        if (gparam == null || workIds == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<WorkOperateLog> list = this.getListByWorkIds(workIds, workModule);
        return new PageInfo(list);
    }

    private void addLog(Long workId, Byte workModule, String reason, Long operaterId, String operaterName, Byte status, String companyName) {
        Date now = new Date();
        if (StringUtils.sql_inj((String)reason).booleanValue()) {
            reason = null;
        }
        if (StringUtils.sql_inj((String)operaterName).booleanValue()) {
            operaterName = null;
        }
        if (StringUtils.sql_inj((String)companyName).booleanValue()) {
            companyName = null;
        }
        WorkOperateLog log = new WorkOperateLog(Long.valueOf(this.idworker.nextId()), workModule, workId, status, reason, now, operaterName, operaterId, now, operaterId, companyName);
        ((WorkOperateLogMapper)this.dao).insertSelective(log);
    }

    private void addLogUseCid(Long workId, Byte workModule, String reason, Long operaterId, String operaterName, Byte status, Long cid) {
        Date now = new Date();
        if (StringUtils.sql_inj((String)reason).booleanValue()) {
            reason = null;
        }
        if (StringUtils.sql_inj((String)operaterName).booleanValue()) {
            operaterName = null;
        }
        WorkOperateLog log = new WorkOperateLog(Long.valueOf(this.idworker.nextId()), workModule, workId, status, reason, now, operaterName, operaterId, now, operaterId, cid);
        ((WorkOperateLogMapper)this.dao).insertSelective(log);
    }

    @Transactional
    public void back(Long workId, Byte workModule, String reason, Long operaterId, String operaterName, String companyName) {
        this.addLog(workId, workModule, reason, operaterId, operaterName, WorkOperateLogStatusEnum.back.getVal(), companyName);
    }

    @Transactional
    public void backUseCid(Long workId, Byte workModule, String reason, Long operaterId, String operaterName, Long cid) {
        this.addLogUseCid(workId, workModule, reason, operaterId, operaterName, WorkOperateLogStatusEnum.back.getVal(), cid);
    }

    @Transactional
    public void backUseCidList(Long workId, Byte workModule, String reason, Long operaterId, String operaterName, List<Long> cidList) {
        if (CollUtil.isEmpty(cidList)) {
            return;
        }
        Date now = new Date();
        ArrayList<WorkOperateLog> list = new ArrayList<WorkOperateLog>(cidList.size());
        for (Long cid : cidList) {
            list.add(new WorkOperateLog(Long.valueOf(this.idworker.nextId()), workModule, workId, WorkOperateLogStatusEnum.back.getVal(), reason, now, operaterName, operaterId, now, operaterId, cid));
        }
        this.batchUpdateOrInsert(list, WorkOperateLogMapper.class, (item, mapper) -> mapper.insertSelective(item));
    }

    @Transactional
    public void report(Long workId, Byte workModule, Long operaterId, String operaterName, String companyName) {
        this.addLog(workId, workModule, null, operaterId, operaterName, WorkOperateLogStatusEnum.report.getVal(), companyName);
    }

    @Transactional
    public void reportUseCid(Long workId, Byte workModule, Long operaterId, String operaterName, Long cid) {
        this.addLogUseCid(workId, workModule, null, operaterId, operaterName, WorkOperateLogStatusEnum.report.getVal(), cid);
    }

    @Transactional
    public String reportLogSql(Long workId, Byte workModule, Long operaterId, String operaterName, String companyName) {
        Date now = new Date();
        String dateStr = DateUtils.format((Date)now, (String)"yyyy-MM-dd HH:mm:ss");
        Long id = this.idworker.nextId();
        WorkOperateLog log = new WorkOperateLog(id, workModule, workId, WorkOperateLogStatusEnum.report.getVal(), null, now, operaterName, operaterId, now, operaterId, companyName);
        String sql = "insert into work_operate_log(id,work_module,work_id,work_status,create_date,operater,create_by,update_date,is_valid,company_name) values(" + id + "," + workModule + "," + workId + ",1,'" + dateStr + "','" + companyName + "'," + operaterId + ",'" + dateStr + "',1,'" + companyName + "');";
        return sql;
    }

    public Boolean isBack(Long workId, Byte workModule) {
        WorkOperateLog log = ((WorkOperateLogMapper)this.dao).lastWorkOperateBackLog(workId, workModule);
        return log != null;
    }

    @Transactional
    public void pass(Long workId, Byte workModule, Long operaterId, String operaterName, String companyName) {
        this.addLog(workId, workModule, null, operaterId, operaterName, WorkOperateLogStatusEnum.pass.getVal(), companyName);
    }

    @Transactional
    public void passUseCid(Long workId, Byte workModule, Long operaterId, String operaterName, Long cid) {
        this.addLogUseCid(workId, workModule, null, operaterId, operaterName, WorkOperateLogStatusEnum.pass.getVal(), cid);
    }

    @Transactional
    public void passUseCidList(Long workId, Byte workModule, Long operaterId, String operaterName, List<Long> cidList) {
        if (CollUtil.isEmpty(cidList)) {
            return;
        }
        Date now = new Date();
        ArrayList<WorkOperateLog> list = new ArrayList<WorkOperateLog>(cidList.size());
        for (Long cid : cidList) {
            list.add(new WorkOperateLog(Long.valueOf(this.idworker.nextId()), workModule, workId, WorkOperateLogStatusEnum.pass.getVal(), null, now, operaterName, operaterId, now, operaterId, cid));
        }
        this.batchUpdateOrInsert(list, WorkOperateLogMapper.class, (item, mapper) -> mapper.insertSelective(item));
    }

    @Transactional
    public void addOperateLog(Long workId, Byte workModule, String reason, Long operaterId, String operaterName, WorkOperateLogStatusEnum status, String companyName) {
        this.addLog(workId, workModule, reason, operaterId, operaterName, status.getVal(), companyName);
    }

    @Transactional
    public void addOperateLogUseCid(Long workId, Byte workModule, String reason, Long operaterId, String operaterName, WorkOperateLogStatusEnum status, Long cid) {
        this.addLogUseCid(workId, workModule, reason, operaterId, operaterName, status.getVal(), cid);
    }

    public void addOperateLogUseCidList(Long workId, Byte workModule, String reason, Long operaterId, String operaterName, WorkOperateLogStatusEnum status, List<Long> cidList) {
        if (CollUtil.isEmpty(cidList)) {
            return;
        }
        Date now = new Date();
        ArrayList<WorkOperateLog> list = new ArrayList<WorkOperateLog>(cidList.size());
        for (Long cid : cidList) {
            list.add(new WorkOperateLog(Long.valueOf(this.idworker.nextId()), workModule, workId, status.getVal(), null, now, operaterName, operaterId, now, operaterId, cid));
        }
        this.batchUpdateOrInsert(list, WorkOperateLogMapper.class, (item, mapper) -> mapper.insertSelective(item));
    }

    @Transactional
    public void ignore(Long workId, Byte workModule, Long operaterId, String operaterName, String companyName) {
        this.addLog(workId, workModule, null, operaterId, operaterName, WorkOperateLogStatusEnum.ignore.getVal(), companyName);
    }

    @Transactional
    public void ignore(Long workId, Byte workModule, String reason, Long operaterId, String operaterName, String companyName) {
        this.addLog(workId, workModule, reason, operaterId, operaterName, WorkOperateLogStatusEnum.ignore.getVal(), companyName);
    }

    @Transactional
    public void ignoreUseWorkIdList(List<Long> workIdList, Byte workModule, String reason, Long operaterId, String operaterName, Long cid) {
        if (CollUtil.isEmpty(workIdList)) {
            return;
        }
        Date now = new Date();
        ArrayList<WorkOperateLog> list = new ArrayList<WorkOperateLog>(workIdList.size());
        for (Long workId : workIdList) {
            list.add(new WorkOperateLog(Long.valueOf(this.idworker.nextId()), workModule, workId, WorkOperateLogStatusEnum.ignore.getVal(), reason, now, operaterName, operaterId, now, operaterId, cid));
        }
        this.batchUpdateOrInsert(list, WorkOperateLogMapper.class, (item, mapper) -> mapper.insertSelective(item));
    }

    @Transactional
    public void retip(Long workId, Byte workModule, Long operaterId, String operaterName, String companyName) {
        this.addLog(workId, workModule, null, operaterId, operaterName, WorkOperateLogStatusEnum.retip.getVal(), companyName);
    }

    @Transactional
    public void riskUpdateLog(Integer page, Integer size) throws IOException {
        List risks = this.riskExposeEvaluateService.updateRiskLevelAndLog(page, size);
        StringBuilder levelStr = new StringBuilder();
        StringBuilder logStr = new StringBuilder();
        if (risks != null) {
            for (RiskExposeEvaluate risk : risks) {
                String updateSql = "update  risk_expose_evaluate set risk_level=" + risk.getRiskLevel() + " where id=" + risk.getId() + ";";
                String insertLogSql = this.reportLogSql(risk.getId(), WorkOperateLogEnum.investigationRiskAssessment.getTypeVal(), 2179614949624832L, "\u6d59\u6c5f\u7701\u75be\u75c5\u9884\u9632\u63a7\u5236\u4e2d\u5fc3", "\u6d59\u6c5f\u7701\u75be\u75c5\u9884\u9632\u63a7\u5236\u4e2d\u5fc3");
                levelStr.append(updateSql);
                levelStr.append("\r\n");
                logStr.append(insertLogSql);
                logStr.append("\r\n");
            }
        }
        String word = levelStr.toString() + logStr.toString();
        FileOutputStream fileOutputStream = null;
        File file = new File("E:/testfile/test.txt");
        if (!file.exists()) {
            file.createNewFile();
        }
        fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(word.getBytes("gbk"));
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    @Transactional
    public void addOnlineTrainLog(Long workId, Byte workModule, String reason, Long operaterId, String operaterName, Byte workStatus, String companyName) {
        this.addLog(workId, workModule, reason, operaterId, operaterName, workStatus, companyName);
    }

    public WorkOperateLog getReason(Long workId, Byte workModule, WorkOperateLogStatusEnum status, Long cid) {
        List<WorkOperateLog> list = ((WorkOperateLogMapper)this.dao).getReason(workId, workModule, status.getVal(), cid);
        return CollUtil.isEmpty(list) ? null : list.get(0);
    }

    public Map<Pair<Long, Long>, WorkOperateLog> getReasonBatch(Byte workModule, WorkOperateLogStatusEnum status, List<Pair<Long, Long>> workIdCidPairs) {
        if (CollUtil.isEmpty(workIdCidPairs)) {
            return MapUtil.newHashMap();
        }
        HashSet<Pair<Long, Long>> pairSet = new HashSet<Pair<Long, Long>>(workIdCidPairs);
        List<Long> workIdList = workIdCidPairs.stream().map(Pair::getKey).distinct().collect(Collectors.toList());
        List<Long> cidList = workIdCidPairs.stream().map(Pair::getValue).distinct().collect(Collectors.toList());
        List<WorkOperateLog> list = ((WorkOperateLogMapper)this.dao).getReasonBatchSimple(workModule, status.getVal(), workIdList, cidList);
        HashMap<Pair<Long, Long>, WorkOperateLog> resultMap = new HashMap<Pair<Long, Long>, WorkOperateLog>();
        Map<Pair, List<WorkOperateLog>> groupedLogs = list.stream().filter(log -> pairSet.contains(new Pair((Object)log.getWorkId(), (Object)log.getCid()))).collect(Collectors.groupingBy(log -> new Pair((Object)log.getWorkId(), (Object)log.getCid())));
        groupedLogs.forEach((key, logs) -> {
            logs.sort((log1, log2) -> log2.getCreateDate().compareTo(log1.getCreateDate()));
            resultMap.put((Pair<Long, Long>)key, (WorkOperateLog)logs.get(0));
        });
        return resultMap;
    }

    public Boolean hasLog(Long workId) {
        Example example = new Example(WorkOperateLog.class);
        example.createCriteria().andEqualTo("workId", (Object)workId).andEqualTo("isValid", (Object)true);
        example.setOrderByClause("create_date desc");
        List workOperateLogs = ((WorkOperateLogMapper)this.dao).selectByExample(example);
        return !CollectionUtils.isEmpty((Collection)workOperateLogs);
    }

    @Transactional
    public void addCompanyChangeLog(Long workId, Long operaterId, String operaterName, Byte workStatus, List<Long> cidList, String reason) {
        Date now = new Date();
        ArrayList<WorkOperateLog> list = new ArrayList<WorkOperateLog>();
        if (CollUtil.isEmpty(cidList)) {
            list.add(new WorkOperateLog(Long.valueOf(this.idworker.nextId()), WorkOperateLogEnum.companyChange.getTypeVal(), workId, workStatus, reason, now, operaterName, operaterId, now, operaterId));
        } else {
            for (Long cid : cidList) {
                list.add(new WorkOperateLog(Long.valueOf(this.idworker.nextId()), WorkOperateLogEnum.companyChange.getTypeVal(), workId, workStatus, reason, now, operaterName, operaterId, now, operaterId, cid));
            }
        }
        this.batchUpdateOrInsert(list, WorkOperateLogMapper.class, (item, mapper) -> mapper.insertSelective(item));
    }

    @Transactional
    public void reportBacth(List<WorkOperateLog> addWorkOperateLogList) {
        if (CollectionUtil.isEmpty(addWorkOperateLogList)) {
            return;
        }
        ((WorkOperateLogMapper)this.dao).insertList2(addWorkOperateLogList);
    }
}

