/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.onlineMonitoring.syncdata;

import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.modules.datacentre.model.system.riskFactors.OccupationalRiskAttrModel;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IOccupationalRiskAttrProvideService;
import cn.smarthse.modules.health.onlineMonitoring.service.device.IOnlineMonitorDeviceFactorService;
import cn.smarthse.modules.health.supervise.dao.onlineMonitoring.OnlineDeviceMapper;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDevice;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDeviceAlarm;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDeviceAlarmLog;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDeviceRealData;
import cn.smarthse.modules.health.supervise.enums.onlinedevice.AlarmCondition;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceAlarmLogService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceAlarmService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceService;
import cn.smarthse.snowflake.IdWorker;
import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class OnlineRealDataAlarmServiceImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OnlineRealDataAlarmServiceImpl.class);
    @Autowired
    private IOnlineDeviceService onlineDeviceService;
    @Autowired
    private IOnlineDeviceAlarmService onlineDeviceAlarmService;
    @Autowired
    private IOnlineDeviceAlarmLogService onlineDeviceAlarmLogService;
    @Autowired
    private IOnlineMonitorDeviceFactorService deviceFactorService;
    @Value(value="${cron.onlineMonitorTask.seq:}")
    private String onlineMonitorTaskSeq;
    @DubboReference(version="1.0.0")
    IHarmFactorService harmFactorService;
    @Autowired
    protected IdWorker idworker;
    @Autowired
    private RedisClient redisClient;
    @DubboReference
    private IOccupationalRiskAttrProvideService riskAttrProvideService;
    private static final String ING_ALARM_CACHE_NAME = "ingAlarmCache";
    private static final String HARMID_CASE_CACHE_NAME = "harmid:alarmcase";
    private static final String HARMID_DATATYPE_ATTRNAME_VALUE = "harmid:datatype:attrname:value";
    private static final String ALARM_DEVICE_COUNT = "alarm:device:count";
    public static final int EXCURSION_LIMIT = 5;
    public static final int ALARM_COUNT = 3;

    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void handleOnlineMonitorData(List<OnlineDeviceRealData> realTimeDataList) {
        log.info("\u5904\u7406\u5b9e\u65f6\u91c7\u96c6\u6570\u636e\u62a5\u8b66\u4efb\u52a1\uff1a{}", (Object)Thread.currentThread().getName());
        if (CollectionUtils.isEmpty(realTimeDataList)) {
            return;
        }
        List dbOnlineDevice = this.onlineDeviceService.getCacheOnlineDeviceList(null);
        if (CollectionUtils.isEmpty((Collection)dbOnlineDevice)) {
            return;
        }
        List effectiveRealDataList = realTimeDataList.stream().filter(f -> {
            if (StringUtils.isBlank((CharSequence)f.getVData()) || !StringUtils.isNumber((String)f.getVData())) {
                log.warn("\u76d1\u6d4b\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u8bb0\u5f55\uff0c OnlineDeviceRealData\uff1a{}", (Object)JSON.toJSONString((Object)f));
                return false;
            }
            return StringUtils.isNumber((String)f.getVData());
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(effectiveRealDataList)) {
            ArrayList<OnlineDeviceAlarmLog> alarmLogResultList = new ArrayList<OnlineDeviceAlarmLog>();
            ArrayList<OnlineDeviceAlarm> alarmResultList = new ArrayList<OnlineDeviceAlarm>();
            Map<Long, List<OnlineDeviceRealData>> deviceIdGroupMap = effectiveRealDataList.stream().collect(Collectors.groupingBy(OnlineDeviceRealData::getDeviceId));
            if (MapUtils.isNotEmpty(deviceIdGroupMap)) {
                Set<Long> deviceIdSet = deviceIdGroupMap.keySet();
                for (Long deviceId : deviceIdSet) {
                    List<OnlineDeviceRealData> onlineDeviceRealDataList = deviceIdGroupMap.get(deviceId);
                    this.handleAlarmInfo(onlineDeviceRealDataList, alarmResultList, alarmLogResultList);
                }
            }
            this.onlineDeviceAlarmLogService.insertAlarmLogDatas(alarmLogResultList);
            this.onlineDeviceAlarmService.insertAlarmDatas(alarmResultList);
            this.updateDeviceStatu(alarmResultList);
        }
    }

    private String getCacheKey(Long deviceId, Long factorId, Integer dataType) {
        String s1 = deviceId == null ? "" : deviceId.toString();
        String s2 = factorId == null ? "" : factorId.toString();
        String s3 = dataType == null ? "" : dataType.toString();
        return s1 + s2 + s3;
    }

    public void updateDeviceStatu(List<OnlineDeviceAlarm> alarmResultList) {
        HashMap<Long, OnlineDevice> onlineDeviceMap = new HashMap<Long, OnlineDevice>();
        if (CollectionUtils.isNotEmpty(alarmResultList)) {
            for (OnlineDeviceAlarm onlineDeviceAlarm : alarmResultList) {
                OnlineDevice device1 = onlineDeviceMap.computeIfAbsent(onlineDeviceAlarm.getDeviceId(), k -> {
                    OnlineDevice device = new OnlineDevice();
                    device.setStatus(Byte.valueOf((byte)0));
                    device.setId(onlineDeviceAlarm.getDeviceId());
                    return device;
                });
                device1.setLatestAlarmDate(new Date());
                if (!onlineDeviceAlarm.getIng().booleanValue()) continue;
                device1.setStatus(Byte.valueOf((byte)1));
            }
            ArrayList deviceList = new ArrayList(onlineDeviceMap.values());
            int n = this.onlineDeviceService.batchUpdateOrInsert(deviceList, OnlineDeviceMapper.class, (item, d) -> d.updateByPrimaryKeySelective(item));
        }
    }

    public String getOverLimitByFactorId(Long factorId, Integer dataType) {
        if (factorId == null) {
            return null;
        }
        String cacheKey = factorId + String.valueOf(dataType == null ? "" : dataType);
        String value = (String)this.redisClient.get(HARMID_DATATYPE_ATTRNAME_VALUE, cacheKey, 1440L, () -> {
            HarmFactor harmFactor;
            if (Objects.equals(dataType, 1002) && (harmFactor = this.harmFactorService.getThisById(factorId)) != null && harmFactor.getCid() != null && Objects.equals(harmFactor.getType(), "\u7c89\u5c18")) {
                return "8";
            }
            List factorLimitValues = this.riskAttrProvideService.getByFactorId(factorId);
            if (CollectionUtils.isNotEmpty((Collection)factorLimitValues)) {
                Map<String, String> limitMap = factorLimitValues.stream().collect(Collectors.toMap(OccupationalRiskAttrModel::getAttrName, OccupationalRiskAttrModel::getAttrValue));
                String attrName = "";
                String attrValue = "";
                if (Objects.equals(dataType, 1002)) {
                    attrValue = limitMap.get("twa_total");
                    if (StringUtils.isNumber((String)attrValue)) {
                        BigDecimal multiply = new BigDecimal(attrValue).multiply(new BigDecimal(5));
                        attrValue = multiply.stripTrailingZeros().toPlainString();
                    }
                } else if (Objects.equals(dataType, 1003)) {
                    attrValue = limitMap.get("twa_respirabel");
                    if (StringUtils.isNumber((String)attrValue)) {
                        BigDecimal multiply = new BigDecimal(attrValue).multiply(new BigDecimal(5));
                        attrValue = multiply.stripTrailingZeros().toPlainString();
                    }
                } else {
                    String mac = limitMap.get("mac");
                    String twa = limitMap.get("twa");
                    String stel = limitMap.get("stel");
                    if (StringUtils.isNotBlank((CharSequence)mac)) {
                        attrValue = mac;
                    } else if (StringUtils.isNotBlank((CharSequence)stel)) {
                        attrValue = stel;
                    } else if (StringUtils.isNotBlank((CharSequence)twa)) {
                        BigDecimal multiply = new BigDecimal(twa).multiply(new BigDecimal(5));
                        attrValue = multiply.stripTrailingZeros().toPlainString();
                    }
                }
                return attrValue;
            }
            return null;
        });
        return value;
    }

    private void handleAlarmInfo(List<OnlineDeviceRealData> realTimeData, List<OnlineDeviceAlarm> alarmResultList, List<OnlineDeviceAlarmLog> alarmLogResultList) {
        if (CollectionUtils.isEmpty(realTimeData) || realTimeData.get(0).getDeviceId() == null) {
            return;
        }
        Long deviceId = realTimeData.get(0).getDeviceId();
        List onlineDeviceList = this.onlineDeviceService.getCacheOnlineDeviceList(deviceId);
        if (CollectionUtils.isEmpty((Collection)onlineDeviceList)) {
            log.error("\u83b7\u5f97\u76d1\u6d4b\u6570\u636e\u4e2d\u7684\u8bbe\u5907id \u5728\u8bbe\u5907\u8868\u4e2d\u4e0d\u5b58\u5728\uff0c deviceId:{}", (Object)deviceId);
            return;
        }
        OnlineDevice onlineDevice = (OnlineDevice)onlineDeviceList.get(0);
        for (OnlineDeviceRealData realTimeDatum : realTimeData) {
            BigDecimal ingAlarmValueBig;
            Integer dataType;
            Long factorId = realTimeDatum.getFactorId();
            String overLimitByFactorId = this.getOverLimitByFactorId(factorId, dataType = realTimeDatum.getDataType());
            if (StringUtils.isBlank((CharSequence)overLimitByFactorId)) {
                log.warn("\u5371\u5bb3\u56e0\u7d20\uff1a{}\uff0c dataType\uff1a{} \u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5371\u5bb3\u56e0\u7d20\u9650\u503c \u4e0d\u80fd\u4ea7\u751f\u9884\u8b66", (Object)factorId, (Object)dataType);
                continue;
            }
            BigDecimal dataValueBig = new BigDecimal(realTimeDatum.getVData());
            BigDecimal alarmValue = new BigDecimal(overLimitByFactorId);
            OnlineDeviceAlarm ingAlarm = this.getTaskIngAlarmByDevice(onlineDevice, factorId, dataType);
            if (ingAlarm != null && StringUtils.isNotBlank((CharSequence)ingAlarm.getAlarmVdata()) && alarmValue.compareTo(ingAlarmValueBig = new BigDecimal(ingAlarm.getAlarmVdata())) != 0) {
                log.warn("\u91cd\u65b0\u4fee\u6539\u4e86\u62a5\u8b66\u9608\u503c, \u91cd\u65b0\u62a5\u8b66--");
                ingAlarm.setAlarmReason("\u4fee\u6539\u62a5\u8b66\u9608\u503c");
                this.onlineDeviceAlarmService.closeAlarm(ingAlarm, true);
                this.delAlarm(this.getCacheKey(deviceId, factorId, dataType));
                ingAlarm = null;
            }
            if (Objects.equals(factorId, 567L)) {
                dataValueBig = dataValueBig.setScale(1, 4);
            }
            OnlineDeviceAlarm alarm = new OnlineDeviceAlarm();
            alarm.setDeviceId(onlineDevice.getId());
            alarm.setCases(this.getAlarmCaseByHarmId(factorId));
            alarm.setId(Long.valueOf(this.idworker.nextId()));
            alarm.setFactorId(factorId);
            alarm.setIng(Boolean.valueOf(false));
            alarm.setDataType(dataType);
            alarm.setSeq(this.onlineMonitorTaskSeq);
            String alarmCacheKey = this.getCacheKey(deviceId, factorId, dataType);
            if (dataValueBig.compareTo(alarmValue) >= 0) {
                long alarmCount = this.redisClient.incr(ALARM_DEVICE_COUNT + alarmCacheKey, 1L);
                alarm.setIng(Boolean.valueOf(true));
                alarm.setAlarmVdata(overLimitByFactorId);
                alarm.setAlarmType(Integer.valueOf(2));
                if (ingAlarm != null) {
                    OnlineDeviceAlarmLog log = new OnlineDeviceAlarmLog();
                    log.setVData(Double.valueOf(dataValueBig.doubleValue()));
                    log.setAlarmId(ingAlarm.getId());
                    log.setCreateDate(new Date());
                    alarmLogResultList.add(log);
                    continue;
                }
                if (alarmCount < 3L) continue;
                ingAlarm = alarm;
                this.redisClient.set("ingAlarmCache:" + alarmCacheKey, (Object)alarm);
                alarmResultList.add(alarm);
                continue;
            }
            this.redisClient.del(new String[]{ALARM_DEVICE_COUNT + alarmCacheKey});
            this.delAlarm(alarmCacheKey);
            if (ingAlarm != null) {
                ingAlarm.setIng(Boolean.valueOf(false));
                this.onlineDeviceAlarmService.closeAlarm(ingAlarm, true);
            }
            this.delAlarm(alarmCacheKey);
        }
    }

    private void delAlarm(String key) {
        this.redisClient.del(new String[]{"ingAlarmCache:" + key});
    }

    private Integer getAlarmCaseByDeviceType(Integer deviceType) {
        if (deviceType == null) {
            return null;
        }
        AlarmCondition alarmCase = null;
        if (deviceType != null) {
            if (deviceType == 1) {
                alarmCase = AlarmCondition.DUST_OR_CHEMICAL_OVERPROOF;
            } else if (deviceType == 2) {
                alarmCase = AlarmCondition.NOISE_OVERPROOF;
            }
            if (alarmCase != null) {
                return alarmCase.getCode();
            }
        }
        return null;
    }

    private Integer getAlarmCaseByHarmId(Long harmId) {
        if (harmId == null) {
            return null;
        }
        if (harmId != null) {
            Integer alarmCaseInt = (Integer)this.redisClient.get(HARMID_CASE_CACHE_NAME, "" + harmId, 0L, () -> {
                HarmFactor harmFactor = this.harmFactorService.getThisById(harmId);
                if (harmFactor != null) {
                    String type = harmFactor.getType();
                    if ("\u7269\u7406\u56e0\u7d20".equals(type)) {
                        return AlarmCondition.NOISE_OVERPROOF.getCode();
                    }
                    if ("\u7c89\u5c18".equals(type)) {
                        return AlarmCondition.DUST_OR_CHEMICAL_OVERPROOF.getCode();
                    }
                }
                return null;
            });
            return alarmCaseInt;
        }
        return null;
    }

    private OnlineDeviceAlarm getTaskIngAlarmByDevice(OnlineDevice onlineDevice, Long factorId, Integer dataType) {
        if (onlineDevice == null || onlineDevice.getId() == null) {
            return null;
        }
        if (onlineDevice.getType() == null) {
            log.error("\u83b7\u53d6\u8be5\u8bbe\u5907\u7684\u62a5\u8b66\u4fe1\u606f\u51fa\u9519\uff0c\u8bbe\u5907\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a, {}", (Object)JSON.toJSONString((Object)onlineDevice));
            return null;
        }
        OnlineDeviceAlarm ingAlarm = (OnlineDeviceAlarm)this.redisClient.get(ING_ALARM_CACHE_NAME, this.getCacheKey(onlineDevice.getId(), factorId, dataType), 0L, () -> {
            String types = onlineDevice.getType();
            OnlineDeviceAlarm dbIngAlarm = this.onlineDeviceAlarmService.getDbIngAlarm(onlineDevice.getId(), factorId, Integer.valueOf(2), null, dataType);
            return dbIngAlarm;
        });
        return ingAlarm;
    }

    public void clearIngAlarmCacheByDeviceId(Long deviceId, Long factorId, Integer dataType) {
        if (deviceId == null) {
            return;
        }
        if (factorId != null) {
            this.delAlarm(this.getCacheKey(deviceId, factorId, dataType));
        } else {
            Map stringOnlineDeviceAlarmConcurrentMap = this.redisClient.mapByPrefix(ING_ALARM_CACHE_NAME);
            if (MapUtils.isNotEmpty((Map)stringOnlineDeviceAlarmConcurrentMap)) {
                HashSet<String> removeKey = new HashSet<String>();
                Set<@NonNull K> keySet = stringOnlineDeviceAlarmConcurrentMap.keySet();
                for (String key : keySet) {
                    if (!key.contains(deviceId.toString())) continue;
                    removeKey.add(key);
                }
                if (CollectionUtils.isNotEmpty(removeKey)) {
                    this.redisClient.del(removeKey);
                }
            }
        }
    }
}

