/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.onlineMonitoring.syncdata;

import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.onlineMonitoring.service.device.IOnlineMonitorDeviceFactorService;
import cn.smarthse.modules.health.supervise.dao.onlineMonitoring.OnlineDeviceMapper;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDevice;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDeviceAlarm;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDeviceAlarmLog;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDeviceRealData;
import cn.smarthse.modules.health.supervise.enums.onlinedevice.AlarmCondition;
import cn.smarthse.modules.health.supervise.model.onlinemonitor.OnlineDeviceAlarmSettingModel;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceAlarmLogService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceAlarmService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceService;
import cn.smarthse.snowflake.IdWorker;
import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class OnlineDeviceAlarmTaskServiceImpl {
    protected Logger logger = LoggerFactory.getLogger((String)"onlinemonitorlogger");
    @Autowired
    private IOnlineDeviceService onlineDeviceService;
    @Autowired
    private IOnlineDeviceAlarmService onlineDeviceAlarmService;
    @Autowired
    private IOnlineDeviceAlarmLogService onlineDeviceAlarmLogService;
    @Autowired
    private IOnlineMonitorDeviceFactorService deviceFactorService;
    @Value(value="${cron.onlineMonitorTask.seq:}")
    private String onlineMonitorTaskSeq;
    @DubboReference(version="1.0.0")
    IHarmFactorService harmFactorService;
    @Autowired
    protected IdWorker idworker;
    @Autowired
    private RedisClient redisClient;
    private ConcurrentHashMap<String, LongAdder> alarmDeviceCountMap = new ConcurrentHashMap();
    private static final String ING_ALARM_CACHE_NAME = "ingAlarmCache";
    private static final String HARMID_CASE_CACHE_NAME = "harmid:alarmcase";

    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void handleOnlineMonitorData(List<OnlineDeviceRealData> realTimeDataList) {
        this.logger.info("\u5904\u7406\u5b9e\u65f6\u91c7\u96c6\u6570\u636e\u62a5\u8b66\u4efb\u52a1\uff1a{}", (Object)Thread.currentThread().getName());
        if (CollectionUtils.isEmpty(realTimeDataList)) {
            return;
        }
        List dbOnlineDevice = this.onlineDeviceService.getCacheOnlineDeviceList(null);
        if (CollectionUtils.isEmpty((Collection)dbOnlineDevice)) {
            return;
        }
        List effectiveRealDataList = realTimeDataList.stream().filter(f -> {
            if (StringUtils.isBlank((CharSequence)f.getVData()) || !StringUtils.isNumber((String)f.getVData())) {
                this.logger.warn("\u76d1\u6d4b\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u8bb0\u5f55\uff0c OnlineDeviceRealData\uff1a{}", (Object)JSON.toJSONString((Object)f));
                return false;
            }
            return StringUtils.isNumber((String)f.getVData());
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(effectiveRealDataList)) {
            ArrayList<OnlineDeviceAlarmLog> alarmLogResultList = new ArrayList<OnlineDeviceAlarmLog>();
            ArrayList<OnlineDeviceAlarm> alarmResultList = new ArrayList<OnlineDeviceAlarm>();
            Map<Long, List<OnlineDeviceRealData>> deviceIdGroupMap = effectiveRealDataList.stream().collect(Collectors.groupingBy(OnlineDeviceRealData::getDeviceId));
            if (MapUtils.isNotEmpty(deviceIdGroupMap)) {
                Set<Long> deviceIdSet = deviceIdGroupMap.keySet();
                for (Long deviceId : deviceIdSet) {
                    List<OnlineDeviceRealData> onlineDeviceRealDataList = deviceIdGroupMap.get(deviceId);
                    this.handleAlarmInfo(onlineDeviceRealDataList, alarmResultList, alarmLogResultList);
                }
            }
            this.onlineDeviceAlarmLogService.insertAlarmLogDatas(alarmLogResultList);
            this.onlineDeviceAlarmService.insertAlarmDatas(alarmResultList);
            this.updateDeviceStatu(alarmResultList);
        }
    }

    private String getCacheKey(Long deviceId, Long factorId, Integer dataType) {
        String s1 = deviceId == null ? "" : deviceId.toString();
        String s2 = factorId == null ? "" : factorId.toString();
        String s3 = dataType == null ? "" : dataType.toString();
        return s1 + s2 + s3;
    }

    public void updateDeviceStatu(List<OnlineDeviceAlarm> alarmResultList) {
        HashMap<Long, OnlineDevice> onlineDeviceMap = new HashMap<Long, OnlineDevice>();
        if (CollectionUtils.isNotEmpty(alarmResultList)) {
            for (OnlineDeviceAlarm onlineDeviceAlarm : alarmResultList) {
                OnlineDevice device1 = onlineDeviceMap.computeIfAbsent(onlineDeviceAlarm.getDeviceId(), k -> {
                    OnlineDevice device = new OnlineDevice();
                    device.setStatus(Byte.valueOf((byte)0));
                    device.setId(onlineDeviceAlarm.getDeviceId());
                    return device;
                });
                device1.setLatestAlarmDate(new Date());
                if (!onlineDeviceAlarm.getIng().booleanValue()) continue;
                device1.setStatus(Byte.valueOf((byte)1));
            }
            ArrayList deviceList = new ArrayList(onlineDeviceMap.values());
            int n = this.onlineDeviceService.batchUpdateOrInsert(deviceList, OnlineDeviceMapper.class, (item, d) -> d.updateByPrimaryKeySelective(item));
        }
    }

    private void handleAlarmInfo(List<OnlineDeviceRealData> realTimeData, List<OnlineDeviceAlarm> alarmResultList, List<OnlineDeviceAlarmLog> alarmLogResultList) {
        Collection<List<OnlineDeviceRealData>> values;
        if (CollectionUtils.isEmpty(realTimeData) || realTimeData.get(0).getDeviceId() == null) {
            return;
        }
        Long deviceId = realTimeData.get(0).getDeviceId();
        List onlineDeviceList = this.onlineDeviceService.getCacheOnlineDeviceList(deviceId);
        if (CollectionUtils.isEmpty((Collection)onlineDeviceList)) {
            this.logger.error("\u83b7\u5f97\u76d1\u6d4b\u6570\u636e\u4e2d\u7684\u8bbe\u5907id \u5728\u8bbe\u5907\u8868\u4e2d\u4e0d\u5b58\u5728\uff0c deviceId:{}", (Object)deviceId);
            return;
        }
        Map<String, List<OnlineDeviceRealData>> groupMap = realTimeData.stream().collect(Collectors.groupingBy(k -> {
            String deviceIdStr = k.getDeviceId() == null ? "" : k.getDeviceId().toString();
            String factorIdStr = k.getFactorId() == null ? "" : k.getFactorId().toString();
            String dataTypeStr = k.getDataType() == null ? "" : k.getDataType().toString();
            return deviceIdStr + factorIdStr + dataTypeStr;
        }));
        if (MapUtils.isNotEmpty(groupMap) && CollectionUtils.isNotEmpty(values = groupMap.values())) {
            for (List<OnlineDeviceRealData> value : values) {
                if (value.size() <= 1) continue;
                this.logger.error("\u4e0a\u4f20\u5b9e\u65f6\u6570\u636e\u6709\u8bef\uff1a\u4e0a\u4f20\u6570\u636e\u5b58\u5728\u591a\u6761\u540cfactorId\u548c\u540cdataType \u7684\u6570\u636e");
            }
        }
        OnlineDevice onlineDevice = (OnlineDevice)onlineDeviceList.get(0);
        String deviceType = onlineDevice.getType();
        List deviceAlarmSettingModels = this.deviceFactorService.getWarnInfoByDeviceId(deviceId);
        Map<Object, Object> deviceFactorSettingMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)deviceAlarmSettingModels)) {
            deviceFactorSettingMap = deviceAlarmSettingModels.stream().collect(Collectors.toMap(k -> {
                String dataType = k.getDataType() == null ? "" : k.getDataType().toString();
                return k.getFactorId().toString() + dataType;
            }, v -> v));
        }
        for (OnlineDeviceRealData realTimeDatum : realTimeData) {
            BigDecimal ingAlarmValueBig;
            Long factorId = realTimeDatum.getFactorId();
            Integer dataType = realTimeDatum.getDataType();
            String mapKey = factorId.toString() + (dataType == null ? "" : dataType.toString());
            if (!deviceFactorSettingMap.containsKey(mapKey)) {
                this.logger.warn("\u8bbe\u5907\uff1a{}\u7684\u5371\u5bb3\u56e0\u7d20id:{}\u6ca1\u6709\u8bbe\u7f6e\u62a5\u8b66", (Object)deviceId, (Object)mapKey);
                continue;
            }
            OnlineDeviceAlarmSettingModel alarmSettingModel = (OnlineDeviceAlarmSettingModel)deviceFactorSettingMap.get(mapKey);
            String earlyWarning = alarmSettingModel.getEarlyWarning();
            String alarmVdata = alarmSettingModel.getAlarmVdata();
            Integer alarmCount = alarmSettingModel.getStandard();
            if (StringUtils.isBlank((CharSequence)earlyWarning) || StringUtils.isBlank((CharSequence)alarmVdata) || alarmCount == null) {
                this.logger.warn("\u8bbe\u5907\uff1a{}\u7684\u5371\u5bb3\u56e0\u7d20id:{}\uff0c\u8bbe\u7f6e\u7684\u6570\u636e\u6709\u8bef\uff1a{}", new Object[]{deviceId, factorId, alarmSettingModel.toString()});
                continue;
            }
            BigDecimal dataValueBig = new BigDecimal(realTimeDatum.getVData());
            BigDecimal alarmValue = new BigDecimal(alarmVdata);
            BigDecimal preAlarmValue = new BigDecimal(earlyWarning);
            OnlineDeviceAlarm ingAlarm = this.getTaskIngAlarmByDevice(onlineDevice, factorId, dataType);
            if (ingAlarm != null && StringUtils.isNotBlank((CharSequence)ingAlarm.getAlarmVdata()) && alarmValue.compareTo(ingAlarmValueBig = new BigDecimal(ingAlarm.getAlarmVdata())) != 0) {
                this.logger.warn("\u91cd\u65b0\u4fee\u6539\u4e86\u62a5\u8b66\u9608\u503c, \u91cd\u65b0\u62a5\u8b66--");
                ingAlarm.setAlarmReason("\u4fee\u6539\u62a5\u8b66\u9608\u503c");
                this.onlineDeviceAlarmService.closeAlarm(ingAlarm, true);
                this.delAlarm(this.getCacheKey(deviceId, factorId, dataType));
                ingAlarm = null;
            }
            if (Objects.equals(factorId, 567L)) {
                dataValueBig = dataValueBig.setScale(1, 4);
            }
            OnlineDeviceAlarm alarm = new OnlineDeviceAlarm();
            alarm.setDeviceId(onlineDevice.getId());
            alarm.setCases(this.getAlarmCaseByHarmId(factorId));
            alarm.setId(Long.valueOf(this.idworker.nextId()));
            alarm.setFactorId(factorId);
            alarm.setIng(Boolean.valueOf(false));
            alarm.setDataType(dataType);
            alarm.setSeq(this.onlineMonitorTaskSeq);
            if (dataValueBig.compareTo(alarmValue) >= 0) {
                LongAdder longAdder = this.alarmDeviceCountMap.computeIfAbsent(this.getCacheKey(deviceId, factorId, dataType), v -> new LongAdder());
                longAdder.increment();
                alarm.setIng(Boolean.valueOf(true));
                alarm.setAlarmVdata(alarmValue.stripTrailingZeros().toPlainString());
                alarm.setAlarmType(Integer.valueOf(2));
                if (longAdder.intValue() >= alarmCount && ingAlarm == null) {
                    ingAlarm = alarm;
                    this.redisClient.set("ingAlarmCache:" + this.getCacheKey(deviceId, factorId, dataType), (Object)alarm);
                    alarmResultList.add(alarm);
                }
                if (ingAlarm == null) continue;
                OnlineDeviceAlarmLog log = new OnlineDeviceAlarmLog();
                log.setVData(Double.valueOf(dataValueBig.doubleValue()));
                log.setAlarmId(ingAlarm.getId());
                log.setCreateDate(new Date());
                alarmLogResultList.add(log);
                continue;
            }
            if (dataValueBig.compareTo(preAlarmValue) >= 0) {
                this.alarmDeviceCountMap.computeIfAbsent(this.getCacheKey(deviceId, factorId, dataType), v -> new LongAdder()).reset();
                this.delAlarm(this.getCacheKey(deviceId, factorId, dataType));
                alarm.setAlarmVdata(preAlarmValue.stripTrailingZeros().toPlainString());
                alarm.setAlarmType(Integer.valueOf(1));
                alarmResultList.add(alarm);
                OnlineDeviceAlarmLog log = new OnlineDeviceAlarmLog();
                log.setVData(Double.valueOf(dataValueBig.doubleValue()));
                log.setAlarmId(alarm.getId());
                log.setCreateDate(new Date());
                alarmLogResultList.add(log);
                if (ingAlarm != null) {
                    ingAlarm.setAlarmReason("\u76d1\u6d4b\u503c\u672a\u8d85\u8fc7\u62a5\u8b66\u9608\u503c");
                    ingAlarm.setIng(Boolean.valueOf(false));
                    this.onlineDeviceAlarmService.closeAlarm(ingAlarm, true);
                }
                this.delAlarm(this.getCacheKey(deviceId, factorId, dataType));
                continue;
            }
            this.alarmDeviceCountMap.computeIfAbsent(this.getCacheKey(deviceId, factorId, dataType), v -> new LongAdder()).reset();
            this.delAlarm(this.getCacheKey(deviceId, factorId, dataType));
            if (ingAlarm != null) {
                ingAlarm.setIng(Boolean.valueOf(false));
                this.onlineDeviceAlarmService.closeAlarm(ingAlarm, true);
            }
            this.delAlarm(this.getCacheKey(deviceId, factorId, dataType));
        }
    }

    private void delAlarm(String key) {
        this.redisClient.del(new String[]{"ingAlarmCache:" + key});
    }

    private Integer getAlarmCaseByDeviceType(Integer deviceType) {
        if (deviceType == null) {
            return null;
        }
        AlarmCondition alarmCase = null;
        if (deviceType != null) {
            if (deviceType == 1) {
                alarmCase = AlarmCondition.DUST_OR_CHEMICAL_OVERPROOF;
            } else if (deviceType == 2) {
                alarmCase = AlarmCondition.NOISE_OVERPROOF;
            }
            if (alarmCase != null) {
                return alarmCase.getCode();
            }
        }
        return null;
    }

    private Integer getAlarmCaseByHarmId(Long harmId) {
        if (harmId == null) {
            return null;
        }
        AlarmCondition alarmCase = null;
        if (harmId != null && (alarmCase = (AlarmCondition)this.redisClient.get(HARMID_CASE_CACHE_NAME, "" + harmId, 0L, () -> {
            HarmFactor harmFactor = this.harmFactorService.getThisById(harmId);
            if (harmFactor != null) {
                String type = harmFactor.getType();
                if ("\u7269\u7406\u56e0\u7d20".equals(type)) {
                    return AlarmCondition.NOISE_OVERPROOF;
                }
                if ("\u7c89\u5c18".equals(type)) {
                    return AlarmCondition.DUST_OR_CHEMICAL_OVERPROOF;
                }
            }
            return null;
        })) != null) {
            return alarmCase.getCode();
        }
        return null;
    }

    private OnlineDeviceAlarm getTaskIngAlarmByDevice(OnlineDevice onlineDevice, Long factorId, Integer dataType) {
        if (onlineDevice == null || onlineDevice.getId() == null) {
            return null;
        }
        if (onlineDevice.getType() == null) {
            this.logger.error("\u83b7\u53d6\u8be5\u8bbe\u5907\u7684\u62a5\u8b66\u4fe1\u606f\u51fa\u9519\uff0c\u8bbe\u5907\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a, {}", (Object)JSON.toJSONString((Object)onlineDevice));
            return null;
        }
        OnlineDeviceAlarm ingAlarm = (OnlineDeviceAlarm)this.redisClient.get(ING_ALARM_CACHE_NAME, this.getCacheKey(onlineDevice.getId(), factorId, dataType), 0L, () -> {
            String types = onlineDevice.getType();
            OnlineDeviceAlarm dbIngAlarm = this.onlineDeviceAlarmService.getDbIngAlarm(onlineDevice.getId(), factorId, Integer.valueOf(2), null, dataType);
            return dbIngAlarm;
        });
        return ingAlarm;
    }

    public void clearIngAlarmCacheByDeviceId(Long deviceId, Long factorId, Integer dataType) {
        if (deviceId == null) {
            return;
        }
        if (factorId != null) {
            this.delAlarm(this.getCacheKey(deviceId, factorId, dataType));
        } else {
            Map stringOnlineDeviceAlarmConcurrentMap = this.redisClient.mapByPrefix(ING_ALARM_CACHE_NAME);
            if (MapUtils.isNotEmpty((Map)stringOnlineDeviceAlarmConcurrentMap)) {
                HashSet<String> removeKey = new HashSet<String>();
                Set<@NonNull K> keySet = stringOnlineDeviceAlarmConcurrentMap.keySet();
                for (String key : keySet) {
                    if (!key.contains(deviceId.toString())) continue;
                    removeKey.add(key);
                }
                if (CollectionUtils.isNotEmpty(removeKey)) {
                    this.redisClient.del(removeKey);
                }
            }
        }
    }
}

