/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.onlineMonitoring;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDeviceApi;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDeviceRealData;
import cn.smarthse.modules.health.supervise.enums.onlinedevice.DeviceTypeDataTypeEnum;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceApiService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IRealTimeDataService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.vo.ZhonggangRealDataVo;
import cn.smarthse.util.common.http.HttpsUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ZhonggRealTimeDataServiceImpl
implements IRealTimeDataService {
    @Value(value="${zhongg_online_monitor_url}")
    private String onlineMonitorUrl;
    @Value(value="${zhongg_online_monitor_user_pwd}")
    private String onlineMonitorUserPwd;
    @Value(value="${cron.onlineMonitorTask.seq:}")
    private String onlineMonitorTaskSeq;
    @Autowired
    IOnlineDeviceApiService onlineDeviceApiService;
    @Autowired
    private IOnlineDeviceService onlineDeviceService;
    private Cache<String, String> tokenCache = Caffeine.newBuilder().expireAfterWrite(60L, TimeUnit.MINUTES).maximumSize(Integer.MAX_VALUE).build();
    private static final String ZHONGG_TOKEN_STR = "zhongg_token_key";
    private Logger logger = LoggerFactory.getLogger(ZhonggRealTimeDataServiceImpl.class);

    public String doLogin() {
        String loginUrl = this.onlineMonitorUrl + "/user/login";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json;charset=UTF-8");
        if (StringUtils.isNotEmpty((String)this.onlineMonitorUserPwd)) {
            Object[] userPwdArr = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)this.onlineMonitorUserPwd, (String)",");
            if (ArrayUtils.isNotEmpty((Object[])userPwdArr)) {
                ArrayList tokenList = new ArrayList();
                if (ArrayUtils.isNotEmpty((Object[])userPwdArr)) {
                    for (Object userPwdStr : userPwdArr) {
                        JSONObject data;
                        String[] userPwd = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)userPwdStr, (String)":");
                        HashMap<String, String> param = new HashMap<String, String>();
                        param.put("account", userPwd[0]);
                        param.put("password", userPwd[1]);
                        String responseStr = HttpsUtil.doPost((String)loginUrl, (String)JSON.toJSONString(param), (String)"utf-8", headers);
                        JSONObject jsonObject = JSONObject.parseObject((String)responseStr);
                        if (!jsonObject.containsKey((Object)"data") || !(data = jsonObject.getJSONObject("data")).containsKey((Object)"token")) continue;
                        String token = data.getString("token");
                        HashMap<String, String> userTokenMap = new HashMap<String, String>();
                        userTokenMap.put("account", userPwd[0]);
                        userTokenMap.put("token", token);
                        tokenList.add(userTokenMap);
                    }
                }
                return JSON.toJSONString(tokenList);
            }
        } else {
            this.logger.warn("\u5728\u7ebf\u76d1\u6d4b\u91c7\u96c6\u7528\u6237\u540d\u5bc6\u7801\u672a\u914d\u7f6e");
        }
        return null;
    }

    public List<OnlineDeviceRealData> getRealTimeDataList() {
        List dbOnlineDeviceApiList;
        String tokenListJson = (String)this.tokenCache.get((Object)ZHONGG_TOKEN_STR, key -> this.doLogin());
        if (StringUtils.isBlank((CharSequence)tokenListJson)) {
            return null;
        }
        List tokenList = JSON.parseArray((String)tokenListJson, Map.class);
        if (CollectionUtils.isEmpty((Collection)tokenList)) {
            this.logger.error("\u672a\u83b7\u53d6\u5230\u4e2d\u94a2Token\u6570\u636e");
        }
        if (CollectionUtils.isNotEmpty((Collection)(dbOnlineDeviceApiList = this.onlineDeviceApiService.getCacheOnlineDeviceApiList(null)))) {
            List zgDeviceList = dbOnlineDeviceApiList.stream().filter(d -> d.getApiSource() != null && "2".equals(d.getApiSource())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(zgDeviceList)) {
                this.logger.debug("\u6ca1\u6709\u914d\u7f6e\u4e2d\u94a2\u7684\u8bbe\u5907\u6570\u636e");
            }
            Map<String, OnlineDeviceApi> dbOnlineDeviceApiMap = zgDeviceList.stream().collect(Collectors.toMap(k -> k.getDeviceNo(), v -> v, (v1, v2) -> v2));
            if (CollectionUtils.isNotEmpty(zgDeviceList)) {
                ArrayList<OnlineDeviceRealData> result = new ArrayList<OnlineDeviceRealData>();
                for (Map tokenMap : tokenList) {
                    String account = (String)tokenMap.get("account");
                    String token = (String)tokenMap.get("token");
                    Set accountDeviceSet = zgDeviceList.stream().filter(f -> account.equals(f.getBelongAccount())).collect(Collectors.toSet());
                    if (CollectionUtils.isEmpty(accountDeviceSet)) continue;
                    ArrayList<Map<String, Object>> devDatapoints = new ArrayList<Map<String, Object>>();
                    for (OnlineDeviceApi onlineDevice : accountDeviceSet) {
                        String deviceNo = onlineDevice.getDeviceNo();
                        String groupNo = onlineDevice.getGroupNo();
                        Byte type = onlineDevice.getType();
                        HashMap<String, Object> devDatapoint = new HashMap<String, Object>();
                        devDatapoint.put("deviceNo", groupNo);
                        devDatapoint.put("dataPointId", deviceNo);
                        devDatapoint.put("slaveIndex", onlineDevice.getSlaveIndex());
                        devDatapoint.put("type", type);
                        devDatapoints.add(devDatapoint);
                    }
                    List<OnlineDeviceRealData> onlineMonitorDeviceData = this.doRealTimeDataList(token, devDatapoints, dbOnlineDeviceApiMap);
                    this.logger.debug("\u5904\u7406\u8d26\u53f7\uff1a{} \u7684\u8bbe\u5907\u6570\u636e\uff0c \u91c7\u96c6\u6570\u636e{}", (Object)account, (Object)JSON.toJSONString(onlineMonitorDeviceData));
                    if (!CollectionUtils.isNotEmpty(onlineMonitorDeviceData)) continue;
                    result.addAll(onlineMonitorDeviceData);
                }
                return result;
            }
        }
        return null;
    }

    public void getDeviceStatus(String token) {
        String url = this.onlineMonitorUrl + "/dev/getDevice";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("token", token);
    }

    public List<OnlineDeviceRealData> doRealTimeDataList(String token, List<Map<String, Object>> devDatapoints, Map<String, OnlineDeviceApi> dbOnlineDeviceApiMap) {
        List zhonggangRealDataVoList;
        JSONObject data;
        String url = this.onlineMonitorUrl + "/vn/ucloudSdk/getLastDataHistory";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("token", token);
        HashMap<String, List<Map<String, Object>>> param = new HashMap<String, List<Map<String, Object>>>();
        param.put("devDatapoints", devDatapoints);
        String responseStr = HttpsUtil.doPost((String)url, (String)JSON.toJSONString(param), (String)"utf-8", headers);
        this.logger.debug("\u4e2d\u94a2\u5b9e\u65f6\u76d1\u6d4b\u6570\u636e\u63a5\u53e3\u54cd\u5e94\uff1a" + responseStr);
        JSONObject jsonObject = JSONObject.parseObject((String)responseStr);
        if (jsonObject != null && jsonObject.containsKey((Object)"data") && (data = jsonObject.getJSONObject("data")) != null && data.containsKey((Object)"list") && CollectionUtils.isNotEmpty((Collection)(zhonggangRealDataVoList = JSONArray.parseArray((String)data.getString("list"), ZhonggangRealDataVo.class)))) {
            List<OnlineDeviceRealData> onlineDeviceRealDataList = zhonggangRealDataVoList.stream().filter(f -> {
                OnlineDeviceApi api = (OnlineDeviceApi)dbOnlineDeviceApiMap.get(f.getDataPointId().toString());
                if (api == null) {
                    this.logger.error("\u4e2d\u94a2\u6570\u636e\u63a5\u53e3\u8fd4\u56de\u7684\u6570\u636e\uff0c\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\uff0cdeviceNo:{}", (Object)f.getDataPointId());
                }
                return f.getValue() != null && api != null;
            }).map(z -> {
                OnlineDeviceRealData realData = new OnlineDeviceRealData();
                realData.setVData(z.getValue().toString());
                if (z.getTime() != null) {
                    realData.setMonitorTime(new Date(z.getTime()));
                }
                OnlineDeviceApi api = (OnlineDeviceApi)dbOnlineDeviceApiMap.get(z.getDataPointId().toString());
                realData.setDeviceId(api.getDeviceId());
                realData.setFactorId(api.getFactorId());
                realData.setSeq(this.onlineMonitorTaskSeq);
                realData.setDataSource(Integer.valueOf(1));
                Object[] dataType = DeviceTypeDataTypeEnum.getDataType((Integer)api.getType().intValue());
                if (ArrayUtils.isNotEmpty((Object[])dataType)) {
                    realData.setDataType((Integer)dataType[0]);
                }
                return realData;
            }).collect(Collectors.toList());
            return onlineDeviceRealDataList;
        }
        return null;
    }
}

