/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.onlineMonitoring;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.supervise.dao.onlineMonitoring.OnlineMonitorDeviceBindMapper;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDevice;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineMonitorDeviceBind;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineMonitorDeviceBindService;
import cn.smarthse.modules.health.supervise.vo.onlineMonitoring.device.OnlineDeviceBindVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.BusinessException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class OnlineMonitorDeviceBindServiceImpl
extends BaseServiceImpl<OnlineMonitorDeviceBindMapper, OnlineMonitorDeviceBind>
implements IOnlineMonitorDeviceBindService {
    protected Logger logger = LoggerFactory.getLogger((String)"onlinemonitorlogger");
    @Autowired
    private IOnlineDeviceService onlineDeviceService;

    @Transactional(readOnly=false)
    public void bind(OnlineDeviceBindVo deviceBindVo, Long cid, Long createBy) throws BusinessException {
        String cameraId = deviceBindVo.getCameraId();
        String deviceIds = deviceBindVo.getDeviceIds();
        List deviceIdList = StringUtils.parseToLongList((String)deviceIds, (String)",");
        if (StringUtils.isBlank((CharSequence)cameraId)) {
            throw new BusinessException("\u53c2\u6570cameraId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)deviceIdList)) {
            throw new BusinessException("\u53c2\u6570deviceIds\u6709\u8bef");
        }
        OnlineDevice cameraObj = (OnlineDevice)this.onlineDeviceService.getById(Long.valueOf(Long.parseLong(cameraId)));
        if (Objects.isNull(cameraObj)) {
            throw new BusinessException("\u627e\u4e0d\u5230cameraId\u6570\u636e");
        }
        if (!Objects.equals(cameraObj.getType(), "3")) {
            throw new BusinessException("cameraId\u975e\u76d1\u63a7\u8bbe\u5907");
        }
        List deviceList = this.onlineDeviceService.getListByIds(StringUtils.join((Iterable)deviceIdList, (String)","));
        Set<Object> dbIdSet = new HashSet();
        if (CollectionUtils.isNotEmpty((Collection)deviceList)) {
            dbIdSet = deviceList.stream().map(OnlineDevice::getId).collect(Collectors.toSet());
        }
        ArrayList deviceIdListTemp = new ArrayList();
        deviceIdListTemp.addAll(deviceIdList);
        deviceIdListTemp.removeAll(dbIdSet);
        if (CollectionUtils.isNotEmpty(deviceIdListTemp)) {
            throw new BusinessException("\u8bbe\u5907id\u3010" + StringUtils.join(deviceIdListTemp, (String)",") + "\u3011\u9519\u8bef\uff0c \u627e\u4e0d\u5230\u5bf9\u5e94\u8bbe\u5907\u6570\u636e");
        }
        Example e = new Example(OnlineMonitorDeviceBind.class);
        Example.Criteria criteria = e.createCriteria().andEqualTo("cameraId", (Object)cameraId);
        OnlineMonitorDeviceBind del = new OnlineMonitorDeviceBind();
        del.setIsValid(Boolean.valueOf(false));
        del.setUpdateBy(createBy);
        del.setUpdateDate(new Date());
        ((OnlineMonitorDeviceBindMapper)this.dao).updateByExampleSelective(del, e);
        for (Long aLong : deviceIdList) {
            OnlineMonitorDeviceBind bind = new OnlineMonitorDeviceBind();
            bind.setCreateBy(createBy);
            bind.setCreateDate(new Date());
            bind.setCid(cid);
            bind.setCameraId(cameraId);
            bind.setDeviceId("" + aLong);
            bind.setIsValid(Boolean.valueOf(true));
            ((OnlineMonitorDeviceBindMapper)this.dao).insert(bind);
        }
    }
}

