/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.onlineMonitoring;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.supervise.dao.onlineMonitoring.OnlineDeviceSceneConfigMapper;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDeviceSceneConfig;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceSceneConfigService;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class OnlineDeviceSceneConfigServiceImpl
extends BaseServiceImpl<OnlineDeviceSceneConfigMapper, OnlineDeviceSceneConfig>
implements IOnlineDeviceSceneConfigService {
    private Cache<Long, OnlineDeviceSceneConfig> configCache = Caffeine.newBuilder().expireAfterWrite(60L, TimeUnit.MINUTES).maximumSize(Integer.MAX_VALUE).build();

    public OnlineDeviceSceneConfig getDeviceByDeviceId(Long id) {
        Example example = new Example(OnlineDeviceSceneConfig.class);
        example.createCriteria().andEqualTo("deviceId", (Object)id).andEqualTo("isValid", (Object)true);
        OnlineDeviceSceneConfig onlineDeviceSceneConfig = (OnlineDeviceSceneConfig)((OnlineDeviceSceneConfigMapper)this.dao).selectOneByExample(example);
        return onlineDeviceSceneConfig;
    }

    @Transactional(readOnly=false)
    public void updateConfig(OnlineDeviceSceneConfig config, Long userId) {
        this.update(config, userId);
        this.configCache.invalidateAll();
    }

    public List<OnlineDeviceSceneConfig> getAllConfig() {
        Example example = new Example(OnlineDeviceSceneConfig.class);
        Example.Criteria criteria = example.createCriteria().andEqualTo("isValid", (Object)true);
        return ((OnlineDeviceSceneConfigMapper)this.dao).selectByExample(example);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Map<Long, OnlineDeviceSceneConfig> getConfigMap() {
        this.logger.info("\u52a0\u8f7d\u8bbe\u5907\u914d\u7f6e\u4fe1\u606f...");
        @NonNull @NonNull ConcurrentMap configConcurrentMap = this.configCache.asMap();
        if (MapUtils.isEmpty((Map)configConcurrentMap)) {
            this.logger.info("\u8bbe\u5907\u914d\u7f6e\u4fe1\u606f\u7f13\u5b58\u4e3a\u7a7a\uff0c\u4ece\u6570\u636e\u5e93\u4e2d\u91cd\u65b0\u52a0\u8f7d...");
            List<OnlineDeviceSceneConfig> allConfig = this.getAllConfig();
            for (OnlineDeviceSceneConfig onlineDeviceSceneConfig : allConfig) {
                this.configCache.put((Object)onlineDeviceSceneConfig.getDeviceId(), (Object)onlineDeviceSceneConfig);
            }
            configConcurrentMap = this.configCache.asMap();
        }
        return configConcurrentMap;
    }

    public OnlineDeviceSceneConfig getConfigMap(Long deviceId) {
        OnlineDeviceSceneConfig onlineDeviceSceneConfig1 = (OnlineDeviceSceneConfig)this.configCache.get((Object)deviceId, key -> {
            this.logger.info("\u7f13\u5b58\u4e2d\u65e0\u914d\u7f6e\u6570\u636e\uff0c\u4ecedb\u4e2d\u52a0\u8f7d...");
            return this.getDeviceByDeviceId(deviceId);
        });
        return onlineDeviceSceneConfig1;
    }
}

