/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.onlineMonitoring;

import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.datacentre.model.system.riskFactors.FactorLimitValue;
import cn.smarthse.modules.health.supervise.dao.onlineMonitoring.OnlineDeviceRealDataMapper;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDeviceExcess;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDeviceRealData;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceExcessService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceRealDataService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.syncdata.OnlineRealDataAlarmServiceImpl;
import cn.smarthse.services.hfi.api.service.IFactorLimitValueService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.curator.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class OnlineDeviceRealDataServiceImpl
extends BaseServiceImpl<OnlineDeviceRealDataMapper, OnlineDeviceRealData>
implements IOnlineDeviceRealDataService {
    protected Logger logger = LoggerFactory.getLogger((String)"onlinemonitorlogger");
    @Autowired
    private OnlineRealDataAlarmServiceImpl alarmTaskService;
    @DubboReference
    IFactorLimitValueService factorLimitValueService;
    @Autowired
    IOnlineDeviceExcessService onlineDeviceExcessService;
    @Autowired
    RedisClient redisClient;
    private final String ONLINE_DEVICE_LAST_REALDATA = "online_device_last_realdata";
    private ExecutorService executorService = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), 2 * Runtime.getRuntime().availableProcessors(), 30L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>(), new ThreadFactoryBuilder().setNameFormat("\u76d1\u6d4b\u62a5\u8b66\u5904\u7406\u4efb\u52a1-%d").setUncaughtExceptionHandler((thread, throwable) -> this.logger.error("\u7ebf\u7a0b\uff1a{}\uff0c \u53d1\u751f\u5f02\u5e38\uff0c {}", (Object)thread, (Object)throwable)).build());

    private String generateKey2(OnlineDeviceRealData model) {
        Long deviceId = model.getDeviceId();
        Long factorId = model.getFactorId();
        Integer dataType1 = model.getDataType();
        return (deviceId == null ? "" : deviceId.toString()) + (factorId == null ? "" : factorId.toString()) + (dataType1 == null ? "" : dataType1.toString());
    }

    @Transactional(readOnly=false)
    public int handleRealMonitorData(List<OnlineDeviceRealData> realTimeDataResultList) {
        if (CollectionUtils.isNotEmpty(realTimeDataResultList)) {
            for (OnlineDeviceRealData realData : realTimeDataResultList) {
                realData.setId(Long.valueOf(this.idworker.nextId()));
                if (realData.getMonitorTime() == null) {
                    realData.setMonitorTime(new Date());
                }
                if (StringUtils.isBlank((CharSequence)realData.getVData())) {
                    realData.setVData("0");
                }
                this.redisClient.hset("online_device_last_realdata", this.generateKey2(realData), (Object)realData.getVData());
            }
            int realDataCounts = ((OnlineDeviceRealDataMapper)this.dao).insertRealDatas(realTimeDataResultList);
            this.executorService.execute(() -> this.alarmTaskService.handleOnlineMonitorData(realTimeDataResultList));
            this.logger.info("realDataCounts: {}", (Object)realDataCounts);
            return realDataCounts;
        }
        return 0;
    }

    @Transactional(readOnly=false)
    public void test() {
        int min = 1;
        int max = 10;
        ArrayList<OnlineDeviceRealData> list = new ArrayList<OnlineDeviceRealData>();
        for (int i = 1; i < 101; ++i) {
            Long id = 100L;
            id = id + (long)(i / 10);
            Random random = new Random();
            String dateStr = "2023-09-" + random.nextInt(30);
            OnlineDeviceRealData onlineDeviceRealData = new OnlineDeviceRealData();
            onlineDeviceRealData.setDataType(Integer.valueOf(1002));
            onlineDeviceRealData.setMonitorTime(DateUtil.getDate((String)(dateStr + " 16:57:40"), (String)"yyyy-MM-dd HH:mm:ss"));
            onlineDeviceRealData.setFactorId(Long.valueOf(3L));
            onlineDeviceRealData.setVData("" + random.nextInt(min + max));
            onlineDeviceRealData.setDeviceId(id);
            onlineDeviceRealData.setId(Long.valueOf(this.idworker.nextId()));
            onlineDeviceRealData.setDataSource(Integer.valueOf(10));
            onlineDeviceRealData.setIsValid(Boolean.valueOf(true));
            list.add(onlineDeviceRealData);
        }
        ((OnlineDeviceRealDataMapper)this.dao).insertList2(list);
    }

    public void statisticsMonthOverData(Integer month) {
        List factorLimitValues = this.factorLimitValueService.queryFCLimitValues();
        List<OnlineDeviceRealData> realDataList = ((OnlineDeviceRealDataMapper)this.dao).listByMonth(month);
        Map<Long, List<OnlineDeviceRealData>> deviceMap = realDataList.stream().collect(Collectors.groupingBy(OnlineDeviceRealData::getDeviceId));
        for (Long deviceId : deviceMap.keySet()) {
            List<OnlineDeviceRealData> deviceRealDataList = deviceMap.get(deviceId);
            Map<String, List<OnlineDeviceRealData>> factorDataTypeMap = deviceRealDataList.stream().collect(Collectors.groupingBy(item -> item.getFactorId() + "," + item.getDataType()));
            for (String factorDataType : factorDataTypeMap.keySet()) {
                Double limitValue;
                List<OnlineDeviceRealData> deviceRealData = factorDataTypeMap.get(factorDataType);
                String[] split = factorDataType.split(",");
                Long factorId = Long.parseLong(split[0]);
                Integer dataType = Integer.parseInt(split[1]);
                FactorLimitValue factorLimitValue = this.getByFactorId(factorLimitValues, factorId);
                Double d = Objects.equals(1002, dataType) ? factorLimitValue.getTwaTotal() : (limitValue = Objects.equals(1003, dataType) ? factorLimitValue.getTwaRespirabel() : null);
                if (Objects.isNull(limitValue)) continue;
                ArrayList<OnlineDeviceExcess> excessList = new ArrayList<OnlineDeviceExcess>();
                this.computedExcess(deviceRealData, limitValue, excessList);
                if (!CollectionUtils.isNotEmpty(excessList)) continue;
                this.onlineDeviceExcessService.saveBatch(excessList);
            }
        }
    }

    private void computedExcess(List<OnlineDeviceRealData> deviceRealData, Double limitValue, List<OnlineDeviceExcess> excessList) {
        int consecutiveExceeds = 0;
        Date startDate = null;
        for (OnlineDeviceRealData deviceRealDatum : deviceRealData) {
            consecutiveExceeds = Double.parseDouble(deviceRealDatum.getVData()) > limitValue ? ++consecutiveExceeds : 0;
            if (consecutiveExceeds == 1) {
                startDate = deviceRealDatum.getMonitorTime();
            }
            if (consecutiveExceeds != 3) continue;
            OnlineDeviceExcess excess = new OnlineDeviceExcess();
            excess.setYear(Integer.valueOf(DateUtils.getYear((Date)deviceRealDatum.getMonitorTime())));
            excess.setMonth(Integer.valueOf(DateUtils.getMonth((Date)deviceRealDatum.getMonitorTime())));
            excess.setCid(deviceRealDatum.getCid());
            excess.setAreaId(deviceRealDatum.getAreaId());
            excess.setDeviceId(deviceRealDatum.getDeviceId());
            excess.setFactorId(deviceRealDatum.getFactorId());
            excess.setStartTime(startDate);
            excess.setId(Long.valueOf(this.idworker.nextId()));
            excess.setCreateDate(new Date());
            excess.setUpdateDate(new Date());
            excess.setUpdateBy(Long.valueOf(0L));
            excess.setCreateBy(Long.valueOf(0L));
            excess.setIsValid(Boolean.valueOf(true));
            excessList.add(excess);
        }
    }

    private FactorLimitValue getByFactorId(List<FactorLimitValue> factorLimitValues, Long factorId) {
        return factorLimitValues.stream().filter(item -> factorId.equals(item.getHazardId())).findFirst().orElse(null);
    }
}

