/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.onlineMonitoring;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.param.SearchParam;
import cn.smarthse.modules.health.supervise.dao.onlineMonitoring.OnlineDeviceAlarmMapper;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDevice;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDeviceAlarm;
import cn.smarthse.modules.health.supervise.enums.onlinedevice.AlarmCondition;
import cn.smarthse.modules.health.supervise.model.home.v3223.onlineMonitoring.PneumocoChartData;
import cn.smarthse.modules.health.supervise.model.onlinemonitor.MoreAlarmModel;
import cn.smarthse.modules.health.supervise.model.onlinemonitor.MoreAlarmParamModel;
import cn.smarthse.modules.health.supervise.model.onlinemonitor.OnlineDeviceAlarmModel;
import cn.smarthse.modules.health.supervise.model.onlinemonitor.OnlineDeviceAlarmParamModel;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineAlarmSettingService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceAlarmLogService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceAlarmService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.syncdata.OnlineDeviceAlarmTaskServiceImpl;
import cn.smarthse.modules.health.supervise.vo.onlineMonitoring.CollectOnlineDeviceAlaramVo;
import cn.smarthse.modules.health.supervise.vo.onlineMonitoring.OnlineDeviceAlaramSearchVo;
import cn.smarthse.modules.health.supervise.vo.onlineMonitoring.OnlineDeviceAlarmDataCollectVo;
import cn.smarthse.modules.health.supervise.vo.onlineMonitoring.OnlineDeviceAlarmDataVo;
import cn.smarthse.modules.platform.model.AreaModel;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class OnlineDeviceAlarmServiceImpl
extends BaseServiceImpl<OnlineDeviceAlarmMapper, OnlineDeviceAlarm>
implements IOnlineDeviceAlarmService {
    @Autowired
    IOnlineDeviceAlarmLogService onlineDeviceAlarmLogService;
    @Autowired
    IOnlineDeviceAlarmService self;
    @Autowired
    OnlineDeviceAlarmTaskServiceImpl alarmTaskService;
    @Autowired
    private IOnlineDeviceService onlineDeviceService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaProvideService;
    @Autowired
    private IOnlineAlarmSettingService settingService;

    public OnlineDeviceAlarm getDbIngAlarm(Long deviceId, Long factorId, Integer alarmType, Integer alarmCase) {
        List alarmList;
        Example e = new Example(OnlineDeviceAlarm.class);
        Example.Criteria criteria = e.createCriteria().andEqualTo("deviceId", (Object)deviceId).andEqualTo("factorId", (Object)factorId).andEqualTo("ing", (Object)true);
        if (alarmType != null) {
            criteria.andEqualTo("alarmType", (Object)alarmType);
        }
        if (alarmCase != null) {
            criteria.andEqualTo("cases", (Object)alarmCase);
        }
        if (CollectionUtils.isEmpty(alarmList = this.getListByExample(e))) {
            return null;
        }
        List collect2 = alarmList.stream().filter(a -> a.getAlarmType() == 2).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect2)) {
            return (OnlineDeviceAlarm)collect2.get(0);
        }
        List collect1 = alarmList.stream().filter(a -> a.getAlarmType() == 1).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect1)) {
            return (OnlineDeviceAlarm)collect1.get(0);
        }
        return (OnlineDeviceAlarm)alarmList.get(0);
    }

    public OnlineDeviceAlarm getDbIngAlarm(Long deviceId, Long factorId, Integer alarmType, Integer alarmCase, Integer dataType) {
        List alarmList;
        Example e = new Example(OnlineDeviceAlarm.class);
        Example.Criteria criteria = e.createCriteria().andEqualTo("deviceId", (Object)deviceId).andEqualTo("factorId", (Object)factorId).andEqualTo("ing", (Object)true);
        if (alarmType != null) {
            criteria.andEqualTo("alarmType", (Object)alarmType);
        }
        if (alarmCase != null) {
            criteria.andEqualTo("cases", (Object)alarmCase);
        }
        if (dataType != null) {
            criteria.andEqualTo("dataType", (Object)dataType);
        }
        if (CollectionUtils.isEmpty(alarmList = this.getListByExample(e))) {
            return null;
        }
        List collect2 = alarmList.stream().filter(a -> a.getAlarmType() == 2).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect2)) {
            return (OnlineDeviceAlarm)collect2.get(0);
        }
        List collect1 = alarmList.stream().filter(a -> a.getAlarmType() == 1).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect1)) {
            return (OnlineDeviceAlarm)collect1.get(0);
        }
        return (OnlineDeviceAlarm)alarmList.get(0);
    }

    public synchronized OnlineDeviceAlarm getDbIngAlarm(Long deviceId, Integer alarmType, Integer alarmCase) {
        List alarmList;
        Example e = new Example(OnlineDeviceAlarm.class);
        Example.Criteria criteria = e.createCriteria().andEqualTo("deviceId", (Object)deviceId).andEqualTo("ing", (Object)true);
        if (alarmType != null) {
            criteria.andEqualTo("alarmType", (Object)alarmType);
        }
        if (alarmCase != null) {
            criteria.andEqualTo("cases", (Object)alarmCase);
        }
        if (CollectionUtils.isEmpty(alarmList = this.getListByExample(e))) {
            return null;
        }
        List collect2 = alarmList.stream().filter(a -> a.getAlarmType() == 2).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect2)) {
            return (OnlineDeviceAlarm)collect2.get(0);
        }
        List collect1 = alarmList.stream().filter(a -> a.getAlarmType() == 1).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect1)) {
            return (OnlineDeviceAlarm)collect1.get(0);
        }
        return (OnlineDeviceAlarm)alarmList.get(0);
    }

    public OnlineDeviceAlarm getIngEvent(Long deviceId) {
        Example e = new Example(OnlineDeviceAlarm.class);
        e.createCriteria().andEqualTo("deviceId", (Object)deviceId).andEqualTo("alarmType", (Object)1).andEqualTo("ing", (Object)true);
        OnlineDeviceAlarm oneByExample = (OnlineDeviceAlarm)this.getOneByExample(e);
        return oneByExample;
    }

    public void insertAlarmDatas(List<OnlineDeviceAlarm> addAlarmList) {
        if (CollectionUtils.isEmpty(addAlarmList)) {
            return;
        }
        ((OnlineDeviceAlarmMapper)this.dao).insertAlarmDatas(addAlarmList);
    }

    public List<OnlineDeviceAlarmDataVo> getDeviceAlarm(Long areaId, Byte level) {
        List<OnlineDeviceAlarmDataVo> deviceAlarm = ((OnlineDeviceAlarmMapper)this.dao).getDeviceAlarm(areaId, level);
        return deviceAlarm;
    }

    public PageInfo<OnlineDeviceAlarmDataCollectVo> pageAlarmLogDataByDeviceId(JqGridParam gparam, OnlineDeviceAlaramSearchVo searchVo) {
        if (searchVo.getDeviceId() == null && CollectionUtils.isEmpty((Collection)searchVo.getDeviceIdList())) {
            return null;
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<OnlineDeviceAlarmDataCollectVo> collectVoList = this.collectAlarmData(searchVo);
        return new PageInfo(collectVoList);
    }

    public List<CollectOnlineDeviceAlaramVo> collectAlarmDataByDate(OnlineDeviceAlaramSearchVo searchVo) {
        if (searchVo.getDeviceId() == null && CollectionUtils.isEmpty((Collection)searchVo.getDeviceIdList())) {
            Collections.emptyList();
        }
        return ((OnlineDeviceAlarmMapper)this.dao).collectAlarmDataByDate(searchVo);
    }

    public List<CollectOnlineDeviceAlaramVo> collectAlarmDataByCases(OnlineDeviceAlaramSearchVo searchVo) {
        if (searchVo.getDeviceId() == null && CollectionUtils.isEmpty((Collection)searchVo.getDeviceIdList())) {
            Collections.emptyList();
        }
        return ((OnlineDeviceAlarmMapper)this.dao).collectAlarmDataByCases(searchVo);
    }

    public List<MoreAlarmModel> collectMoreAlarm(MoreAlarmParamModel param) {
        return ((OnlineDeviceAlarmMapper)this.dao).collectMoreAlarm(param);
    }

    public List<MoreAlarmModel> listMoreAlarm(MoreAlarmParamModel param) {
        return ((OnlineDeviceAlarmMapper)this.dao).listMoreAlarm(param);
    }

    public PageInfo<MoreAlarmModel> pageMoreAlarm(JqGridParam page, MoreAlarmParamModel param) {
        AreaModel areaModel;
        if (CollectionUtils.isEmpty((Collection)param.getMoreAlarmModelList())) {
            return new PageInfo(new ArrayList());
        }
        if (param.getAreaId() != null && param.getAreaLevel() == null && (areaModel = this.areaProvideService.getAreaById(param.getAreaId())) != null) {
            param.setAreaLevel(areaModel.getLevel());
        }
        PageHelper.startPage((int)page.getPage(), (int)page.getRows());
        List<MoreAlarmModel> alarmModelList = ((OnlineDeviceAlarmMapper)this.dao).listMoreAlarm(param);
        return new PageInfo(alarmModelList);
    }

    public List<OnlineDeviceAlarmDataCollectVo> collectAlarmData(OnlineDeviceAlaramSearchVo searchVo) {
        List<OnlineDeviceAlarmDataCollectVo> collectVoList;
        if (searchVo.getDeviceId() == null && CollectionUtils.isEmpty((Collection)searchVo.getDeviceIdList())) {
            Collections.emptyList();
        }
        if (CollectionUtils.isNotEmpty(collectVoList = ((OnlineDeviceAlarmMapper)this.dao).collectAlarmData(searchVo))) {
            this.onlineDeviceAlarmLogService.settingMaxVdata(collectVoList);
        }
        return collectVoList;
    }

    public Integer getAlarmCaseByDeviceType(Byte deviceType) {
        if (deviceType == null) {
            return 0;
        }
        AlarmCondition alarmCase = null;
        if (deviceType != null) {
            if (deviceType.intValue() == 1) {
                alarmCase = AlarmCondition.DUST_OR_CHEMICAL_OVERPROOF;
            } else if (deviceType.intValue() == 2) {
                alarmCase = AlarmCondition.NOISE_OVERPROOF;
            }
            if (alarmCase != null) {
                return alarmCase.getCode();
            }
        }
        return 0;
    }

    private String getDeviceAlarmCaseCacheKey(Long deviceId, Integer alarmCaseByDeviceType) {
        return deviceId.toString() + alarmCaseByDeviceType;
    }

    private String generateAlarmCaseCacheKey(Long deviceId, Integer alarmCase) {
        String cacheKey = deviceId.toString() + alarmCase.toString();
        return cacheKey;
    }

    @Transactional(readOnly=false)
    public void closeAlarm(OnlineDeviceAlarm ingAlarm, boolean closeDeviceAlarm) {
        if (ingAlarm == null) {
            return;
        }
        if (ingAlarm != null) {
            ingAlarm.setIng(Boolean.valueOf(false));
            ingAlarm.setDisarmTime(new Date());
            ingAlarm.setUpdateDate(new Date());
            this.update(ingAlarm);
            int updater = ((OnlineDeviceAlarmMapper)this.dao).updateByPrimaryKeySelective(ingAlarm);
            if (updater > 0 && closeDeviceAlarm) {
                OnlineDevice device = new OnlineDevice();
                device.setId(ingAlarm.getDeviceId());
                device.setUpdateDate(new Date());
                device.setStatus(Byte.valueOf((byte)0));
                this.onlineDeviceService.update((Object)device, null);
            }
        }
    }

    @Transactional(readOnly=false)
    public void igonrAlarm(OnlineDeviceAlarm deviceAlarm) {
        OnlineDeviceAlarm alarm = (OnlineDeviceAlarm)this.getById(deviceAlarm.getId());
        if (alarm != null) {
            this.alarmTaskService.clearIngAlarmCacheByDeviceId(alarm.getDeviceId(), alarm.getFactorId(), deviceAlarm.getDataType());
            this.update(deviceAlarm);
        }
    }

    public void clearAlarmCacheByAlarm(OnlineDevice deviceAlarm) {
        if (deviceAlarm != null) {
            this.alarmTaskService.clearIngAlarmCacheByDeviceId(deviceAlarm.getId(), null, null);
        }
    }

    public List<OnlineDeviceAlarmModel> listDeviceAlarmModel(OnlineDeviceAlarmParamModel alarmParam) {
        if (alarmParam == null) {
            return Collections.emptyList();
        }
        List<OnlineDeviceAlarmModel> onlineDeviceAlarmModels = ((OnlineDeviceAlarmMapper)this.dao).listDeviceAlarmModel(alarmParam);
        if (CollectionUtils.isNotEmpty(onlineDeviceAlarmModels)) {
            List collect = onlineDeviceAlarmModels.stream().map(OnlineDeviceAlarm::getId).collect(Collectors.toList());
            Map maxvalues = this.onlineDeviceAlarmLogService.getMaxvalues(collect);
            for (OnlineDeviceAlarmModel onlineDeviceAlarmModel : onlineDeviceAlarmModels) {
                onlineDeviceAlarmModel.setMaxValue((Double)maxvalues.get(onlineDeviceAlarmModel.getId()));
                if (Objects.equals(onlineDeviceAlarmModel.getDataType(), 1002)) {
                    onlineDeviceAlarmModel.setMonitorObj(onlineDeviceAlarmModel.getMonitorObj() + "-\u603b\u5c18");
                    continue;
                }
                if (!Objects.equals(onlineDeviceAlarmModel.getDataType(), 1003)) continue;
                onlineDeviceAlarmModel.setMonitorObj(onlineDeviceAlarmModel.getMonitorObj() + "-\u547c\u5c18");
            }
        }
        return onlineDeviceAlarmModels;
    }

    public PageInfo<OnlineDeviceAlarmModel> pageDeviceAlarmModel(JqGridParam param, OnlineDeviceAlarmParamModel search) {
        Date start = search.getStart();
        Date end = search.getEnd();
        if (start != null) {
            search.setStart(DateUtils.getStartTime((Date)start));
        }
        if (end != null) {
            search.setEnd(DateUtils.getEndTime((Date)end));
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<OnlineDeviceAlarmModel> gradeOneYearClassAModelList = this.listDeviceAlarmModel(search);
        PageInfo page = new PageInfo(gradeOneYearClassAModelList);
        return page;
    }

    public List<PneumocoChartData> fcChartData(Date start, Date end, SearchParam param) {
        return ((OnlineDeviceAlarmMapper)this.dao).fcChartData(start, end, param);
    }
}

