/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.onlineMonitoring;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.supervise.dao.onlineMonitoring.OnlineDeviceAlarmLogMapper;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDeviceAlarmLog;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineAlarmSettingService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceAlarmLogService;
import cn.smarthse.modules.health.supervise.vo.onlineMonitoring.OnlineDeviceAlarmDataCollectVo;
import cn.smarthse.modules.health.supervise.vo.onlineMonitoring.OnlineDeviceAlarmDataVo;
import cn.smarthse.modules.health.supervise.vo.onlineMonitoring.OnlineDeviceAlarmLogQueryVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class OnlineDeviceAlarmLogServiceImpl
extends BaseServiceImpl<OnlineDeviceAlarmLogMapper, OnlineDeviceAlarmLog>
implements IOnlineDeviceAlarmLogService {
    @Autowired
    private IOnlineAlarmSettingService settingService;

    public int insertAlarmLogDatas(List<OnlineDeviceAlarmLog> alarmLogList) {
        if (CollectionUtils.isEmpty(alarmLogList)) {
            return 0;
        }
        return ((OnlineDeviceAlarmLogMapper)this.dao).insertAlarmLogDatas(alarmLogList);
    }

    public List<OnlineDeviceAlarmDataVo> getAlarmLogData(OnlineDeviceAlarmLogQueryVo queryVo, Long areaId, Byte level) {
        if (queryVo != null && queryVo.getAlarmEndDate() != null) {
            Date date = DateUtils.addDay((Date)queryVo.getAlarmEndDate(), (int)1);
            queryVo.setAlarmEndDate(date);
        }
        List<OnlineDeviceAlarmDataVo> alarmLogDataList = ((OnlineDeviceAlarmLogMapper)this.dao).getAlarmLogData(queryVo, areaId, level);
        return alarmLogDataList;
    }

    public PageInfo<OnlineDeviceAlarmDataVo> pageAlarmLogData(JqGridParam gparam, OnlineDeviceAlarmLogQueryVo queryVo, Long areaId, Byte level) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<OnlineDeviceAlarmDataVo> alarmLogData = this.getAlarmLogData(queryVo, areaId, level);
        return new PageInfo(alarmLogData);
    }

    public String getMaxVdataByDeviceId(Long alarmId) {
        if (alarmId == null) {
            return "";
        }
        String maxVdataByDeviceId = ((OnlineDeviceAlarmLogMapper)this.dao).getMaxVdataByDeviceId(alarmId);
        if (StringUtils.isBlank((CharSequence)maxVdataByDeviceId)) {
            return "";
        }
        return maxVdataByDeviceId;
    }

    public void settingMaxVdata(List<OnlineDeviceAlarmDataCollectVo> collectVoList) {
        if (CollectionUtils.isEmpty(collectVoList)) {
            return;
        }
        List<Long> alarmIdList = collectVoList.stream().map(OnlineDeviceAlarmDataCollectVo::getAlarmId).collect(Collectors.toList());
        Map<Long, Double> result = this.getMaxvalues(alarmIdList);
        for (OnlineDeviceAlarmDataCollectVo collectVo : collectVoList) {
            if (!result.containsKey(collectVo.getAlarmId())) continue;
            collectVo.setMaxVdata(result.get(collectVo.getAlarmId()));
        }
    }

    public Map<Long, Double> getMaxvalues(List<Long> alarmIdList) {
        HashMap<Long, Double> result = new HashMap<Long, Double>();
        if (CollectionUtils.isEmpty(alarmIdList)) {
            return result;
        }
        List<Map<String, Object>> maxDataMapList = ((OnlineDeviceAlarmLogMapper)this.dao).getMaxVdataMapByDeviceIds(alarmIdList);
        if (CollectionUtils.isNotEmpty(maxDataMapList)) {
            for (Map<String, Object> maxDataMap : maxDataMapList) {
                Long alarm_id = MapUtils.getLong(maxDataMap, (Object)"alarm_id");
                Double maxData = MapUtils.getDouble(maxDataMap, (Object)"maxData");
                result.put(alarm_id, maxData);
            }
        }
        return result;
    }

    public PageInfo<OnlineDeviceAlarmLog> pageAlarmLogDataByAlaramId(JqGridParam gparam, Long alarmId) {
        if (alarmId == null) {
            return null;
        }
        Example e = new Example(OnlineDeviceAlarmLog.class);
        e.createCriteria().andEqualTo("alarmId", (Object)alarmId).andEqualTo("isValid", (Object)true);
        e.setOrderByClause("create_date desc");
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List listByExample = this.getListByExample(e);
        return new PageInfo(listByExample);
    }
}

