/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.onlineMonitoring;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.onlineMonitoring.entity.warning.MoreAlarmConfig;
import cn.smarthse.modules.health.onlineMonitoring.service.warning.IMoreAlarmConfigService;
import cn.smarthse.modules.health.param.SearchParam;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.supervise.dao.onlineMonitoring.OnlineDeviceAiwarningMapper;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDevice;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDeviceAiwarning;
import cn.smarthse.modules.health.supervise.enums.onlinedevice.RiskwarringTypeEnum;
import cn.smarthse.modules.health.supervise.model.home.v3223.onlineMonitoring.PneumocoChartData;
import cn.smarthse.modules.health.supervise.model.onlinemonitor.OnlineDeviceAiwarningCollectModel;
import cn.smarthse.modules.health.supervise.model.onlinemonitor.OnlineDeviceAiwarningIntelligentModel;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceAiwarningService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceService;
import cn.smarthse.modules.health.supervise.vo.onlineMonitoring.MonitoringSearchVo;
import cn.smarthse.util.common.StringUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.BusinessException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class OnlineDeviceAiwarningServiceImpl
extends BaseServiceImpl<OnlineDeviceAiwarningMapper, OnlineDeviceAiwarning>
implements IOnlineDeviceAiwarningService {
    @Autowired
    IOnlineDeviceService deviceService;
    @Autowired
    IMoreAlarmConfigService moreAlarmConfigService;
    @DubboReference
    IReformItemBasicService reformItemBasicService;

    @Transactional(readOnly=false)
    public void saveOnlineDeviceAiwarning(OnlineDeviceAiwarning aiwarning) throws BusinessException {
        if (StringUtils.isBlank((CharSequence)aiwarning.getDeviceNo())) {
            throw new BusinessException("\u8bbe\u5907\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OnlineDevice cacheByDeviceNo = this.deviceService.getCacheByDeviceNo(aiwarning.getDeviceNo(), aiwarning.getCid());
        if (cacheByDeviceNo == null) {
            throw new BusinessException("\u672a\u6dfb\u52a0\u8bbe\u5907\uff0c\u8bf7\u5148\u6dfb\u52a0\u8bbe\u5907");
        }
        aiwarning.setDeviceId(cacheByDeviceNo.getId());
        this.add(aiwarning, null, null);
        Date findTime = aiwarning.getFindTime();
        if (findTime == null) {
            findTime = new Date();
        }
        String dataTypeName = RiskwarringTypeEnum.getNameByCode((Integer)aiwarning.getDataType());
        try {
            Object fileIds = aiwarning.getBackgroud();
            fileIds = fileIds == null ? aiwarning.getViewRecord() : (String)fileIds + "," + aiwarning.getViewRecord();
        }
        catch (Exception e) {
            this.logger.error("\u6dfb\u52a0\u6574\u6539\u9879\u51fa\u9519", (Throwable)e);
        }
    }

    @Transactional(readOnly=true)
    public Integer countAiwarning(Long areaId, Byte areaLevel, Boolean isCurrent) {
        int num = 0;
        List moreAlarmConfigs = this.moreAlarmConfigService.getConfig(Integer.valueOf(1));
        if (CollectionUtils.isEmpty((Collection)moreAlarmConfigs)) {
            return num;
        }
        Set<Integer> alarmConditionSet = moreAlarmConfigs.stream().filter(f -> f.getStatus() == 1).map(MoreAlarmConfig::getAlarmCondition).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(alarmConditionSet)) {
            return num;
        }
        List<OnlineDeviceAiwarningCollectModel> onlineDeviceAiwarningCollectModels = ((OnlineDeviceAiwarningMapper)this.dao).collectAiwarning(areaId, areaLevel, alarmConditionSet, isCurrent, 0);
        if (CollectionUtils.isEmpty(onlineDeviceAiwarningCollectModels)) {
            return num;
        }
        for (OnlineDeviceAiwarningCollectModel model : onlineDeviceAiwarningCollectModels) {
            num += model.getNum().intValue();
        }
        return num;
    }

    @Transactional(readOnly=false)
    public List<OnlineDeviceAiwarningCollectModel> collectAiwarning(Long areaId, Byte areaLevel, Boolean isCurrent) {
        List moreAlarmConfigs = this.moreAlarmConfigService.getConfig(Integer.valueOf(1));
        if (CollectionUtils.isEmpty((Collection)moreAlarmConfigs)) {
            return Collections.emptyList();
        }
        Set<Integer> alarmConditionSet = moreAlarmConfigs.stream().filter(f -> f.getStatus() == 1).map(MoreAlarmConfig::getAlarmCondition).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(alarmConditionSet)) {
            return Collections.emptyList();
        }
        Integer deviceNum = this.deviceService.getDeviceNumByArea(areaId, areaLevel, isCurrent);
        if (deviceNum == 0) {
            ArrayList<OnlineDeviceAiwarningCollectModel> onlineDeviceAiwarningCollectModels = new ArrayList<OnlineDeviceAiwarningCollectModel>();
            for (Integer integer : alarmConditionSet) {
                OnlineDeviceAiwarningCollectModel model = new OnlineDeviceAiwarningCollectModel();
                model.setName(RiskwarringTypeEnum.getNameByCode((Integer)integer));
                model.setCode(integer);
                model.setFlag(Boolean.valueOf(false));
                onlineDeviceAiwarningCollectModels.add(model);
            }
            return onlineDeviceAiwarningCollectModels;
        }
        List<OnlineDeviceAiwarningCollectModel> aiwarningCollectModels = this.getAiwarningCollectModels(areaId, areaLevel, alarmConditionSet, isCurrent);
        if (CollectionUtils.isNotEmpty(aiwarningCollectModels)) {
            for (OnlineDeviceAiwarningCollectModel aiwarningCollectModel : aiwarningCollectModels) {
                aiwarningCollectModel.setName(RiskwarringTypeEnum.getNameByCode((Integer)aiwarningCollectModel.getCode()));
                aiwarningCollectModel.setFlag(Boolean.valueOf(true));
            }
        }
        return aiwarningCollectModels;
    }

    private List<OnlineDeviceAiwarningCollectModel> getAiwarningCollectModels(Long areaId, Byte areaLevel, Set<Integer> alarmConditionSet, Boolean isCurrent) {
        List<OnlineDeviceAiwarningCollectModel> onlineDeviceAiwarningCollectModels = ((OnlineDeviceAiwarningMapper)this.dao).collectAiwarning(areaId, areaLevel, alarmConditionSet, isCurrent, 4);
        for (OnlineDeviceAiwarningCollectModel onlineDeviceAiwarningCollectModel : onlineDeviceAiwarningCollectModels) {
            alarmConditionSet.remove(onlineDeviceAiwarningCollectModel.getCode());
        }
        for (Integer integer : alarmConditionSet) {
            OnlineDeviceAiwarningCollectModel model = new OnlineDeviceAiwarningCollectModel();
            model.setNum(Long.valueOf(Long.parseLong("0")));
            model.setCode(integer);
            onlineDeviceAiwarningCollectModels.add(model);
        }
        return onlineDeviceAiwarningCollectModels;
    }

    public PageInfo<OnlineDeviceAiwarningIntelligentModel> intelligentAiwarning(JqGridParam param, MonitoringSearchVo search) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        PageInfo page = new PageInfo(this.intelligentAiwarningList(search));
        return page;
    }

    public List<OnlineDeviceAiwarningIntelligentModel> intelligentAiwarningList(MonitoringSearchVo search) {
        if (StringUtils.isNotEmpty((String)search.getIds())) {
            ArrayList<OnlineDeviceAiwarningIntelligentModel> list = new ArrayList<OnlineDeviceAiwarningIntelligentModel>();
            List<String> asList = Arrays.asList(search.getIds().split(","));
            int maxSize = 500;
            int page = (int)Math.ceil((double)asList.size() * 1.0 / (double)maxSize);
            for (int i = 0; i < page; ++i) {
                List<String> subIds = asList.stream().skip(i * maxSize).limit(maxSize).collect(Collectors.toList());
                List<OnlineDeviceAiwarningIntelligentModel> subList = ((OnlineDeviceAiwarningMapper)this.dao).getAiwarningIntelligentModelByIds(subIds);
                list.addAll(subList);
            }
            return list;
        }
        return ((OnlineDeviceAiwarningMapper)this.dao).intelligentAiwarning(search);
    }

    public List<PneumocoChartData> maskChartData(Date start, Date end, SearchParam param) {
        return ((OnlineDeviceAiwarningMapper)this.dao).maskChartData(start, end, param);
    }
}

