/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.onlineMonitoring;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.supervise.dao.onlineMonitoring.OnlineAlarmSettingMapper;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineAlarmSetting;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineAlarmSettingService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class OnlineAlarmSettingServiceImpl
extends BaseServiceImpl<OnlineAlarmSettingMapper, OnlineAlarmSetting>
implements IOnlineAlarmSettingService {
    private Map<Byte, OnlineAlarmSetting> typeMap = new HashedMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<Byte, OnlineAlarmSetting> getAlarmSetting() {
        if (!MapUtils.isEmpty(this.typeMap)) return this.typeMap;
        Class<OnlineAlarmSettingServiceImpl> clazz = OnlineAlarmSettingServiceImpl.class;
        synchronized (OnlineAlarmSettingServiceImpl.class) {
            if (!MapUtils.isEmpty(this.typeMap)) return this.typeMap;
            this.typeMap = this.getAlarmSetting4Db();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.typeMap;
        }
    }

    public OnlineAlarmSetting getAlarmSettingByDeviceType(Byte deviceType) {
        Map<Byte, OnlineAlarmSetting> alarmSetting = this.getAlarmSetting();
        if (MapUtils.isNotEmpty(alarmSetting) && alarmSetting.containsKey(deviceType)) {
            return alarmSetting.get(deviceType);
        }
        return null;
    }

    @Transactional(readOnly=false)
    public void saveAlarmSetting(List<OnlineAlarmSetting> settingList) {
        this.typeMap.clear();
        OnlineAlarmSetting setting = new OnlineAlarmSetting();
        setting.setIsValid(Boolean.valueOf(false));
        setting.setUpdateDate(new Date());
        Example e = new Example(OnlineAlarmSetting.class);
        e.createCriteria().andEqualTo("isValid", (Object)true);
        ((OnlineAlarmSettingMapper)this.dao).updateByExampleSelective(setting, e);
        if (CollectionUtils.isNotEmpty(settingList)) {
            for (OnlineAlarmSetting onlineAlarmSetting : settingList) {
                this.add(onlineAlarmSetting);
            }
        }
    }

    public Map<Byte, OnlineAlarmSetting> getAlarmSetting4Db() {
        Object result = new HashedMap();
        Example e = new Example(OnlineAlarmSetting.class);
        e.createCriteria().andEqualTo("isValid", (Object)true);
        List OnlineAlarmSettingList = this.getListByExample(e);
        if (CollectionUtils.isNotEmpty(OnlineAlarmSettingList)) {
            result = OnlineAlarmSettingList.stream().collect(Collectors.toMap(OnlineAlarmSetting::getDeviceType, v -> v, (v1, v2) -> v2));
        }
        return result;
    }

    public List<OnlineAlarmSetting> getOnlineAlarmSettingList() {
        Example e = new Example(OnlineAlarmSetting.class);
        e.createCriteria().andEqualTo("isValid", (Object)true);
        List<OnlineAlarmSetting> onlineAlarmSettingList = this.getListByExample(e);
        return onlineAlarmSettingList;
    }
}

