/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.keyFactory;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;

public class RiskManagement {
    private int level;
    private double riskResolutionRate;
    private double detectionOverrunRate;
    private double physicalExamAbnormalRate;
    private static final Map<Integer, Map<String, Double>> scoreRules = new HashMap<Integer, Map<String, Double>>();

    public RiskManagement(int level, double riskResolutionRate, double detectionOverrunRate, double physicalExamAbnormalRate) {
        this.level = level;
        this.riskResolutionRate = riskResolutionRate;
        this.detectionOverrunRate = detectionOverrunRate;
        this.physicalExamAbnormalRate = physicalExamAbnormalRate;
    }

    public double getRiskResolutionScore() {
        return this.calculateScore("riskResolution");
    }

    public double getDetectionOverrunScore() {
        return this.calculateScore("detectionOverrun");
    }

    public double getPhysicalExamAbnormalScore() {
        return this.calculateScore("physicalExamAbnormal");
    }

    public double calculateResolutionCapacity() {
        double totalScore = this.getRiskResolutionScore() + this.getDetectionOverrunScore() + this.getPhysicalExamAbnormalScore();
        if (this.level == 3 && totalScore > 5.0) {
            totalScore = 5.0;
        }
        return new BigDecimal(totalScore).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    private double calculateScore(String type) {
        Map<String, Double> rules = scoreRules.get(this.level);
        if (rules == null) {
            return 0.0;
        }
        double threshold = rules.get(type);
        switch (type) {
            case "riskResolution": {
                return this.calculateRiskResolutionScore(threshold);
            }
            case "detectionOverrun": {
                return this.calculateDetectionOverrunScore(threshold);
            }
            case "physicalExamAbnormal": {
                return this.calculatePhysicalExamAbnormalScore(threshold);
            }
        }
        throw new IllegalArgumentException("Invalid type");
    }

    private double calculateRiskResolutionScore(double threshold) {
        if (this.level == 2) {
            return this.riskResolutionRate >= threshold ? 1.0 : 0.0;
        }
        if (this.level == 3) {
            if (this.riskResolutionRate >= threshold && this.riskResolutionRate <= 80.0) {
                double value = (this.riskResolutionRate - threshold) * 0.1 + 1.0;
                return new BigDecimal(value).setScale(2, RoundingMode.HALF_UP).doubleValue();
            }
            if (this.riskResolutionRate > 80.0) {
                return 3.0;
            }
            return 0.0;
        }
        return 0.0;
    }

    private double calculateDetectionOverrunScore(double threshold) {
        return this.detectionOverrunRate == threshold ? (this.level == 2 ? 0.5 : 1.0) : 0.0;
    }

    private double calculatePhysicalExamAbnormalScore(double threshold) {
        return this.physicalExamAbnormalRate == threshold ? (this.level == 2 ? 0.5 : 1.0) : 0.0;
    }

    static {
        HashMap<String, Double> municipalRules = new HashMap<String, Double>();
        municipalRules.put("riskResolution", 80.0);
        municipalRules.put("detectionOverrun", 100.0);
        municipalRules.put("physicalExamAbnormal", 100.0);
        scoreRules.put(2, municipalRules);
        HashMap<String, Double> countyRules = new HashMap<String, Double>();
        countyRules.put("riskResolution", 60.0);
        countyRules.put("detectionOverrun", 100.0);
        countyRules.put("physicalExamAbnormal", 100.0);
        scoreRules.put(3, countyRules);
    }
}

