/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.keyFactory;

import cn.hutool.core.util.EscapeUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.database.persistence.LayUiResponseResult;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.PageUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.compliance.enums.ComplianceCodeEnum;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.entity.base.wmbase.WarnSignManage;
import cn.smarthse.modules.health.entity.base.wmbase.WarnSignManageDetail;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaffDetail;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.entity.work.shield.ProtectEquipIssueRecord;
import cn.smarthse.modules.health.entity.work.thirdtime.TsProjectSimple;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.newcompanyguide.vo.NewCompanyGuideTodoListVo;
import cn.smarthse.modules.health.param.SearchParam;
import cn.smarthse.modules.health.service.base.wmbase.IWarnSignManageDetailService;
import cn.smarthse.modules.health.service.base.wmbase.IWarnSignManageService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateFilesService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffDetailService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.shield.IProtectEquipIssueRecordDetailService;
import cn.smarthse.modules.health.service.work.shield.IProtectEquipIssueRecordService;
import cn.smarthse.modules.health.service.work.thirdtime.simple.ITsProjectSimpleService;
import cn.smarthse.modules.health.supervise.dao.keyFactory.KeyFactoryMapper;
import cn.smarthse.modules.health.supervise.entity.keyFactory.KeyFactory;
import cn.smarthse.modules.health.supervise.entity.keyFactory.KeyFactoryApprovalHistory;
import cn.smarthse.modules.health.supervise.enums.keyFactory.HistoryStatusEnum;
import cn.smarthse.modules.health.supervise.enums.keyFactory.KeyFactoryStatusEnum;
import cn.smarthse.modules.health.supervise.enums.keyFactory.KeyFactoryTypeEnum;
import cn.smarthse.modules.health.supervise.model.home.v3223.homeIndex.HomeEnergyEfficiencyVo;
import cn.smarthse.modules.health.supervise.model.keyFactory.CompanyInfo;
import cn.smarthse.modules.health.supervise.model.keyFactory.KeyFactoryAudit;
import cn.smarthse.modules.health.supervise.model.keyFactory.KeyFactoryGradeInfo;
import cn.smarthse.modules.health.supervise.model.keyFactory.KeyFactoryInfo;
import cn.smarthse.modules.health.supervise.model.keyFactory.RiskInfo;
import cn.smarthse.modules.health.supervise.service.keyFactory.IApprovalDataSourceService;
import cn.smarthse.modules.health.supervise.service.keyFactory.IKeyFactoryApprovalHistoryService;
import cn.smarthse.modules.health.supervise.service.keyFactory.IKeyFactoryService;
import cn.smarthse.modules.health.supervise.vo.keyfactory.KeyFactoryAuditNumVo;
import cn.smarthse.modules.health.vo.litearchive.ZjArchiveCountView;
import cn.smarthse.modules.health.vo.work.HomeIndexSearchVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.BusinessException;
import javax.smarthse.exception.ServiceException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class KeyFactoryServiceImpl
extends BaseServiceImpl<KeyFactoryMapper, KeyFactory>
implements IKeyFactoryService {
    @DubboReference
    private ITsProjectSimpleService tsProjectSimpleService;
    @DubboReference
    private ICertificateStaffDetailService certificateStaffDetailService;
    @DubboReference
    private IProtectEquipIssueRecordService protectEquipIssueRecordService;
    @DubboReference
    private IProtectEquipIssueRecordDetailService protectEquipIssueRecordDetailService;
    @DubboReference
    private IWarnSignManageService warnSignManageService;
    @DubboReference
    private IWarnSignManageDetailService warnSignManageDetailService;
    @DubboReference
    private ICertificateFilesService certificateFilesService;
    @Resource
    private IKeyFactoryApprovalHistoryService keyFactoryApprovalHistoryService;
    @DubboReference
    private IReformItemBasicService reformItemBasicService;
    @DubboReference
    private ILiteArchiveService liteArchiveService;
    @Autowired
    private DataSourceTransactionManager txManager;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @Resource
    IBusinessDataUpdateRefreshService businessDataUpdateRefreshService;
    private Map<Byte, Function<Long, Object>> operationMap;
    private Map<Byte, IApprovalDataSourceService> dataSourceTypeMap;

    @PostConstruct
    private void init() {
        this.operationMap = new HashMap<Byte, Function<Long, Object>>();
        this.operationMap.put(KeyFactoryTypeEnum.THREE_TIME.getCode(), this::threeTimeData);
        this.operationMap.put(KeyFactoryTypeEnum.TRAIN.getCode(), this::trainCertStaffData);
        this.operationMap.put(KeyFactoryTypeEnum.WARNING_SIGNS.getCode(), this::warnSignManageData);
        this.operationMap.put(KeyFactoryTypeEnum.PROTECTIVE.getCode(), this::protectEquipIssueRecordData);
    }

    @PostConstruct
    private void initDataSourceType() {
        this.dataSourceTypeMap = new HashMap<Byte, IApprovalDataSourceService>();
        this.dataSourceTypeMap.put(KeyFactoryTypeEnum.TRAIN.getCode(), (IApprovalDataSourceService)this.certificateStaffDetailService);
        this.dataSourceTypeMap.put(KeyFactoryTypeEnum.WARNING_SIGNS.getCode(), (IApprovalDataSourceService)this.warnSignManageService);
        this.dataSourceTypeMap.put(KeyFactoryTypeEnum.PROTECTIVE.getCode(), (IApprovalDataSourceService)this.protectEquipIssueRecordService);
        this.dataSourceTypeMap.put(KeyFactoryTypeEnum.THREE_TIME.getCode(), (IApprovalDataSourceService)this.tsProjectSimpleService);
    }

    private IApprovalDataSourceService getApprovalDataSourceService(Byte type) {
        if (type == null) {
            return null;
        }
        return this.dataSourceTypeMap.get(type);
    }

    public List<KeyFactory> listData(SearchParam param) {
        List<KeyFactory> list;
        if (param != null && StringUtils.isNotBlank((CharSequence)param.getScales())) {
            param.setScaleList(StringUtils.parseToIntegerList((String)param.getScales(), (String)","));
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(list = ((KeyFactoryMapper)this.dao).listData(param))) {
            List collect = list.stream().filter(item -> item != null && item.getBusinessId() != null).map(KeyFactory::getBusinessId).collect(Collectors.toList());
            Example example = new Example(KeyFactoryApprovalHistory.class);
            example.createCriteria().andIn("businessId", collect).andEqualTo("isValid", (Object)true);
            List listByExample = this.keyFactoryApprovalHistoryService.getListByExample(example);
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)listByExample)) {
                Map map = listByExample.stream().filter(item -> item != null && item.getStatus().intValue() == 1).collect(Collectors.toMap(KeyFactoryApprovalHistory::getBusinessId, Function.identity(), (a, b) -> a.getCreateDate().getTime() >= b.getCreateDate().getTime() ? a : b));
                for (KeyFactory keyFactory : list) {
                    KeyFactoryApprovalHistory history;
                    if (keyFactory == null || keyFactory.getBusinessId() == null || (history = (KeyFactoryApprovalHistory)map.get(keyFactory.getBusinessId())) == null) continue;
                    if (keyFactory.getType().equals(history.getType())) {
                        keyFactory.setCreateDate(history.getCreateDate());
                        continue;
                    }
                    listByExample.stream().filter(item -> item != null && item.getStatus().intValue() == 1 && item.getBusinessId().equals(keyFactory.getBusinessId()) && item.getType().equals(keyFactory.getType())).max(Comparator.comparing(KeyFactoryApprovalHistory::getCreateDate)).ifPresent(history2 -> keyFactory.setCreateDate(history2.getCreateDate()));
                }
            }
        }
        return list;
    }

    public LayUiResponseResult<List<KeyFactory>> listPage(SearchParam param) {
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        PageInfo pageInfo = new PageInfo(this.listData(param));
        return new LayUiResponseResult(Long.valueOf(pageInfo.getTotal()), (Object)pageInfo.getList());
    }

    @Transactional(readOnly=false)
    public Long submitKeyFactory(Company currentCompany, Long loginStaffId, Long businessId, KeyFactoryTypeEnum typeEnum) {
        KeyFactory keyFactory = this.getByBusinessId(businessId);
        if (Objects.isNull(keyFactory)) {
            keyFactory = new KeyFactory();
        }
        keyFactory.setCid(currentCompany.getId());
        keyFactory.setBusinessId(businessId);
        keyFactory.setCompanyAddress(currentCompany.getRegisterAddress());
        keyFactory.setCompanyName(currentCompany.getName());
        keyFactory.setStatus(KeyFactoryStatusEnum.AUDIT.getCode());
        keyFactory.setType(typeEnum.getCode());
        keyFactory.setUpdateBy(loginStaffId);
        keyFactory.setCreateBy(loginStaffId);
        if (keyFactory.getId() == null) {
            this.add(keyFactory);
        } else {
            this.update(keyFactory);
        }
        return keyFactory.getId();
    }

    @Transactional(readOnly=false)
    public KeyFactory getByBusinessId(Long businessId) {
        Example example = new Example(KeyFactory.class);
        example.createCriteria().andEqualTo("businessId", (Object)businessId);
        List list = this.getListByExample(example);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(list)) {
            return (KeyFactory)list.get(0);
        }
        return null;
    }

    @Transactional
    public Long submitNotNeedAudit(Company currentCompany, Long loginStaffId, Long businessId, KeyFactoryTypeEnum typeEnum) {
        KeyFactory keyFactory = new KeyFactory();
        keyFactory.setCid(currentCompany.getId());
        keyFactory.setBusinessId(businessId);
        keyFactory.setCompanyAddress(currentCompany.getRegisterAddress());
        keyFactory.setCompanyName(currentCompany.getName());
        keyFactory.setStatus(KeyFactoryStatusEnum.NOT_NEED_AUDIT.getCode());
        keyFactory.setType(typeEnum.getCode());
        keyFactory.setUpdateBy(loginStaffId);
        keyFactory.setCreateBy(loginStaffId);
        this.add(keyFactory);
        return keyFactory.getId();
    }

    public KeyFactoryInfo getKeyFactoryInfo(Long id) {
        KeyFactoryInfo info = new KeyFactoryInfo();
        KeyFactory keyFactory = (KeyFactory)this.getById(id);
        CompanySuperviseModel companySuperviseModel = this.companyProvideBySuperviseService.getCompanyInfoById(keyFactory.getCid());
        CompanyInfo companyInfo = new CompanyInfo();
        BeanUtils.copyProperties((Object)companySuperviseModel, (Object)companyInfo);
        companyInfo.setCompanyName(companySuperviseModel.getName());
        companyInfo.setAddress(companySuperviseModel.getWorkAddress());
        companyInfo.setIndustry(companySuperviseModel.getIndustryCategoryName());
        companyInfo.setCompanyLevel(companySuperviseModel.getBelongType());
        companyInfo.setCid(companySuperviseModel.getId());
        Example e = new Example(KeyFactory.class);
        e.createCriteria().andEqualTo("cid", (Object)keyFactory.getCid()).andEqualTo("isValid", (Object)true).andEqualTo("status", (Object)KeyFactoryStatusEnum.AUDIT.getCode());
        List keyFactoryList = this.getListByExample(e);
        Map<Byte, Long> map = keyFactoryList.stream().collect(Collectors.groupingBy(KeyFactory::getType, Collectors.counting()));
        List auditList = map.keySet().stream().map(item -> {
            KeyFactoryAudit ad = new KeyFactoryAudit();
            ad.setRiskType(item);
            ad.setCount(((Long)map.get(item)).intValue());
            return ad;
        }).collect(Collectors.toList());
        companyInfo.setAuditList(auditList);
        RiskInfo riskInfo = new RiskInfo();
        BeanUtils.copyProperties((Object)keyFactory, (Object)riskInfo);
        riskInfo.setRiskType(keyFactory.getType());
        Example example = new Example(KeyFactoryApprovalHistory.class);
        example.createCriteria().andEqualTo("businessId", (Object)keyFactory.getBusinessId()).andEqualTo("type", (Object)keyFactory.getType()).andEqualTo("status", (Object)1).andEqualTo("isValid", (Object)true);
        example.orderBy("createDate").desc();
        List list = this.keyFactoryApprovalHistoryService.getListByExample(example);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)list) && list.get(0) != null) {
            keyFactory.setCreateDate(((KeyFactoryApprovalHistory)list.get(0)).getCreateDate());
            riskInfo.setSubmitTimeStr(keyFactory.getCreateDateStr());
        } else {
            riskInfo.setSubmitTimeStr(keyFactory.getCreateDateStr());
        }
        Object detailInfo = this.operationMap.get(keyFactory.getType()).apply(keyFactory.getBusinessId());
        detailInfo = DesensitizationUtils.setDesensitizationFieldFromObject((Object)detailInfo);
        info.setCompanyInfo(companyInfo);
        info.setRiskInfo(riskInfo);
        info.setDetailInfo(detailInfo);
        return info;
    }

    public int countFinishNum() {
        Example e = new Example(KeyFactory.class);
        e.createCriteria().andEqualTo("isValid", (Object)true).andIn("status", Arrays.asList(KeyFactoryStatusEnum.PASS.getCode(), KeyFactoryStatusEnum.NOT_NEED_AUDIT.getCode()));
        return ((KeyFactoryMapper)this.dao).selectCountByExample(e);
    }

    public KeyFactoryAuditNumVo countAuditNum(SearchParam searchVo) {
        KeyFactoryAuditNumVo keyFactoryAuditNumVo = new KeyFactoryAuditNumVo();
        Map<Byte, Integer> map = ((KeyFactoryMapper)this.dao).countAuditNum(searchVo, KeyFactoryStatusEnum.AUDIT.getCode()).stream().filter(Objects::nonNull).collect(Collectors.toMap(KeyFactoryAuditNumVo::getType, KeyFactoryAuditNumVo::getTypeNum));
        List.of(KeyFactoryTypeEnum.PROTECTIVE.getCode(), KeyFactoryTypeEnum.THREE_TIME.getCode(), KeyFactoryTypeEnum.TRAIN.getCode(), KeyFactoryTypeEnum.WARNING_SIGNS.getCode()).forEach(type -> keyFactoryAuditNumVo.setValue(type, map.getOrDefault(type, 0)));
        return keyFactoryAuditNumVo;
    }

    private TsProjectSimple threeTimeData(Long id) {
        return this.tsProjectSimpleService.getDetailById(id);
    }

    private CertificateStaffDetail trainCertStaffData(Long id) {
        CertificateStaffDetail record = (CertificateStaffDetail)this.certificateStaffDetailService.getById(id);
        if (!Objects.isNull(record)) {
            List files = this.certificateFilesService.getByCerid(record.getId());
            record.setFiles(files);
        }
        return record;
    }

    private WarnSignManage warnSignManageData(Long id) {
        return (WarnSignManage)this.warnSignManageService.getById(id);
    }

    public PageInfo<WarnSignManageDetail> warnSignDetails(Long id, int pageNum, int pageSize) {
        List recordDetailList = this.warnSignManageDetailService.getRecordDetailListByRecordId(id);
        return PageUtil.getPageInfo((List)recordDetailList, (int)pageNum, (int)pageSize);
    }

    private ProtectEquipIssueRecord protectEquipIssueRecordData(Long id) {
        ProtectEquipIssueRecord record = (ProtectEquipIssueRecord)this.protectEquipIssueRecordService.getById(id);
        if (!Objects.isNull(record)) {
            List recordDetailListByRecordId = this.protectEquipIssueRecordDetailService.getRecordDetailListByRecordId(record.getId());
            record.setRecordDetailList(recordDetailListByRecordId);
        }
        return record;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean approval(Long loginStaffId, String loginUserName, String companyName, Long id, Byte status, String refusedReason) throws BusinessException {
        int length;
        int effectRows;
        if (StrUtil.isNotBlank((CharSequence)refusedReason)) {
            refusedReason = EscapeUtil.unescapeHtml4((CharSequence)refusedReason);
        }
        if ((effectRows = ((KeyFactoryMapper)this.dao).approval(loginStaffId, id, status, KeyFactoryStatusEnum.AUDIT.getCode(), new Date())) < 1) {
            this.logger.debug("\u5173\u952e\u56e0\u7d20\u753b\u50cf-\u5ba1\u6838\u64cd\u4f5ckey_factory\u8868id\uff1a{}", (Object)id);
            throw new BusinessException("\u5173\u952e\u56e0\u7d20\u753b\u50cf-\u5ba1\u6838\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        }
        KeyFactory keyFactory = (KeyFactory)this.getById(id);
        IApprovalDataSourceService approvalDataSourceService = this.getApprovalDataSourceService(keyFactory.getType());
        int approvalEffectRows = approvalDataSourceService.approval(keyFactory, status);
        if (approvalEffectRows < 1) {
            this.logger.debug("\u5173\u952e\u56e0\u7d20\u753b\u50cf-\u5ba1\u6838\u64cd\u4f5c\u4e1a\u52a1\u8868\u7c7b\u578b\uff1a{}, \u4e1a\u52a1\u4e3b\u8868id\uff1a{}", (Object)keyFactory.getType(), (Object)keyFactory.getBusinessId());
        }
        KeyFactoryApprovalHistory approvalNewRecord = new KeyFactoryApprovalHistory();
        approvalNewRecord.setCid(keyFactory.getCid());
        approvalNewRecord.setType(keyFactory.getType());
        approvalNewRecord.setBusinessId(keyFactory.getBusinessId());
        approvalNewRecord.setUpdateDate(new Date());
        approvalNewRecord.setUpdateBy(loginStaffId);
        approvalNewRecord.setOperator(loginUserName);
        approvalNewRecord.setOperatorCompanyName(companyName);
        if (Objects.equals(KeyFactoryStatusEnum.BACK.getCode(), status)) {
            approvalNewRecord.setReason(refusedReason);
            approvalNewRecord.setStatus(HistoryStatusEnum.BACK.getCode());
        } else {
            approvalNewRecord.setStatus(HistoryStatusEnum.PASS.getCode());
        }
        if (StrUtil.isNotBlank((CharSequence)approvalNewRecord.getReason()) && (length = approvalNewRecord.getReason().length()) > 256) {
            throw new ServiceException("\u9000\u56de\u539f\u56e0\u5b57\u7b26\u9650\u5236256\uff0c\u70e6\u8bf7\u4fee\u6539\u5185\u5bb9\u540e\u91cd\u65b0\u63d0\u4ea4");
        }
        this.keyFactoryApprovalHistoryService.add((Object)approvalNewRecord);
        if (KeyFactoryTypeEnum.THREE_TIME.getCode().equals(keyFactory.getType()) && KeyFactoryStatusEnum.PASS.getCode().equals(status)) {
            this.businessDataUpdateRefreshService.addBusinessDataUpdateMsg(keyFactory.getCid(), null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE04});
        }
        return true;
    }

    @Transactional
    public void delByBusinessId(Long id) {
        ((KeyFactoryMapper)this.dao).delByBusinessId(id);
    }

    public HomeEnergyEfficiencyVo getData6(HomeIndexSearchVo searchVo, HomeEnergyEfficiencyVo efficiencyVo) {
        List<HomeEnergyEfficiencyVo> list = ((KeyFactoryMapper)this.dao).getData6(searchVo);
        if (CollectionUtils.isEmpty(list)) {
            return efficiencyVo;
        }
        int score = list.size();
        int rank = 1;
        int flag = 1;
        double previous = 1000.0;
        for (HomeEnergyEfficiencyVo item : list) {
            if (item == null) continue;
            if (previous > item.getRate()) {
                rank = flag;
                score = list.size() - flag + 1;
            }
            if (searchVo.getChooseAreaId().equals(item.getAreaId())) {
                efficiencyVo.setRate6(String.valueOf(item.getRate()));
                efficiencyVo.setRank6(Integer.valueOf(rank));
                efficiencyVo.setScore6(String.valueOf(score));
                break;
            }
            previous = item.getRate();
            ++flag;
        }
        return efficiencyVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public int batchUpdate(List<KeyFactory> keyFactoryList) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(keyFactoryList)) {
            return 0;
        }
        return this.batchUpdateOrInsert(keyFactoryList, KeyFactoryMapper.class, (item, mapper) -> mapper.updateStatus((KeyFactory)item));
    }

    public KeyFactoryGradeInfo getCompletionByCid(Long cid) {
        KeyFactoryGradeInfo keyFactoryGradeInfo = new KeyFactoryGradeInfo();
        ZjArchiveCountView archiveCountView = this.liteArchiveService.getZjArchiveCountViewByCid(cid);
        boolean archiveCompletion = archiveCountView.getThirdState() == 3 && archiveCountView.getThirdState() == 4 && archiveCountView.getCheckState() == 3 && archiveCountView.getPhysicalState() == 3 && archiveCountView.getTrainState() == 3 && archiveCountView.getStaffState() == 3;
        int countThisYearPhcPhyRec = ((KeyFactoryMapper)this.dao).countThisYearPhcPhyRec(cid);
        int last2YearNum = this.tsProjectSimpleService.countLast2YearNum(cid);
        int unFinishNum = this.tsProjectSimpleService.countUnFinishNum(cid);
        List list = this.reformItemBasicService.getInfoByReformGenerationSource(Arrays.asList(ReformGenerationSourceEnum.YSZYB, ReformGenerationSourceEnum.JJZ), cid, Integer.valueOf(2024));
        ReformItemBasic reformItemBasic = list.stream().filter(item -> item.getStatus() != 3).findFirst().orElse(null);
        keyFactoryGradeInfo.setHasJJZOrYSZJBReform(Boolean.valueOf(Objects.nonNull(reformItemBasic)));
        keyFactoryGradeInfo.setThreeLast2YearNum(last2YearNum);
        keyFactoryGradeInfo.setHasUnFinish(Boolean.valueOf(unFinishNum > 0));
        keyFactoryGradeInfo.setArchiveCompletion(Boolean.valueOf(archiveCompletion));
        keyFactoryGradeInfo.setHasPhyphc(Boolean.valueOf(countThisYearPhcPhyRec > 0));
        return keyFactoryGradeInfo;
    }

    public NewCompanyGuideTodoListVo newCompanyVisualization(SearchParam param) {
        NewCompanyGuideTodoListVo newCompanyGuideTodoListVo = ((KeyFactoryMapper)this.dao).newCompanyVisualization(param);
        if (ObjectUtil.isNotNull((Object)newCompanyGuideTodoListVo)) {
            return newCompanyGuideTodoListVo;
        }
        return new NewCompanyGuideTodoListVo();
    }
}

