/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.keyFactory;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.param.KeyFactoryScoreParam;
import cn.smarthse.modules.health.supervise.dao.keyFactory.KeyFactoryScoreTableMapper;
import cn.smarthse.modules.health.supervise.entity.keyFactory.KeyFactoryScoreTable;
import cn.smarthse.modules.health.supervise.model.keyFactory.KeyFactoryScoreInfo;
import cn.smarthse.modules.health.supervise.model.keyFactory.KeyFactoryScoreTableHistory;
import cn.smarthse.modules.health.supervise.service.keyFactory.IKeyFactoryScoreTableService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@DubboService
public class KeyFactoryScoreTableServiceImpl
extends BaseServiceImpl<KeyFactoryScoreTableMapper, KeyFactoryScoreTable>
implements IKeyFactoryScoreTableService {
    public List<KeyFactoryScoreInfo> airResultList(KeyFactoryScoreParam param) {
        return ((KeyFactoryScoreTableMapper)this.dao).airResultList(param);
    }

    public KeyFactoryScoreInfo historyHeadData(KeyFactoryScoreParam searchParam) {
        if (StringUtils.isEmpty((CharSequence)searchParam.getUrlType()) || !StringUtils.isNumeric((CharSequence)searchParam.getUrlType())) {
            return null;
        }
        KeyFactoryScoreInfo keyFactoryScoreInfo = ((KeyFactoryScoreTableMapper)this.dao).headDataHistory(searchParam, Integer.parseInt(searchParam.getUrlType()));
        if (keyFactoryScoreInfo != null && searchParam.getUrlType().equals("20250630")) {
            keyFactoryScoreInfo.setExistRiskCompanyNum(Integer.valueOf(keyFactoryScoreInfo.getNeedKeyFactoryCompanyNum() - keyFactoryScoreInfo.getFinishDefuseCompanyNum()));
            keyFactoryScoreInfo.setNoRiskCompanyNum(keyFactoryScoreInfo.getFinishDefuseCompanyNum());
        }
        return keyFactoryScoreInfo;
    }

    public PageInfo<KeyFactoryScoreInfo> historyListDataPage(KeyFactoryScoreParam searchParam) {
        PageHelper.startPage((int)searchParam.getPage(), (int)searchParam.getRows());
        List<KeyFactoryScoreInfo> keyFactoryScoreInfos = this.historyListData(searchParam);
        return new PageInfo(keyFactoryScoreInfos);
    }

    public List<KeyFactoryScoreInfo> historyListData(KeyFactoryScoreParam searchParam) {
        if (StringUtils.isEmpty((CharSequence)searchParam.getUrlType()) || !StringUtils.isNumeric((CharSequence)searchParam.getUrlType())) {
            return Collections.emptyList();
        }
        List<KeyFactoryScoreInfo> keyFactoryScoreInfos = ((KeyFactoryScoreTableMapper)this.dao).listDataHistory(searchParam, Integer.parseInt(searchParam.getUrlType()));
        if (searchParam.getUrlType().equals("20250630")) {
            for (KeyFactoryScoreInfo keyFactoryScoreInfo : keyFactoryScoreInfos) {
                if (keyFactoryScoreInfo == null) continue;
                keyFactoryScoreInfo.setExistRiskCompanyNum(Integer.valueOf(keyFactoryScoreInfo.getNeedKeyFactoryCompanyNum() - keyFactoryScoreInfo.getFinishDefuseCompanyNum()));
                keyFactoryScoreInfo.setNoRiskCompanyNum(keyFactoryScoreInfo.getFinishDefuseCompanyNum());
            }
        }
        return keyFactoryScoreInfos;
    }

    public List<KeyFactoryScoreTableHistory> historyListTotal(KeyFactoryScoreParam param) {
        return ((KeyFactoryScoreTableMapper)this.dao).historyListTotal(param);
    }

    public List<KeyFactoryScoreInfo> airResultParentList(KeyFactoryScoreParam param) {
        return ((KeyFactoryScoreTableMapper)this.dao).airResultParentList(param);
    }

    public List<KeyFactoryScoreInfo> exportListData(KeyFactoryScoreParam param) {
        ArrayList<KeyFactoryScoreInfo> factoryScoreInfos = new ArrayList<KeyFactoryScoreInfo>();
        if (param.getAirResult().booleanValue()) {
            List<KeyFactoryScoreInfo> parentList = this.airResultParentList(param);
            List<KeyFactoryScoreInfo> dataList = this.airResultList(param);
            parentList.stream().forEach(info -> {
                List<KeyFactoryScoreInfo> childrenList = this.getChildrenList(dataList, info.getAreaId());
                if (CollectionUtils.isNotEmpty(childrenList)) {
                    childrenList.forEach(i -> i.setParentAreaName(info.getAreaName()));
                }
                info.setParentAreaName(info.getAreaName());
                info.setAreaName("/");
                childrenList.add(0, (KeyFactoryScoreInfo)info);
                factoryScoreInfos.addAll(childrenList);
            });
        } else if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank((CharSequence)param.getUrlType())) {
            param.setIsShowCurrent(Boolean.valueOf(true));
            factoryScoreInfos.addAll(this.historyListData(param));
        }
        return factoryScoreInfos;
    }

    private List<KeyFactoryScoreInfo> getChildrenList(List<KeyFactoryScoreInfo> dataList, Long areaId) {
        if (CollectionUtils.isEmpty(dataList) || Objects.isNull(areaId)) {
            return Collections.emptyList();
        }
        return dataList.stream().filter(item -> item.getAreaParentId().equals(areaId)).collect(Collectors.toList());
    }
}

