/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.keyFactory;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.param.SearchParam;
import cn.smarthse.modules.health.supervise.dao.keyFactory.KeyFactoryApprovalHistoryMapper;
import cn.smarthse.modules.health.supervise.entity.keyFactory.KeyFactoryApprovalHistory;
import cn.smarthse.modules.health.supervise.enums.keyFactory.HistoryStatusEnum;
import cn.smarthse.modules.health.supervise.enums.keyFactory.KeyFactoryTypeEnum;
import cn.smarthse.modules.health.supervise.service.keyFactory.IKeyFactoryApprovalHistoryService;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class KeyFactoryApprovalHistoryServiceImpl
extends BaseServiceImpl<KeyFactoryApprovalHistoryMapper, KeyFactoryApprovalHistory>
implements IKeyFactoryApprovalHistoryService {
    public PageInfo<KeyFactoryApprovalHistory> getKeyFactoryOperatorHistories(KeyFactoryApprovalHistory searchParam, int pageNum, int pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        return new PageInfo(this.getOperatorHistory(searchParam));
    }

    public List<KeyFactoryApprovalHistory> getOperatorHistory(KeyFactoryApprovalHistory searchParam) {
        Example example = new Example(KeyFactoryApprovalHistory.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("cid", (Object)searchParam.getCid());
        criteria.andEqualTo("type", (Object)searchParam.getType());
        criteria.andEqualTo("businessId", (Object)searchParam.getBusinessId());
        criteria.andEqualTo("isValid", (Object)true);
        example.orderBy("updateDate").desc();
        return this.getListByExample(example);
    }

    public PageInfo<KeyFactoryApprovalHistory> getPageOperatorHistory(JqGridParam jqGridParam, KeyFactoryApprovalHistory searchParam) {
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List<KeyFactoryApprovalHistory> list = this.getOperatorHistory(searchParam);
        return new PageInfo(list);
    }

    @Transactional(rollbackFor={Exception.class})
    public void addNewRecord(Company currentCompany, StaffInfo staffInfo, Long businessId, KeyFactoryTypeEnum typeEnum) {
        KeyFactoryApprovalHistory his = this.createHis(currentCompany, staffInfo, businessId, typeEnum);
        his.setCid(currentCompany.getId());
        his.setStatus(HistoryStatusEnum.SUBMIT.getCode());
        this.add(his);
    }

    @Transactional(rollbackFor={Exception.class})
    public void addCloseRecord(Company currentCompany, StaffInfo staffInfo, Long businessId, KeyFactoryTypeEnum typeEnum) {
        KeyFactoryApprovalHistory his = this.createHis(currentCompany, staffInfo, businessId, typeEnum);
        his.setCid(currentCompany.getId());
        his.setStatus(HistoryStatusEnum.CLOSED.getCode());
        this.add(his);
    }

    @Transactional
    public Integer addRecord(List<KeyFactoryApprovalHistory> record) {
        if (CollectionUtils.isEmpty(record)) {
            return 0;
        }
        List collect = record.parallelStream().peek(item -> {
            if (item.getCreateDate() == null) {
                item.setCreateDate(new Date());
            }
            if (item.getUpdateDate() == null) {
                item.setUpdateDate(new Date());
            }
            if (item.getId() == null) {
                item.setId(Long.valueOf(this.idworker.nextId()));
            }
            item.setIsValid(Global.TRUE);
        }).collect(Collectors.toList());
        return this.batchUpdateOrInsert(collect, KeyFactoryApprovalHistoryMapper.class, (item, mapper) -> mapper.insert(item));
    }

    private KeyFactoryApprovalHistory createHis(Company currentCompany, StaffInfo staffInfo, Long businessId, KeyFactoryTypeEnum typeEnum) {
        KeyFactoryApprovalHistory his = new KeyFactoryApprovalHistory();
        his.setBusinessId(businessId);
        his.setType(typeEnum.getCode());
        if (his.getId() == null) {
            his.setId(Long.valueOf(this.idworker.nextId()));
        }
        his.setOperator(staffInfo.getStaffBasicInfo() == null ? null : staffInfo.getStaffBasicInfo().getRealName());
        his.setOperatorCompanyName(currentCompany.getName());
        his.setUpdateBy(staffInfo.getId());
        his.setCreateBy(staffInfo.getId());
        his.setUpdateDate(new Date());
        his.setCreateDate(new Date());
        his.setIsValid(Boolean.valueOf(true));
        return his;
    }

    public PageInfo<KeyFactoryApprovalHistory> listData(Long businessId, SearchParam param) {
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        Example example = new Example(KeyFactoryApprovalHistory.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("businessId", (Object)businessId);
        criteria.andEqualTo("isValid", (Object)true);
        example.orderBy("createDate").desc();
        return new PageInfo(this.getListByExample(example));
    }

    @Transactional
    public void delByBusinessId(Long tsId) {
        Example example = new Example(KeyFactoryApprovalHistory.class);
        example.createCriteria().andEqualTo("businessId", (Object)tsId);
        ((KeyFactoryApprovalHistoryMapper)this.dao).deleteByExample(example);
    }

    public String getReasonByBusinessId(Long tsId) {
        return ((KeyFactoryApprovalHistoryMapper)this.dao).getReasonByBusinessId(tsId);
    }
}

