/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.importantIndustryCategory;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.health.compliance.task.ComplianceScoreRefreshTask;
import cn.smarthse.modules.health.supervise.dao.sysparam.ImportantIndustryCategoryFactoryMapper;
import cn.smarthse.modules.health.supervise.dao.sysparam.ImportantIndustryCategoryMapper;
import cn.smarthse.modules.health.supervise.dao.sysparam.ImportantIndustryCategoryTypeMapper;
import cn.smarthse.modules.health.supervise.entity.sysparam.ImportantIndustryCategory;
import cn.smarthse.modules.health.supervise.entity.sysparam.ImportantIndustryCategoryFactory;
import cn.smarthse.modules.health.supervise.entity.sysparam.ImportantIndustryCategoryType;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.importantIndustryCategory.IImportantIndustryCategoryFactoryService;
import cn.smarthse.modules.health.supervise.service.importantIndustryCategory.IImportantIndustryCategoryService;
import cn.smarthse.modules.health.supervise.service.importantIndustryCategory.IImportantIndustryCategoryTypeService;
import cn.smarthse.snowflake.IdWorker;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ImportantIndustryCategoryServiceImpl
implements IImportantIndustryCategoryService {
    @Autowired
    protected IdWorker idworker;
    @Autowired
    private IImportantIndustryCategoryTypeService categoryTypeService;
    @Autowired
    private IImportantIndustryCategoryFactoryService categoryFactoryService;
    @Autowired
    private ImportantIndustryCategoryMapper dao;
    @Autowired
    private ComplianceScoreRefreshTask scoreRefreshTask;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private RedissonClient redissonClient;
    @DubboReference
    private IOrganizationService organizationService;

    public List<ImportantIndustryCategory> getList() {
        return this.dao.getList();
    }

    public int getImportIndustryCompanyNum(Long areaId, Byte areaLevel, Boolean isBelongType) {
        List<CompanySuperviseModel> resultList = this.getImportIndustryCompanyList(areaId, areaLevel, isBelongType);
        return CollectionUtils.isNotEmpty(resultList) ? resultList.size() : 0;
    }

    public List<CompanySuperviseModel> getImportIndustryCompanyList(Long areaId, Byte areaLevel, Boolean isBelongType) {
        return this.dao.getImportIndustryCompanyList(areaId, areaLevel, isBelongType);
    }

    public List<ImportantIndustryCategoryType> listCategoryType(ImportantIndustryCategoryType param) {
        Example example = new Example(ImportantIndustryCategoryType.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)Global.TRUE);
        if (StringUtils.isNotBlank((CharSequence)param.getImportantTypeName())) {
            criteria.andLike("importantTypeName", "%" + param.getImportantTypeName() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)param.getExcludedImportantTypeStr())) {
            criteria.andNotIn("importantType", (Iterable)StringUtils.parseToLongList((String)param.getExcludedImportantTypeStr()));
        }
        if (param.getImportantType() != null) {
            criteria.andEqualTo("importantType", (Object)param.getImportantType());
        }
        if (param.getMenuSet() != null) {
            criteria.andEqualTo("menuSet", (Object)param.getMenuSet());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getSortName())) {
            example.setOrderByClause(param.getSortName() + " " + param.getSortMethod());
        }
        List list = this.categoryTypeService.getListByExample(example);
        if (param.getIsDelSearch().booleanValue()) {
            Set<Integer> noDelCategoryType = this.haveDetailCategoryType();
            for (ImportantIndustryCategoryType entity : list) {
                if (entity == null || noDelCategoryType.contains(entity.getImportantType())) continue;
                entity.setIsDel(Boolean.valueOf(true));
            }
        }
        return list;
    }

    public PageInfo<ImportantIndustryCategoryType> pageCategoryType(JqGridParam jqGridParam, ImportantIndustryCategoryType param) {
        if (jqGridParam.getTotal() == -1L) {
            PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows(), (boolean)false);
        } else {
            PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        }
        List<ImportantIndustryCategoryType> importantIndustryCategoryTypes = this.listCategoryType(param);
        for (ImportantIndustryCategoryType importantIndustryCategoryType : importantIndustryCategoryTypes) {
            ArrayList<String> unitList = new ArrayList<String>();
            importantIndustryCategoryType.setImportantIndustryCategoryFactoryList(this.listCategoryTypeFactory(new ImportantIndustryCategoryFactory().setCategoryTypeId(importantIndustryCategoryType.getId())));
            importantIndustryCategoryType.setImportantIndustryCategoryList(this.listCategory(new ImportantIndustryCategory().setCategoryTypeId(importantIndustryCategoryType.getId())));
            String supervisionUnit = importantIndustryCategoryType.getSupervisionUnit();
            if (supervisionUnit == null || supervisionUnit.isEmpty()) continue;
            for (String s : supervisionUnit.split(",")) {
                Long id = Long.valueOf(s);
                unitList.add(this.organizationService.getOrgById(id).getName());
            }
            importantIndustryCategoryType.setSupervisionUnitList(unitList);
        }
        return new PageInfo(importantIndustryCategoryTypes);
    }

    public List<ImportantIndustryCategory> listCategory(ImportantIndustryCategory param) {
        return this.dao.listCategory(param);
    }

    public PageInfo<ImportantIndustryCategory> pageCategory(JqGridParam jqGridParam, ImportantIndustryCategory param) {
        if (jqGridParam.getTotal() == -1L) {
            PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows(), (boolean)false);
        } else {
            PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        }
        return new PageInfo(this.listCategory(param));
    }

    public List<ImportantIndustryCategoryFactory> listCategoryTypeFactory(ImportantIndustryCategoryFactory param) {
        return this.dao.listCategoryTypeFactory(param);
    }

    public PageInfo<ImportantIndustryCategoryFactory> pageCategoryTypeFactory(JqGridParam jqGridParam, ImportantIndustryCategoryFactory param) {
        if (jqGridParam.getTotal() == -1L) {
            PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows(), (boolean)false);
        } else {
            PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        }
        return new PageInfo(this.listCategoryTypeFactory(param));
    }

    public ImportantIndustryCategoryType getTypeByImportantType(Integer importantType) {
        return this.categoryTypeService.getByImportantType(importantType);
    }

    public ImportantIndustryCategoryType getTypeById(Long id) {
        String supervisionUnit;
        if (id == null) {
            throw new ServiceException("\u53c2\u6570\u4e3a\u7a7a");
        }
        ImportantIndustryCategoryType importantIndustryCategoryType = (ImportantIndustryCategoryType)this.categoryTypeService.getById(id);
        if (importantIndustryCategoryType != null && (supervisionUnit = importantIndustryCategoryType.getSupervisionUnit()) != null && !supervisionUnit.isEmpty()) {
            ArrayList<String> unitList = new ArrayList<String>();
            for (String s : supervisionUnit.split(",")) {
                Long oid = Long.valueOf(s);
                unitList.add(this.organizationService.getOrgById(oid).getName());
            }
            importantIndustryCategoryType.setSupervisionUnitList(unitList);
        }
        return importantIndustryCategoryType;
    }

    @Transactional(readOnly=false)
    public ImportantIndustryCategoryType addOrUpdateCategoryType(ImportantIndustryCategoryType categoryType, String method) {
        if (categoryType == null || StringUtils.isBlank((CharSequence)categoryType.getImportantTypeName()) || StringUtils.isBlank((CharSequence)method)) {
            throw new ServiceException("\u53c2\u6570\u4e3a\u7a7a");
        }
        Example example = new Example(ImportantIndustryCategoryType.class);
        example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE);
        example.setOrderByClause("important_type desc");
        List list = this.categoryTypeService.getListByExample(example);
        boolean isExit1 = list.stream().filter(Objects::nonNull).anyMatch(item -> item.getImportantTypeName().equals(categoryType.getImportantTypeName()));
        this.clearCache();
        if (method.equals("add")) {
            if (isExit1) {
                throw new ServiceException("\u91cd\u70b9\u884c\u4e1a\u540d\u79f0\u5df2\u5b58\u5728");
            }
            Integer importantType = categoryType.getImportantType();
            if (importantType == null) {
                throw new ServiceException("\u91cd\u70b9\u884c\u4e1a\u7f16\u53f7\u672a\u586b\u5199");
            }
            if (importantType < 0 || importantType > 10000) {
                throw new ServiceException("\u91cd\u70b9\u884c\u4e1a\u7f16\u53f7\u53d6\u503c\u8303\u56f40~10000");
            }
            boolean isExit2 = list.stream().filter(Objects::nonNull).anyMatch(item -> item.getImportantType().equals(importantType));
            if (isExit2) {
                throw new ServiceException("\u91cd\u70b9\u884c\u4e1a\u7f16\u53f7\u5df2\u5b58\u5728");
            }
            categoryType.setId(Long.valueOf(this.idworker.nextId()));
            categoryType.setMenuSet(Integer.valueOf(0));
            categoryType.setCreateBy(categoryType.getUpdateBy());
            categoryType.setIsCount(categoryType.getIsCount());
            categoryType.setCreateDate(new Date());
            categoryType.setUpdateDate(new Date());
            return (ImportantIndustryCategoryType)this.categoryTypeService.add((Object)categoryType);
        }
        Long id = categoryType.getId();
        if (id == null) {
            throw new ServiceException("\u4e3b\u952e\u53c2\u6570\u4e3a\u7a7a");
        }
        ImportantIndustryCategoryType categoryTypeNew = new ImportantIndustryCategoryType();
        categoryTypeNew.setId(id);
        categoryTypeNew.setImportantTypeName(categoryType.getImportantTypeName());
        categoryTypeNew.setIsCount(categoryType.getIsCount());
        this.categoryTypeService.update((Object)categoryTypeNew, categoryType.getUpdateBy());
        ImportantIndustryCategoryType data = (ImportantIndustryCategoryType)this.categoryTypeService.getById(id);
        ImportantIndustryCategory category = new ImportantIndustryCategory();
        category.setImportantTypeName(data.getImportantTypeName());
        Example example1 = new Example(ImportantIndustryCategory.class);
        example1.createCriteria().andEqualTo("importantType", (Object)data.getImportantType());
        this.dao.updateByExampleSelective(category, example1);
        return data;
    }

    @Transactional(readOnly=false)
    public List<ImportantIndustryCategory> addCategoryList(List<Long> industryIds, Long categoryTypeId, Long operator) {
        if (CollectionUtils.isEmpty(industryIds) || categoryTypeId == null) {
            throw new ServiceException("\u53c2\u6570\u4e3a\u7a7a");
        }
        Date date = new Date();
        ImportantIndustryCategoryType categoryType = (ImportantIndustryCategoryType)this.categoryTypeService.getById(categoryTypeId);
        if (categoryType == null) {
            throw new ServiceException("\u627e\u4e0d\u5230\u8be5\u91cd\u70b9\u884c\u4e1a\u7c7b\u578b\u6570\u636e");
        }
        Example example = new Example(ImportantIndustryCategory.class);
        example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("importantType", (Object)categoryType.getImportantType());
        Set already = this.dao.selectByExample(example).stream().filter(Objects::nonNull).map(ImportantIndustryCategory::getIndustryCategoryId).collect(Collectors.toSet());
        List collect = industryIds.stream().filter(item -> !already.contains(item)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return Collections.emptyList();
        }
        this.clearCache();
        ArrayList<ImportantIndustryCategory> list = new ArrayList<ImportantIndustryCategory>();
        for (Long industryCategoryId : collect) {
            ImportantIndustryCategory category = new ImportantIndustryCategory();
            category.setId(Long.valueOf(this.idworker.nextId()));
            category.setIndustryCategoryId(industryCategoryId);
            category.setImportantType(categoryType.getImportantType());
            category.setImportantTypeName(categoryType.getImportantTypeName());
            category.setState(Integer.valueOf(0));
            category.setCreateBy(operator);
            category.setUpdateBy(operator);
            category.setCreateDate(date);
            category.setUpdateDate(date);
            category.setIsValid(Boolean.valueOf(true));
            list.add(category);
        }
        this.dao.insertList2(list);
        return list;
    }

    @Transactional(readOnly=false)
    public List<ImportantIndustryCategoryFactory> addCategoryFactoryList(List<Long> factoryIds, Long categoryTypeId, Long operator) {
        if (CollectionUtils.isEmpty(factoryIds) || categoryTypeId == null) {
            throw new ServiceException("\u53c2\u6570\u4e3a\u7a7a");
        }
        Date date = new Date();
        ImportantIndustryCategoryType categoryType = (ImportantIndustryCategoryType)this.categoryTypeService.getById(categoryTypeId);
        if (categoryType == null) {
            throw new ServiceException("\u627e\u4e0d\u5230\u8be5\u91cd\u70b9\u884c\u4e1a\u7c7b\u578b\u6570\u636e");
        }
        Example example = new Example(ImportantIndustryCategoryFactory.class);
        example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("importantType", (Object)categoryType.getImportantType());
        Set already = this.categoryFactoryService.getListByExample(example).stream().filter(Objects::nonNull).map(ImportantIndustryCategoryFactory::getFactoryId).collect(Collectors.toSet());
        List collect = factoryIds.stream().filter(item -> !already.contains(item)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return Collections.emptyList();
        }
        this.clearCache();
        ArrayList<ImportantIndustryCategoryFactory> list = new ArrayList<ImportantIndustryCategoryFactory>();
        for (Long factoryId : collect) {
            ImportantIndustryCategoryFactory category = new ImportantIndustryCategoryFactory();
            category.setId(Long.valueOf(this.idworker.nextId()));
            category.setFactoryId(factoryId);
            category.setImportantType(categoryType.getImportantType());
            category.setState(Integer.valueOf(0));
            category.setCreateBy(operator);
            category.setUpdateBy(operator);
            category.setCreateDate(date);
            category.setUpdateDate(date);
            category.setIsValid(Boolean.valueOf(true));
            list.add(category);
        }
        this.categoryFactoryService.batchUpdateOrInsert(list, ImportantIndustryCategoryFactoryMapper.class, (item, mapper) -> mapper.insert(item));
        return list;
    }

    @Transactional(readOnly=false)
    public int updateCategoryState(List<Long> ids, Integer state, Long operator) {
        if (CollectionUtils.isEmpty(ids) || state == null) {
            throw new ServiceException("\u53c2\u6570\u4e3a\u7a7a");
        }
        this.clearCache();
        Example example = new Example(ImportantIndustryCategory.class);
        example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andNotEqualTo("state", (Object)state).andIn("id", ids);
        ImportantIndustryCategory category = new ImportantIndustryCategory();
        category.setState(state);
        category.setUpdateBy(operator);
        category.setUpdateDate(new Date());
        return this.dao.updateByExampleSelective(category, example);
    }

    @Transactional(readOnly=false)
    public int updateCategoryFactoryState(List<Long> ids, Integer state, Long operator) {
        this.clearCache();
        return this.categoryFactoryService.updateCategoryFactoryState(ids, state, operator);
    }

    @Transactional(readOnly=false)
    public int delCategory(List<Long> ids, Long operator) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new ServiceException("\u53c2\u6570\u4e3a\u7a7a");
        }
        Example example = new Example(ImportantIndustryCategory.class);
        example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("state", (Object)1).andIn("id", ids);
        int i = this.dao.selectCountByExample(example);
        if (i > 0) {
            throw new ServiceException("\u5b58\u5728\u542f\u7528\u72b6\u6001\u7684\u884c\u4e1a\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5");
        }
        this.clearCache();
        Example exampleUpdate = new Example(ImportantIndustryCategory.class);
        exampleUpdate.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("state", (Object)0).andIn("id", ids);
        ImportantIndustryCategory category = new ImportantIndustryCategory();
        category.setIsValid(Boolean.valueOf(false));
        category.setUpdateBy(operator);
        category.setUpdateDate(new Date());
        return this.dao.updateByExampleSelective(category, exampleUpdate);
    }

    @Transactional
    public int delCategoryType(List<Long> ids, Long operator) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new ServiceException("\u53c2\u6570\u4e3a\u7a7a");
        }
        Set<Integer> categoryType = this.haveDetailCategoryType();
        Set categoryFactory = this.categoryFactoryService.haveDetailCategoryFactory();
        List list = this.categoryTypeService.getListByIds(StringUtils.join(ids, (String)","));
        boolean isExit = list.stream().filter(Objects::nonNull).anyMatch(item -> categoryType.contains(item.getImportantType()));
        if (isExit) {
            throw new ServiceException("\u5b58\u5728\u91cd\u70b9\u884c\u4e1a\u7c7b\u578b\u6709\u6240\u5c5e\u884c\u4e1a\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        boolean isExit2 = list.stream().filter(Objects::nonNull).anyMatch(item -> categoryFactory.contains(item.getImportantType()));
        if (isExit2) {
            throw new ServiceException("\u5b58\u5728\u91cd\u70b9\u884c\u4e1a\u7c7b\u578b\u6709\u5371\u5bb3\u56e0\u7d20\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        this.clearCache();
        this.categoryTypeService.delCategoryType(ids, operator);
        return 0;
    }

    @Transactional(readOnly=false)
    public int delCategoryFactory(List<Long> ids, Long operator) {
        this.clearCache();
        return this.categoryFactoryService.delCategoryFactory(ids, operator);
    }

    public Set<Integer> haveDetailCategoryType() {
        Example example = new Example(ImportantIndustryCategory.class);
        example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE);
        return this.dao.selectByExample(example).stream().filter(Objects::nonNull).map(ImportantIndustryCategory::getImportantType).collect(Collectors.toSet());
    }

    @Transactional(readOnly=false)
    public void checkCategoryTypeMenu(String ids) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            throw new ServiceException("\u8bf7\u52fe\u9009\u81f3\u5c11\u4e00\u4e2a\u9009\u9879");
        }
        this.clearCache();
        Set select = Arrays.stream(ids.split(",")).filter(Objects::nonNull).map(Long::parseLong).collect(Collectors.toSet());
        this.categoryTypeService.checkCategoryTypeMenu(select);
    }

    @Transactional(readOnly=false)
    public int sortCategoryTypeMenu(List<ImportantIndustryCategoryType> categoryTypeList) {
        if (CollectionUtils.isEmpty(categoryTypeList)) {
            return 0;
        }
        this.clearCache();
        ArrayList<ImportantIndustryCategoryType> list = new ArrayList<ImportantIndustryCategoryType>();
        int categoryTypeListSize = categoryTypeList.size();
        for (int i = 0; i < categoryTypeListSize; ++i) {
            ImportantIndustryCategoryType categoryType = categoryTypeList.get(i);
            ImportantIndustryCategoryType newCategoryType = new ImportantIndustryCategoryType();
            newCategoryType.setId(categoryType.getId());
            newCategoryType.setMenuSort(Integer.valueOf(i));
            list.add(newCategoryType);
        }
        return this.categoryTypeService.batchUpdateOrInsert(list, ImportantIndustryCategoryTypeMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ComplianceScoreRefresh(Long id) {
        RLock lock = this.redissonClient.getLock(String.valueOf(id));
        if (lock.tryLock()) {
            try {
                this.scoreRefreshTask.refreshAllCompliance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                lock.unlock();
            }
        }
    }

    public Map<Integer, List<Long>> getCategoryTypeFactoryIdListByCache() {
        return (Map)this.redisClient.get("importantIndustryCategory", "getCategoryTypeFactoryIdListByCache", (long)cacheTimeOut.intValue(), () -> {
            Example example = new Example(ImportantIndustryCategoryFactory.class);
            example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("state", (Object)1);
            return this.categoryFactoryService.getListByExample(example).stream().filter(Objects::nonNull).collect(Collectors.groupingBy(ImportantIndustryCategoryFactory::getImportantType, Collectors.mapping(ImportantIndustryCategoryFactory::getFactoryId, Collectors.toList())));
        }, (TypeReference)new TypeReference<Map<Integer, List<Long>>>(){});
    }

    public PageInfo<ImportantIndustryCategory> listCategoryPage(JqGridParam jqGridParam, String keyWord) {
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List<ImportantIndustryCategory> importantIndustryCategories = this.dao.listCategoryState(keyWord);
        PageInfo data = new PageInfo(importantIndustryCategories);
        return data;
    }

    private void clearCache() {
        this.redisClient.delPrefix("importantIndustryCategory");
    }

    @Transactional
    public ResponseData<Boolean> updateIsCount(ImportantIndustryCategoryType categoryType) {
        int i = this.categoryTypeService.updateIsCount(categoryType);
        if (i == 0) {
            return ResponseData.fail((String)"\u66f4\u65b0\u6570\u91cf\u4e3a0");
        }
        return ResponseData.success((Object)true);
    }

    @Transactional
    public String updateSupervisionUnit(ImportantIndustryCategoryType categoryType) {
        int i = this.categoryTypeService.updateSupervisionUnit(categoryType);
        if (i > 0) {
            return "\u66f4\u65b0\u6210\u529f";
        }
        return "\u66f4\u65b0\u5931\u8d25";
    }
}

