/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.hccheckplan.impl;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.supervise.dao.hccheckplan.ThirdOrgHcCheckResultCollectMapper;
import cn.smarthse.modules.health.supervise.entity.hcchekplan.ThirdOrgHcCheckResultCollect;
import cn.smarthse.modules.health.supervise.service.hccheckplan.IThirdOrgHcCheckResultCollectDataService;
import cn.smarthse.modules.health.supervise.service.hccheckplan.IThirdOrgHcCheckResultCollectService;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ThirdOrgHcCheckResultCollectServiceImpl
extends BaseServiceImpl<ThirdOrgHcCheckResultCollectMapper, ThirdOrgHcCheckResultCollect>
implements IThirdOrgHcCheckResultCollectService {
    @Autowired
    private IThirdOrgHcCheckResultCollectDataService collectDataService;

    public List<ThirdOrgHcCheckResultCollect> getHcCheckResultCollectListByhcId(Long hcId, Long cid) {
        Example e = new Example(ThirdOrgHcCheckResultCollect.class);
        e.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("cid", (Object)cid).andEqualTo("hcId", (Object)hcId);
        e.orderBy("collectType");
        List list = ((ThirdOrgHcCheckResultCollectMapper)this.dao).selectByExample(e);
        HashMap<CallSite, ThirdOrgHcCheckResultCollect> map = new HashMap<CallSite, ThirdOrgHcCheckResultCollect>();
        String[] collectTypeStrs = new String[]{"1", "2", "4", "12", "10", "11", "9", "5", "7", "6", "8", "13", "3", "14", "15", "17", "16"};
        for (ThirdOrgHcCheckResultCollect h : list) {
            map.put((CallSite)((Object)("" + h.getCollectType())), h);
        }
        ArrayList<ThirdOrgHcCheckResultCollect> newList = new ArrayList<ThirdOrgHcCheckResultCollect>();
        for (String s : collectTypeStrs) {
            ThirdOrgHcCheckResultCollect h = (ThirdOrgHcCheckResultCollect)map.get(s);
            if (h == null) continue;
            newList.add(h);
        }
        return newList;
    }

    @Transactional(readOnly=false)
    public void addHcCheckResultCollectSubmit(Long hcId, String[] collectTypes, Long cid, Long loginStaffId) {
        Example e = new Example(ThirdOrgHcCheckResultCollect.class);
        ThirdOrgHcCheckResultCollect hrc = new ThirdOrgHcCheckResultCollect();
        hrc.setIsValid(Global.FALSE);
        e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("hcId", (Object)hcId);
        ((ThirdOrgHcCheckResultCollectMapper)this.dao).updateByExampleSelective(hrc, e);
        e = new Example(ThirdOrgHcCheckResultCollect.class);
        e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("hcId", (Object)hcId);
        List list = ((ThirdOrgHcCheckResultCollectMapper)this.dao).selectByExample(e);
        HashMap<CallSite, ThirdOrgHcCheckResultCollect> map = new HashMap<CallSite, ThirdOrgHcCheckResultCollect>();
        if (list != null && list.size() > 0) {
            for (ThirdOrgHcCheckResultCollect h : list) {
                map.put((CallSite)((Object)("" + h.getCollectType())), h);
            }
        }
        for (String s : collectTypes) {
            if (map.get(s) != null) {
                ((ThirdOrgHcCheckResultCollect)map.get(s)).setIsValid(Global.TRUE);
                this.update((ThirdOrgHcCheckResultCollect)map.get(s), loginStaffId);
                continue;
            }
            ThirdOrgHcCheckResultCollect h = new ThirdOrgHcCheckResultCollect();
            h.setIsValid(Global.TRUE);
            h.setCollectType(Byte.valueOf(s));
            h.setCid(cid);
            h.setHcId(hcId);
            this.add(h, loginStaffId, cid);
        }
    }

    @Transactional(readOnly=false)
    public ThirdOrgHcCheckResultCollect getHcCheckResultCollectByhcIdAndCollectType(Long hcId, Byte collectType, Long cid, Long loginStaffId) {
        Example e = new Example(ThirdOrgHcCheckResultCollect.class);
        e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("hcId", (Object)hcId).andEqualTo("collectType", (Object)collectType);
        List list = ((ThirdOrgHcCheckResultCollectMapper)this.dao).selectByExample(e);
        if (list != null && list.size() > 0) {
            if (!((ThirdOrgHcCheckResultCollect)list.get(0)).getIsValid().booleanValue()) {
                ((ThirdOrgHcCheckResultCollect)list.get(0)).setIsValid(Global.TRUE);
                this.updateByPrimaryKey((ThirdOrgHcCheckResultCollect)list.get(0), loginStaffId);
            }
            return (ThirdOrgHcCheckResultCollect)list.get(0);
        }
        ThirdOrgHcCheckResultCollect h = new ThirdOrgHcCheckResultCollect();
        h.setIsValid(Global.TRUE);
        h.setCollectType(collectType);
        h.setCid(cid);
        h.setHcId(hcId);
        this.add(h, loginStaffId, cid);
        return h;
    }

    public List<Long> getAllHcCheckPlanIdsByCollectTypes(String collectTypes, Long cid) {
        return ((ThirdOrgHcCheckResultCollectMapper)this.dao).getAllHcCheckPlanIdsByCollectTypes(collectTypes, cid);
    }

    @Transactional(readOnly=false)
    public void deleteNotValidAndNoResultCollectDataByCidAndHcId(Long cid, Long hcId) {
        if (cid == null || hcId == null) {
            return;
        }
        ((ThirdOrgHcCheckResultCollectMapper)this.dao).deleteNotValidAndNoResultCollectDataByCidAndHcId(cid, hcId);
    }

    @Transactional(readOnly=false)
    public void deleteNoResultCollectDataTypeByCidAndHcId(Long cid, Long hcId) {
        if (cid == null || hcId == null) {
            return;
        }
        ((ThirdOrgHcCheckResultCollectMapper)this.dao).deleteNoResultCollectDataTypeByCidAndHcId(cid, hcId);
    }

    public List<ThirdOrgHcCheckResultCollect> getNotGoodHcCheckResultCollectListByhcId(Long hcId, Long cid) {
        List<ThirdOrgHcCheckResultCollect> list = ((ThirdOrgHcCheckResultCollectMapper)this.dao).getNotGoodHcCheckResultCollectListByhcId(hcId, cid);
        HashMap<CallSite, ThirdOrgHcCheckResultCollect> map = new HashMap<CallSite, ThirdOrgHcCheckResultCollect>();
        String[] collectTypeStrs = new String[]{"1", "2", "4", "12", "10", "11", "9", "5", "7", "6", "8", "13", "3", "14", "15", "17", "16"};
        for (ThirdOrgHcCheckResultCollect h : list) {
            map.put((CallSite)((Object)("" + h.getCollectType())), h);
        }
        ArrayList<ThirdOrgHcCheckResultCollect> newList = new ArrayList<ThirdOrgHcCheckResultCollect>();
        for (String s : collectTypeStrs) {
            ThirdOrgHcCheckResultCollect h = (ThirdOrgHcCheckResultCollect)map.get(s);
            if (h == null) continue;
            newList.add(h);
        }
        return newList;
    }
}

