/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.hccheckplan.impl;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.supervise.dao.hccheckplan.HcCheckThirdOrgMapper;
import cn.smarthse.modules.health.supervise.entity.hcchekplan.HcCheckThirdOrg;
import cn.smarthse.modules.health.supervise.service.hccheckplan.IHcCheckThirdOrgService;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import java.util.Collections;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class HcCheckThirdOrgServiceImpl
extends BaseServiceImpl<HcCheckThirdOrgMapper, HcCheckThirdOrg>
implements IHcCheckThirdOrgService {
    @DubboReference
    ICheckPlanService checkPlanService;
    @Autowired
    private RedissonClient redissonClient;

    @Transactional(readOnly=false, rollbackFor={Exception.class})
    public void addOrUpdateById(HcCheckThirdOrg org) {
        Example example = new Example(HcCheckThirdOrg.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("thirdOrgId", (Object)org.getThirdOrgId());
        List list = ((HcCheckThirdOrgMapper)this.dao).selectByExample(example);
        if (list == null || list.size() == 0) {
            this.add(org);
        } else {
            org.setId(((HcCheckThirdOrg)list.get(0)).getId());
            this.update(org);
        }
    }

    @Transactional(readOnly=false, rollbackFor={Exception.class})
    public void deleteThisByOrgId(Long orgId) {
        Example example = new Example(HcCheckThirdOrg.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("thirdOrgId", (Object)orgId);
        List list = ((HcCheckThirdOrgMapper)this.dao).selectByExample(example);
        if (list != null && list.size() > 0) {
            HcCheckThirdOrg org = new HcCheckThirdOrg();
            org.setId(((HcCheckThirdOrg)list.get(0)).getId());
            this.delete(org, 0L);
        }
    }

    @Transactional(readOnly=false, rollbackFor={Exception.class})
    public void deleteThisByOrgIds(List<Long> orgIds) {
        if (orgIds == null || orgIds.isEmpty()) {
            return;
        }
        ((HcCheckThirdOrgMapper)this.dao).deleteThisByOrgIds(orgIds);
    }

    @Transactional(readOnly=false, rollbackFor={Exception.class})
    public void recoverByOrgId(Long orgId) {
        ((HcCheckThirdOrgMapper)this.dao).recoverByOrgId(orgId);
    }

    public HcCheckThirdOrg getThisByOrgId(Long orgId) {
        Example example = new Example(HcCheckThirdOrg.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("thirdOrgId", (Object)orgId);
        List list = ((HcCheckThirdOrgMapper)this.dao).selectByExample(example);
        if (list != null && list.size() > 0) {
            return (HcCheckThirdOrg)list.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public Integer autoUpdateAndAddCheckPlanFromWandaCheck(Long sourceId, Integer type) {
        if (sourceId == null) {
            return 0;
        }
        RLock lock = this.redissonClient.getLock("checkPlan:IHcCheckThirdOrgService:" + sourceId);
        if (lock.tryLock()) {
            try {
                this.checkPlanService.autoAddCheckPlanFromWandaCheck(Collections.singletonList(sourceId));
                this.checkPlanService.autoUpdateCheckPlanFromWandaCheck(Collections.singletonList(sourceId));
                this.checkPlanService.inspectionAndReturnWanda(Collections.singletonList(sourceId));
                Integer n = 1;
                return n;
            }
            finally {
                lock.unlock();
            }
        }
        this.logger.error("\u672a\u83b7\u5f97\u9501\u8d44\u6e90checkPlan:IHcCheckThirdOrgService: id:{}", (Object)sourceId);
        return 0;
    }
}

