/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.hccheckplan.impl;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckPlan;
import cn.smarthse.modules.health.service.work.hccheckplan.IHcCheckPlanService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.supervise.dao.hccheckplan.HcCheckThirdOrgPlanMapper;
import cn.smarthse.modules.health.supervise.dao.hccheckplan.ThirdOrgHcCheckTypeMapper;
import cn.smarthse.modules.health.supervise.entity.hcchekplan.HcCheckThirdOrg;
import cn.smarthse.modules.health.supervise.entity.hcchekplan.HcCheckThirdOrgPlan;
import cn.smarthse.modules.health.supervise.entity.hcchekplan.ThirdOrgHcCheckType;
import cn.smarthse.modules.health.supervise.entity.operate.WorkOperateLog;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogEnum;
import cn.smarthse.modules.health.supervise.enums.hccheckplan.CheckDataSourceEnum;
import cn.smarthse.modules.health.supervise.service.hccheckplan.IHcCheckThirdOrgPlanService;
import cn.smarthse.modules.health.supervise.service.hccheckplan.IHcCheckThirdOrgService;
import cn.smarthse.modules.health.supervise.service.hccheckplan.IThirdOrgHcCheckResultCollectDataService;
import cn.smarthse.modules.health.supervise.service.hccheckplan.IThirdOrgHcCheckResultCollectService;
import cn.smarthse.modules.health.supervise.service.operate.IWorkOperateLogService;
import cn.smarthse.modules.health.supervise.utils.hccheckplan.EditDataUtil;
import cn.smarthse.modules.health.supervise.vo.hccheckplan.HcCheckThirdOrgPlanVo;
import cn.smarthse.modules.health.supervise.vo.hccheckplan.HcCheckThirdOrgQueryVo;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.services.hfi.api.pojo.vo.CheckOverPointVo;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.ICheckResultService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class HcCheckThirdOrgPlanServiceImpl
extends BaseServiceImpl<HcCheckThirdOrgPlanMapper, HcCheckThirdOrgPlan>
implements IHcCheckThirdOrgPlanService {
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService companyProvideByHSEService;
    @Autowired
    ThirdOrgHcCheckTypeMapper hcCheckTypeMapper;
    @DubboReference(version="1.0.0")
    ISysAreaProvideService sysAreaProvideService;
    @DubboReference
    IHcCheckPlanService hcCheckPlanService;
    @Autowired
    IThirdOrgHcCheckResultCollectDataService thirdOrgHcCheckResultCollectDataService;
    @Autowired
    IHcCheckThirdOrgService hcCheckThirdOrgService;
    @Autowired
    IThirdOrgHcCheckResultCollectService thirdOrgHcCheckResultCollectService;
    @DubboReference
    private ICheckPlanService checkPlanService;
    @DubboReference
    private IReformItemBasicService reformItemBasicService;
    @Autowired
    private IWorkOperateLogService workOperateLogService;
    @DubboReference
    private ICheckResultService checkResultService;

    @Transactional(readOnly=false)
    public HcCheckThirdOrgPlan getNotValidHcCheckThirdOrgPlan(Long cid, Long createBy, CheckDataSourceEnum source) {
        HcCheckThirdOrgPlan hc = new HcCheckThirdOrgPlan();
        hc.setIsValid(Boolean.valueOf(false));
        hc.setCid(cid);
        hc.setCheckDataSource(source.getNameCode());
        hc.setCheckPlanType(Byte.valueOf((byte)0));
        hc.setProjAppearStatus(Byte.valueOf((byte)1));
        hc.setStatus(Byte.valueOf((byte)0));
        hc.setCheckServiceType(Byte.valueOf((byte)0));
        hc.setCreateBy(createBy);
        hc.setUpdateBy(createBy);
        hc.setCreateDate(new Date());
        hc.setUpdateDate(new Date());
        ((HcCheckThirdOrgPlanMapper)this.dao).insertSelective(hc);
        return hc;
    }

    public PageInfo<HcCheckThirdOrgPlanVo> getHcCheckThirdOrgPlansPageBySearch(JqGridParam jParam, HcCheckThirdOrgQueryVo searchVo) {
        if (searchVo.getAreaId() == null) {
            searchVo.setAreaId("330000000000");
        }
        AreaModel area = null;
        if (searchVo.getAreaId() != null && !"0".equals(searchVo.getAreaId())) {
            area = this.sysAreaProvideService.getAreaById(Long.valueOf(searchVo.getAreaId()));
        }
        if (area != null) {
            searchVo.setAreaLevel(area.getLevel());
        }
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        Page list = (Page)this.getHcCheckThirdOrgPlansBySearch(searchVo);
        ArrayList<HcCheckThirdOrgPlanVo> finalList = new ArrayList<HcCheckThirdOrgPlanVo>();
        for (HcCheckThirdOrgPlan hc : list) {
            HcCheckThirdOrgPlanVo vo = new HcCheckThirdOrgPlanVo();
            vo.setHc(hc);
            HcCheckThirdOrgPlanVo statVo = this.getCheckPointStatByHcIdAndCid(hc.getId(), hc.getCid());
            vo.setNotStandardPointCount(statVo.getNotStandardPointCount());
            vo.setCheckPointCount(statVo.getCheckPointCount());
            vo.setQualifiedPointCount(statVo.getQualifiedPointCount());
            vo.setNotStandardRate(statVo.getNotStandardRate());
            vo.setIsBack(this.workOperateLogService.isBack(hc.getId(), WorkOperateLogEnum.hcCheck.getTypeVal()));
            if (hc.getGiveReportTime() != null) {
                vo.setGiveReportTimeStr(hc.getGiveReportTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
            finalList.add(vo);
        }
        PageInfo finalPageInfo = new PageInfo(finalList);
        finalPageInfo.setPageNum(list.getPageNum());
        finalPageInfo.setPages(list.getPages());
        finalPageInfo.setPageSize(list.getPageSize());
        finalPageInfo.setTotal(list.getTotal());
        return finalPageInfo;
    }

    public List<HcCheckThirdOrgPlan> getHcCheckThirdOrgPlansBySearch(HcCheckThirdOrgQueryVo searchVo) {
        List<HcCheckThirdOrgPlan> list = ((HcCheckThirdOrgPlanMapper)this.dao).getHcCheckThirdOrgPlansBySearch(searchVo);
        for (HcCheckThirdOrgPlan hc : list) {
            HcCheckThirdOrg org;
            AreaModel area;
            ThirdOrgHcCheckType type;
            if (hc.getCheckType() != null && (type = this.getHcCheckTypeById(hc.getCheckType())) != null) {
                hc.setHcCheckTypeName(type.getCheckTypeName());
            }
            if (hc.getProjAreaId() != null && (area = this.sysAreaProvideService.getAreaById(hc.getProjAreaId())) != null) {
                hc.setProjAreaName(area.getFullname() + hc.getProjAreaDetail());
            }
            hc.setOverproofCount(((HcCheckThirdOrgPlanMapper)this.dao).getNotStandardPointCountByHcId(hc.getId()));
            if (hc.getThirdPartyOrCheckOrgId() != null && (org = this.hcCheckThirdOrgService.getThisByOrgId(hc.getThirdPartyOrCheckOrgId())) != null) {
                hc.setThirdOrgName(org.getThirdOrgName());
            }
            if (hc.getCheckTimeBegin() != null && hc.getCheckTimeEnd() != null) {
                hc.setCheckTime(hc.getCheckTimeBegin().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + "\u81f3" + hc.getCheckTimeEnd().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
            if (hc.getOrgReportTime() != null) {
                hc.setReportTime(hc.getOrgReportTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
            if (hc.getCid() == null) continue;
            hc.setCompanyName(this.companyProvideByHSEService.getCompanyNameById(hc.getCid()));
        }
        return list;
    }

    public List<HcCheckThirdOrgPlanVo> exportHcCheckThirdOrgPlansBySearch(HcCheckThirdOrgQueryVo searchVo) {
        ArrayList<HcCheckThirdOrgPlanVo> finalList = new ArrayList<HcCheckThirdOrgPlanVo>();
        if (searchVo.getAreaId() == null) {
            searchVo.setAreaId("330000000000");
        }
        AreaModel area = null;
        if (searchVo.getAreaId() != null && !"0".equals(searchVo.getAreaId())) {
            area = this.sysAreaProvideService.getAreaById(Long.valueOf(searchVo.getAreaId()));
        }
        if (area != null) {
            searchVo.setAreaLevel(area.getLevel());
        }
        List<HcCheckThirdOrgPlan> list = this.getHcCheckThirdOrgPlansBySearch(searchVo);
        for (HcCheckThirdOrgPlan hc : list) {
            HcCheckThirdOrgPlanVo vo = new HcCheckThirdOrgPlanVo();
            finalList.add(vo);
            vo.setThirdOrgName(hc.getThirdOrgName());
            vo.setCompanyName(hc.getCompanyName());
            vo.setLinkMan(hc.getLinkMan());
            vo.setLinkTel(hc.getLinkTel());
            vo.setNotStandardPointCount(hc.getOverproofCount());
            vo.setCheckPointCount(((HcCheckThirdOrgPlanMapper)this.dao).getCheckPointCountByHcId(hc.getId()));
            vo.setQualifiedPointCount(((HcCheckThirdOrgPlanMapper)this.dao).getQualifiedPointCountByHcId(hc.getId()));
            if (vo.getCheckPointCount() != null && vo.getCheckPointCount() != 0) {
                if (vo.getNotStandardPointCount() != null && vo.getNotStandardPointCount() == 0) {
                    vo.setNotStandardRate("0.00%");
                } else {
                    vo.setNotStandardRate(new BigDecimal((double)vo.getNotStandardPointCount().intValue() * 100.0 / (double)vo.getCheckPointCount().intValue()).setScale(2, 4).doubleValue() + "%");
                }
            } else {
                vo.setNotStandardRate("0.00%");
            }
            if (hc.getGiveReportTime() != null) {
                vo.setGiveReportTimeStr(hc.getGiveReportTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
            vo.setReportTime(hc.getReportTime());
            vo.setProjAppearName(hc.getProjAppearName());
        }
        return finalList;
    }

    @Transactional(readOnly=false)
    public HcCheckThirdOrgPlan updateHcCheckThirdOrgPlanSumbit(HcCheckThirdOrgPlan hcCheckThirdOrgPlan, Long loginBy, String userName, String companyName) {
        HcCheckPlan db = (HcCheckPlan)EditDataUtil.copy((Object)hcCheckThirdOrgPlan, (Object)new HcCheckPlan());
        if (db.getId() != null) {
            db.setIsValid(Boolean.valueOf(true));
            if (db.getProjAppearStatus() != null && db.getProjAppearStatus() == 2) {
                db.setOrgReportTime(new Date());
                this.workOperateLogService.report(db.getId(), WorkOperateLogEnum.hcCheck.getTypeVal(), loginBy, userName, companyName);
            }
            this.hcCheckPlanService.updateHcCheckThirdOrgPlanSumbit(db, loginBy);
        }
        this.thirdOrgHcCheckResultCollectService.deleteNotValidAndNoResultCollectDataByCidAndHcId(hcCheckThirdOrgPlan.getCid(), hcCheckThirdOrgPlan.getId());
        this.thirdOrgHcCheckResultCollectService.deleteNoResultCollectDataTypeByCidAndHcId(hcCheckThirdOrgPlan.getCid(), hcCheckThirdOrgPlan.getId());
        return hcCheckThirdOrgPlan;
    }

    @Transactional(readOnly=false)
    public HcCheckPlan updateHcCheckThirdOrgPlanToHealthSumbit(HcCheckPlan hcCheckThirdOrgPlan, Long loginBy) {
        return this.hcCheckPlanService.updateHcCheckThirdOrgPlanSumbit(hcCheckThirdOrgPlan, loginBy);
    }

    @Transactional(readOnly=false)
    public Integer deleteHcCheckThirdOrgPlanById(Long id, Long loginBy) {
        if (id == null) {
            return null;
        }
        HcCheckThirdOrgPlan hc = new HcCheckThirdOrgPlan();
        hc.setId(id);
        this.delete(hc, loginBy);
        return 1;
    }

    public HcCheckThirdOrgPlan getHcCheckThirdOrgPlanById(Long id) {
        HcCheckThirdOrg org;
        AreaModel area;
        ThirdOrgHcCheckType type;
        HcCheckThirdOrgPlan hc = (HcCheckThirdOrgPlan)this.getById(id);
        if (hc == null) {
            return null;
        }
        if (hc.getCid() != null) {
            hc.setCompanyName(this.companyProvideByHSEService.getCompanyNameById(hc.getCid()));
        }
        if (hc.getCheckType() != null && (type = this.getHcCheckTypeById(hc.getCheckType())) != null) {
            hc.setHcCheckTypeName(type.getCheckTypeName());
        }
        if (hc.getProjAreaId() != null && (area = this.sysAreaProvideService.getAreaById(hc.getProjAreaId())) != null) {
            hc.setProjAreaName(area.getFullname() + hc.getProjAreaDetail());
        }
        if (hc.getThirdPartyOrCheckOrgId() != null && (org = this.hcCheckThirdOrgService.getThisByOrgId(hc.getThirdPartyOrCheckOrgId())) != null) {
            hc.setThirdOrgName(org.getThirdOrgName());
        }
        if (hc.getCheckTimeBegin() != null && hc.getCheckTimeEnd() != null) {
            hc.setCheckTime(hc.getCheckTimeBegin().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + "\u81f3" + hc.getCheckTimeEnd().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        }
        if (hc.getOrgReportTime() != null) {
            hc.setReportTime(hc.getOrgReportTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        }
        if (hc.getCid() != null) {
            hc.setCompanyName(this.companyProvideByHSEService.getCompanyNameById(hc.getCid()));
        }
        return hc;
    }

    public List<ThirdOrgHcCheckType> getHcCheckTypeListByCid(Long cid) {
        return this.hcCheckTypeMapper.getHcCheckTypeListByCid(cid);
    }

    public ThirdOrgHcCheckType getHcCheckTypeById(Long id) {
        return (ThirdOrgHcCheckType)this.hcCheckTypeMapper.selectByPrimaryKey(id);
    }

    public HcCheckThirdOrgPlan getHcCheckThirdOrgPlanByEvaluateId(Long evaluateId) {
        if (evaluateId == null) {
            return null;
        }
        Example e = new Example(HcCheckThirdOrgPlan.class);
        e.createCriteria().andEqualTo("evaluateId", (Object)evaluateId);
        e.or().andEqualTo("relatedJobEvaluationId", (Object)evaluateId);
        List list = ((HcCheckThirdOrgPlanMapper)this.dao).selectByExample(e);
        if (list != null && list.size() > 0) {
            HcCheckThirdOrg org;
            AreaModel area;
            ThirdOrgHcCheckType type;
            HcCheckThirdOrgPlan hc = (HcCheckThirdOrgPlan)list.get(0);
            if (hc.getCid() != null) {
                hc.setCompanyName(this.companyProvideByHSEService.getCompanyNameById(hc.getCid()));
            }
            if (hc.getCheckType() != null && (type = this.getHcCheckTypeById(hc.getCheckType())) != null) {
                hc.setHcCheckTypeName(type.getCheckTypeName());
            }
            if (hc.getProjAreaId() != null && (area = this.sysAreaProvideService.getAreaById(hc.getProjAreaId())) != null) {
                hc.setProjAreaName(area.getFullname() + hc.getProjAreaDetail());
            }
            if (hc.getCheckTimeBegin() != null && hc.getCheckTimeEnd() != null) {
                hc.setCheckTime(hc.getCheckTimeBegin().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + "\u81f3" + hc.getCheckTimeEnd().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
            if (hc.getThirdPartyOrCheckOrgId() != null && (org = this.hcCheckThirdOrgService.getThisByOrgId(hc.getThirdPartyOrCheckOrgId())) != null) {
                hc.setThirdOrgName(org.getThirdOrgName());
            }
            return hc;
        }
        return null;
    }

    public Integer getCheckPointCountByHcId(Long hcId) {
        return ((HcCheckThirdOrgPlanMapper)this.dao).getCheckPointCountByHcId(hcId);
    }

    public Integer getQualifiedPointCountByHcId(Long hcId) {
        return ((HcCheckThirdOrgPlanMapper)this.dao).getQualifiedPointCountByHcId(hcId);
    }

    public Integer getNotStandardPointCountByHcId(Long hcId) {
        return ((HcCheckThirdOrgPlanMapper)this.dao).getNotStandardPointCountByHcId(hcId);
    }

    public HcCheckThirdOrgPlanVo getCheckPointStatByHcId(Long hcId) {
        HcCheckThirdOrgPlanVo vo = new HcCheckThirdOrgPlanVo();
        vo.setNotStandardPointCount(((HcCheckThirdOrgPlanMapper)this.dao).getNotStandardPointCountByHcId(hcId));
        vo.setCheckPointCount(((HcCheckThirdOrgPlanMapper)this.dao).getCheckPointCountByHcId(hcId));
        vo.setQualifiedPointCount(((HcCheckThirdOrgPlanMapper)this.dao).getQualifiedPointCountByHcId(hcId));
        if (vo.getCheckPointCount() != null && vo.getCheckPointCount() != 0) {
            if (vo.getNotStandardPointCount() != null && vo.getNotStandardPointCount() == 0) {
                vo.setNotStandardRate("0.00%");
            } else {
                vo.setNotStandardRate(new BigDecimal((double)vo.getNotStandardPointCount().intValue() * 100.0 / (double)vo.getCheckPointCount().intValue()).setScale(2, 4).doubleValue() + "%");
            }
        } else {
            vo.setNotStandardRate("0.00%");
        }
        return vo;
    }

    public Integer getNotStandardPointCountByCidAndYear(Long cid, Integer year) {
        return ((HcCheckThirdOrgPlanMapper)this.dao).getNotStandardPointCountByCidAndYear(cid, year);
    }

    public Integer getReportedHcCheckCountBySearch(HcCheckThirdOrgQueryVo searchVo) {
        return ((HcCheckThirdOrgPlanMapper)this.dao).getReportedHcCheckCountV1620BySearch(searchVo);
    }

    public HcCheckThirdOrgPlanVo getCheckPointStatByHcIdAndCid(Long hcId, Long cid) {
        if (hcId == null || cid == null) {
            return null;
        }
        HcCheckThirdOrgPlanVo vo = ((HcCheckThirdOrgPlanMapper)this.dao).getCheckPointStatByHcIdAndCid(hcId, cid);
        if (vo != null) {
            if (vo.getCheckPointCount() != null && vo.getCheckPointCount() != 0) {
                if (vo.getNotStandardPointCount() == null) {
                    vo.setNotStandardPointCount(Integer.valueOf(0));
                }
                if (vo.getNotStandardPointCount() == 0) {
                    vo.setNotStandardRate("0.00%");
                } else {
                    vo.setNotStandardRate(new BigDecimal((double)vo.getNotStandardPointCount().intValue() * 100.0 / (double)vo.getCheckPointCount().intValue()).setScale(2, 4).doubleValue() + "%");
                }
            } else {
                vo.setNotStandardRate("0.00%");
            }
        }
        return vo;
    }

    public List<HcCheckThirdOrgPlanVo> getHcCheckThirdOrgPlansV1620BySearch(HcCheckThirdOrgQueryVo searchVo) {
        List<HcCheckThirdOrgPlanVo> list = ((HcCheckThirdOrgPlanMapper)this.dao).getHcCheckThirdOrgPlansV1620BySearch(searchVo);
        for (HcCheckThirdOrgPlanVo vo : list) {
            if (vo.getNotStandardPointCount() == null || vo.getCheckPointCount() == null || vo.getNotStandardPointCount() == 0 || vo.getCheckPointCount() == 0) {
                vo.setNotStandardRate("0.00%");
                vo.setNotStandardPointCount(Integer.valueOf(vo.getNotStandardPointCount() == null ? 0 : vo.getNotStandardPointCount()));
                vo.setCheckPointCount(Integer.valueOf(vo.getCheckPointCount() == null ? 0 : vo.getCheckPointCount()));
                vo.setQualifiedPointCount(Integer.valueOf(vo.getQualifiedPointCount() == null ? 0 : vo.getQualifiedPointCount()));
            } else {
                vo.setNotStandardRate(new BigDecimal((double)vo.getNotStandardPointCount().intValue() * 100.0 / (double)vo.getCheckPointCount().intValue()).setScale(2, 4).doubleValue() + "%");
            }
            if (vo.getGiveReportTime() == null) continue;
            vo.setGiveReportTimeStr(vo.getGiveReportTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        }
        return list;
    }

    public PageInfo<HcCheckThirdOrgPlanVo> getHcCheckThirdOrgPlansPageV1620BySearch(JqGridParam jParam, HcCheckThirdOrgQueryVo searchVo) {
        AreaModel area = null;
        if (searchVo.getAreaId() != null && !"0".equals(searchVo.getAreaId())) {
            area = this.sysAreaProvideService.getAreaById(Long.valueOf(searchVo.getAreaId()));
        }
        if (area != null) {
            searchVo.setAreaLevel(area.getLevel());
        }
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        Page list = (Page)((HcCheckThirdOrgPlanMapper)this.dao).getHcCheckThirdOrgPlansV1620BySearch(searchVo);
        for (HcCheckThirdOrgPlanVo vo : list) {
            if (vo.getNotStandardPointCount() == null || vo.getCheckPointCount() == null || vo.getNotStandardPointCount() == 0 || vo.getCheckPointCount() == 0) {
                vo.setNotStandardRate("0.00%");
                vo.setNotStandardPointCount(Integer.valueOf(vo.getNotStandardPointCount() == null ? 0 : vo.getNotStandardPointCount()));
                vo.setCheckPointCount(Integer.valueOf(vo.getCheckPointCount() == null ? 0 : vo.getCheckPointCount()));
                vo.setQualifiedPointCount(Integer.valueOf(vo.getQualifiedPointCount() == null ? 0 : vo.getQualifiedPointCount()));
            } else {
                vo.setNotStandardRate(new BigDecimal((double)vo.getNotStandardPointCount().intValue() * 100.0 / (double)vo.getCheckPointCount().intValue()).setScale(2, 4).doubleValue() + "%");
            }
            if (vo.getGiveReportTime() == null) continue;
            vo.setGiveReportTimeStr(vo.getGiveReportTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        }
        return new PageInfo((List)list);
    }

    @Transactional(readOnly=false)
    public void backToThirdOrg(WorkOperateLog log) {
        if (log == null || log.getWorkId() == null) {
            return;
        }
        this.workOperateLogService.back(log.getWorkId(), log.getWorkModule(), log.getReason(), log.getCreateBy(), log.getOperater(), log.getCompanyName());
        this.checkPlanService.reback(log.getWorkId(), log.getCreateBy());
        List checkOverPointVos = this.checkResultService.queryCheckOverPointVo(log.getId());
        for (CheckOverPointVo vo : checkOverPointVos) {
            this.reformItemBasicService.deleteReformInfoBySourceId(vo.getResultId());
        }
    }
}

