/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.hccheckplan.impl;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.supervise.dao.hccheckplan.HcCheckCompMapper;
import cn.smarthse.modules.health.supervise.entity.hcchekplan.HcCheckChemicalStat;
import cn.smarthse.modules.health.supervise.entity.hcchekplan.HcCheckComp;
import cn.smarthse.modules.health.supervise.entity.hcchekplan.HcCheckDustStat;
import cn.smarthse.modules.health.supervise.entity.hcchekplan.HcCheckInfoStat;
import cn.smarthse.modules.health.supervise.entity.hcchekplan.HcCheckNoiseStat;
import cn.smarthse.modules.health.supervise.service.hccheckplan.IHcCheckAreaThirdStatService;
import cn.smarthse.modules.health.supervise.service.hccheckplan.IHcCheckPlanCompService;
import cn.smarthse.modules.health.supervise.service.hccheckplan.IHcCheckThirdOrgPlanService;
import cn.smarthse.modules.health.supervise.service.hccheckplan.IHcCheckThirdOrgService;
import cn.smarthse.modules.health.supervise.service.occriskfactor.IOccupationalRiskFactorsService;
import cn.smarthse.modules.health.supervise.service.reform.IReformService;
import cn.smarthse.modules.health.supervise.service.sys.ISysAreaService;
import cn.smarthse.modules.health.supervise.vo.hccheckplan.CompanyQueryData;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class HcCheckPlanCompServiceImpl
implements IHcCheckPlanCompService {
    @Autowired
    ISysAreaService sysAreaService;
    @Autowired
    IOccupationalRiskFactorsService occupationalRiskFactorsService;
    @Autowired
    IReformService reformService;
    @Autowired
    HcCheckCompMapper hcCheckCompMapper;
    @Autowired
    IHcCheckThirdOrgPlanService hcCheckThirdOrgPlanService;
    @Autowired
    IHcCheckAreaThirdStatService hcCheckAreaThirdStatService;
    @Autowired
    IHcCheckThirdOrgService hcCheckThirdOrgService;

    public List<HcCheckComp> getHcCheckCompsMoreThanOneYearByCids(List<Long> cids) {
        List<HcCheckComp> list = this.hcCheckCompMapper.getHcCheckCompsMoreThanOneYearByCids(cids);
        return list;
    }

    public PageInfo<HcCheckComp> getHcCheckCompsMoreThanOneYearPageInfoByCids(JqGridParam jParam, List<Long> cids) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        return new PageInfo(this.getHcCheckCompsMoreThanOneYearByCids(cids));
    }

    public List<HcCheckComp> getHcCheckCompsLessThanThreeMonthsByCids(List<Long> cids, Integer month) {
        List<HcCheckComp> list = this.hcCheckCompMapper.getHcCheckCompsLessThanThreeMonthsByCids(cids, month);
        return list;
    }

    public PageInfo<HcCheckComp> getHcCheckCompsLessThanThreeMonthsPageInfoByCids(JqGridParam jParam, List<Long> cids, Integer month) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        return new PageInfo(this.getHcCheckCompsLessThanThreeMonthsByCids(cids, month));
    }

    public List<HcCheckInfoStat> getNewHcCheckInfoStatsByCid(Long cid) {
        List<HcCheckInfoStat> list = this.hcCheckCompMapper.getNewHcCheckInfoStatsByCid(cid);
        return list;
    }

    public Integer getAllCountResultDataByHcId(Long cid, Long hcId) {
        return this.hcCheckCompMapper.getAllCountResultDataByHcId(cid, hcId);
    }

    public Integer getHcCheckPlanRegularCountByCids(List<Long> cids) {
        return this.hcCheckCompMapper.getHcCheckPlanRegularCountByCids(cids);
    }

    public Integer getHcCheckPlanNoAccordCountByYearAndCid(String year, Long cid) {
        return this.hcCheckCompMapper.getHcCheckPlanNoAccordCountByYearAndCid(year, cid);
    }

    public Integer getHcCheckPlanCompletedCountByYear(String year, Long cid) {
        return this.hcCheckCompMapper.getHcCheckPlanCompletedCountByYear(year, cid);
    }

    public List<HcCheckComp> getNeverHcCheckCompsByCids(List<CompanyQueryData> query, List<Long> cids) {
        return this.hcCheckCompMapper.getNeverHcCheckCompsByCids(query, cids);
    }

    public PageInfo<HcCheckComp> getNeverHcCheckCompsPageInfoByCids(JqGridParam jParam, List<CompanyQueryData> query, List<Long> cids) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        return new PageInfo(this.getNeverHcCheckCompsByCids(query, cids));
    }

    public List<HcCheckComp> getAlreadyHcChecked() {
        return this.hcCheckCompMapper.getAlreadyHcChecked();
    }

    public List<Long> getReformIdsByHcIds(List<Long> hcIds) {
        return this.hcCheckCompMapper.getReformIdsByHcIds(hcIds);
    }

    public Map<String, List<HcCheckDustStat>> getHcCheckDustStatMap() {
        HashMap<String, List<HcCheckDustStat>> map = new HashMap<String, List<HcCheckDustStat>>();
        map.put("sum", this.hcCheckCompMapper.getHcCheckDustStatSum());
        map.put("total", this.hcCheckCompMapper.getHcCheckDustStatRespirabel());
        map.put("respirabel", this.hcCheckCompMapper.getHcCheckDustStatRespirabel());
        return map;
    }

    public Map<String, List<HcCheckChemicalStat>> getHcChecktChemicalStatMap() {
        HashMap<String, List<HcCheckChemicalStat>> map = new HashMap<String, List<HcCheckChemicalStat>>();
        map.put("cmac", this.hcCheckCompMapper.getHcCheckChemicalStatCmac());
        map.put("cstel", this.hcCheckCompMapper.getHcCheckChemicalStatCstel());
        map.put("ctwa", this.hcCheckCompMapper.getHcCheckChemicalStatCtwa());
        map.put("sum", this.hcCheckCompMapper.getHcCheckChemicalStatSum());
        return map;
    }

    public PageInfo<HcCheckDustStat> getHcCheckDustStatPageInfoByCidsAndHarmIds(JqGridParam jParam, String areaCode, Byte level, String searchKey, Boolean isFilter, Byte flag) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        return new PageInfo(this.getHcCheckDustStatByCidsAndHarmIds(areaCode, level, searchKey, isFilter, flag));
    }

    public List<HcCheckDustStat> getHcCheckDustStatByCidsAndHarmIds(String areaCode, Byte level, String searchKey, Boolean isFilter, Byte flag) {
        List<HcCheckDustStat> result = this.hcCheckCompMapper.getHcCheckDustStatByareaCodeAndHarmIds(areaCode, level, searchKey, isFilter, flag);
        return result;
    }

    public PageInfo<HcCheckChemicalStat> getHcCheckChemicalStatPageInfoByAreaCodeAndHarmIds(JqGridParam jParam, String areaCode, Byte level, String searchKey, Boolean isFilter, Byte flag) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        List<HcCheckChemicalStat> idList = this.getHcCheckChemicalStatByAreaCodeAndHarmIds(areaCode, level, searchKey, isFilter, flag);
        return new PageInfo(idList);
    }

    public List<HcCheckChemicalStat> getHcCheckChemicalStatByAreaCodeAndHarmIds(String areaCode, Byte level, String searchKey, Boolean isFilter, Byte flag) {
        List<HcCheckChemicalStat> result = this.hcCheckCompMapper.getHcCheckChemicalStatByAreaCodeAndHarmIds(areaCode, level, searchKey, isFilter, flag);
        return result;
    }

    public PageInfo<HcCheckNoiseStat> getHcCheckNoiseStatPageInfoByAreaCodeAndHarmIds(JqGridParam jParam, String areaCode, Byte level, Boolean isFilter, Byte flag) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        return new PageInfo(this.getHcCheckNoiseStatByAreaCode(areaCode, level, isFilter, flag));
    }

    public List<HcCheckNoiseStat> getHcCheckNoiseStatByAreaCode(String areaCode, Byte level, Boolean isFilter, Byte flag) {
        List<HcCheckNoiseStat> result = this.hcCheckCompMapper.getHcCheckNoiseStatByAreaCode(areaCode, level, isFilter, flag);
        return result;
    }

    public HcCheckDustStat getTotalDustByAreaCode(String areaCode, Byte level, String searchKey, Byte flag) {
        return this.hcCheckCompMapper.getTotalDustByAreaCode(areaCode, level, searchKey, flag);
    }

    public HcCheckChemicalStat getTotalChemicalByAreaCode(String areaCode, Byte level, String searchKey, Byte flag) {
        return this.hcCheckCompMapper.getTotalChemicalByAreaCode(areaCode, level, searchKey, flag);
    }
}

