/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.hccheckplan.impl;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.datacentre.model.system.riskFactors.FactorAttr;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.supervise.constants.CheckDiffValidateConstantsData;
import cn.smarthse.modules.health.supervise.dao.hccheckplan.HcCheckAreaThirdStatMapper;
import cn.smarthse.modules.health.supervise.entity.hcchekplan.HcCheckScaleNum;
import cn.smarthse.modules.health.supervise.entity.hcchekplan.HcCheckThirdStat;
import cn.smarthse.modules.health.supervise.entity.hcchekplan.ThresholdValues;
import cn.smarthse.modules.health.supervise.entity.warning.CompanyHarms;
import cn.smarthse.modules.health.supervise.enums.ThirdHarmTypeEnum;
import cn.smarthse.modules.health.supervise.service.company.IThirdCompanyService;
import cn.smarthse.modules.health.supervise.service.hccheckplan.IHcCheckAreaThirdStatService;
import cn.smarthse.modules.health.supervise.vo.company.ComChemicalCheckResult;
import cn.smarthse.modules.health.supervise.vo.company.ComDustCheckResult;
import cn.smarthse.modules.health.supervise.vo.company.ScaleCompanyCheckNum;
import cn.smarthse.services.hfi.api.pojo.bo.ScaleCompanyCheckNumBo;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.lang.invoke.CallSite;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class HcCheckAreaThirdStatServiceImpl
implements IHcCheckAreaThirdStatService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    HcCheckAreaThirdStatMapper hcCheckAreaThirdStatMapper;
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference(version="1.0.0")
    private IHarmFactorService harmFactorService;
    @Autowired
    private ThreadPoolExecutor threadPoolExecutor;
    @DubboReference
    private ICheckPlanService checkPlanService;
    @Autowired
    private IThirdCompanyService thirdCompanyService;

    public Integer getHcCheckCompanyCountByAreaAndYear(String areaId, Byte level, Integer year) {
        return this.hcCheckAreaThirdStatMapper.getHcCheckCompanyCountByAreaAndYear(areaId, level, year);
    }

    public List<HcCheckThirdStat> getHcCheckThirdStatByArea(String parentCode, Byte level) {
        return this.hcCheckAreaThirdStatMapper.getHcCheckThirdStatByArea(parentCode, level);
    }

    public List<HcCheckThirdStat> getHcCheckThirdStatByHarm(String parentCode, Byte level) {
        return this.hcCheckAreaThirdStatMapper.getHcCheckThirdStatByHarm(parentCode, level);
    }

    public List<HcCheckThirdStat> getHcCheckThirdStatByIndustry(String parentCode, Byte level) {
        return this.hcCheckAreaThirdStatMapper.getHcCheckThirdStatByIndustry(parentCode, level);
    }

    public Integer getWorkHarmStaffCountByAreaAndYear(String parentCode, Byte level, Integer year, Byte ownLevel) {
        return this.hcCheckAreaThirdStatMapper.getWorkHarmStaffCountByAreaAndYear(parentCode, level, year, ownLevel);
    }

    public Integer getOnWorkCompanyStaffCountByAreaAndYear(String parentCode, Byte level, Integer year) {
        return this.hcCheckAreaThirdStatMapper.getOnWorkCompanyStaffCountByAreaAndYear(parentCode, level, year);
    }

    public Integer getCompanyFunctionalOrganizationMemberCountByAreaAndYear(String parentCode, Byte level, Integer year) {
        return this.hcCheckAreaThirdStatMapper.getCompanyFunctionalOrganizationMemberCountByAreaAndYear(parentCode, level, year);
    }

    public List<HcCheckThirdStat> getHcCheckThirdBelowProofRateStatByAreaAndYearAndRateValue(String parentCode, Byte level, Integer year, Double rateVal) {
        List<HcCheckThirdStat> list = this.hcCheckAreaThirdStatMapper.getHcCheckThirdBelowProofRateStatByAreaAndYearAndRateValue(parentCode, level, year, rateVal);
        for (HcCheckThirdStat stat : list) {
            stat.setLastCheckTime(this.hcCheckAreaThirdStatMapper.getLastCheckStartTimeByCid(stat.getCid()));
        }
        return list;
    }

    public PageInfo<HcCheckThirdStat> getHcCheckThirdBelowProofRateStatByAreaAndYearAndRateValuePage(JqGridParam jParam, String parentCode, Byte level, Integer year, Double rateVal) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        return new PageInfo(this.getHcCheckThirdBelowProofRateStatByAreaAndYearAndRateValue(parentCode, level, year, rateVal));
    }

    public List<HcCheckThirdStat> getHcCheckExpiryCompanyMoreThanOneYearByArea(String parentCode, Byte level) {
        return this.hcCheckAreaThirdStatMapper.getHcCheckExpiryCompanyMoreThanOneYearByArea(parentCode, level);
    }

    public PageInfo<HcCheckThirdStat> getHcCheckExpiryCompanyMoreThanOneYearByAreaPage(JqGridParam jParam, String parentCode, Byte level) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        return new PageInfo(this.getHcCheckExpiryCompanyMoreThanOneYearByArea(parentCode, level));
    }

    public Integer getHcCheckExpiryCompanyCountMoreThanOneYearByArea(String parentCode, Byte level) {
        return this.hcCheckAreaThirdStatMapper.getHcCheckExpiryCompanyCountMoreThanOneYearByArea(parentCode, level);
    }

    public List<HcCheckThirdStat> getHcCheckExpiryCompanyInTwoWeeksByArea(String parentCode, Byte level, Date dateStart, Date dateEnd) {
        return this.hcCheckAreaThirdStatMapper.getHcCheckExpiryCompanyInTwoWeeksByArea(parentCode, level, dateStart, dateEnd);
    }

    public Integer getHcCheckExpiryCompanyCountInTwoWeeksByArea(String parentCode, Byte level, Date dateStart, Date dateEnd) {
        return this.hcCheckAreaThirdStatMapper.getHcCheckExpiryCompanyCountInTwoWeeksByArea(parentCode, level, dateStart, dateEnd);
    }

    public PageInfo<HcCheckThirdStat> getHcCheckExpiryCompanyInTwoWeeksByAreaPage(JqGridParam jParam, String parentCode, Byte level, Date dateStart, Date dateEnd) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        return new PageInfo(this.getHcCheckExpiryCompanyInTwoWeeksByArea(parentCode, level, dateStart, dateEnd));
    }

    public List<HcCheckThirdStat> getHcCheckExpiryCompanyNeverCheckByArea(String parentCode, Byte level) {
        return this.hcCheckAreaThirdStatMapper.getHcCheckExpiryCompanyNeverCheckByArea(parentCode, level);
    }

    public Integer getHcCheckExpiryCompanyNeverCheckCountByArea(String parentCode, Byte level) {
        return this.hcCheckAreaThirdStatMapper.getHcCheckExpiryCompanyNeverCheckCountByArea(parentCode, level);
    }

    public PageInfo<HcCheckThirdStat> getHcCheckExpiryCompanyNeverCheckByAreaPage(JqGridParam jParam, String parentCode, Byte level) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        return new PageInfo(this.getHcCheckExpiryCompanyNeverCheckByArea(parentCode, level));
    }

    public Integer getHcCheckCompanyCountByAreaAndBetweenTime(String parentCode, Byte level, Date begin, Date end) {
        Long areaId = null;
        if (parentCode != null && !parentCode.isEmpty()) {
            areaId = Long.parseLong(parentCode);
        }
        if (begin == null) {
            return this.checkPlanService.countComNumByTimeRangeByArea(areaId, level, null, null, null);
        }
        return this.checkPlanService.countComNumByTimeRangeByArea(areaId, level, DateUtil.getFromDate((Date)begin), DateUtil.getFromDate((Date)end), null);
    }

    public Integer getHcCheckCompanyCountByIndustry(Long areaId, Byte level, String industryCategoryIds) {
        if (industryCategoryIds == null || industryCategoryIds.isEmpty()) {
            return 0;
        }
        LocalDateTime start = DateUtil.getLocalDateTime((int)LocalDate.now().getYear(), (int)1, (int)1, (int)0, (int)0, (int)0);
        LocalDateTime end = LocalDateTime.now();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (String s : industryCategoryIds.split(",")) {
            ids.add(Long.parseLong(s));
        }
        return this.checkPlanService.countComNumByYearByIndustryByArea(areaId, level, ids, start, end, null);
    }

    public Integer getHcCheckCompanyCountByHarmFactor(Long areaId, Byte level, String factorIds) {
        String[] split;
        if (factorIds == null || factorIds.length() == 0) {
            return 0;
        }
        ArrayList<Long> factorList = new ArrayList<Long>();
        for (String s : split = factorIds.split(",")) {
            factorList.add(Long.parseLong(s));
        }
        LocalDateTime start = DateUtil.getLocalDateTime((int)LocalDate.now().getYear(), (int)1, (int)1, (int)0, (int)0, (int)0);
        LocalDateTime end = LocalDateTime.now();
        return this.checkPlanService.countComNumByTimeRangeByFactorByArea(areaId, level, factorList, start, end, null);
    }

    public List<ScaleCompanyCheckNum> getHcCheckCompanyCountGroupByScale(Long areaId, Byte level) {
        LocalDateTime start = DateUtil.getLocalDateTime((int)LocalDate.now().getYear(), (int)1, (int)1, (int)0, (int)0, (int)0);
        LocalDateTime end = LocalDateTime.now();
        List numBos = this.checkPlanService.countComNumByAreaGroupByScale(areaId, level, start, end, null);
        LinkedList<ScaleCompanyCheckNum> list = new LinkedList<ScaleCompanyCheckNum>();
        for (ScaleCompanyCheckNumBo numBo : numBos) {
            ScaleCompanyCheckNum num = new ScaleCompanyCheckNum();
            num.setCheckNum(numBo.getCheckComNum());
            num.setScale(numBo.getScale());
            list.add(num);
        }
        return list;
    }

    public List<HcCheckThirdStat> getHcCheckThirdStatByHarmType(String parentCode, Byte level) {
        return this.hcCheckAreaThirdStatMapper.getHcCheckThirdStatByHarmType(parentCode, level);
    }

    public List<HcCheckThirdStat> getHcCheckThirdStatByScale(String parentCode, Byte level) {
        return this.hcCheckAreaThirdStatMapper.getHcCheckThirdStatByScale(parentCode, level);
    }

    public String getHarmNamesByHcIdByHcId(Long hcId) {
        List<String> harmNames = this.hcCheckAreaThirdStatMapper.getHarmNamesByHcId(hcId);
        if (harmNames != null && harmNames.size() > 0) {
            return String.join((CharSequence)",", harmNames);
        }
        return "";
    }

    public Long getLastRegularHcCheckPlanIdByCid(Long cid) {
        Long hcId = this.hcCheckAreaThirdStatMapper.getLastRegularHcCheckPlanIdByCid(cid);
        return hcId;
    }

    public List<HcCheckThirdStat> getHcCheckThirdBelowProofRateStatByAreaAndYearAndThresholdValues(String areaId, Byte level, Integer year, ThresholdValues vo) {
        List<HcCheckThirdStat> list = this.hcCheckAreaThirdStatMapper.getHcCheckThirdBelowProofRateStatByAreaAndYearAndThresholdValues(areaId, level, year, vo);
        for (HcCheckThirdStat stat : list) {
            stat.setLastCheckTime(this.hcCheckAreaThirdStatMapper.getLastCheckStartTimeByCid(stat.getCid()));
        }
        return list;
    }

    public List<HcCheckThirdStat> hcCheckThirdStatScaleComCountByScaleAndArea(final String areaId, final Byte level) {
        ArrayList<HcCheckThirdStat> list = new ArrayList<HcCheckThirdStat>();
        for (final ThirdHarmTypeEnum type : ThirdHarmTypeEnum.values()) {
            Callable<HcCheckThirdStat> statCall = new Callable<HcCheckThirdStat>(){

                @Override
                public HcCheckThirdStat call() throws Exception {
                    HcCheckThirdStat stat = new HcCheckThirdStat();
                    stat.setHarmType(type.getTypeVal().toString());
                    stat.setHarmTypeName(type.getHarmTypeName());
                    List<HcCheckScaleNum> scales = HcCheckAreaThirdStatServiceImpl.this.hcCheckAreaThirdStatMapper.hcCheckCompByScaleAndArea(areaId, level, type.getTypeVal());
                    List<HcCheckScaleNum> occps = HcCheckAreaThirdStatServiceImpl.this.hcCheckAreaThirdStatMapper.hcCheckCompByOccuAndArea(areaId, level, type.getTypeVal());
                    if (scales != null && scales.size() > 0) {
                        for (HcCheckScaleNum num : scales) {
                            if (num.getScale() == null) continue;
                            if (num.getScale() == 1) {
                                stat.setScale1(num.getNum());
                                continue;
                            }
                            if (num.getScale() == 2) {
                                stat.setScale2(num.getNum());
                                continue;
                            }
                            if (num.getScale() == 3) {
                                stat.setScale3(num.getNum());
                                continue;
                            }
                            if (num.getScale() != 4) continue;
                            stat.setScale4(num.getNum());
                        }
                    }
                    if (occps != null && occps.size() > 0) {
                        for (HcCheckScaleNum num : occps) {
                            if (num.getScale() == null) continue;
                            if (num.getScale() == 0) {
                                stat.setScale5(num.getNum());
                                continue;
                            }
                            if (num.getScale() != 1) continue;
                            stat.setScale6(num.getNum());
                        }
                    }
                    stat.setScaleTotal(Integer.valueOf(stat.getScale1() + stat.getScale2() + stat.getScale3() + stat.getScale4()));
                    return stat;
                }
            };
            FutureTask<HcCheckThirdStat> areaTask = new FutureTask<HcCheckThirdStat>(statCall);
            new Thread(areaTask).start();
            try {
                list.add(areaTask.get());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public PageInfo<HcCheckThirdStat> getHcCheckThirdBelowProofRateStatByAreaAndYearAndThresholdValuesPage(JqGridParam jParam, String areaId, Byte level, Integer year, ThresholdValues vo) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        return new PageInfo(this.getHcCheckThirdBelowProofRateStatByAreaAndYearAndThresholdValues(areaId, level, year, vo));
    }

    public Integer getThirdOrgHcCheckPlanReportedCountByYearAndOrgId(String areaId, Byte level, Integer year, Long orgId) {
        return this.hcCheckAreaThirdStatMapper.getThirdOrgHcCheckPlanReportedCountByYearAndOrgId(areaId, level, year, orgId);
    }

    public List<Long> getThirdOrgIdListByParentCode(String areaId, Byte level) {
        return this.hcCheckAreaThirdStatMapper.getThirdOrgIdListByAreaId(areaId, level);
    }

    public Date getLastHcCheckReportTimeByOrgAndParentCode(String areaId, Byte level, Long orgId) {
        return this.hcCheckAreaThirdStatMapper.getLastHcCheckReportTimeByOrgAndAreaId(areaId, level, orgId);
    }

    public List<CompanyHarms> getHcCheckCompanyHarmListByParentCode(String areaId, Byte level, Date start, Date end) {
        List<CompanyHarms> list = this.hcCheckAreaThirdStatMapper.getHcCheckCompanyHarmListByAreaId(areaId, level, start, end);
        if (list == null || list.size() == 0) {
            return list;
        }
        HashMap map = new HashMap();
        for (CompanyHarms ccid : list) {
            map.put(ccid.getCid(), new ArrayList());
        }
        List<CompanyHarms> cidAndHarmIds = this.hcCheckAreaThirdStatMapper.getHcCHeckCidAndHarmIdsByTimeRange(start, end);
        for (CompanyHarms cidAndHarmId : cidAndHarmIds) {
            if (map.get(cidAndHarmId.getCid()) == null || ((List)map.get(cidAndHarmId.getCid())).contains(cidAndHarmId.getHarmId())) continue;
            ((List)map.get(cidAndHarmId.getCid())).add(cidAndHarmId.getHarmId());
        }
        for (CompanyHarms ch : list) {
            if (((List)map.get(ch.getCid())).size() <= 0) continue;
            ArrayList<CallSite> strs = new ArrayList<CallSite>();
            for (Long haId : (List)map.get(ch.getCid())) {
                strs.add((CallSite)((Object)("" + haId)));
            }
            ch.setHarmFactorIds(String.join((CharSequence)",", strs));
        }
        return list;
    }

    public List<Long> getHcCHeckHarmIdsByCidAndTimeRange(Long cid, Date start, Date end) {
        return this.hcCheckAreaThirdStatMapper.getHcCHeckHarmIdsByCidAndTimeRange(cid, start, end);
    }

    public List<Long> getHcCHeckHarmIdsByCidAndTimeRangeAndCheckValueMoreThanTen(Long cid, Date start, Date end) {
        return this.hcCheckAreaThirdStatMapper.getHcCHeckHarmIdsByCidAndTimeRangeAndCheckValueMoreThanTen(cid, start, end);
    }

    public List<CompanyHarms> getHcCheckCompanyHarmListByParentCodeAndTwoBetweenTime(String areaId, Byte level, Date start1, Date end1, Date start2, Date end2) {
        List<CompanyHarms> list = this.hcCheckAreaThirdStatMapper.getHcCheckCompanyHarmListByAreaIdAndTwoBetweenTime(areaId, level, start1, end1, start2, end2);
        if (list == null || list.size() == 0) {
            return list;
        }
        HashMap map = new HashMap();
        for (CompanyHarms companyHarms : list) {
            map.put(companyHarms.getCid(), new ArrayList());
        }
        List<CompanyHarms> cidAndHarmIds = this.hcCheckAreaThirdStatMapper.getHcCHeckCidAndHarmIdsByTwoTimeRange(start1, end1, start2, end2);
        for (CompanyHarms cidAndHarmId : cidAndHarmIds) {
            if (map.get(cidAndHarmId.getCid()) == null || ((List)map.get(cidAndHarmId.getCid())).contains(cidAndHarmId.getHarmId())) continue;
            ((List)map.get(cidAndHarmId.getCid())).add(cidAndHarmId.getHarmId());
        }
        ArrayList<CompanyHarms> arrayList = new ArrayList<CompanyHarms>();
        for (CompanyHarms ch : list) {
            if (((List)map.get(ch.getCid())).size() <= 0) continue;
            ArrayList<CallSite> strs = new ArrayList<CallSite>();
            for (Long haId : (List)map.get(ch.getCid())) {
                strs.add((CallSite)((Object)("" + haId)));
            }
            ch.setHarmFactorIds(String.join((CharSequence)",", strs));
            arrayList.add(ch);
        }
        return arrayList;
    }

    public List<Long> getHcCHeckHarmIdsByCidAndTwoTimeRangeAndCheckValueMoreThanTen(Long cid, Date start1, Date end1, Date start2, Date end2) {
        return this.hcCheckAreaThirdStatMapper.getHcCHeckHarmIdsByCidAndTwoTimeRangeAndCheckValueMoreThanTen(cid, start1, end1, start2, end2);
    }

    public Integer getHcCheckCompanyCountByAreaAndBeforeNYear(String areaId, Byte level, Integer year, Integer n) {
        return this.hcCheckAreaThirdStatMapper.getHcCheckCompanyCountByAreaAndBeforeNYear(areaId, level, year, n);
    }

    public Integer getHcCheckCompanyCountByAreaAndBetweenTime(String areaId, Byte level, Integer year, Date beginTime, Date endTime) {
        Long longAreaId = null;
        if (areaId != null && !areaId.isEmpty()) {
            longAreaId = Long.parseLong(areaId);
        }
        return this.checkPlanService.countComNumByTimeRangeByArea(longAreaId, level, DateUtil.getFromDate((Date)beginTime), DateUtil.getFromDate((Date)endTime), null);
    }

    public List<ComChemicalCheckResult> getComChemicalCheckResult(Long cid, List<Long> harmFactorIds, Date startDate, Date endDate) {
        if (harmFactorIds == null || harmFactorIds.isEmpty()) {
            return new ArrayList<ComChemicalCheckResult>(0);
        }
        return this.hcCheckAreaThirdStatMapper.getComChemicalCheckResult(cid, harmFactorIds, startDate, endDate);
    }

    public List<ComDustCheckResult> getComDustCheckResult(Long cid, List<Long> harmFactorIds, Date startDate, Date endDate) {
        if (harmFactorIds == null || harmFactorIds.isEmpty()) {
            return new ArrayList<ComDustCheckResult>(0);
        }
        return this.hcCheckAreaThirdStatMapper.getComDustCheckResult(cid, harmFactorIds, startDate, endDate);
    }

    public List<CompanyHarms> getChemicalAndDustCheckDiffCom(List<CompanyHarms> list) throws ExecutionException, InterruptedException {
        ArrayList<CompanyHarms> rList = new ArrayList<CompanyHarms>();
        ArrayList harmFactorIdList = new ArrayList(32);
        for (CompanyHarms companyHarms : list) {
            List l = companyHarms.getHarmFactorIdList();
            if (l == null || l.isEmpty()) continue;
            harmFactorIdList.addAll(l);
        }
        List factorAttr = this.harmFactorService.getByFactorIds(harmFactorIdList);
        ArrayList<Future<CheckResult>> futures = new ArrayList<Future<CheckResult>>(list.size());
        for (CompanyHarms companyHarms : list) {
            Future<CheckResult> future = this.threadPoolExecutor.submit(() -> this.istChemicalAndDustCheckDiffCom(companyHarms, factorAttr));
            futures.add(future);
        }
        for (Future future : futures) {
            CheckResult checkResult = (CheckResult)future.get();
            if (!checkResult.getResult().booleanValue()) continue;
            rList.add(checkResult.getHarms());
        }
        return rList;
    }

    private CheckResult istChemicalAndDustCheckDiffCom(CompanyHarms companyHarms, List<FactorAttr> factorAttr) {
        CheckResult checkResult = new CheckResult();
        checkResult.setHarms(companyHarms);
        Date now = new Date();
        Date start = DateUtils.addYear((Date)now, (int)-1);
        Date end = now;
        List<ComChemicalCheckResult> comChemicalCheckResult1 = this.getComChemicalCheckResult(companyHarms.getCid(), companyHarms.getHarmFactorIdList(), start, end);
        List<ComDustCheckResult> comDusCheckResult1 = this.getComDustCheckResult(companyHarms.getCid(), companyHarms.getHarmFactorIdList(), start, end);
        start = DateUtils.addYear((Date)now, (int)-2);
        end = DateUtils.addYear((Date)now, (int)-1);
        List<ComChemicalCheckResult> comChemicalCheckResult2 = this.getComChemicalCheckResult(companyHarms.getCid(), companyHarms.getHarmFactorIdList(), start, end);
        List<ComDustCheckResult> comDusCheckResult2 = this.getComDustCheckResult(companyHarms.getCid(), companyHarms.getHarmFactorIdList(), start, end);
        boolean result = this.chemicalListDifferenceValidate(comChemicalCheckResult1, comChemicalCheckResult2, factorAttr);
        if (result) {
            checkResult.setResult(result);
            return checkResult;
        }
        result = this.dustlListDifferenceValidate(comDusCheckResult1, comDusCheckResult2, factorAttr);
        checkResult.setResult(result);
        return checkResult;
    }

    private String getLimitValue(Long factorId, String attrName, List<FactorAttr> factorAttr) {
        for (FactorAttr attr : factorAttr) {
            if (!attr.getHazardId().equals(factorId) || !attr.getAttrName().endsWith(attrName)) continue;
            return attr.getAttrValue();
        }
        return null;
    }

    private boolean chemicalListDifferenceValidate(List<ComChemicalCheckResult> comChemicalCheckResult1, List<ComChemicalCheckResult> comChemicalCheckResult2, List<FactorAttr> factorAttr) {
        for (ComChemicalCheckResult r1 : comChemicalCheckResult1) {
            if (r1.getHarmFactorId() == null) continue;
            for (ComChemicalCheckResult r2 : comChemicalCheckResult2) {
                boolean result;
                if (r2.getHarmFactorId() == null || !r1.getHarmFactorId().equals(r2.getHarmFactorId()) || !(result = this.chemicalDifferenceValidate(r1, r2, factorAttr))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean dustlListDifferenceValidate(List<ComDustCheckResult> comDustCheckResult1, List<ComDustCheckResult> comDustCheckResult2, List<FactorAttr> factorAttr) {
        for (ComDustCheckResult r1 : comDustCheckResult1) {
            if (r1.getHarmFactorId() == null) continue;
            for (ComDustCheckResult r2 : comDustCheckResult2) {
                boolean result;
                if (r2.getHarmFactorId() == null || !r1.getHarmFactorId().equals(r2.getHarmFactorId()) || !(result = this.dustDifferenceValidate(r1, r2, factorAttr))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean chemicalDifferenceValidate(ComChemicalCheckResult r1, ComChemicalCheckResult r2, List<FactorAttr> factorAttr) {
        if (r1 == null || r2 == null) {
            return false;
        }
        boolean r = false;
        String cstel3 = r1.getCstel3();
        String cstel3_2 = r2.getCstel3();
        String stelLimit = this.getLimitValue(r1.getHarmFactorId(), "stel", factorAttr);
        if (!StringUtils.isEmpty((CharSequence)stelLimit) && !StringUtils.isEmpty((CharSequence)cstel3) && !StringUtils.isEmpty((CharSequence)cstel3_2) && (r = this.differenceValidate(cstel3.split(","), cstel3_2.split(","), stelLimit))) {
            return true;
        }
        String ctwa = r1.getCtwa();
        String ctwa_2 = r2.getCtwa();
        String twaLimit = this.getLimitValue(r1.getHarmFactorId(), "twa", factorAttr);
        if (!StringUtils.isEmpty((CharSequence)ctwa) && !StringUtils.isEmpty((CharSequence)ctwa_2) && !StringUtils.isEmpty((CharSequence)twaLimit) && (r = this.differenceValidate(ctwa.split(","), ctwa_2.split(","), twaLimit))) {
            return true;
        }
        String peakcontactconcentration = r1.getPeakcontactconcentration();
        String peakcontactconcentration_2 = r2.getPeakcontactconcentration();
        String twa5Limit = this.getLimitValue(r1.getHarmFactorId(), "5twa", factorAttr);
        if (!StringUtils.isEmpty((CharSequence)peakcontactconcentration) && !StringUtils.isEmpty((CharSequence)peakcontactconcentration_2) && !StringUtils.isEmpty((CharSequence)twa5Limit) && (r = this.differenceValidate(peakcontactconcentration.split(","), peakcontactconcentration_2.split(","), twa5Limit))) {
            return true;
        }
        String times = r1.getTimes();
        String times2 = r2.getTimes();
        String macLimit = this.getLimitValue(r1.getHarmFactorId(), "mac", factorAttr);
        if (!StringUtils.isEmpty((CharSequence)times) && !StringUtils.isEmpty((CharSequence)times2) && !StringUtils.isEmpty((CharSequence)macLimit) && (r = this.differenceValidate(times.split(","), times2.split(","), macLimit))) {
            return true;
        }
        return r;
    }

    private boolean dustDifferenceValidate(ComDustCheckResult r1, ComDustCheckResult r2, List<FactorAttr> factorAttr) {
        if (r1 == null || r2 == null) {
            return false;
        }
        boolean r = false;
        String ctwa1 = r1.getCtwa1();
        String ctwa1_2 = r2.getCtwa1();
        String twa_total = this.getLimitValue(r1.getHarmFactorId(), "twa_total", factorAttr);
        if (!StringUtils.isEmpty((CharSequence)ctwa1) && !StringUtils.isEmpty((CharSequence)ctwa1_2) && !StringUtils.isEmpty((CharSequence)twa_total) && (r = this.differenceValidate(ctwa1.split(","), ctwa1_2.split(","), twa_total))) {
            return r;
        }
        String ctwa2 = r1.getCtwa2();
        String ctwa2_2 = r2.getCtwa2();
        String twa_respirabel = this.getLimitValue(r1.getHarmFactorId(), "twa_respirabel", factorAttr);
        if (!StringUtils.isEmpty((CharSequence)ctwa2) && !StringUtils.isEmpty((CharSequence)ctwa2_2) && !StringUtils.isEmpty((CharSequence)twa_respirabel) && (r = this.differenceValidate(ctwa2.split(","), ctwa2_2.split(","), twa_respirabel))) {
            return r;
        }
        String ctwa1range = r1.getCtwa1range();
        String ctwa1range_2 = r2.getCtwa1range();
        String twa5_total = this.getLimitValue(r1.getHarmFactorId(), "5twa_total", factorAttr);
        if (!StringUtils.isEmpty((CharSequence)ctwa1range) && !StringUtils.isEmpty((CharSequence)ctwa1range_2) && !StringUtils.isEmpty((CharSequence)twa5_total) && (r = this.differenceValidate(ctwa1range.split(","), ctwa1range_2.split(","), twa5_total))) {
            return r;
        }
        String ctwa2range = r1.getCtwa2range();
        String ctwa2range_2 = r2.getCtwa2range();
        String twa5_respirabel = this.getLimitValue(r1.getHarmFactorId(), "5twa_respirabel", factorAttr);
        if (!StringUtils.isEmpty((CharSequence)ctwa2range) && !StringUtils.isEmpty((CharSequence)ctwa2range_2) && !StringUtils.isEmpty((CharSequence)twa5_respirabel) && (r = this.differenceValidate(ctwa2range.split(","), ctwa2range_2.split(","), twa5_respirabel))) {
            return r;
        }
        return r;
    }

    private boolean differenceValidate(String[] array1, String[] array2, String limit) {
        if (array1 == null || array1.length == 0 || array2 == null || array2.length == 0) {
            return false;
        }
        ArrayList<Double> doubleArray1 = new ArrayList<Double>();
        for (int i = 0; i < array1.length; ++i) {
            String s = array1[i];
            if (s.contains("~")) {
                s = s.substring(s.indexOf("~") + 1);
            }
            if (s.contains("-")) {
                s = s.substring(s.indexOf("-") + 1);
            }
            if (s.length() <= 0) continue;
            try {
                if (s.contains("\uff1c")) {
                    s = s.replace("\uff1c", "");
                }
                s = s.replace(" ", "");
                doubleArray1.add(Double.parseDouble(s));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ArrayList<Double> doubleArray2 = new ArrayList<Double>();
        for (int i = 0; i < array2.length; ++i) {
            String s = array2[i];
            if (s.contains("~")) {
                s = s.substring(s.indexOf("~") + 1);
            }
            if (s.contains("-")) {
                s = s.substring(s.indexOf("-") + 1);
            }
            if (s.length() <= 0) continue;
            try {
                if (s.contains("\uff1c")) {
                    s = s.replace("\uff1c", "");
                }
                s = s.replace(" ", "");
                doubleArray2.add(Double.parseDouble(s));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (doubleArray1.isEmpty() || doubleArray2.isEmpty()) {
            return false;
        }
        return this.doDifferenceValidate(doubleArray1, doubleArray2, Double.parseDouble(limit));
    }

    private boolean doDifferenceValidate(List<Double> array1, List<Double> array2, double limit) {
        double squire2;
        double max2;
        double max1 = this.maxValue(array1);
        double max_difference_value = Math.abs(max1 - (max2 = this.maxValue(array2)));
        if (max_difference_value > 0.5 * limit) {
            return true;
        }
        int len1 = array1.size();
        int len2 = array2.size();
        if (len1 == 1 || len2 == 1) {
            return false;
        }
        double avg1 = this.getAvg(array1);
        double avg2 = this.getAvg(array2);
        double squire1 = this.getSquireValue(array1);
        if (squire1 > (squire2 = this.getSquireValue(array2))) {
            return this.doDifferenceValidateResult(len1, avg1, squire1, len2, avg2, squire2);
        }
        return this.doDifferenceValidateResult(len2, avg2, squire2, len1, avg1, squire1);
    }

    private boolean doDifferenceValidateResult(int len1, double avg1, double squire1, int len2, double avg2, double squire2) {
        double avgDif = Math.abs(avg1 - avg2);
        double f_calculate = squire1 / squire2;
        if (squire2 == 0.0) {
            return false;
        }
        double f_check = this.fCheck(len1 - 1, len2 - 1);
        if (f_calculate < f_check) {
            double t_check;
            double n;
            double s_square_sum = Math.sqrt(((double)(len1 - 1) * squire1 + (double)(len2 - 1) * squire2) / (double)(len1 + len2 - 2));
            double t_calculate = avgDif / (s_square_sum * (n = Math.sqrt(1 / len1 + 1 / len2)));
            return t_calculate <= (t_check = this.tCheck(len1 + len2 - 2));
        }
        double k = squire1 / (double)len1 / (squire1 / (double)len1 + squire2 / (double)len2);
        double one_k = 1.0 - k;
        double df = 1.0 / (k * k / (double)(len1 - 1) + one_k / one_k / (double)(len2 - 1));
        double t_calculate = avgDif / Math.sqrt(squire1 / (double)len1 + squire2 / (double)len2);
        try {
            double t_check = this.tCheck(df);
            return t_calculate <= t_check;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("df=" + df + ",len1:" + len1 + ";len2:" + len2);
            return false;
        }
    }

    private double maxValue(List<Double> doubles) {
        double max = 0.0;
        for (double d : doubles) {
            if (!(d > max)) continue;
            max = d;
        }
        return max;
    }

    private double getAvg(List<Double> doubles) {
        double sum = 0.0;
        for (double d : doubles) {
            sum += d;
        }
        return sum / (double)doubles.size();
    }

    private double getSquireValue(List<Double> arr) {
        if (arr.size() == 1) {
            return 0.0;
        }
        double avg = this.getAvg(arr);
        double sum = 0.0;
        for (double v : arr) {
            sum += Math.abs(v - avg) * Math.abs(v - avg);
        }
        return sum / (double)(arr.size() - 1);
    }

    private double fCheck(int n1, int n2) {
        if (n1 > 1000) {
            n1 = 1000;
        }
        for (Map.Entry<Integer, List<Double>> entry : CheckDiffValidateConstantsData.ftable.entrySet()) {
            if (n1 > entry.getKey()) continue;
            n1 = entry.getKey();
            break;
        }
        if (n2 > 1000) {
            n2 = 1000;
        }
        for (int i = 0; i < CheckDiffValidateConstantsData.index_list.length; ++i) {
            if (n2 > CheckDiffValidateConstantsData.index_list[i]) continue;
            n2 = i;
            break;
        }
        return CheckDiffValidateConstantsData.ftable.get(n1).get(n2);
    }

    private double tCheck(double n1) {
        if (n1 > 200.0) {
            return 1.96;
        }
        if (CheckDiffValidateConstantsData.table.containsKey(n1)) {
            return CheckDiffValidateConstantsData.table.get(n1);
        }
        if (n1 > 150.0) {
            return 1.976 - (n1 - 150.0) * 0.004 / 50.0;
        }
        if (n1 > 125.0) {
            return 1.979 - (n1 - 125.0) * 0.003 / 25.0;
        }
        if (n1 > 100.0) {
            return 1.984 - (n1 - 100.0) * 0.005 / 25.0;
        }
        if (n1 > 90.0) {
            return 1.987 - (n1 - 90.0) * 0.003 / 10.0;
        }
        if (n1 > 80.0) {
            return 1.99 - (n1 - 80.0) * 0.003 / 10.0;
        }
        if (n1 > 70.0) {
            return 1.994 - (n1 - 70.0) * 0.004 / 10.0;
        }
        if (n1 > 60.0) {
            return 2.0 - (n1 - 60.0) * 0.006 / 10.0;
        }
        if (n1 > 50.0) {
            return 2.009 - (n1 - 50.0) * 0.009 / 10.0;
        }
        if (n1 > 40.0) {
            return 2.021 - (n1 - 40.0) * 0.011 / 10.0;
        }
        if (n1 > 30.0) {
            return 2.0423 - (n1 - 30.0) * 0.0213 / 10.0;
        }
        try {
            double x = CheckDiffValidateConstantsData.table.get((int)n1);
            double x2 = CheckDiffValidateConstantsData.table.get((int)(n1 + 1.0));
            return x - (x - x2 * (n1 - (double)((int)n1)));
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            this.logger.error("\u83b7\u53d6double\u7a7a\u6307\u9488\u5f02\u5e38,n1=" + n1, (Throwable)e);
            return 1.96;
        }
    }

    public String getHarmNamesFromLastNewHc(Long cid) {
        List<String> harmNames = this.hcCheckAreaThirdStatMapper.getHarmNamesFromLastNewHc(cid);
        if (harmNames != null && harmNames.size() > 0) {
            return String.join((CharSequence)",", harmNames.stream().distinct().collect(Collectors.toList()));
        }
        return null;
    }

    public List<Long> getHarmIdsFromHcCheck(Long cid) {
        return this.hcCheckAreaThirdStatMapper.getHarmIdsFromHcCheck(cid);
    }

    private static class CheckResult {
        private Boolean result;
        private CompanyHarms harms;

        private CheckResult() {
        }

        public Boolean getResult() {
            return this.result;
        }

        public void setResult(Boolean result) {
            this.result = result;
        }

        public CompanyHarms getHarms() {
            return this.harms;
        }

        public void setHarms(CompanyHarms harms) {
            this.harms = harms;
        }
    }
}

