/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.harmFactorDeclare;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.health.supervise.dao.harmFactorDeclare.SuperviseHarmFactorDeclareMapper;
import cn.smarthse.modules.health.supervise.entity.harmFactorDeclare.CountDataModel;
import cn.smarthse.modules.health.supervise.entity.harmFactorDeclare.HarmFactorDeclareCompanyInfo;
import cn.smarthse.modules.health.supervise.entity.harmFactorDeclare.HarmFactorDeclareInfo;
import cn.smarthse.modules.health.supervise.service.harmFactorDeclare.ISuperviseHarmFactorDeclareService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class SuperviseHarmFactorDeclareServiceImpl
implements ISuperviseHarmFactorDeclareService {
    @Autowired
    SuperviseHarmFactorDeclareMapper dao;

    public PageInfo<HarmFactorDeclareInfo> getPreviousHarmFactorDeclareInfo(JqGridParam gparam, Long cid) {
        if (cid == null) {
            return null;
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<HarmFactorDeclareInfo> list = this.dao.getListofHarmFactorDeclareByCid(cid);
        return new PageInfo(list);
    }

    public int getDeclareNumByCidAndYear(Long cid, Integer year) {
        if (cid == null || year == null) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("cid", cid);
        List<HarmFactorDeclareInfo> list = this.dao.getListByYear(params);
        if (list != null && list.size() > 0) {
            return list.size();
        }
        return 0;
    }

    public HarmFactorDeclareCompanyInfo getHarmFactorDeclareCompanyInfo(List<Long> listCids) {
        HarmFactorDeclareCompanyInfo info = new HarmFactorDeclareCompanyInfo();
        if (listCids == null) {
            return info;
        }
        int total = listCids.size();
        info.setTotalNum(Integer.valueOf(total));
        Object cids = "-9";
        for (Long cid : listCids) {
            cids = (String)cids + "," + cid;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cids", cids);
        List<HarmFactorDeclareInfo> list = this.dao.getHarmFactorDeclareCompanyInfo(params);
        int declareNum = 0;
        float rate = 0.0f;
        if (list != null && list.size() > 0) {
            declareNum = list.size();
        }
        if (declareNum == 0 || total == 0) {
            rate = 0.0f;
            info.setDaclareRateStr("0");
        } else {
            DecimalFormat df = new DecimalFormat("0.00");
            rate = Float.parseFloat(df.format((float)declareNum / (float)total));
            float rate1 = rate * 100.0f;
            info.setDaclareRateStr(rate1 + "%");
        }
        info.setDaclareRate(rate);
        info.setDeclareNum(Integer.valueOf(declareNum));
        return info;
    }

    public int getDeclareCompanyNumByAreaAndYear(Long areaId, Byte level, Integer year) {
        if (areaId == null || year == null) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("level", level);
        params.put("areaId", areaId);
        Integer comNum = this.dao.getDeclareCompanyNumByAreaAndYear(params);
        return comNum;
    }

    public int getExpireDeclareCompNum(Long areaId, Byte level) {
        if (areaId == null) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("level", level);
        params.put("areaId", areaId);
        List<Company> list = this.dao.getExpireDeclareCompList(params);
        if (list != null && list.size() > 0) {
            return list.size();
        }
        return 0;
    }

    public List<Company> getExpireDeclareCompList(Long areaId, Byte level) {
        if (areaId == null) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("level", level);
        params.put("areaId", areaId);
        List<Company> list = this.dao.getExpireDeclareCompList(params);
        return list;
    }

    public int getWillExpireThirtDayDeclareCompNum(Long areaId, Byte level) {
        if (areaId == null) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("level", level);
        params.put("areaId", areaId);
        List<Company> list = this.dao.getWillExpireThirtDayDeclareCompList(params);
        if (list != null && list.size() > 0) {
            return list.size();
        }
        return 0;
    }

    public List<Company> getWillExpireThirtDayDeclareCompList(Long areaId, Byte level) {
        if (areaId == null) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("level", level);
        params.put("areaId", areaId);
        List<Company> list = this.dao.getWillExpireThirtDayDeclareCompList(params);
        return list;
    }

    public List<CountDataModel> getComNumByScale(Long areaId, Byte level) {
        if (areaId == null) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("level", level);
        params.put("areaId", areaId);
        List<CountDataModel> list = this.dao.getComNumByScale(params);
        return list;
    }

    public List<CountDataModel> getDecComNumBySacle(Long areaId, Byte level) {
        if (areaId == null) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("level", level);
        params.put("areaId", areaId);
        List<CountDataModel> list = this.dao.getDecComNumBySacle(params);
        return list;
    }
}

