/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.harmFactorDeclare;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.supervise.dao.harmFactorDeclare.DeclareInfoMapper;
import cn.smarthse.modules.health.supervise.entity.harmFactorDeclare.DeclareInfo;
import cn.smarthse.modules.health.supervise.entity.harmFactorDeclare.DeclareOccDistribution;
import cn.smarthse.modules.health.supervise.entity.harmFactorDeclare.DeclareOccType;
import cn.smarthse.modules.health.supervise.service.harmFactorDeclare.IDeclareAuditService;
import cn.smarthse.modules.health.supervise.service.harmFactorDeclare.IDeclareInfoService;
import cn.smarthse.modules.health.supervise.service.harmFactorDeclare.IDeclareOccDistributionService;
import cn.smarthse.modules.health.supervise.service.harmFactorDeclare.IDeclareOccTypeService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class DecalreInfoServiceImpl
extends BaseServiceImpl<DeclareInfoMapper, DeclareInfo>
implements IDeclareInfoService {
    @Autowired
    IDeclareOccTypeService declareOccTypeService;
    @Autowired
    IDeclareOccDistributionService declareOccDistributionService;
    @Autowired
    IDeclareAuditService declareAuditService;

    public DeclareInfo getInfo(String id) {
        DeclareInfo info = (DeclareInfo)((DeclareInfoMapper)this.dao).selectByPrimaryKey(id);
        if (info != null) {
            if (info.getDecalareType() != null && info.getDecalareType().equals("\u521d\u6b21\u7533\u62a5")) {
                info.setChangeReasion("-");
            }
            Date recordTime = this.declareAuditService.getRecordTime(id);
            DeclareOccType occType = this.declareOccTypeService.getOccTypeByDeclareId(id);
            if (occType != null) {
                info.setOccDiseNum(occType.getTotalNum());
            }
            info.setRecordTime(recordTime);
        }
        return info;
    }

    public DeclareInfo getDetailInfo(String id) {
        DeclareInfo info = (DeclareInfo)((DeclareInfoMapper)this.dao).selectByPrimaryKey(id);
        if (info.getDecalareType().equals("\u521d\u6b21\u7533\u62a5")) {
            info.setChangeReasion("-");
        }
        if (info != null && info.getId() != null) {
            DeclareOccType occType = this.declareOccTypeService.getOccTypeByDeclareId(info.getId());
            info.setOccType(occType);
            List distList = this.declareOccDistributionService.getListByDeclareId(info.getId());
            if (distList != null && distList.size() > 0) {
                int lenth = 0;
                int total = 0;
                for (DeclareOccDistribution dsb : distList) {
                    lenth += dsb.getLenth();
                    if (dsb.getContactsNumNorep() == null) continue;
                    total += dsb.getContactsNumNorep().intValue();
                }
                info.setLenth(lenth);
                info.setTotal(total);
            }
            List auditList = this.declareAuditService.getListByDeclareId(info.getId());
            info.setAuditList(auditList);
            info.setDistList(distList);
        }
        return info;
    }

    public int getDeclareCompanyNumByAreaAndYear(Long areaId, Byte level, Integer year) {
        if (areaId == null) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("areaId", areaId);
        params.put("level", level);
        Integer comNum = 0;
        comNum = year == null ? ((DeclareInfoMapper)this.dao).getDeclareCompNumByArea(params) : ((DeclareInfoMapper)this.dao).getDeclareCompNumByAreaAndYear(params);
        return comNum;
    }

    public int getDeclareCompanyNumByAreaAndTime(Long areaId, Byte level, Date beginTime, Date endTime, Byte ownLevel) {
        if (areaId == null) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("areaId", areaId);
        params.put("level", level);
        params.put("beginTime", beginTime);
        params.put("endTime", endTime);
        params.put("ownLevel", ownLevel);
        Integer comNum = 0;
        comNum = ((DeclareInfoMapper)this.dao).getDeclareCompanyNumByAreaAndTime(params);
        return comNum;
    }

    public List<Long> getDeclareCompanyIdByYear(Integer year) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        List<Long> cids = ((DeclareInfoMapper)this.dao).getDeclareCompIdByYear(params);
        return cids;
    }

    public int getDeclareNumByCidAndYear(Long cid, Integer year) {
        if (cid == null || year == null) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("cid", cid);
        List<DeclareInfo> list = ((DeclareInfoMapper)this.dao).getListByYearAndCcid(params);
        if (list != null && list.size() > 0) {
            return list.size();
        }
        return 0;
    }

    public String getDeclareSumInfoByCidAndYear(Long cid, Integer year) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("cid", cid);
        List<DeclareInfo> list = ((DeclareInfoMapper)this.dao).getListByYearAndCcid(params);
        if (list != null && list.size() > 0) {
            DeclareInfo info = list.get(0);
            return "\u5df2\u8fdb\u884c\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5\uff0c\u7533\u62a5\u7c7b\u578b\u4e3a" + info.getDecalareType();
        }
        return "\u672a\u8fdb\u884c\u804c\u4e1a\u75c5\u5371\u5bb3\u7533\u62a5";
    }

    public PageInfo<DeclareInfo> getDeclareInfoPage(JqGridParam param) {
        if (param.getCid() == null) {
            return null;
        }
        Long cid = param.getCid();
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<DeclareInfo> list = ((DeclareInfoMapper)this.dao).getDecListByCid(cid);
        if (list != null) {
            for (DeclareInfo info : list) {
                if (info.getDecalareType() == null || !info.getDecalareType().equals("\u521d\u6b21\u7533\u62a5") || info.getChangeReasion() == null) continue;
                info.setChangeReasion("-");
            }
        }
        return new PageInfo(list);
    }
}

