/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.exceptionlist;

import cn.hutool.core.collection.ListUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.SpringContextHolder;
import cn.smarthse.modules.datacentre.model.supervise.CompanyGradeModelV3;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyInfoService;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.supervise.dao.exceptionlist.CompanyVictimExceptionRecMapper;
import cn.smarthse.modules.health.supervise.entity.exceptionlist.CompanyVictimExceptionRec;
import cn.smarthse.modules.health.supervise.model.exceptionlist.CompanyExceptionCountModel;
import cn.smarthse.modules.health.supervise.model.exceptionlist.CompanyExceptionListModel;
import cn.smarthse.modules.health.supervise.model.exceptionlist.CompanyExceptionListParam;
import cn.smarthse.modules.health.supervise.service.exceptionlist.ICompanyVictimExceptionRecService;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateService;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class CompanyVictimExceptionRecServiceImpl
extends BaseServiceImpl<CompanyVictimExceptionRecMapper, CompanyVictimExceptionRec>
implements ICompanyVictimExceptionRecService {
    @DubboReference
    private IStaffInfoService staffInfoService;
    @Autowired
    private IComplianceCompanyInfoService complianceCompanyInfoService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideService superviseService;
    @Autowired
    private IRiskExposeEvaluateService exposeEvaluateService;

    public List<CompanyVictimExceptionRec> getCurrVictimRecList() {
        Example e = new Example(CompanyVictimExceptionRec.class);
        e.createCriteria().andEqualTo("isCurr", (Object)1).andEqualTo("isValid", (Object)1);
        List<CompanyVictimExceptionRec> listByExample = this.getListByExample(e);
        return listByExample;
    }

    public List<CompanyVictimExceptionRec> listVictimRecByCid(Long cid) {
        Example e = new Example(CompanyVictimExceptionRec.class);
        e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)1);
        List<CompanyVictimExceptionRec> listByExample = this.getListByExample(e);
        return listByExample;
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRES_NEW)
    public void saveVictimException(List<CompanyVictimExceptionRec> list) {
        this.batchUpdateOrInsert(list, CompanyVictimExceptionRecMapper.class, (item, m) -> {
            if (item.getId() == null) {
                item.setCreateDate(new Date());
                item.setUpdateDate(new Date());
                item.setId(Long.valueOf(IdWorker.getId()));
                item.setIsValid(Boolean.valueOf(true));
                return m.insert(item);
            }
            item.setUpdateDate(new Date());
            return m.updateByPrimaryKeySelective(item);
        });
    }

    @Transactional(readOnly=true)
    public void calculateVictimException(List<Long> cids) {
        if (CollectionUtils.isEmpty(cids)) {
            Set cidsByVictimnullorgt3 = this.complianceCompanyInfoService.getCidsByVictimnullorgt3();
            if (CollectionUtils.isEmpty((Collection)cidsByVictimnullorgt3)) {
                return;
            }
            cids = new ArrayList<Long>(cidsByVictimnullorgt3);
        }
        List companyGradeModelV3s = this.superviseService.listComapnyGradeInfoV3(cids);
        Map pickUpCountMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)companyGradeModelV3s)) {
            pickUpCountMap = companyGradeModelV3s.stream().collect(HashMap::new, (map, item) -> map.put(item.getCid(), item.getPickupCount()), HashMap::putAll);
        }
        HashMap staffWorkNumDataMap = new HashMap();
        ListUtil.partition(cids, (int)1000).forEach(cisListPart -> {
            List staffInfos = this.staffInfoService.collectStaffInfoWorkNum(cisListPart, null, Integer.valueOf(1));
            if (CollectionUtils.isNotEmpty((Collection)staffInfos)) {
                Map<Long, Integer> partDataMap = staffInfos.stream().collect(Collectors.groupingBy(StaffInfo::getCid, Collectors.collectingAndThen(Collectors.toList(), l -> {
                    int totalLocalWorkNum = l.stream().mapToInt(StaffInfo::getLocalWorkNum).sum();
                    int totalOutWorkNum = l.stream().mapToInt(StaffInfo::getOutWorkNum).sum();
                    return totalLocalWorkNum + totalOutWorkNum;
                })));
                staffWorkNumDataMap.putAll(partDataMap);
            }
        });
        List<CompanyVictimExceptionRec> currVictimRecList = this.getCurrVictimRecList();
        Map<Object, Object> recMap = new HashMap();
        if (CollectionUtils.isNotEmpty(currVictimRecList)) {
            recMap = currVictimRecList.stream().collect(Collectors.toMap(CompanyVictimExceptionRec::getCid, Function.identity(), (v1, v2) -> v1));
        }
        ArrayList<CompanyVictimExceptionRec> result = new ArrayList<CompanyVictimExceptionRec>();
        for (Long cid : cids) {
            Integer victims = (Integer)pickUpCountMap.get(cid);
            Integer workNum = staffWorkNumDataMap.get(cid) == null ? 0 : (Integer)staffWorkNumDataMap.get(cid);
            CompanyVictimExceptionRec dbRec = (CompanyVictimExceptionRec)recMap.get(cid);
            CompanyVictimExceptionRec rec = new CompanyVictimExceptionRec();
            rec.setEvaluateTime(new Date());
            rec.setPromiseVictim(workNum);
            rec.setSysVictim(victims);
            rec.setCid(cid);
            rec.setIsCurr(Integer.valueOf(1));
            Integer currException = 0;
            if (!(victims != null && victims <= 2 || workNum >= 3 && workNum != null)) {
                currException = 1;
            }
            if (dbRec != null) {
                Integer dbRecException = dbRec.getException();
                if (Objects.equals(dbRecException, currException)) continue;
                if (Objects.equals(currException, 0)) {
                    dbRec.setIsCurr(Integer.valueOf(0));
                    result.add(dbRec);
                    continue;
                }
                rec.setException(Integer.valueOf(1));
                result.add(rec);
                dbRec.setIsCurr(Integer.valueOf(0));
                result.add(dbRec);
                continue;
            }
            if (!Objects.equals(currException, 1)) continue;
            rec.setException(currException);
            result.add(rec);
        }
        if (CollectionUtils.isNotEmpty(result)) {
            ((ICompanyVictimExceptionRecService)SpringContextHolder.getBean(ICompanyVictimExceptionRecService.class)).saveVictimException(result);
        }
    }

    @Transactional(readOnly=true)
    public void calculateVictimExceptionV2(List<Long> cids) {
        List<CompanyGradeModelV3> companyGradeModelV3s = ((CompanyVictimExceptionRecMapper)this.dao).listVictIdentifyLt3(cids);
        if (CollectionUtils.isEmpty(companyGradeModelV3s)) {
            return;
        }
        List cidList = companyGradeModelV3s.stream().map(CompanyGradeModelV3::getCid).collect(Collectors.toList());
        ArrayList allRiskEvaluete = new ArrayList();
        ListUtil.partition(cidList, (int)1000).forEach(cisListPart -> {
            List touchHarmPeopleNumber = this.exposeEvaluateService.getTouchHarmPeopleNumber(cisListPart);
            allRiskEvaluete.addAll(touchHarmPeopleNumber);
        });
        if (CollectionUtils.isEmpty(allRiskEvaluete)) {
            return;
        }
        Map<Long, Integer> cidHarmNumMap = allRiskEvaluete.stream().collect(Collectors.toMap(RiskExposeEvaluate::getCid, RiskExposeEvaluate::getWorkNum));
        List<CompanyVictimExceptionRec> currVictimRecList = this.getCurrVictimRecList();
        Map<Object, Object> recMap = new HashMap();
        if (CollectionUtils.isNotEmpty(currVictimRecList)) {
            recMap = currVictimRecList.stream().collect(Collectors.toMap(CompanyVictimExceptionRec::getCid, Function.identity(), (v1, v2) -> v1));
        }
        ArrayList<CompanyVictimExceptionRec> result = new ArrayList<CompanyVictimExceptionRec>();
        for (Long cid : cidList) {
            CompanyVictimExceptionRec dbRec = (CompanyVictimExceptionRec)recMap.get(cid);
            Integer harmNum = cidHarmNumMap.get(cid);
            CompanyVictimExceptionRec rec = new CompanyVictimExceptionRec();
            rec.setEvaluateTime(new Date());
            rec.setPromiseVictim(harmNum);
            rec.setSysVictim(Integer.valueOf(1));
            rec.setCid(cid);
            rec.setIsCurr(Integer.valueOf(1));
            Integer currException = 0;
            if (harmNum != null && harmNum > 2) {
                currException = 1;
            }
            if (dbRec != null) {
                rec.setException(currException);
                rec.setId(dbRec.getId());
                result.add(rec);
                continue;
            }
            if (!Objects.equals(currException, 1)) continue;
            rec.setException(currException);
            result.add(rec);
        }
        if (CollectionUtils.isNotEmpty(result)) {
            ((ICompanyVictimExceptionRecService)SpringContextHolder.getBean(ICompanyVictimExceptionRecService.class)).saveVictimException(result);
        }
    }

    public List<CompanyExceptionListModel> listExceptionListModel(CompanyExceptionListParam param) {
        return ((CompanyVictimExceptionRecMapper)this.dao).listExceptionListModel(param);
    }

    public CompanyExceptionCountModel countExceptionListModel(CompanyExceptionListParam param) {
        return ((CompanyVictimExceptionRecMapper)this.dao).countExceptionListModel(param);
    }

    public PageInfo<CompanyExceptionListModel> pageExceptionListModel(JqGridParam page, CompanyExceptionListParam param) {
        PageHelper.startPage((int)page.getPage(), (int)page.getRows());
        List<CompanyExceptionListModel> companyExceptionListModels = this.listExceptionListModel(param);
        PageInfo pageR = new PageInfo(companyExceptionListModels);
        return pageR;
    }

    public CompanyExceptionListModel getExceptionModel(Long cid) {
        CompanyExceptionListParam param = new CompanyExceptionListParam();
        param.setCid(cid);
        List<CompanyExceptionListModel> companyExceptionListModels = this.listExceptionListModel(param);
        if (CollectionUtils.isNotEmpty(companyExceptionListModels)) {
            return companyExceptionListModels.get(0);
        }
        return null;
    }
}

