/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.exceptionlist;

import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.SpringContextHolder;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.enums.CompanyBaseChangeTypeEnum;
import cn.smarthse.modules.datacentre.model.supervise.CompanyBaseChangeInfo;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.health.supervise.dao.exceptionlist.CompanyBasechangeExceptionSumMapper;
import cn.smarthse.modules.health.supervise.entity.exceptionlist.CompanyBasechangeExceptionSum;
import cn.smarthse.modules.health.supervise.service.exceptionlist.ICompanyBasechangeExceptionSumService;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class CompanyBasechangeExceptionSumServiceImpl
extends BaseServiceImpl<CompanyBasechangeExceptionSumMapper, CompanyBasechangeExceptionSum>
implements ICompanyBasechangeExceptionSumService {
    public List<CompanyBasechangeExceptionSum> getCompanyBasechangeExceptionSum(List<Long> cids) {
        Example e = new Example(CompanyBasechangeExceptionSum.class);
        Example.Criteria criteria = e.createCriteria().andEqualTo("is_valid", (Object)true);
        if (CollectionUtils.isNotEmpty(cids)) {
            criteria.andIn("cid", cids);
        }
        return this.getListByExample(e);
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRES_NEW)
    public void batchSaveCompanyBasechangeExceptionSum(List<CompanyBasechangeExceptionSum> list, List<Long> cids) {
        Example e = new Example(CompanyBasechangeExceptionSum.class);
        if (CollectionUtils.isNotEmpty(cids)) {
            e.createCriteria().andIn("cid", cids);
        }
        ((CompanyBasechangeExceptionSumMapper)this.dao).deleteByExample(e);
        this.batchUpdateOrInsert(list, CompanyBasechangeExceptionSumMapper.class, (item, m) -> {
            if (item.getId() == null) {
                item.setCreateDate(new Date());
                item.setId(Long.valueOf(IdWorker.getId()));
                item.setUpdateDate(new Date());
                item.setIsValid(Boolean.valueOf(true));
                return m.insert(item);
            }
            item.setUpdateDate(new Date());
            return m.updateByPrimaryKeySelective(item);
        });
    }

    public List<CompanyBaseChangeInfo> listBusinessStateExceptionRecByCid(Long cid) {
        CompanyBaseChangeInfo param = new CompanyBaseChangeInfo();
        param.setCid(cid);
        List<CompanyBaseChangeInfo> companyBaseChangeInfos = ((CompanyBasechangeExceptionSumMapper)this.dao).listBusinessStateExceptionByCid(param);
        if (CollectionUtil.isNotEmpty(companyBaseChangeInfos)) {
            companyBaseChangeInfos.forEach(c -> {
                if (StringUtils.isNotEmpty((String)c.getRealName())) {
                    c.setOperators(c.getRealName());
                }
            });
        }
        return companyBaseChangeInfos;
    }

    public CompanySuperviseModel listBusinessStateByIrs(Long cid) {
        CompanySuperviseModel companyBaseChangeInfos = ((CompanyBasechangeExceptionSumMapper)this.dao).listBusinessStateByIrs(cid);
        return companyBaseChangeInfos;
    }

    public void calculateBusinessStateException(List<Long> cids) {
        List<CompanyBasechangeExceptionSum> currRecList = ((CompanyBasechangeExceptionSumMapper)this.dao).collectBusinessStateException(cids);
        if (CollectionUtils.isNotEmpty(currRecList)) {
            for (CompanyBasechangeExceptionSum rec : currRecList) {
                rec.setEvaluateTime(new Date());
                rec.setChangeType(CompanyBaseChangeTypeEnum.BUSINESS_STATE_CHANGE.getValue());
            }
        }
        ((ICompanyBasechangeExceptionSumService)SpringContextHolder.getBean(ICompanyBasechangeExceptionSumService.class)).batchSaveCompanyBasechangeExceptionSum(currRecList, cids);
    }
}

