/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.evaluate;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.health.supervise.dao.company.CompanyMapper;
import cn.smarthse.modules.health.supervise.dao.evaluate.SuperviseThirdEvaluateMapper;
import cn.smarthse.modules.health.supervise.dao.evaluate.ThirdEvaluateMapper;
import cn.smarthse.modules.health.supervise.entity.evaluate.ThirdEvaluateModel;
import cn.smarthse.modules.health.supervise.service.evaluate.IThirdEvaluateService;
import cn.smarthse.modules.health.supervise.vo.evaluate.EvaluateMaxTimeByOrgIdVo;
import cn.smarthse.services.hfi.api.entity.CheckOverPoint;
import cn.smarthse.services.hfi.api.model.grade.CompanyOccTypeVo;
import cn.smarthse.services.hfi.api.service.ICheckOverPointService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class ThirdEvaluateServiceImpl
extends BaseServiceImpl<CompanyMapper, Company>
implements IThirdEvaluateService {
    @Autowired
    private ThirdEvaluateMapper thirdEvaluateMapper;
    @Autowired
    private SuperviseThirdEvaluateMapper superviseThirdEvaluateMapper;
    @DubboReference
    private ICheckOverPointService checkOverPointService;

    public List<Map> collectFinishEvaluate(Long cid, int year, List<Integer> evaluateTypeList) {
        return this.thirdEvaluateMapper.collectFinishEvaluate(cid, year, evaluateTypeList);
    }

    public String collectFinishEvaluateStr(Long cid, int year) {
        List<Integer> evaluateTypeList = Arrays.asList(1);
        List<Map> thisYearEvaluateCount = this.collectFinishEvaluate(cid, year, evaluateTypeList);
        if (CollectionUtils.isNotEmpty(thisYearEvaluateCount)) {
            ArrayList<Long> checkPlanIdList = new ArrayList<Long>();
            for (Map evaluateCountMap : thisYearEvaluateCount) {
                Long checkplanId = MapUtils.getLong((Map)evaluateCountMap, (Object)"checkplan_id");
                if (checkplanId == null) continue;
                checkPlanIdList.add(checkplanId);
            }
            int overPoint = this.calcCheckOverPoint(checkPlanIdList);
            return String.format("\u5df2\u8fdb\u884c\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u73b0\u72b6\u8bc4\u4ef7\uff0c\u5176\u4e2d\u8d85\u6807\u70b9\u6570<strong class=\"ft18 red\">%d</strong>\u4e2a", overPoint);
        }
        return "\u672a\u8fdb\u884c\u804c\u4e1a\u75c5\u5371\u5bb3\u73b0\u72b6\u8bc4\u4ef7";
    }

    private int calcCheckOverPoint(List<Long> checkPlanIdList) {
        Map<Long, CheckOverPoint> checkOverPointMap;
        if (CollectionUtils.isEmpty(checkPlanIdList)) {
            return 0;
        }
        int notStandardPointCountByHcId = 0;
        List checkOverPointList = this.checkOverPointService.getByCheckIds(checkPlanIdList);
        if (CollectionUtils.isNotEmpty((Collection)checkOverPointList) && MapUtils.isNotEmpty(checkOverPointMap = checkOverPointList.stream().collect(Collectors.toMap(CheckOverPoint::getCheckId, m -> m, (k1, k2) -> k1)))) {
            for (Long checkPlanId : checkPlanIdList) {
                if (!checkOverPointMap.containsKey(checkPlanId)) continue;
                CheckOverPoint checkOverPoint = checkOverPointMap.get(checkPlanId);
                Integer overPoint = Optional.ofNullable(checkOverPoint).map(CheckOverPoint::getOverPoint).orElse(0);
                notStandardPointCountByHcId += overPoint.intValue();
            }
        }
        return notStandardPointCountByHcId;
    }

    public String collectFinishThirdTimeStr(Long cid, int year) {
        List<Integer> thredEvaluateTypeList = Arrays.asList(2, 3);
        List<Map> thisYearEvaluateCount = this.collectFinishEvaluate(cid, year, thredEvaluateTypeList);
        if (CollectionUtils.isNotEmpty(thisYearEvaluateCount)) {
            return String.format("\u5df2\u8fdb\u884c\u804c\u4e1a\u536b\u751f\u8bc4\u4ef7<strong class=\"ft18 red\">%d</strong>\u6b21", thisYearEvaluateCount.size());
        }
        return "\u672a\u8fdb\u884c\u804c\u4e1a\u536b\u751f\u8bc4\u4ef7";
    }

    public PageInfo<ThirdEvaluateModel> pageThirdEvaluate(JqGridParam gparam, Long cid, List<Integer> evaluateTypeList) {
        if (cid == null) {
            return null;
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<ThirdEvaluateModel> list = this.thirdEvaluateMapper.pageThirdEvaluate(cid, evaluateTypeList);
        return new PageInfo(list);
    }

    public Map<Long, Integer> countEvaluateUploadNum(Long[] evaluateOrgIdArr, List<Integer> evaluateTypeList, Integer year, Long areaId, Byte areaLevel) {
        if (CollectionUtils.isEmpty(evaluateTypeList) || evaluateOrgIdArr == null || evaluateOrgIdArr.length == 0) {
            return MapUtils.EMPTY_MAP;
        }
        List<Map> evaluateUploadNumList = this.thirdEvaluateMapper.countEvaluateUploadNum(evaluateOrgIdArr, year, evaluateTypeList, areaId, areaLevel);
        HashMap<Long, Integer> result = new HashMap<Long, Integer>();
        if (CollectionUtils.isNotEmpty(evaluateUploadNumList)) {
            for (Map evaluateUploadNum : evaluateUploadNumList) {
                result.put(MapUtils.getLong((Map)evaluateUploadNum, (Object)"evaluate_org_cid"), MapUtils.getInteger((Map)evaluateUploadNum, (Object)"num"));
            }
        }
        return result;
    }

    public Map<Long, Integer> countPreEvaluateNum(Long[] evaluateOrgIdArr, Integer year, Long areaId, Byte areaLevel) {
        ArrayList<Integer> evaluateTypeList = new ArrayList<Integer>();
        evaluateTypeList.add(2);
        return this.countEvaluateUploadNum(evaluateOrgIdArr, evaluateTypeList, year, areaId, areaLevel);
    }

    public Map<Long, Integer> countPreControllEvaluateNum(Long[] evaluateOrgIdArr, Integer year, Long areaId, Byte areaLevel) {
        ArrayList<Integer> evaluateTypeList = new ArrayList<Integer>();
        evaluateTypeList.add(2);
        evaluateTypeList.add(3);
        return this.countEvaluateUploadNum(evaluateOrgIdArr, evaluateTypeList, year, areaId, areaLevel);
    }

    public Map<Long, Integer> countNowEvaluateNum(Long[] evaluateOrgIdArr, Integer year, Long areaId, Byte areaLevel) {
        ArrayList<Integer> evaluateTypeList = new ArrayList<Integer>();
        evaluateTypeList.add(1);
        return this.countEvaluateUploadNum(evaluateOrgIdArr, evaluateTypeList, year, areaId, areaLevel);
    }

    public List<Long> listNowEvaluateOrgIds(Long areaId, Byte ownLevel) {
        ArrayList<Integer> evaluateTypeList = new ArrayList<Integer>();
        evaluateTypeList.add(1);
        return this.thirdEvaluateMapper.listUploadedOrgIdsByAreaId(areaId, evaluateTypeList, ownLevel);
    }

    public List<Long> listThirdTimeEvaluateOrgIds(Long areaId, Byte ownLevel) {
        ArrayList<Integer> evaluateTypeList = new ArrayList<Integer>();
        evaluateTypeList.add(2);
        evaluateTypeList.add(3);
        return this.thirdEvaluateMapper.listUploadedOrgIdsByAreaId(areaId, evaluateTypeList, ownLevel);
    }

    public List<EvaluateMaxTimeByOrgIdVo> listNowEvaOrgIdLastTime(Long areaId, List<Long> orgIdList) {
        ArrayList<Integer> evaluateTypeList = new ArrayList<Integer>();
        evaluateTypeList.add(1);
        List<EvaluateMaxTimeByOrgIdVo> maxTimeByOrgIdVoList = this.thirdEvaluateMapper.getEvaluateMaxTimeByOrgIDs(areaId, orgIdList, evaluateTypeList);
        return maxTimeByOrgIdVoList;
    }

    public List<EvaluateMaxTimeByOrgIdVo> listPreEvaOrgIdLastTime(Long areaId, List<Long> orgIdList) {
        ArrayList<Integer> evaluateTypeList = new ArrayList<Integer>();
        evaluateTypeList.add(2);
        List<EvaluateMaxTimeByOrgIdVo> maxTimeByOrgIdVoList = this.thirdEvaluateMapper.getEvaluateMaxTimeByOrgIDs(areaId, orgIdList, evaluateTypeList);
        return maxTimeByOrgIdVoList;
    }

    public Integer getLastOccTypeByCid(Long cid) {
        Integer lastOccType = this.superviseThirdEvaluateMapper.getLastOccTypeByCid(cid);
        if (lastOccType != null) {
            if (lastOccType == 3) {
                return 0;
            }
            if (lastOccType == 2) {
                return 1;
            }
            if (lastOccType == 1) {
                return 2;
            }
        }
        return null;
    }

    public int collectUploadNum4Area(Long areaId, Byte arealevel) {
        if (areaId == null || arealevel == null) {
            return 0;
        }
        return this.thirdEvaluateMapper.collectUploadNum4Area(areaId, arealevel);
    }

    public Map<Long, Integer> collectUploadNum4Org(Long areaId, Byte arealevel, List<Long> orgIdList) {
        if (areaId == null || arealevel == null) {
            return null;
        }
        List<Map<Long, Object>> mapList = this.thirdEvaluateMapper.collectUploadNum4Org(areaId, arealevel, orgIdList);
        if (CollectionUtils.isNotEmpty(mapList)) {
            HashMap<Long, Integer> map = new HashMap<Long, Integer>();
            for (Map<Long, Object> longIntegerMap : mapList) {
                Long evaluateOrgCid = MapUtils.getLong(longIntegerMap, (Object)"evaluateOrgCid");
                Integer num = MapUtils.getInteger(longIntegerMap, (Object)"num");
                map.put(evaluateOrgCid, num);
            }
            return map;
        }
        return null;
    }

    public List<Long> listEvaluateOrgIdListByArea(Long areaId, Byte arealevel) {
        return this.thirdEvaluateMapper.listEvaluateOrgIdListByArea(areaId, arealevel);
    }

    public Map<Long, CompanyOccTypeVo> listAllOccType() {
        List<CompanyOccTypeVo> evaluateThirdModels = this.superviseThirdEvaluateMapper.listAllOccType();
        if (CollectionUtils.isNotEmpty(evaluateThirdModels)) {
            Map<Long, CompanyOccTypeVo> collect = evaluateThirdModels.stream().filter(f -> f.getOccType() != null).collect(Collectors.toMap(CompanyOccTypeVo::getCid, v -> v, (v1, v2) -> v1));
            return collect;
        }
        return MapUtils.EMPTY_MAP;
    }
}

