/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.disease;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.base.disease.Disease;
import cn.smarthse.modules.health.entity.base.disease.DiseaseType;
import cn.smarthse.modules.health.supervise.dao.base.DiseaseThirdMapper;
import cn.smarthse.modules.health.supervise.service.disease.IDiseaseThirdService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class DiseaseThirdServiceImpl
extends BaseServiceImpl<DiseaseThirdMapper, Disease>
implements IDiseaseThirdService {
    public List<DiseaseType> listTypes() {
        return ((DiseaseThirdMapper)this.dao).listTypes();
    }

    public List<Disease> listDiseases(Integer tid, String searchKey, String isNotNeed) {
        return ((DiseaseThirdMapper)this.dao).listDiseases(tid, searchKey, isNotNeed);
    }

    public List<Disease> listDiseases(Integer id) {
        Example example = new Example(Disease.class);
        example.createCriteria().andEqualTo("id", (Object)id);
        return this.getListByExample(example);
    }

    public List<Disease> listDiseases(List<Integer> idList) {
        Example example = new Example(Disease.class);
        example.createCriteria().andIn("id", idList);
        return this.getListByExample(example);
    }

    public Disease getDiseaseByName(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return new Disease();
        }
        List<Disease> list = ((DiseaseThirdMapper)this.dao).getByName(name);
        if (list == null || list.isEmpty()) {
            return new Disease();
        }
        return list.get(0);
    }

    public Map<String, Integer> getAllDiseaseNameIdMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List<Disease> list = this.getAll();
        if (list == null || list.isEmpty()) {
            return map;
        }
        for (Disease l : list) {
            map.put(l.getDiseaseName(), l.getId());
        }
        return map;
    }

    private List<Disease> getAll() {
        Example example = new Example(Disease.class);
        List list = ((DiseaseThirdMapper)this.dao).selectByExample(example);
        return list;
    }

    public Map<String, Integer> getAllSuspectDiseaseNameIdMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List<Disease> list = this.getAll();
        if (list == null || list.isEmpty()) {
            return map;
        }
        for (Disease l : list) {
            if (!StringUtils.isNotEmpty((String)l.getDiseaseName())) continue;
            map.put("\u7591\u4f3c" + l.getDiseaseName(), l.getId());
        }
        return map;
    }
}

