/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.deviceMonitoring;

import cn.hutool.core.convert.Convert;
import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.bx.service.IBxFxhjService;
import cn.smarthse.modules.health.bx.service.IBxYszybService;
import cn.smarthse.modules.health.bx.service.IBxZybService;
import cn.smarthse.modules.health.entity.sys.SysLog;
import cn.smarthse.modules.health.onlineMonitoring.entity.device.OnlineMonitorDeviceFactor;
import cn.smarthse.modules.health.onlineMonitoring.entity.device.OnlineMonitorWarning;
import cn.smarthse.modules.health.onlineMonitoring.service.device.IOnlineMonitorDeviceFactorService;
import cn.smarthse.modules.health.onlineMonitoring.service.device.IOnlineMonitorWarningService;
import cn.smarthse.modules.health.onlineMonitoring.vo.OnlineDeviceCreditSupervise;
import cn.smarthse.modules.health.param.SearchParam;
import cn.smarthse.modules.health.supervise.dao.onlineMonitoring.OnlineDeviceMapper;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDevice;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDeviceCamera;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDeviceRealData;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDeviceVo;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineMonitoringAreaCount;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineMonitoringBigDataCountVo;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineMonitoringCount;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineMonitoringCountSearchVo;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineMonitoringDataVo;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineMonitoringDeviceStatistic;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineMonitoringOverDataVo;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.WarnTopDataVo;
import cn.smarthse.modules.health.supervise.enums.onlinedevice.DeviceTypeDataTypeEnum;
import cn.smarthse.modules.health.supervise.model.CameraImageResult;
import cn.smarthse.modules.health.supervise.model.OnlineDeviceParam;
import cn.smarthse.modules.health.supervise.model.home.v3223.onlineMonitoring.OnlineDeviceHomeData;
import cn.smarthse.modules.health.supervise.model.home.v3223.onlineMonitoring.PneumocoChartData;
import cn.smarthse.modules.health.supervise.model.home.v3223.onlineMonitoring.PneumocoInfo;
import cn.smarthse.modules.health.supervise.model.onlinemonitor.OnlineMonitoringDeviceModel;
import cn.smarthse.modules.health.supervise.model.onlinemonitor.OnlineMonitoringWarningModel;
import cn.smarthse.modules.health.supervise.model.onlinemonitor.WarnRateModel;
import cn.smarthse.modules.health.supervise.model.onlinemonitor.WarnRateParam;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceAiwarningService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceAlarmService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceCameraService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineMonitorDeviceBindService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.syncdata.OnlineRealDataAlarmServiceImpl;
import cn.smarthse.modules.health.supervise.service.sys.ISysLogThirdService;
import cn.smarthse.modules.health.supervise.task.onlinemonitor.CreditSuperviseTask;
import cn.smarthse.modules.health.supervise.vo.onlineMonitoring.MonitoringSearchVo;
import cn.smarthse.modules.health.supervise.vo.onlineMonitoring.OnlineMonitoringSearchVo;
import cn.smarthse.modules.health.supervise.vo.onlineMonitoring.device.OnlineDeviceBindVo;
import cn.smarthse.modules.health.supervise.vo.onlineMonitoring.device.OnlineDeviceStateVo;
import cn.smarthse.modules.health.supervise.vo.onlineMonitoring.device.OnlineDeviceUpdateNoVo;
import cn.smarthse.modules.health.vo.work.HomeIndexSearchVo;
import cn.smarthse.modules.uploader.FileResourceEnum;
import cn.smarthse.services.hfi.api.service.IFactorLimitValueService;
import cn.smarthse.util.common.StringUtils;
import cn.smarthse.util.common.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.BusinessException;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class OnlineDeviceServiceImpl
extends BaseServiceImpl<OnlineDeviceMapper, OnlineDevice>
implements IOnlineDeviceService {
    private List<OnlineDevice> dbOnlineDeviceList = new CopyOnWriteArrayList<OnlineDevice>();
    private ConcurrentHashMap<String, OnlineDevice> deviceNoMap = new ConcurrentHashMap();
    @DubboReference
    private IBxZybService bxZybService;
    @DubboReference
    private IBxYszybService yszybService;
    @DubboReference
    private IBxFxhjService bxFxhjService;
    @Autowired
    private ISysLogThirdService logService;
    @Autowired(required=false)
    protected OssClientBean ossClientBean;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @Autowired
    IOnlineDeviceCameraService onlineDeviceCameraService;
    @Autowired
    IOnlineDeviceAlarmService alarmService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaService;
    @DubboReference(version="1.0.0")
    private IHarmFactorService harmFactorService;
    @DubboReference
    private IFactorLimitValueService factorLimitValueService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @Autowired
    private IOnlineMonitorDeviceFactorService onlineMonitorDeviceFactorService;
    @Autowired
    @Lazy
    IOnlineMonitorWarningService onlineMonitorWarningService;
    @Autowired
    IOnlineDeviceAiwarningService onlineDeviceAiwarningService;
    @Autowired
    private IOnlineDeviceAlarmService onlineDeviceAlarmService;
    @Autowired
    private IOnlineMonitorDeviceBindService onlineMonitorDeviceBindService;
    @Autowired
    private OnlineRealDataAlarmServiceImpl dataAlarmService;
    @Autowired
    private CreditSuperviseTask creditSuperviseTask;
    @Autowired
    RedisClient redisClient;
    private final String ONLINE_DEVICE_LAST_REALDATA = "online_device_last_realdata";
    private HashMap<Integer, String> deviceTypeFactoryTyeMap = new HashMap<Integer, String>(){
        {
            this.put(1, "\u7c89\u5c18");
            this.put(0, "\u5316\u5b66\u56e0\u7d20");
            this.put(2, "\u7269\u7406\u56e0\u7d20");
            this.put(3, "\u7269\u7406\u56e0\u7d20");
            this.put(4, "\u7269\u7406\u56e0\u7d20");
            this.put(5, "\u653e\u5c04\u56e0\u7d20");
            this.put(6, "\u5176\u4ed6\u56e0\u7d20");
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public List<OnlineDevice> getCacheOnlineDeviceList(Long deviceId) {
        OnlineDevice onlineDevice;
        Object object;
        if (CollectionUtils.isEmpty(this.dbOnlineDeviceList)) {
            object = OnlineDeviceServiceImpl.class;
            // MONITORENTER : cn.smarthse.modules.health.supervise.service.deviceMonitoring.OnlineDeviceServiceImpl.class
            if (CollectionUtils.isEmpty(this.dbOnlineDeviceList)) {
                this.dbOnlineDeviceList = this.getListByExample(null);
            }
            // MONITOREXIT : object
        }
        if (!CollectionUtils.isNotEmpty(this.dbOnlineDeviceList)) {
            this.logger.info("\u8bbe\u5907\u8868\u4e2d\u65e0\u8bb0\u5f55...");
            return null;
        }
        if (deviceId == null) return this.dbOnlineDeviceList;
        object = this.dbOnlineDeviceList.iterator();
        do {
            if (!object.hasNext()) return null;
        } while (!deviceId.equals((onlineDevice = (OnlineDevice)object.next()).getId()));
        ArrayList<OnlineDevice> arrayList = new ArrayList<OnlineDevice>();
        arrayList.add(onlineDevice);
        return arrayList;
    }

    public PageInfo<OnlineDevice> getDeviceInfoPage(JqGridParam param, Long areaId, Byte areaLevel, OnlineDevice device) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<OnlineDevice> list = ((OnlineDeviceMapper)this.dao).getDeviceInfoPage(areaId, areaLevel, device);
        for (OnlineDevice de : list) {
            if (de.getAreaId() == null) continue;
            String areaName = this.sysAreaService.getFullName(de.getAreaId(), ">");
            de.setAreaName(areaName);
        }
        return new PageInfo(list);
    }

    public List<OnlineMonitoringCount> getDeviceCompanyList(Long areaId, Byte areaLevel) {
        List<OnlineMonitoringCount> list = ((OnlineDeviceMapper)this.dao).getDeviceCompanyList(areaId, areaLevel);
        List<OnlineDevice> deviceList = ((OnlineDeviceMapper)this.dao).getDeviceInfoPage(areaId, areaLevel, new OnlineDevice());
        Map<Object, Object> onlineDeviceMap = new HashMap();
        if (CollectionUtils.isNotEmpty(deviceList)) {
            onlineDeviceMap = deviceList.stream().collect(Collectors.groupingBy(k -> k.getCid().toString() + k.getType().toString()));
        }
        if (list != null && list.size() > 0) {
            for (OnlineMonitoringCount com : list) {
                Long cid = com.getCid();
                com.setDustDevice((List)onlineDeviceMap.getOrDefault(cid + "1", new ArrayList()));
                com.setNoiseDevice((List)onlineDeviceMap.getOrDefault(cid + "2", new ArrayList()));
                com.setCameraDevice((List)onlineDeviceMap.getOrDefault(cid + "3", new ArrayList()));
                com.setChemistryDevice((List)onlineDeviceMap.getOrDefault(cid + "0", new ArrayList()));
            }
        }
        return list;
    }

    public List<OnlineMonitoringAreaCount> getDevicNumList(OnlineMonitoringCountSearchVo searchVo) {
        List<OnlineMonitoringAreaCount> list = ((OnlineDeviceMapper)this.dao).getDevicNumList(searchVo);
        return list;
    }

    public List<OnlineDevice> getHomeDeviceList(Long areaId, Byte areaLevel) {
        OnlineDevice device = new OnlineDevice();
        PageHelper.startPage((int)1, (int)10);
        List<OnlineDevice> list = ((OnlineDeviceMapper)this.dao).getDeviceInfoPage(areaId, areaLevel, device);
        return list;
    }

    public OnlineMonitoringCount getDeviceInfoByCid(Long cid) {
        OnlineMonitoringCount info = new OnlineMonitoringCount();
        info.setCid(cid);
        OnlineDevice param = new OnlineDevice();
        param.setCid(cid);
        param.setType("1");
        List<OnlineDevice> dustDevice = ((OnlineDeviceMapper)this.dao).getDeviceInfoPage(null, null, param);
        OnlineDevice param2 = new OnlineDevice();
        param2.setCid(cid);
        param2.setType("2");
        List<OnlineDevice> noiseDevice = ((OnlineDeviceMapper)this.dao).getDeviceInfoPage(null, null, param2);
        info.setDustDevice(dustDevice);
        info.setNoiseDevice(noiseDevice);
        return info;
    }

    public OnlineDevice getDetailInfoById(Long id) {
        return ((OnlineDeviceMapper)this.dao).getDetailInfoById(id);
    }

    public Boolean isHaveOnlineMonitoringByCid(Long cid) {
        if (cid == null) {
            return false;
        }
        OnlineDevice param = new OnlineDevice();
        param.setCid(cid);
        List<OnlineDevice> list = ((OnlineDeviceMapper)this.dao).getDeviceInfoPage(null, null, param);
        if (list != null && list.size() > 0) {
            return true;
        }
        return false;
    }

    public List<OnlineDevice> getDeviceListInfoByCid(Long cid) {
        if (cid == null) {
            return null;
        }
        OnlineDevice param = new OnlineDevice();
        param.setCid(cid);
        List<OnlineDevice> list = ((OnlineDeviceMapper)this.dao).getDeviceInfoPage(null, null, param);
        return list;
    }

    public List<OnlineDevice> getExportList(Long areaId, Byte level, OnlineDevice searchVo) {
        List<OnlineDevice> list = ((OnlineDeviceMapper)this.dao).getDeviceInfoPage(areaId, level, searchVo);
        if (list != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            for (OnlineDevice device : list) {
                device.settingTypeStr();
                if (device.getStatus() != null) {
                    if (device.getStatus() == 0) {
                        device.setStatusStr("\u6b63\u5e38");
                    } else if (device.getStatus() == 1) {
                        device.setStatusStr("\u62a5\u8b66");
                    } else {
                        device.setStatusStr("\u79bb\u7ebf");
                    }
                }
                if (device.getLatestAlarmDate() == null) continue;
                device.setLastAlarmTimeStr(dateFormat.format(device.getLatestAlarmDate()));
            }
        }
        return list;
    }

    public List<OnlineMonitoringDataVo> getDeviceDate(OnlineMonitoringSearchVo param) {
        return ((OnlineDeviceMapper)this.dao).getDeviceMOnitoringDate(param);
    }

    public List<OnlineDevice> getDevicesByCamera(Long cameraId) {
        Example example = new Example(OnlineDeviceCamera.class);
        example.createCriteria().andEqualTo("cameraId", (Object)cameraId).andEqualTo("isValid", (Object)true);
        List deviceCameras = this.onlineDeviceCameraService.getListByExample(example);
        if (deviceCameras != null) {
            return deviceCameras.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<OnlineDeviceCamera>(Comparator.comparing(OnlineDeviceCamera::getDeviceId))), ArrayList::new)).stream().map(s -> (OnlineDevice)this.getById(s.getDeviceId())).collect(Collectors.toList());
        }
        return null;
    }

    public List<OnlineDevice> getCamerasByDevice(Long deviceId) {
        Example example = new Example(OnlineDeviceCamera.class);
        example.createCriteria().andEqualTo("deviceId", (Object)deviceId).andEqualTo("isValid", (Object)true);
        List deviceCameras = this.onlineDeviceCameraService.getListByExample(example);
        if (deviceCameras != null && deviceCameras.size() > 0) {
            List<OnlineDevice> collect = deviceCameras.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<OnlineDeviceCamera>(Comparator.comparing(OnlineDeviceCamera::getCameraId))), ArrayList::new)).stream().map(s -> {
                OnlineDeviceParam param = new OnlineDeviceParam();
                param.setId(s.getCameraId());
                return this.getDeviceInfoByParam(param);
            }).collect(Collectors.toList());
            collect.removeAll(Collections.singleton(null));
            return collect;
        }
        return null;
    }

    public Map<Long, Set<Long>> getDeviceId4CameraIdMap() {
        Example example = new Example(OnlineDeviceCamera.class);
        example.createCriteria().andEqualTo("isValid", (Object)true);
        List deviceCameras = this.onlineDeviceCameraService.getListByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)deviceCameras)) {
            Map<Long, Set<Long>> mapData = deviceCameras.stream().collect(Collectors.groupingBy(OnlineDeviceCamera::getDeviceId, Collectors.mapping(f -> f.getCameraId(), Collectors.toSet())));
            return mapData;
        }
        return new ConcurrentHashMap<Long, Set<Long>>();
    }

    @Transactional(readOnly=false)
    public void updateDeviceInfo(OnlineDevice info, Long loginUserId) {
        this.update(info, loginUserId);
        this.dbOnlineDeviceList = null;
        this.alarmService.clearAlarmCacheByAlarm(info);
    }

    public List<OnlineMonitoringOverDataVo> getDeviceOverDateCount(Long deviceId) {
        return ((OnlineDeviceMapper)this.dao).getDeviceOverDateCount(deviceId);
    }

    public List<OnlineMonitoringOverDataVo> getDeviceOverDateCountV317(OnlineMonitoringSearchVo vo) {
        return ((OnlineDeviceMapper)this.dao).getDeviceOverDateCountV317(vo);
    }

    public List<OnlineMonitoringBigDataCountVo> getDeviceBigMoreDateCount(Long deviceId) {
        return ((OnlineDeviceMapper)this.dao).getDeviceBigMoreDateCount(deviceId);
    }

    public List<OnlineMonitoringBigDataCountVo> getDeviceBigMoreDateCountV317(OnlineMonitoringSearchVo vo) {
        return ((OnlineDeviceMapper)this.dao).getDeviceBigMoreDateCountV317New(vo);
    }

    public List<OnlineDevice> getDtuListByCameraId(Long CameraId) {
        Example example = new Example(OnlineDeviceCamera.class);
        example.createCriteria().andEqualTo("cameraId", (Object)CameraId).andEqualTo("isValid", (Object)true);
        List listByExample = this.onlineDeviceCameraService.getListByExample(example);
        List deviceIds = listByExample.stream().map(item -> item.getDeviceId()).collect(Collectors.toList());
        Object ids = "";
        for (Long deviceId : deviceIds) {
            ids = (String)ids + deviceId + ",";
        }
        List listByIds = this.getListByIds((String)ids);
        List<OnlineDevice> collect = listByIds.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getType()) && StringUtils.contains((CharSequence)item.getType(), (CharSequence)"4")).collect(Collectors.toList());
        return collect;
    }

    public OnlineDevice getByDeviceNo(String deviceNo, Long cid) {
        List list;
        Example example = new Example(OnlineDevice.class);
        Example.Criteria criteria = example.createCriteria().andEqualTo("deviceNo", (Object)deviceNo).andEqualTo("isValid", (Object)true);
        if (cid != null) {
            criteria.andEqualTo("cid", (Object)cid);
        }
        return (list = this.getListByExample(example)) != null && !list.isEmpty() ? (OnlineDevice)list.get(0) : null;
    }

    public OnlineDevice getCacheByDeviceNo(String deviceNo, Long cid) {
        if (StringUtils.isBlank((CharSequence)deviceNo)) {
            return null;
        }
        OnlineDevice onlineDevice = this.deviceNoMap.computeIfAbsent(deviceNo + cid, v -> {
            OnlineDevice byDeviceNo = this.getByDeviceNo(deviceNo, cid);
            return byDeviceNo;
        });
        return onlineDevice;
    }

    public List<WarnTopDataVo> getWarnTopComList(Long areaId, Byte level) {
        return ((OnlineDeviceMapper)this.dao).getWarnTopComList(areaId, level);
    }

    public List<WarnTopDataVo> getWarnTopAreaList(Long areaId, Byte level) {
        return ((OnlineDeviceMapper)this.dao).getWarnTopAreaList(areaId, level);
    }

    public Boolean isHaveOnlineCameraByCid(long cid) {
        if (Objects.isNull(cid)) {
            return false;
        }
        OnlineDevice param = new OnlineDevice();
        param.setCid(Long.valueOf(cid));
        List<OnlineDevice> list = ((OnlineDeviceMapper)this.dao).getDeviceInfoPage(null, null, param);
        List collect = list.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getType()) && StringUtils.contains((CharSequence)item.getType(), (CharSequence)"3")).collect(Collectors.toList());
        if (collect != null && collect.size() > 0) {
            return true;
        }
        return false;
    }

    public Integer getDeviceNumByArea(Long areaId, Byte level, Boolean isBelongType) {
        return ((OnlineDeviceMapper)this.dao).getDeviceNumByArea(areaId, level, isBelongType);
    }

    public Integer getDeviceNumByAreaAndDeviceType(Long areaId, Byte level, Boolean isBelongType, Integer type) {
        return ((OnlineDeviceMapper)this.dao).getDeviceNumByAreaAndDeviceType(areaId, level, isBelongType, type);
    }

    public Integer getDeviceAlarmNumByArea(Long areaId, Byte level, Boolean isBelongType) {
        return ((OnlineDeviceMapper)this.dao).getDeviceAlarmNumByArea(areaId, level, isBelongType);
    }

    private CameraImageResult uploadFile(CameraImageResult result) throws IOException {
        String fileName = result.getTempFileName();
        File obj = new File(fileName);
        Long time = 500L;
        while (!obj.exists()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if ((time = Long.valueOf(time + 500L)) < 5000L) continue;
            this.logger.warn("ffmpeg\u622a\u56fe\u4e0d\u5b58\u5728:{}", (Object)obj.getAbsolutePath());
            return result;
        }
        String ossPath = "camera/capture";
        SysFileModel file = new SysFileModel();
        String[] arr = fileName.split("\\=");
        String oss = this.ossClientBean.OSSPutObject(String.valueOf(UUID.randomUUID()) + "." + arr[arr.length - 1], obj, ossPath, fileName, null);
        file.setFileName(fileName);
        file.setResource(Integer.valueOf(FileResourceEnum.companyHealth_07.getValue()));
        file.setFileSize(FileUtils.byteCountToDisplaySize((long)FileUtils.sizeOf((File)obj)));
        if (fileName.contains(".")) {
            file.setFileExt(fileName.substring(fileName.lastIndexOf(".") + 1));
        }
        file.setFileHash("" + FileUtils.checksumCRC32((File)obj));
        file.setOssUrl(oss);
        file.setDescription("");
        file = this.sysFileProvideService.addSysFile(file, Long.valueOf(0L));
        result.setFileId(file.getId());
        return result;
    }

    private CameraImageResult isMaskDidi(CameraImageResult cameraImageResult) {
        String api = "http://ai-tech.apigw-gz.didiyunapi.com/kouzhaodetectcomm?appname=com.didi.face-detection-mask.ddy-phone&amp;pid=200152301&is_position=1";
        String tempFileName = cameraImageResult.getTempFileName();
        File file = new File(tempFileName);
        if (!file.exists()) {
            this.logger.warn("\u53e3\u7f69\u4f69\u6234\u8bc6\u522b,\u56fe\u7247\u4e0d\u5b58\u5728:{}", (Object)file.getAbsolutePath());
            return cameraImageResult;
        }
        this.logger.info("\u56fe\u7247\u8def\u5f84{}", (Object)file.getAbsolutePath());
        try {
            FileInputStream inputStream = new FileInputStream(file);
            byte[] src = new byte[((InputStream)inputStream).available()];
            ((InputStream)inputStream).read(src);
            String base64 = Base64.getEncoder().encodeToString(src);
            ((InputStream)inputStream).close();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("image", (Object)base64);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "AppCode  ACDDo8xS5YNGtswRcNbsbVoaeg3MT1ET");
            String s = HttpUtil.doPostString((String)api, (String)jsonObject.toJSONString(), headers, (String)"utf-8");
            this.addLog("\u53e3\u7f69\u8bc6\u522b\u63a5\u53e3\u8fd4\u56de", s);
            JSONObject obj = JSON.parseObject((String)s);
            JSONObject data = obj.getJSONObject("data");
            JSONArray candidate = data.getJSONArray("candidate");
            for (int i = 0; i < candidate.size(); ++i) {
                cameraImageResult.setMask(Boolean.valueOf(true));
                JSONObject c = candidate.getJSONObject(i);
                Integer mask = c.getInteger("mask");
                if (!mask.equals(-1)) continue;
                cameraImageResult.setMask(Boolean.valueOf(false));
                return cameraImageResult;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cameraImageResult;
    }

    private void addLog(String title, String params) {
        SysLog sysLog = new SysLog();
        sysLog.setType(Byte.valueOf((byte)0));
        sysLog.setLogSource(Byte.valueOf((byte)1));
        sysLog.setTitle(title);
        sysLog.setParams(params);
        this.logService.add((Object)sysLog);
    }

    @Transactional(readOnly=false)
    public OnlineDeviceVo saveOrUpdateDevice(OnlineDeviceVo onlineDevice) throws BusinessException {
        if (onlineDevice != null) {
            this.dbOnlineDeviceList = null;
            OnlineDevice device = new OnlineDevice();
            BeanUtils.copyProperties((Object)onlineDevice, (Object)device);
            OnlineDevice dbDevice = null;
            if (StringUtils.isNotBlank((CharSequence)onlineDevice.getDeviceId())) {
                dbDevice = (OnlineDevice)this.getById(Long.parseLong(onlineDevice.getDeviceId()));
                if (dbDevice == null) {
                    throw new BusinessException("\u627e\u4e0d\u5230\u8bbe\u5907id:" + onlineDevice.getDeviceId() + "\u7684\u6570\u636e");
                }
                this.deviceNoMap.remove(dbDevice.getDeviceNo() + dbDevice.getCid());
            } else if (StringUtils.isNotBlank((CharSequence)onlineDevice.getDeviceNo())) {
                dbDevice = this.getByDeviceNo(onlineDevice.getDeviceNo(), onlineDevice.getCid());
                this.deviceNoMap.remove(onlineDevice.getDeviceNo() + onlineDevice.getCid());
            }
            device.setUpdateDate(new Date());
            device.setUpdateBy(onlineDevice.getCreateBy());
            device.setDataSource(Integer.valueOf(2));
            device.setType(onlineDevice.getDeviceType());
            device.setPosition(onlineDevice.getInstallAddress());
            device.setVideoAddress(onlineDevice.getOnlineView());
            if (dbDevice != null) {
                if (!Objects.equals(dbDevice.getCid(), device.getCid())) {
                    throw new HealthException("\u4f01\u4e1a\u4e0e\u8bbe\u5907\u6240\u5c5e\u4f01\u4e1a\u4e0d\u5339\u914d\uff01");
                }
                this.onlineMonitorDeviceFactorService.delByDeviceId(dbDevice.getId());
                device.setId(dbDevice.getId());
                device.setCid(null);
                if (StringUtils.isBlank((CharSequence)onlineDevice.getDeviceId())) {
                    device.setDeviceNo(null);
                }
                this.update(device, null);
                onlineDevice.setDeviceId("" + device.getId());
                this.onlineMonitorDeviceFactorService.clearCacheByDeviceId(device.getId());
            } else {
                device.setCreateBy(onlineDevice.getCreateBy());
                device.setCreateDate(new Date());
                device = this.add(device, null, onlineDevice.getCid());
                onlineDevice.setDeviceId("" + device.getId());
            }
            this.creditSuperviseTask.updateCreditSupervise(Arrays.asList(onlineDevice.getCid()));
            List deviceTypeFactorIdList = onlineDevice.getDeviceTypeFactorIdList();
            if (CollectionUtils.isNotEmpty((Collection)deviceTypeFactorIdList)) {
                Map<Integer, String> deviceTypeFactorIdMap = deviceTypeFactorIdList.stream().collect(Collectors.toMap(k -> k.getDeviceType(), v -> v.getHarmFactorIds()));
                Set<Integer> deviceTypeSet = deviceTypeFactorIdMap.keySet();
                for (Integer deviceTypeItem : deviceTypeSet) {
                    String harmFactorIds = deviceTypeFactorIdMap.get(deviceTypeItem);
                    List harmIdList = CommonUtil.str2LongList((String)harmFactorIds);
                    List harmByIds = this.harmFactorService.getHarmByIds(harmFactorIds);
                    HashSet<Long> harmIdSet = new HashSet<Long>();
                    HashSet<String> factorTypeSet = new HashSet<String>();
                    String factorType = this.deviceTypeFactoryTyeMap.get(deviceTypeItem);
                    factorTypeSet.add(factorType);
                    if (CollectionUtils.isNotEmpty((Collection)harmByIds)) {
                        for (HarmFactor harmById : harmByIds) {
                            if (!factorTypeSet.contains(harmById.getType())) {
                                throw new HealthException("\u8bbe\u5907\u7c7b\u578b\u4e0e\u5371\u5bb3\u56e0\u7d20\u4e0d\u5339\u914d");
                            }
                            harmIdSet.add(harmById.getId());
                        }
                    }
                    for (Long harmId : harmIdList) {
                        Integer[] dataTypeArr;
                        if (!harmIdSet.contains(harmId)) {
                            throw new HealthException("\u5371\u5bb3\u56e0\u7d20\u3010" + harmId + "\u3011\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9");
                        }
                        if (Objects.equals(deviceTypeItem, 1)) {
                            OnlineMonitorDeviceFactor onlineMonitorDeviceFactor;
                            String containsZongHu = this.containsZongHu(harmId);
                            if (containsZongHu.contains("1") || StringUtils.isBlank((CharSequence)containsZongHu)) {
                                onlineMonitorDeviceFactor = new OnlineMonitorDeviceFactor();
                                onlineMonitorDeviceFactor.setFactorId(harmId);
                                onlineMonitorDeviceFactor.setDeviceId(device.getId());
                                onlineMonitorDeviceFactor.setDataType(Integer.valueOf(1002));
                                onlineMonitorDeviceFactor.setCreateDate(new Date());
                                this.onlineMonitorDeviceFactorService.add((Object)onlineMonitorDeviceFactor, null, null);
                            }
                            if (!containsZongHu.contains("2")) continue;
                            onlineMonitorDeviceFactor = new OnlineMonitorDeviceFactor();
                            onlineMonitorDeviceFactor.setFactorId(harmId);
                            onlineMonitorDeviceFactor.setDeviceId(device.getId());
                            onlineMonitorDeviceFactor.setDataType(Integer.valueOf(1003));
                            onlineMonitorDeviceFactor.setCreateDate(new Date());
                            this.onlineMonitorDeviceFactorService.add((Object)onlineMonitorDeviceFactor, null, null);
                            continue;
                        }
                        for (Integer dataType : dataTypeArr = DeviceTypeDataTypeEnum.getDataType((Integer)deviceTypeItem)) {
                            OnlineMonitorDeviceFactor onlineMonitorDeviceFactor = new OnlineMonitorDeviceFactor();
                            onlineMonitorDeviceFactor.setFactorId(harmId);
                            onlineMonitorDeviceFactor.setDeviceId(device.getId());
                            onlineMonitorDeviceFactor.setDataType(dataType);
                            onlineMonitorDeviceFactor.setCreateDate(new Date());
                            this.onlineMonitorDeviceFactorService.add((Object)onlineMonitorDeviceFactor, null, null);
                        }
                    }
                }
            }
        }
        return onlineDevice;
    }

    public String containsZongHu(Long factorId) {
        StringBuffer result = new StringBuffer();
        List factorLimitKeys = this.factorLimitValueService.getFactorLimitKeys(factorId);
        if (CollectionUtils.isNotEmpty((Collection)factorLimitKeys)) {
            if (factorLimitKeys.contains("twa_total")) {
                result.append("1");
            }
            if (factorLimitKeys.contains("twa_respirabel")) {
                result.append("2");
            }
            return result.toString();
        }
        return "";
    }

    public List<OnlineDevice> getDetailInfoListById(Long id) {
        return ((OnlineDeviceMapper)this.dao).getDetailInfoListById(id);
    }

    public boolean hasExitTwo(Long id) {
        List<OnlineDeviceRealData> list = ((OnlineDeviceMapper)this.dao).getDataTypeByDeviceId(id);
        return list.size() > 1;
    }

    public Map<String, String> getTypes() {
        List<Map<String, String>> typeList = ((OnlineDeviceMapper)this.dao).getTypes();
        return this.converMap(typeList);
    }

    public PageInfo<OnlineMonitoringDeviceModel> getOnlineMonitoringDeviceList(JqGridParam param, MonitoringSearchVo vo) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<OnlineMonitoringDeviceModel> list = ((OnlineDeviceMapper)this.dao).getOnlineMonitoringDeviceList(vo);
        HashMap<String, String> deviceLastRealDataMap = new HashMap<String, String>();
        for (OnlineMonitoringDeviceModel model : list) {
            this.settingValue(model, deviceLastRealDataMap);
        }
        return new PageInfo(list);
    }

    private String generateKey2(OnlineDeviceRealData model) {
        Long deviceId = model.getDeviceId();
        Long factorId = model.getFactorId();
        Integer dataType1 = model.getDataType();
        return (deviceId == null ? "" : deviceId.toString()) + (factorId == null ? "" : factorId.toString()) + (dataType1 == null ? "" : dataType1.toString());
    }

    private String generateKey(OnlineMonitoringDeviceModel model) {
        Long deviceId = model.getId();
        Long factorId = model.getFactorId();
        String dataType1 = model.getDataType();
        return (deviceId == null ? "" : deviceId.toString()) + (factorId == null ? "" : factorId.toString()) + (dataType1 == null ? "" : dataType1.toString());
    }

    private void settingValue(OnlineMonitoringDeviceModel model, Map<String, String> deviceLastRealDataMap) {
        if (model.getFactorId() != null) {
            String overLimit;
            String unit = "";
            unit = Objects.equals(model.getType(), "2") ? "dB(A)" : "mg/m\u00b3";
            String mapKey = this.generateKey(model);
            String realData = deviceLastRealDataMap.get(mapKey);
            if (realData != null) {
                model.setEarlyWarning(realData);
            } else {
                Object o = this.redisClient.hget("online_device_last_realdata", mapKey);
                if (o != null) {
                    model.setEarlyWarning(Convert.toStr((Object)o) + unit);
                }
            }
            Object fid2 = String.valueOf(model.getFactorId());
            Integer dataType = null;
            if (StringUtils.isNotEmpty((String)model.getDataType())) {
                fid2 = (String)fid2 + "-" + model.getDataType();
                if ("1002".equals(model.getDataType())) {
                    model.setFactorName(model.getFactorName() + "-\u603b\u5c18");
                } else if ("1003".equals(model.getDataType())) {
                    model.setFactorName(model.getFactorName() + "-\u547c\u5c18");
                }
                if (StringUtils.isNumber((String)model.getDataType())) {
                    dataType = Integer.parseInt(model.getDataType());
                }
            }
            if (StringUtils.isEmpty((CharSequence)model.getAlarmVdata()) && StringUtils.isNotEmpty((String)(overLimit = this.dataAlarmService.getOverLimitByFactorId(model.getFactorId(), dataType)))) {
                model.setAlarmVdata(overLimit + unit);
            }
        }
    }

    private void settingExportValue(OnlineMonitoringDeviceModel model, Map<String, OnlineMonitoringWarningModel> dataMap, Map<String, OnlineMonitoringWarningModel> map) {
        if (model.getFactorId() != null) {
            OnlineMonitoringWarningModel warningModel;
            String unit = "";
            unit = model.getType() == "2" ? "dB(A)" : "mg/m\u00b3";
            String fid = String.valueOf(model.getId());
            OnlineMonitoringWarningModel deviceDataViewModel = map.get(fid);
            if (deviceDataViewModel != null) {
                model.setEarlyWarning(deviceDataViewModel.getEarlyWarning() + unit);
            }
            Object fid2 = String.valueOf(model.getFactorId());
            if (StringUtils.isNotEmpty((String)model.getDataType())) {
                fid2 = (String)fid2 + "-" + model.getDataType();
                if ("1002".equals(model.getDataType())) {
                    model.setFactorName(model.getFactorName() + "-\u603b\u5c18");
                } else if ("1003".equals(model.getDataType())) {
                    model.setFactorName(model.getFactorName() + "-\u547c\u5c18");
                }
            }
            if (StringUtils.isEmpty((CharSequence)model.getAlarmVdata()) && (warningModel = dataMap.get(fid2)) != null) {
                model.setAlarmVdata(warningModel.getEarlyWarning() + unit);
            }
        }
        if (model.getLatestAlarmDate() != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm");
            model.setLatestAlarmDateStr(format.format(model.getLatestAlarmDate()));
        }
    }

    public List<OnlineMonitoringDeviceModel> getDeviceList(MonitoringSearchVo vo) {
        if (vo == null) {
            return new ArrayList<OnlineMonitoringDeviceModel>();
        }
        List<OnlineMonitoringDeviceModel> list = ((OnlineDeviceMapper)this.dao).getOnlineMonitoringDeviceList(vo);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<OnlineMonitoringDeviceModel>();
        }
        for (OnlineMonitoringDeviceModel onlineMonitoringDeviceModel : list) {
            this.settingValue(onlineMonitoringDeviceModel, new HashMap<String, String>());
        }
        return list;
    }

    public OnlineDevice getDeviceInfoByParam(OnlineDeviceParam param) {
        List<OnlineDevice> deviceInfoByParam = ((OnlineDeviceMapper)this.dao).getDeviceInfoByParam(param);
        if (CollectionUtils.isNotEmpty(deviceInfoByParam)) {
            List warns;
            OnlineDevice info = deviceInfoByParam.get(0);
            if (StringUtils.isEmpty((CharSequence)info.getThreshold()) && CollectionUtils.isNotEmpty((Collection)(warns = this.onlineMonitorWarningService.getByFactorIdDataType(info.getFactorId(), info.getDataType())))) {
                info.setThreshold(((OnlineMonitorWarning)warns.get(0)).getEarlyWarning());
            }
            return info;
        }
        return null;
    }

    public List<String> checkAll(MonitoringSearchVo vo) {
        return ((OnlineDeviceMapper)this.dao).checkAll(vo);
    }

    @Transactional(readOnly=false)
    public int updateDeviceNo(OnlineDeviceUpdateNoVo onlineDevice) throws BusinessException {
        Example e2 = new Example(OnlineDevice.class);
        e2.createCriteria().andEqualTo("deviceNo", (Object)onlineDevice.getNewDeviceNo()).andEqualTo("isValid", (Object)true);
        int countByExample = this.getCountByExample(e2);
        if (countByExample > 0) {
            throw new BusinessException(String.format("\u5df2\u5b58\u5728\u8bbe\u5907\u7f16\u53f7\uff1a%s", onlineDevice.getNewDeviceNo()));
        }
        Example e = new Example(OnlineDevice.class);
        e.createCriteria().andEqualTo("deviceNo", (Object)onlineDevice.getDeviceNo()).andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)onlineDevice.getCid());
        OnlineDevice result = new OnlineDevice();
        result.setUpdateDate(new Date());
        result.setUpdateBy(onlineDevice.getUpdateBy());
        result.setDeviceNo(onlineDevice.getNewDeviceNo());
        return ((OnlineDeviceMapper)this.dao).updateByExampleSelective(result, e);
    }

    private Map<String, String> converMap(List<Map<String, String>> typeList) {
        HashMap<String, String> converMap = new HashMap<String, String>();
        if (typeList == null) {
            return converMap;
        }
        for (Map<String, String> map : typeList) {
            converMap.put(map.get("type"), map.get("typeName"));
        }
        return converMap;
    }

    @Transactional(readOnly=false)
    public void updateOnlineDeviceData() {
        Object dids;
        List<OnlineDeviceRealData> lastRealData;
        Map<String, OnlineMonitoringDeviceStatistic> statisticMap = ((OnlineDeviceMapper)this.dao).getAllOnlineDeviceStatisticData();
        ArrayList<OnlineMonitoringDeviceStatistic> statisticList = new ArrayList<OnlineMonitoringDeviceStatistic>();
        Calendar calendar = Calendar.getInstance();
        List<OnlineMonitoringDeviceModel> list = ((OnlineDeviceMapper)this.dao).getAllOnlineMonitoringDeviceList();
        Map<String, String> deviceLastRealDataMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(list) && CollectionUtils.isNotEmpty(lastRealData = ((OnlineDeviceMapper)this.dao).getDeviceLastRealData((List<Long>)(dids = list.stream().map(OnlineMonitoringDeviceModel::getId).collect(Collectors.toList()))))) {
            deviceLastRealDataMap = lastRealData.stream().collect(Collectors.toMap(k -> this.generateKey2((OnlineDeviceRealData)k), v -> v.getVData(), (v1, v2) -> v1));
        }
        for (OnlineMonitoringDeviceModel model : list) {
            OnlineMonitoringDeviceStatistic statistic;
            this.settingValue(model, deviceLastRealDataMap);
            OnlineMonitoringDeviceStatistic m = new OnlineMonitoringDeviceStatistic();
            BeanUtils.copyProperties((Object)model, (Object)m, (String[])new String[]{"id"});
            m.setId(Long.valueOf(this.idworker.nextId()));
            m.setDeviceId(model.getId());
            if (model.getDeviceAccessTime() != null) {
                calendar.setTime(model.getDeviceAccessTime());
                m.setDataYear(Integer.valueOf(calendar.get(1)));
            }
            m.setCreateDate(new Date());
            m.setUpdateDate(new Date());
            Object key = String.valueOf(m.getDeviceId());
            if (m.getFactorId() != null) {
                key = (String)key + "-" + m.getFactorId();
            }
            if (m.getDataType() != null) {
                key = (String)key + "-" + m.getDataType();
            }
            if (m.equals((Object)(statistic = statisticMap.get(key)))) continue;
            if (statistic != null) {
                m.setDataYear(Integer.valueOf(LocalDateTime.now().getYear()));
            }
            statisticList.add(m);
        }
        int maxSize = 500;
        int page = (int)Math.ceil((double)statisticList.size() * 1.0 / (double)maxSize);
        for (int i = 0; i < page; ++i) {
            List<OnlineMonitoringDeviceStatistic> collect = statisticList.stream().skip(i * maxSize).limit(maxSize).collect(Collectors.toList());
            ((OnlineDeviceMapper)this.dao).insertOnlineDeviceData(collect);
        }
    }

    @Transactional(readOnly=false)
    public void bindDevice(OnlineDeviceBindVo deviceBindVo, Long cid, Long createBy) throws BusinessException {
        this.onlineMonitorDeviceBindService.bind(deviceBindVo, cid, createBy);
    }

    public OnlineDeviceHomeData getHomeSuperviseLaw(HomeIndexSearchVo searchVo) {
        OnlineDeviceHomeData data = this.bxFxhjService.getReformData(searchVo);
        SearchParam param = new SearchParam();
        BeanUtils.copyProperties((Object)searchVo, (Object)param);
        param.setLevel(searchVo.getAreaLevel());
        Integer cfbNum = this.bxZybService.getCfbNum(param);
        Integer ysCfbNum = this.yszybService.getYsCfbNum(param);
        data.setCfbNum(cfbNum);
        data.setYsCfbNum(ysCfbNum);
        return data;
    }

    public PneumocoInfo getPneumocoInfo(SearchParam param) {
        PneumocoInfo info = ((OnlineDeviceMapper)this.dao).getDeviceCompanyInfo(param);
        Integer cfbNum = this.bxZybService.getCfbNum(param);
        Integer ysCfbNum = this.yszybService.getYsCfbNum(param);
        info.setCfbNum(cfbNum);
        info.setYsCfbNum(ysCfbNum);
        return info;
    }

    @Transactional(readOnly=false)
    public List<PneumocoChartData> pneumoconiosisChartData(SearchParam param) {
        YearMonth currentYearMonth = YearMonth.now().plus(1L, ChronoUnit.MONTHS);
        YearMonth minus = currentYearMonth.minus(3L, ChronoUnit.MONTHS);
        Date end = Date.from(currentYearMonth.atDay(1).atStartOfDay(ZoneId.systemDefault()).toInstant());
        Date start = Date.from(minus.atDay(1).atStartOfDay(ZoneId.systemDefault()).toInstant());
        List fcList = this.onlineDeviceAlarmService.fcChartData(start, end, param);
        List maskChartData = this.onlineDeviceAiwarningService.maskChartData(start, end, param);
        ArrayList<PneumocoChartData> list = new ArrayList<PneumocoChartData>();
        for (int i = 0; i < 4; ++i) {
            String label = "" + currentYearMonth.minusMonths(i).getMonth().getValue();
            PneumocoChartData mask = maskChartData.stream().filter(item -> item.getLabel().equalsIgnoreCase(label)).findFirst().orElse(new PneumocoChartData());
            PneumocoChartData fc = fcList.stream().filter(item -> item.getLabel().equalsIgnoreCase(label)).findFirst().orElse(new PneumocoChartData());
            list.add(new PneumocoChartData(label + "\u6708", mask.getNotMaskNum(), fc.getOverDensityNum()));
        }
        Collections.reverse(list);
        return list;
    }

    public Long getListByIdx(List<Long> list, int idx) {
        if (CollectionUtils.isEmpty(list)) {
            return 0L;
        }
        if (list.size() > idx) {
            return list.get(idx);
        }
        return 0L;
    }

    public Map<String, List<Long>> warningRatio(WarnRateParam searchVo) {
        LocalDate now = LocalDate.now();
        LocalDate preMonth = now.plusMonths(-1L);
        LocalDate startDate = LocalDate.of(preMonth.getYear(), preMonth.getMonth(), 1);
        LocalDate nextMonth = now.plusMonths(1L);
        LocalDate endDate = LocalDate.of(nextMonth.getYear(), nextMonth.getMonth(), 1);
        searchVo.setStartDate(startDate);
        searchVo.setEndDate(endDate);
        List<WarnRateModel> result = ((OnlineDeviceMapper)this.dao).warningRatio(searchVo);
        Map gropbyDataTypeMonthMap = result.stream().collect(Collectors.groupingBy(WarnRateModel::getDataType, Collectors.mapping(WarnRateModel::getNum, Collectors.toList())));
        HashMap<String, List<Long>> resultMap = new HashMap<String, List<Long>>();
        resultMap.put("\u7c89\u5c18", Arrays.asList(this.getListByIdx(gropbyDataTypeMonthMap.get(1002), 0), this.getListByIdx(gropbyDataTypeMonthMap.get(1002), 1)));
        resultMap.put("\u566a\u58f0", Arrays.asList(this.getListByIdx(gropbyDataTypeMonthMap.get(3001), 0), this.getListByIdx(gropbyDataTypeMonthMap.get(3001), 1)));
        resultMap.put("\u6bd2\u7269", Arrays.asList(this.getListByIdx(gropbyDataTypeMonthMap.get(2001), 0), this.getListByIdx(gropbyDataTypeMonthMap.get(2001), 1)));
        Integer deviceNumByArea = this.getDeviceNumByArea(searchVo.getAreaId(), searchVo.getAreaLevel(), searchVo.getIsCurrent());
        resultMap.put("\u8bbe\u5907\u603b\u6570", Arrays.asList(deviceNumByArea == null ? 0L : deviceNumByArea.longValue()));
        return resultMap;
    }

    public List<OnlineDeviceBindVo> getDevicesByCid(Long cid) {
        return ((OnlineDeviceMapper)this.dao).getDevicesByCid(cid);
    }

    @Transactional(readOnly=false)
    public void updatestate(OnlineDeviceStateVo stateVo, Long cid, Long clientId) {
        if (stateVo == null) {
            return;
        }
        OnlineDevice device = new OnlineDevice();
        device.setId(stateVo.getDeviceId());
        device.setStatus(stateVo.getState());
        device.setStateChangeTime(stateVo.getStateTime());
        this.update(device, clientId);
    }

    public OnlineDevice getByDeviceIdAndCid(Long cid, String deviceId) {
        Example e = new Example(OnlineDevice.class);
        e.createCriteria().andEqualTo("id", (Object)deviceId).andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid);
        e.selectProperties(new String[]{"id"});
        return (OnlineDevice)this.getOneByExample(e);
    }

    public List<OnlineDeviceCreditSupervise> getHasJcJkDeviceCid(List<Long> cids) {
        return ((OnlineDeviceMapper)this.dao).getHasJcJkDeviceCid(cids);
    }

    public Integer getFcOnlineMonitorCount(SearchParam searchParam) {
        if (Objects.equals(searchParam.getLevel(), (byte)1) || Objects.equals(searchParam.getLevel(), (byte)2)) {
            searchParam.setBelongType(Integer.valueOf(searchParam.getLevel().intValue()));
        } else {
            searchParam.setBelongType(Integer.valueOf(0));
        }
        List<Long> cidList = ((OnlineDeviceMapper)this.dao).getFcOnlineMonitorCount(searchParam);
        return cidList.size();
    }
}

