/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.declare;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.supervise.entity.declare.DeclareBase;
import cn.smarthse.modules.health.supervise.entity.declare.DeclareCheck;
import cn.smarthse.modules.health.supervise.entity.declare.DeclareCheckExtend;
import cn.smarthse.modules.health.supervise.entity.declare.DeclareHarm;
import cn.smarthse.modules.health.supervise.entity.declare.DeclareHarmExtend;
import cn.smarthse.modules.health.supervise.entity.declare.DeclareHealth;
import cn.smarthse.modules.health.supervise.entity.declare.DeclareHealthExtend;
import cn.smarthse.modules.health.supervise.entity.declare.DeclareImportVo;
import cn.smarthse.modules.health.supervise.entity.declare.DeclareProduct;
import cn.smarthse.modules.health.supervise.service.declare.IDeclareBaseService;
import cn.smarthse.modules.health.supervise.service.declare.IDeclareCheckService;
import cn.smarthse.modules.health.supervise.service.declare.IDeclareHarmService;
import cn.smarthse.modules.health.supervise.service.declare.IDeclareHealthService;
import cn.smarthse.modules.health.supervise.service.declare.IDeclareProductService;
import cn.smarthse.modules.health.supervise.service.declare.IImportDeclareDataService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class ImportDeclareDataServiceImpl
implements IImportDeclareDataService {
    @DubboReference(version="1.0.0")
    private ICompanyProvideService companyProvideService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @Autowired
    private IDeclareBaseService declareBaseService;
    @Autowired
    private IDeclareHarmService declareHarmService;
    @Autowired
    private IDeclareCheckService declareCheckService;
    @Autowired
    private IDeclareHealthService declareHealthService;
    @Autowired
    private IDeclareProductService declareProductService;
    @DubboReference(version="1.0.0")
    private IHarmFactorService harmFactorService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeclareImportVo getDeclareInfoFromExcel(String ossfile) {
        DeclareImportVo vo = new DeclareImportVo();
        HSSFWorkbook wb = null;
        List<Object> baseList = new ArrayList();
        List<Object> checkList = new ArrayList();
        List<Object> harmList = new ArrayList();
        List<Object> healthList = new ArrayList();
        List<Object> productList = new ArrayList();
        try {
            wb = new HSSFWorkbook(ExcelUtil.getInstance().getOssInputStream(ossfile));
        }
        catch (Exception i) {
        }
        finally {
            if (wb != null) {
                try {
                    block32: for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
                        switch (i) {
                            case 0: {
                                baseList = this.getBaseInfoFromSheet(wb.getSheetAt(i));
                                vo.setBaseList(baseList);
                                continue block32;
                            }
                            case 1: {
                                checkList = this.getCheckInfoFromSheet(wb.getSheetAt(i));
                                vo.setCheckList(checkList);
                                continue block32;
                            }
                            case 2: {
                                harmList = this.getHarmInfoFromSheet(wb.getSheetAt(i));
                                vo.setHarmList(harmList);
                                continue block32;
                            }
                            case 3: {
                                healthList = this.getHealthInfoFromSheet(wb.getSheetAt(i));
                                vo.setHealthList(healthList);
                                continue block32;
                            }
                            case 4: {
                                productList = this.getProductInfoFromSheet(wb.getSheetAt(i));
                                vo.setProductList(productList);
                            }
                        }
                    }
                    wb.close();
                }
                catch (IOException i) {}
            }
        }
        return vo;
    }

    private List<DeclareBase> getBaseInfoFromSheet(HSSFSheet sheetAt) {
        ArrayList<DeclareBase> baseList = new ArrayList<DeclareBase>();
        int rowIndex = 0;
        int cellIndex = 27;
        Iterator iter = sheetAt.rowIterator();
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            if (++rowIndex == 1 || rowIndex == 2) continue;
            DeclareBase vo = new DeclareBase();
            vo.setHaveError(Boolean.valueOf(true));
            vo.setErrorReason("");
            block30: for (int i = 0; i <= cellIndex; ++i) {
                Cell cell = row.getCell(i);
                if (cell == null) {
                    cell = new HSSFWorkbook().createSheet().createRow(1).createCell(0);
                }
                if (i != 4 && i != 27) {
                    cell.setCellType(CellType.STRING);
                }
                switch (i) {
                    case 0: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            String serrial = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)serrial)) {
                                vo.setSerial(Integer.valueOf(Integer.parseInt(serrial)));
                                continue block30;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5e8f\u53f7\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6570\u5b57;<br/>");
                            continue block30;
                        }
                        vo.setHaveError(Boolean.valueOf(false));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5e8f\u53f7\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block30;
                    }
                    case 1: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            String comNum = cell.getStringCellValue().trim();
                            vo.setUnitName(comNum);
                            continue block30;
                        }
                        vo.setHaveError(Boolean.valueOf(false));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u4f01\u4e1a\u540d\u79f0\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block30;
                    }
                    case 2: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            String dectype = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)dectype)) {
                                vo.setDeclareType(Integer.valueOf(Integer.parseInt(dectype)));
                                continue block30;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u7533\u62a5\u7c7b\u522b\u683c\u5f0f\u586b\u5199\u9519\u8bef;<br/>");
                            continue block30;
                        }
                        vo.setHaveError(Boolean.valueOf(false));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u7533\u62a5\u7c7b\u522b\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block30;
                    }
                    case 3: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            String year = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)year)) {
                                vo.setDeclareYear(year);
                                continue block30;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u7533\u62a5\u5e74\u4efd\u683c\u5f0f\u586b\u5199\u9519\u8bef;<br/>");
                            continue block30;
                        }
                        vo.setHaveError(Boolean.valueOf(false));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u7533\u62a5\u5e74\u4efd\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block30;
                    }
                    case 4: {
                        if (cell != null && cell.getCellTypeEnum() != CellType.BLANK) {
                            ImportDeclareDataServiceImpl.dateHandle(cell);
                            if (cell.getCellTypeEnum() == CellType.BLANK) {
                                vo.setHaveError(Boolean.valueOf(false));
                                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u7533\u62a5\u65f6\u95f4\u89e3\u6790\u9519\u8bef;<br/>");
                                continue block30;
                            }
                            if (cell.getCellTypeEnum() == CellType.STRING) continue block30;
                            vo.setDeclareDate(cell.getDateCellValue());
                            continue block30;
                        }
                        vo.setHaveError(Boolean.valueOf(false));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u7533\u62a5\u65f6\u95f4\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block30;
                    }
                    case 5: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            vo.setZoneCode(cell.getStringCellValue());
                            continue block30;
                        }
                        vo.setHaveError(Boolean.valueOf(false));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u6240\u5c5e\u5730\u533a\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block30;
                    }
                    case 6: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            String creditCode = cell.getStringCellValue();
                            if (vo.getUnitName() == null) continue block30;
                            CompanySuperviseModel com = this.companyProvideBySuperviseService.getByCompanyName(vo.getUnitName(), Integer.valueOf(1));
                            if (com != null) {
                                if (creditCode.equals(com.getUnifiedSocialCc())) {
                                    vo.setCreditCode(creditCode);
                                    vo.setCid(com.getId());
                                    continue block30;
                                }
                                vo.setHaveError(Boolean.valueOf(false));
                                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + " , \u5217\u53f7\uff1a" + this.getExcelColName(2) + ",\u4f01\u4e1a\u540d\u79f0\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4f46\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u76f8\u540c\uff0c\u8bf7\u6838\u5b9e;<br/>");
                                continue block30;
                            }
                            if (this.companyProvideBySuperviseService.isHaveThisCreditCode(creditCode, null, null).booleanValue()) {
                                vo.setHaveError(Boolean.valueOf(false));
                                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + " , \u5217\u53f7\uff1a" + this.getExcelColName(2) + ",\uff08\u4f01\u4e1a\u540d\u79f0\uff09\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728;<br/>");
                                continue block30;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + " , \u5217\u53f7\uff1a" + this.getExcelColName(2) + ", \u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4f46\u4f01\u4e1a\u540d\u79f0\u4e0d\u76f8\u540c\uff0c\u8bf7\u6838\u5b9e;<br/>");
                            continue block30;
                        }
                        vo.setHaveError(Boolean.valueOf(false));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block30;
                    }
                    case 7: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            vo.setRegAddr(cell.getStringCellValue());
                            continue block30;
                        }
                        vo.setHaveError(Boolean.valueOf(false));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5355\u4f4d\u6ce8\u518c\u5730\u5740\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block30;
                    }
                    case 8: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            vo.setWorkAddr(cell.getStringCellValue());
                            continue block30;
                        }
                        vo.setHaveError(Boolean.valueOf(false));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5de5\u4f5c\u573a\u6240\u5730\u5740\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block30;
                    }
                    case 9: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            String scale = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)scale)) {
                                vo.setEnterpriseScale(Integer.valueOf(Integer.parseInt(scale)));
                                continue block30;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u4f01\u4e1a\u89c4\u6a21\u683c\u5f0f\u586b\u5199\u9519\u8bef;<br/>");
                            continue block30;
                        }
                        vo.setHaveError(Boolean.valueOf(false));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u4f01\u4e1a\u89c4\u6a21\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block30;
                    }
                    case 10: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            vo.setIndustryCateNo(cell.getStringCellValue());
                            continue block30;
                        }
                        vo.setHaveError(Boolean.valueOf(false));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u884c\u4e1a\u5206\u7c7b\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block30;
                    }
                    case 11: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            vo.setEconomicNo(cell.getStringCellValue());
                            continue block30;
                        }
                        vo.setHaveError(Boolean.valueOf(false));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u7ecf\u6d4e\u7c7b\u578b\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block30;
                    }
                    case 12: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            vo.setFillMan(cell.getStringCellValue());
                            continue block30;
                        }
                        vo.setHaveError(Boolean.valueOf(false));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u586b\u62a5\u4eba\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block30;
                    }
                    case 13: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            vo.setFillPhone(cell.getStringCellValue());
                            continue block30;
                        }
                        vo.setHaveError(Boolean.valueOf(false));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u586b\u62a5\u4eba\u7535\u8bdd\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block30;
                    }
                    case 14: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            vo.setLegalPerson(cell.getStringCellValue());
                            continue block30;
                        }
                        vo.setHaveError(Boolean.valueOf(false));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u6cd5\u5b9a\u4ee3\u8868\u4eba\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block30;
                    }
                    case 15: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            vo.setLegalPersonPhone(cell.getStringCellValue());
                            continue block30;
                        }
                        vo.setHaveError(Boolean.valueOf(false));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u6cd5\u5b9a\u4ee3\u8868\u4eba\u7535\u8bdd\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block30;
                    }
                    case 16: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            vo.setLinkManager(cell.getStringCellValue());
                            continue block30;
                        }
                        vo.setHaveError(Boolean.valueOf(false));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u804c\u4e1a\u536b\u751f\u7ba1\u7406\u8054\u7cfb\u4eba\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block30;
                    }
                    case 17: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            vo.setLinkPhone(cell.getStringCellValue());
                            continue block30;
                        }
                        vo.setHaveError(Boolean.valueOf(false));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u804c\u4e1a\u536b\u751f\u7ba1\u7406\u8054\u7cfb\u4eba\u7535\u8bdd\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block30;
                    }
                    case 18: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            String empNum = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)empNum)) {
                                vo.setEmpNum(Integer.valueOf(Integer.parseInt(empNum)));
                                continue block30;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5728\u518c\u804c\u5de5\u603b\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6570\u5b57;<br/>");
                            continue block30;
                        }
                        vo.setHaveError(Boolean.valueOf(false));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5728\u518c\u804c\u5de5\u603b\u6570\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block30;
                    }
                    case 19: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            String externalNum = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)externalNum)) {
                                vo.setExternalNum(Integer.valueOf(Integer.parseInt(externalNum)));
                                continue block30;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5916\u59d4\u4eba\u5458\u603b\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6570\u5b57;<br/>");
                            continue block30;
                        }
                        vo.setHaveError(Boolean.valueOf(false));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5916\u59d4\u4eba\u5458\u603b\u6570\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block30;
                    }
                    case 20: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            String victimsNum = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)victimsNum)) {
                                vo.setVictimsNum(Integer.valueOf(Integer.parseInt(victimsNum)));
                                continue block30;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u63a5\u5bb3\u603b\u4eba\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6570\u5b57;<br/>");
                            continue block30;
                        }
                        vo.setHaveError(Boolean.valueOf(false));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u63a5\u5bb3\u603b\u4eba\u6570\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block30;
                    }
                    case 21: {
                        String occupationalDiseasesNum;
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            occupationalDiseasesNum = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)occupationalDiseasesNum)) {
                                vo.setOccupationalDiseasesNum(Integer.valueOf(Integer.parseInt(occupationalDiseasesNum)));
                                continue block30;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u804c\u4e1a\u75c5\u603b\u4eba\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6570\u5b57;<br/>");
                            continue block30;
                        }
                        vo.setHaveError(Boolean.valueOf(false));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u804c\u4e1a\u75c5\u603b\u4eba\u6570\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block30;
                    }
                    case 22: {
                        String jun;
                        if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            jun = cell.getStringCellValue().trim();
                            if (jun.equals("\u662f")) {
                                vo.setIfWarProduct(Global.TRUE);
                                continue block30;
                            }
                            if (jun.equals("\u5426")) {
                                vo.setIfWarProduct(Global.FALSE);
                                continue block30;
                            }
                            vo.setIfWarProduct(Global.FALSE);
                            continue block30;
                        }
                        vo.setHaveError(Boolean.valueOf(false));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u662f\u5426\u519b\u5de5\u7b49\u6d89\u5bc6\u4ea7\u54c1\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block30;
                    }
                    case 23: {
                        if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) continue block30;
                        String jun = cell.getStringCellValue().trim();
                        if (jun.equals("\u6709")) {
                            vo.setIfLeadersTrain(Global.TRUE);
                            continue block30;
                        }
                        if (jun.equals("\u65e0")) {
                            vo.setIfLeadersTrain(Global.FALSE);
                            continue block30;
                        }
                        vo.setIfLeadersTrain(Global.FALSE);
                        continue block30;
                    }
                    case 24: {
                        if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) continue block30;
                        String jun = cell.getStringCellValue().trim();
                        if (jun.equals("\u6709")) {
                            vo.setIfManagersTrain(Global.TRUE);
                            continue block30;
                        }
                        if (jun.equals("\u65e0")) {
                            vo.setIfManagersTrain(Global.FALSE);
                            continue block30;
                        }
                        vo.setIfManagersTrain(Global.FALSE);
                        continue block30;
                    }
                    case 25: {
                        if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) continue block30;
                        String occupationalDiseasesNum = cell.getStringCellValue().trim();
                        if (StringUtils.isInteger((String)occupationalDiseasesNum)) {
                            vo.setTrainSum(Integer.valueOf(Integer.parseInt(occupationalDiseasesNum)));
                            continue block30;
                        }
                        vo.setHaveError(Boolean.valueOf(false));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u804c\u4e1a\u75c5\u57f9\u8bad\u603b\u4eba\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6570\u5b57;<br/>");
                        continue block30;
                    }
                    case 26: {
                        if (cell == null || cell.getCellTypeEnum() == CellType.BLANK) continue block30;
                        ImportDeclareDataServiceImpl.dateHandle(cell);
                        if (cell.getCellTypeEnum() == CellType.BLANK) {
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5ba1\u6838\u65f6\u95f4\u89e3\u6790\u9519\u8bef;<br/>");
                            continue block30;
                        }
                        if (cell.getCellTypeEnum() == CellType.STRING) continue block30;
                        vo.setApproveDate(cell.getDateCellValue());
                    }
                }
            }
            baseList.add(vo);
        }
        return baseList;
    }

    private List<DeclareCheck> getCheckInfoFromSheet(HSSFSheet sheetAt) {
        ArrayList<DeclareCheck> checkList = new ArrayList<DeclareCheck>();
        int rowIndex = 0;
        int cellIndex = 30;
        int cowNum = sheetAt.getRow(1).getPhysicalNumberOfCells();
        HashMap<Integer, String> harmNameMap = new HashMap<Integer, String>();
        HashMap<Integer, String> harmTypeMap = new HashMap<Integer, String>();
        Iterator iter = sheetAt.rowIterator();
        while (iter.hasNext()) {
            DeclareCheck vo;
            Row row = (Row)iter.next();
            if (++rowIndex == 1) continue;
            if (rowIndex == 2) {
                if (cowNum <= 31) continue;
                vo = new DeclareCheck();
                vo.setHaveError(Boolean.valueOf(true));
                vo.setErrorReason("");
                for (int i = 31; i < cowNum; ++i) {
                    String harmName;
                    Cell cell = row.getCell(i);
                    cell.setCellType(CellType.STRING);
                    if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) continue;
                    String cellName = cell.getStringCellValue();
                    if (i % 2 != 0) {
                        if (cellName.endsWith("\u68c0\u6d4b\u70b9\u6570") && cellName.contains("_") && !cellName.startsWith("_")) {
                            harmName = this.subString(cellName, "_", "\u68c0\u6d4b\u70b9\u6570");
                            harmNameMap.put(i, harmName);
                            String type = this.harmFactorService.getTypeByName(harmName);
                            harmTypeMap.put(i, type);
                            continue;
                        }
                        vo.setHaveError(Boolean.valueOf(false));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ",\u8868\u5934\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u683c\u5f0f\u4e3a:\u5371\u5bb3\u56e0\u7d20\u79cd\u7c7b_XX\u68c0\u6d4b\u70b9\u6570(XX\u4e3a\u5371\u5bb3\u56e0\u7d20\u540d\u79f0);<br/>");
                        continue;
                    }
                    if (cellName.endsWith("\u8d85\u6807\u70b9\u6570") && cellName.contains("_") && !cellName.startsWith("_")) {
                        harmName = this.subString(cellName, "_", "\u8d85\u6807\u70b9\u6570");
                        if (harmName.equals(harmNameMap.get(i - 1))) continue;
                        vo.setHaveError(Boolean.valueOf(false));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ",\u8868\u5934\u5371\u5bb3\u56e0\u7d20\u4e0e\u524d\u4e00\u5217\u4e0d\u4e00\u81f4;<br/>");
                        continue;
                    }
                    vo.setHaveError(Boolean.valueOf(false));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ",\u8868\u5934\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u683c\u5f0f\u4e3a:\u5371\u5bb3\u56e0\u7d20\u79cd\u7c7b_XX\u8d85\u6807\u70b9\u6570(XX\u4e3a\u5371\u5bb3\u56e0\u7d20\u540d\u79f0);<br/>");
                }
                if (vo.getHaveError().booleanValue()) continue;
                checkList.add(vo);
                continue;
            }
            vo = new DeclareCheck();
            vo.setHaveError(Boolean.valueOf(true));
            vo.setErrorReason("");
            ArrayList<DeclareCheckExtend> extendList = new ArrayList<DeclareCheckExtend>();
            int listsize = 0;
            block35: for (int i = 0; i < cowNum; ++i) {
                String jc;
                Cell cell = row.getCell(i);
                if (cell == null) {
                    cell = new HSSFWorkbook().createSheet().createRow(1).createCell(0);
                }
                cell.setCellType(CellType.STRING);
                if (i <= 30) {
                    switch (i) {
                        case 0: {
                            if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                                String serrial = cell.getStringCellValue().trim();
                                if (StringUtils.isInteger((String)serrial)) {
                                    vo.setSerial(Integer.valueOf(Integer.parseInt(serrial)));
                                    break;
                                }
                                vo.setHaveError(Boolean.valueOf(false));
                                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5e8f\u53f7\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6570\u5b57;<br/>");
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5e8f\u53f7\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                            break;
                        }
                        case 1: {
                            if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                                jc = cell.getStringCellValue().trim();
                                if (jc.equals("\u662f")) {
                                    vo.setIfat(Global.TRUE);
                                    break;
                                }
                                if (!jc.equals("\u5426")) continue block35;
                                vo.setIfat(Global.FALSE);
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u672c\u5e74\u5ea6\u68c0\u6d4b\u60c5\u51b5\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                            break;
                        }
                        case 2: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            vo.setTestUnitNames(cell.getStringCellValue());
                            break;
                        }
                        case 3: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            vo.setTestReportNos(cell.getStringCellValue());
                            break;
                        }
                        case 4: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (jc.equals("\u662f")) {
                                vo.setIfatDust(Global.TRUE);
                                break;
                            }
                            if (!jc.equals("\u5426")) continue block35;
                            vo.setIfatDust(Global.FALSE);
                            break;
                        }
                        case 5: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setIfatDustAllChecknum(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u7c89\u5c18\u603b\u68c0\u6d4b\u70b9\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 6: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setIfatDustAllExcessnum(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u7c89\u5c18\u8d85\u6807\u70b9\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 7: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setIfatDustChecknum(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u77fd\u5c18\u70b9\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 8: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setIfatDustExcessnum(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u77fd\u5c18\u8d85\u6807\u70b9\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 9: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setIfatDustCoalChecknum(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u7164\u5c18\u70b9\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 10: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setIfatDustCoalExcessnum(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u7164\u5c18\u8d85\u6807\u70b9\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 11: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setIfatDustAsbestosChecknum(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u77f3\u68c9\u7c89\u5c18\u70b9\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 12: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setIfatDustAsbestosExcessnum(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u77f3\u68c9\u7c89\u5c18\u8d85\u6807\u70b9\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 13: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (jc.equals("\u662f")) {
                                vo.setIfatChemistry(Global.TRUE);
                                break;
                            }
                            if (!jc.equals("\u5426")) continue block35;
                            vo.setIfatChemistry(Global.FALSE);
                            break;
                        }
                        case 14: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setIfatChemistryAllChecknum(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5316\u5b66\u7269\u8d28\u603b\u68c0\u6d4b\u70b9\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 15: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setIfatChemistryAllExcessnum(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5316\u5b66\u7269\u8d28\u603b\u8d85\u6807\u70b9\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 16: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setIfatChemistryChecknum(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5316\u5b66\u7269\u8d28\u94c5\u68c0\u6d4b\u70b9\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 17: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setIfatChemistryExcessnum(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5316\u5b66\u7269\u8d28\u94c5\u8d85\u6807\u70b9\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 18: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setIfatChemistryBenzeneChecknum(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5316\u5b66\u7269\u8d28\u82ef\u68c0\u6d4b\u70b9\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 19: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setIfatChemistryBenzeneExcessnum(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5316\u5b66\u7269\u8d28\u82ef\u8d85\u6807\u70b9\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 20: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (jc.equals("\u662f")) {
                                vo.setIfatPhysics(Global.TRUE);
                                break;
                            }
                            if (!jc.equals("\u5426")) continue block35;
                            vo.setIfatPhysics(Global.FALSE);
                            break;
                        }
                        case 21: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setIfatPhysicsAllChecknum(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u7269\u7406\u56e0\u7d20\u603b\u68c0\u6d4b\u70b9\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 22: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setIfatPhysicsAllExcessnum(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u7269\u7406\u56e0\u7d20\u603b\u8d85\u6807\u70b9\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 23: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setIfatPhysicsChecknum(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u566a\u58f0\u68c0\u6d4b\u70b9\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 24: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setIfatPhysicsExcessnum(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u566a\u58f0\u8d85\u6807\u70b9\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 25: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (jc.equals("\u662f")) {
                                vo.setIfatRadioactivity(Global.TRUE);
                                break;
                            }
                            if (!jc.equals("\u5426")) continue block35;
                            vo.setIfatRadioactivity(Global.FALSE);
                            break;
                        }
                        case 26: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setIfatRadioactivityChecknum(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u653e\u5c04\u6027\u56e0\u7d20\u603b\u68c0\u6d4b\u70b9\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 27: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setIfatRadioactivityExcessnum(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u653e\u5c04\u6027\u56e0\u7d20\u603b\u8d85\u6807\u70b9\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 28: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (jc.equals("\u662f")) {
                                vo.setIfatBiologyother(Global.TRUE);
                                break;
                            }
                            if (!jc.equals("\u5426")) continue block35;
                            vo.setIfatBiologyother(Global.FALSE);
                            break;
                        }
                        case 29: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setIfatBiologyotherChecknum(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u751f\u7269\u548c\u5176\u4ed6\u56e0\u7d20\u603b\u68c0\u6d4b\u70b9\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 30: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setIfatBiologyotherExcessnum(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u751f\u7269\u548c\u5176\u4ed6\u56e0\u7d20\u603b\u8d85\u6807\u70b9\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                        }
                    }
                    continue;
                }
                if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) continue;
                if (i % 2 != 0) {
                    jc = cell.getStringCellValue().trim();
                    if (StringUtils.isInteger((String)jc)) {
                        DeclareCheckExtend extend = new DeclareCheckExtend();
                        extend.setCheckNum(Integer.valueOf(Integer.parseInt(jc)));
                        extend.setHarmName((String)harmNameMap.get(i));
                        extend.setHarmType((String)harmTypeMap.get(i));
                        extendList.add(extend);
                        ++listsize;
                        continue;
                    }
                    vo.setHaveError(Boolean.valueOf(false));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u68c0\u6d4b\u70b9\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                    continue;
                }
                String cb = cell.getStringCellValue().trim();
                if (StringUtils.isInteger((String)cb)) {
                    if (listsize < true) continue;
                    ((DeclareCheckExtend)extendList.get(listsize - 1)).setExcessNum(Integer.valueOf(Integer.parseInt(cb)));
                    continue;
                }
                vo.setHaveError(Boolean.valueOf(false));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u8d85\u6807\u70b9\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
            }
            if (listsize >= 1) {
                vo.setCheckExtendList(extendList);
            }
            checkList.add(vo);
        }
        return checkList;
    }

    private List<DeclareHarm> getHarmInfoFromSheet(HSSFSheet sheetAt) {
        ArrayList<DeclareHarm> harmList = new ArrayList<DeclareHarm>();
        int rowIndex = 0;
        int cellIndex = 18;
        int cowNum = sheetAt.getRow(1).getPhysicalNumberOfCells();
        HashMap<Integer, String> harmNameMap = new HashMap<Integer, String>();
        HashMap<Integer, String> harmTypeMap = new HashMap<Integer, String>();
        Iterator iter = sheetAt.rowIterator();
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            if (++rowIndex == 1) continue;
            if (rowIndex == 2) {
                if (cowNum <= 19) continue;
                DeclareHarm harm = new DeclareHarm();
                harm.setHaveError(Boolean.valueOf(true));
                harm.setErrorReason("");
                for (int i = 19; i < cowNum; ++i) {
                    Cell cell = row.getCell(i);
                    cell.setCellType(CellType.STRING);
                    if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) continue;
                    String cellName = cell.getStringCellValue();
                    if (!cellName.startsWith("_\u63a5\u89e6") && cellName.contains("_\u63a5\u89e6")) {
                        int strStartIndex = cellName.indexOf("_");
                        String harmName = cellName.substring(strStartIndex + 3);
                        harmNameMap.put(i, harmName);
                        String type = this.harmFactorService.getTypeByName(harmName);
                        harmTypeMap.put(i, type);
                        continue;
                    }
                    harm.setHaveError(Boolean.valueOf(false));
                    harm.setErrorReason(harm.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ",\u8868\u5934\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u683c\u5f0f\u4e3a\uff1a\u5371\u5bb3\u56e0\u7d20\u79cd\u7c7b_\u63a5\u89e6XX\uff08XX\u4e3a\u5371\u5bb3\u56e0\u7d20\u540d\u79f0\uff09;<br/>");
                }
                if (harm.getHaveError().booleanValue()) continue;
                harmList.add(harm);
                continue;
            }
            DeclareHarm vo = new DeclareHarm();
            vo.setHaveError(Boolean.valueOf(true));
            vo.setErrorReason("");
            ArrayList<DeclareHarmExtend> extendList = new ArrayList<DeclareHarmExtend>();
            block23: for (int i = 0; i < cowNum; ++i) {
                String jc;
                Cell cell = row.getCell(i);
                if (cell == null) {
                    cell = new HSSFWorkbook().createSheet().createRow(1).createCell(0);
                }
                cell.setCellType(CellType.STRING);
                if (i <= 18) {
                    switch (i) {
                        case 0: {
                            if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                                String serrial = cell.getStringCellValue().trim();
                                if (StringUtils.isInteger((String)serrial)) {
                                    vo.setSerial(Integer.valueOf(Integer.parseInt(serrial)));
                                    break;
                                }
                                vo.setHaveError(Boolean.valueOf(false));
                                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5e8f\u53f7\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6570\u5b57;<br/>");
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5e8f\u53f7\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                            break;
                        }
                        case 1: {
                            if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                                jc = cell.getStringCellValue().trim();
                                if (jc.equals("\u6709")) {
                                    vo.setIfhfDust(Global.TRUE);
                                    break;
                                }
                                if (!jc.equals("\u65e0")) continue block23;
                                vo.setIfhfDust(Global.FALSE);
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u7c89\u5c18\u5371\u5bb3\u56e0\u7d20\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                            break;
                        }
                        case 2: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setHfDustPeoples(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u7c89\u5c18\u63a5\u89e6\u603b\u4eba\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 3: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setHfDustSiliconPeoples(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u77fd\u5c18\u63a5\u89e6\u4eba\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 4: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setHfDustCoalPeoples(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u63a5\u89e6\u7164\u5c18\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 5: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setHfDustAsbestosNum(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u63a5\u89e6\u77f3\u68c9\u7c89\u5c18\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 6: {
                            if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                                jc = cell.getStringCellValue().trim();
                                if (jc.equals("\u6709")) {
                                    vo.setIfhfChemistry(Global.TRUE);
                                    break;
                                }
                                if (!jc.equals("\u65e0")) continue block23;
                                vo.setIfhfChemistry(Global.FALSE);
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5316\u5b66\u7269\u8d28\u5371\u5bb3\u56e0\u7d20\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                            break;
                        }
                        case 7: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setHfChemistryPeoples(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5316\u5b66\u7269\u8d28\u63a5\u89e6\u603b\u4eba\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 8: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setHfChemistryLeadPeoples(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u63a5\u89e6\u94c5\u4eba\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 9: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setHfChemistryBenzenePeoples(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u63a5\u89e6\u82ef\u4eba\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 10: {
                            if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                                jc = cell.getStringCellValue().trim();
                                if (jc.equals("\u6709")) {
                                    vo.setIfhfPhysics(Global.TRUE);
                                    break;
                                }
                                if (!jc.equals("\u65e0")) continue block23;
                                vo.setIfhfPhysics(Global.FALSE);
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u7269\u7406\u56e0\u7d20\u5371\u5bb3\u56e0\u7d20\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                            break;
                        }
                        case 11: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setHfPhysicsPeoples(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u7269\u7406\u56e0\u7d20\u63a5\u89e6\u603b\u4eba\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 12: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setHfPhysicsNoisePeoples(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u63a5\u89e6\u566a\u58f0\u4eba\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 13: {
                            if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                                jc = cell.getStringCellValue().trim();
                                if (jc.equals("\u6709")) {
                                    vo.setIfhfRadioactivity(Global.TRUE);
                                    break;
                                }
                                if (!jc.equals("\u65e0")) continue block23;
                                vo.setIfhfRadioactivity(Global.FALSE);
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u653e\u5c04\u6027\u56e0\u7d20\u5371\u5bb3\u56e0\u7d20\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                            break;
                        }
                        case 14: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setHfRadioactivityPeoples(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u653e\u5c04\u6027\u56e0\u7d20\u63a5\u89e6\u603b\u4eba\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 15: {
                            if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                                jc = cell.getStringCellValue().trim();
                                if (jc.equals("\u6709")) {
                                    vo.setIfhfBiology(Global.TRUE);
                                    break;
                                }
                                if (!jc.equals("\u65e0")) continue block23;
                                vo.setIfhfBiology(Global.FALSE);
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u751f\u7269\u56e0\u7d20\u5371\u5bb3\u56e0\u7d20\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                            break;
                        }
                        case 16: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setHfBiologyPeoples(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u751f\u7269\u56e0\u7d20\u63a5\u89e6\u603b\u4eba\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 17: {
                            if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                                jc = cell.getStringCellValue().trim();
                                if (jc.equals("\u6709")) {
                                    vo.setIfhfOther(Global.TRUE);
                                    break;
                                }
                                if (!jc.equals("\u65e0")) continue block23;
                                vo.setIfhfOther(Global.FALSE);
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5176\u4ed6\u56e0\u7d20\u5371\u5bb3\u56e0\u7d20\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                            break;
                        }
                        case 18: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setHfOtherPeoples(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5176\u4ed6\u56e0\u7d20\u63a5\u89e6\u603b\u4eba\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                        }
                    }
                    continue;
                }
                if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) continue;
                jc = cell.getStringCellValue().trim();
                if (StringUtils.isInteger((String)jc)) {
                    DeclareHarmExtend extend = new DeclareHarmExtend();
                    extend.setContactNum(Integer.valueOf(Integer.parseInt(jc)));
                    extend.setHarmName((String)harmNameMap.get(i));
                    extend.setHarmType((String)harmTypeMap.get(i));
                    extendList.add(extend);
                    continue;
                }
                vo.setHaveError(Boolean.valueOf(false));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u63a5\u89e6\u4eba\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
            }
            if (extendList.size() > 0) {
                vo.setExtendList(extendList);
            }
            harmList.add(vo);
        }
        return harmList;
    }

    private List<DeclareHealth> getHealthInfoFromSheet(HSSFSheet sheetAt) {
        ArrayList<DeclareHealth> healthList = new ArrayList<DeclareHealth>();
        int rowIndex = 0;
        int cellIndex = 17;
        int cowNum = sheetAt.getRow(1).getPhysicalNumberOfCells();
        HashMap<Integer, String> harmNameMap = new HashMap<Integer, String>();
        HashMap<Integer, String> harmTypeMap = new HashMap<Integer, String>();
        Iterator iter = sheetAt.rowIterator();
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            if (++rowIndex == 1) continue;
            if (rowIndex == 2) {
                if (cowNum <= 18) continue;
                DeclareHealth harm = new DeclareHealth();
                harm.setHaveError(Boolean.valueOf(true));
                harm.setErrorReason("");
                for (int i = 18; i < cowNum; ++i) {
                    Cell cell = row.getCell(i);
                    cell.setCellType(CellType.STRING);
                    if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) continue;
                    String cellName = cell.getStringCellValue();
                    if (cellName.endsWith("\u4f53\u68c0\u4eba\u6570") && cellName.contains("_\u63a5\u89e6") && !cellName.startsWith("_\u63a5\u89e6")) {
                        String harmName = this.subString(cellName, "_\u63a5\u89e6", "\u4f53\u68c0\u4eba\u6570");
                        harmNameMap.put(i, harmName);
                        String type = this.harmFactorService.getTypeByName(harmName);
                        harmTypeMap.put(i, type);
                        continue;
                    }
                    harm.setHaveError(Boolean.valueOf(false));
                    harm.setErrorReason(harm.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ",\u8868\u5934\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u683c\u5f0f\u4e3a\uff1a\u5371\u5bb3\u56e0\u7d20\u79cd\u7c7b_\u63a5\u89e6XX\u4f53\u68c0\u4eba\u6570\uff08XX\u8868\u793a\u5371\u5bb3\u56e0\u7d20\uff09;<br/>");
                }
                if (harm.getHaveError().booleanValue()) continue;
                healthList.add(harm);
                continue;
            }
            DeclareHealth vo = new DeclareHealth();
            vo.setHaveError(Boolean.valueOf(true));
            vo.setErrorReason("");
            ArrayList<DeclareHealthExtend> extendList = new ArrayList<DeclareHealthExtend>();
            for (int i = 0; i < cowNum; ++i) {
                String jc;
                Cell cell = row.getCell(i);
                if (cell == null) {
                    cell = new HSSFWorkbook().createSheet().createRow(1).createCell(0);
                }
                cell.setCellType(CellType.STRING);
                if (i <= 17) {
                    switch (i) {
                        case 0: {
                            if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                                String serrial = cell.getStringCellValue().trim();
                                if (StringUtils.isInteger((String)serrial)) {
                                    vo.setSerial(Integer.valueOf(Integer.parseInt(serrial)));
                                    break;
                                }
                                vo.setHaveError(Boolean.valueOf(false));
                                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5e8f\u53f7\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6570\u5b57;<br/>");
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5e8f\u53f7\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                            break;
                        }
                        case 1: {
                            if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                                jc = cell.getStringCellValue().trim();
                                if (jc.equals("\u662f")) {
                                    vo.setIfhea(Global.TRUE);
                                    break;
                                }
                                if (jc.equals("\u5426")) {
                                    vo.setIfhea(Global.FALSE);
                                    break;
                                }
                                vo.setHaveError(Boolean.valueOf(false));
                                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u672c\u5e74\u5ea6\u804c\u4e1a\u5065\u5eb7\u5f00\u5c55\u60c5\u51b5\u8f93\u5165\u683c\u5f0f\u9519\u8bef;<br/>");
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u672c\u5e74\u5ea6\u804c\u4e1a\u5065\u5eb7\u5f00\u5c55\u60c5\u51b5\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                            break;
                        }
                        case 2: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            vo.setCheckUnitNames(cell.getStringCellValue());
                            break;
                        }
                        case 3: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            vo.setCheckReportNos(cell.getStringCellValue());
                            break;
                        }
                        case 4: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (jc.equals("\u662f")) {
                                vo.setIfheaDust(Global.TRUE);
                                break;
                            }
                            if (jc.equals("\u5426")) {
                                vo.setIfheaDust(Global.FALSE);
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5065\u5eb7\u68c0\u67e5\u7c89\u5c18\u8f93\u5165\u683c\u5f0f\u9519\u8bef;<br/>");
                            break;
                        }
                        case 5: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setHeaDustPeoples(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u7c89\u5c18\u4f53\u68c0\u4eba\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 6: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setHeaDustSiliconPeoples(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u7c89\u5c18_\u63a5\u89e6\u77fd\u5c18\u4f53\u68c0\u4eba\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 7: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setHeaDustCoalPeoples(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u7c89\u5c18_\u63a5\u89e6\u7164\u5c18\u4f53\u68c0\u4eba\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 8: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setHeaDustAsbestosPeoples(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u7c89\u5c18_\u63a5\u89e6\u77f3\u68c9\u5c18\u4f53\u68c0\u4eba\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 9: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (jc.equals("\u662f")) {
                                vo.setIfheaChemistry(Global.TRUE);
                                break;
                            }
                            if (jc.equals("\u5426")) {
                                vo.setIfheaChemistry(Global.FALSE);
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5065\u5eb7\u68c0\u67e5\u5316\u5b66\u7269\u8d28\u8f93\u5165\u683c\u5f0f\u9519\u8bef;<br/>");
                            break;
                        }
                        case 10: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setHeaChemistryPeoples(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5316\u5b66\u7269\u8d28\u4f53\u68c0\u4eba\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 11: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setHeaChemistryLeadPeoples(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u94c5\u4f53\u68c0\u4eba\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 12: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setHeaTchemistryBenzenePeoples(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u82ef\u4f53\u68c0\u4eba\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 13: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (jc.equals("\u662f")) {
                                vo.setIfheaPhysics(Global.TRUE);
                                break;
                            }
                            if (jc.equals("\u5426")) {
                                vo.setIfheaPhysics(Global.FALSE);
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5065\u5eb7\u68c0\u67e5\u7269\u7406\u56e0\u7d20\u8f93\u5165\u683c\u5f0f\u9519\u8bef;<br/>");
                            break;
                        }
                        case 14: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setHeaPhysicsPeoples(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u7269\u7406\u56e0\u7d20\u4f53\u68c0\u4eba\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 15: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setHeaPhysicsNoisePeoples(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u63a5\u89e6\u566a\u58f0\u4f53\u68c0\u4eba\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                            break;
                        }
                        case 16: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (jc.equals("\u662f")) {
                                vo.setIfheaRadioactivity(Global.TRUE);
                                break;
                            }
                            if (jc.equals("\u5426")) {
                                vo.setIfheaRadioactivity(Global.FALSE);
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5065\u5eb7\u68c0\u67e5\u653e\u5c04\u6027\u56e0\u7d20\u8f93\u5165\u683c\u5f0f\u9519\u8bef;<br/>");
                            break;
                        }
                        case 17: {
                            if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                            jc = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)jc)) {
                                vo.setHeaRadioactivityPeoples(Integer.valueOf(Integer.parseInt(jc)));
                                break;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u653e\u5c04\u6027\u56e0\u7d20\u4f53\u68c0\u4eba\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
                        }
                    }
                    continue;
                }
                if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) continue;
                jc = cell.getStringCellValue().trim();
                if (StringUtils.isInteger((String)jc)) {
                    DeclareHealthExtend extend = new DeclareHealthExtend();
                    extend.setCheckNum(Integer.valueOf(Integer.parseInt(jc)));
                    extend.setHarmName((String)harmNameMap.get(i));
                    extend.setHarmType((String)harmTypeMap.get(i));
                    extendList.add(extend);
                    continue;
                }
                vo.setHaveError(Boolean.valueOf(false));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u4f53\u68c0\u4eba\u6570\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6574\u6570;<br/>");
            }
            if (extendList.size() > 0) {
                vo.setExtendList(extendList);
            }
            healthList.add(vo);
        }
        return healthList;
    }

    private List<DeclareProduct> getProductInfoFromSheet(HSSFSheet sheetAt) {
        ArrayList<DeclareProduct> productList = new ArrayList<DeclareProduct>();
        int rowIndex = 0;
        int cellIndex = 3;
        Iterator iter = sheetAt.rowIterator();
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            if (++rowIndex == 1) continue;
            DeclareProduct vo = new DeclareProduct();
            vo.setHaveError(Boolean.valueOf(true));
            vo.setErrorReason("");
            block7: for (int i = 0; i <= cellIndex; ++i) {
                Cell cell = row.getCell(i);
                if (cell == null) {
                    cell = new HSSFWorkbook().createSheet().createRow(1).createCell(0);
                }
                cell.setCellType(CellType.STRING);
                switch (i) {
                    case 0: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            String serrial = cell.getStringCellValue().trim();
                            if (StringUtils.isInteger((String)serrial)) {
                                vo.setSerial(Integer.valueOf(Integer.parseInt(serrial)));
                                continue block7;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5e8f\u53f7\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6570\u5b57;<br/>");
                            continue block7;
                        }
                        vo.setHaveError(Boolean.valueOf(false));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5e8f\u53f7\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block7;
                    }
                    case 1: {
                        if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) continue block7;
                        vo.setProdName(cell.getStringCellValue());
                        continue block7;
                    }
                    case 2: {
                        if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) continue block7;
                        vo.setAnnualOutput(cell.getStringCellValue());
                        continue block7;
                    }
                    case 3: {
                        if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) continue block7;
                        vo.setUnitName(cell.getStringCellValue());
                    }
                }
            }
            productList.add(vo);
        }
        return productList;
    }

    private String getExcelColName(int index) {
        if (index <= 26) {
            return String.valueOf((char)(65 + index - 1));
        }
        int a = index / 26;
        int b = index % 26;
        return String.valueOf((char)(65 + a - 1)) + String.valueOf((char)(65 + b - 1));
    }

    private String subString(String str, String strStart, String strEnd) {
        int strStartIndex = str.indexOf(strStart);
        int strEndIndex = str.indexOf(strEnd);
        if (strStartIndex < 0) {
            return "\u5b57\u7b26\u4e32 :---->" + str + "<---- \u4e2d\u4e0d\u5b58\u5728 " + strStart + ", \u65e0\u6cd5\u622a\u53d6\u76ee\u6807\u5b57\u7b26\u4e32";
        }
        if (strEndIndex < 0) {
            return "\u5b57\u7b26\u4e32 :---->" + str + "<---- \u4e2d\u4e0d\u5b58\u5728 " + strEnd + ", \u65e0\u6cd5\u622a\u53d6\u76ee\u6807\u5b57\u7b26\u4e32";
        }
        String result = str.substring(strStartIndex, strEndIndex).substring(strStart.length());
        return result;
    }

    private static void dateHandle(Cell cell) {
        String dateStr;
        if (cell.getCellTypeEnum() == CellType.STRING && StringUtils.isNotEmpty((String)(dateStr = cell.getStringCellValue()))) {
            Date date = DateUtils.parseDate((Object)dateStr.trim());
            if (date == null) {
                cell.setCellType(CellType.BLANK);
            } else {
                cell.setCellValue(date);
            }
        }
    }

    @Transactional(readOnly=false)
    public int addDecInfoFromExcle(DeclareImportVo vo) {
        List baseList = vo.getBaseList();
        Map<Integer, DeclareCheck> checkMap = this.getCheckMap(vo.getCheckList());
        Map<Integer, DeclareHarm> harmMap = this.getHarmMap(vo.getHarmList());
        Map<Integer, DeclareHealth> healthMap = this.getHealthMap(vo.getHealthList());
        Map<Integer, List<DeclareProduct>> productMap = this.getProductMap(vo.getProductList());
        for (DeclareBase base : baseList) {
            DeclareHarm harm = harmMap.get(base.getSerial());
            DeclareCheck check = checkMap.get(base.getSerial());
            DeclareHealth health = healthMap.get(base.getSerial());
            List<DeclareProduct> pros = productMap.get(base.getSerial());
            base = (DeclareBase)this.declareBaseService.add((Object)base);
            if (check != null) {
                check.setDeclareId(base.getId());
                this.declareCheckService.addWithExtend(check);
            }
            if (harm != null) {
                harm.setDeclareId(base.getId());
                this.declareHarmService.addWithExtend(harm);
            }
            if (health != null) {
                health.setDeclareId(base.getId());
                this.declareHealthService.addWithExtend(health);
            }
            if (pros == null) continue;
            for (DeclareProduct pro : pros) {
                pro.setDeclareId(base.getId());
                this.declareProductService.add((Object)pro);
            }
        }
        return baseList.size();
    }

    public DeclareBase addDeclareInfo(DeclareBase info) {
        DeclareHarm harm = info.getHarm();
        DeclareCheck check = info.getCheck();
        DeclareHealth health = info.getHealth();
        info = (DeclareBase)this.declareBaseService.add((Object)info);
        if (check != null) {
            check.setDeclareId(info.getId());
            this.declareCheckService.addWithExtend(check);
        }
        if (harm != null) {
            harm.setDeclareId(info.getId());
            this.declareHarmService.addWithExtend(harm);
        }
        if (health != null) {
            health.setDeclareId(info.getId());
            this.declareHealthService.addWithExtend(health);
        }
        return info;
    }

    private Map<Integer, DeclareCheck> getCheckMap(List<DeclareCheck> checkList) {
        HashMap<Integer, DeclareCheck> checkMap = new HashMap<Integer, DeclareCheck>();
        if (checkList != null) {
            for (DeclareCheck check : checkList) {
                checkMap.put(check.getSerial(), check);
            }
        }
        return checkMap;
    }

    private Map<Integer, DeclareHarm> getHarmMap(List<DeclareHarm> checkList) {
        HashMap<Integer, DeclareHarm> checkMap = new HashMap<Integer, DeclareHarm>();
        if (checkList != null) {
            for (DeclareHarm check : checkList) {
                checkMap.put(check.getSerial(), check);
            }
        }
        return checkMap;
    }

    private Map<Integer, DeclareHealth> getHealthMap(List<DeclareHealth> checkList) {
        HashMap<Integer, DeclareHealth> checkMap = new HashMap<Integer, DeclareHealth>();
        if (checkList != null) {
            for (DeclareHealth check : checkList) {
                checkMap.put(check.getSerial(), check);
            }
        }
        return checkMap;
    }

    private Map<Integer, List<DeclareProduct>> getProductMap(List<DeclareProduct> checkList) {
        HashMap<Integer, List<DeclareProduct>> checkMap = new HashMap<Integer, List<DeclareProduct>>();
        if (checkList != null) {
            for (DeclareProduct pro : checkList) {
                if (checkMap.get(pro.getSerial()) != null) {
                    ((List)checkMap.get(pro.getSerial())).add(pro);
                    continue;
                }
                ArrayList<DeclareProduct> pros = new ArrayList<DeclareProduct>();
                pros.add(pro);
                checkMap.put(pro.getSerial(), pros);
            }
        }
        return checkMap;
    }
}

