/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.declare;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.health.entity.base.company.WandaDeclare;
import cn.smarthse.modules.health.supervise.dao.declare.DeclareBaseMapper;
import cn.smarthse.modules.health.supervise.entity.declare.CompanyDeclareInfo;
import cn.smarthse.modules.health.supervise.entity.declare.DeclareBase;
import cn.smarthse.modules.health.supervise.entity.declare.DeclareData;
import cn.smarthse.modules.health.supervise.service.certificate.ISuperviseCertificateService;
import cn.smarthse.modules.health.supervise.service.declare.IDeclareBaseService;
import cn.smarthse.modules.health.supervise.service.declare.IDeclareCheckService;
import cn.smarthse.modules.health.supervise.service.declare.IDeclareHarmService;
import cn.smarthse.modules.health.supervise.service.declare.IDeclareHealthService;
import cn.smarthse.modules.health.supervise.service.declare.IDeclareProductService;
import cn.smarthse.modules.health.supervise.service.harmFactorDeclare.IDeclareInfoService;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class DeclareBaseServiceImpl
extends BaseServiceImpl<DeclareBaseMapper, DeclareBase>
implements IDeclareBaseService {
    @Autowired
    IDeclareCheckService declareCheckService;
    @Autowired
    IDeclareHarmService declareHarmService;
    @Autowired
    IDeclareHealthService declareHealthService;
    @Autowired
    IDeclareProductService declareProductService;
    @Autowired
    ISuperviseCertificateService superviseCertificateService;
    @Autowired
    IDeclareInfoService declareInfoService;

    public DeclareData getDeclareDetailById(Long id) {
        DeclareData info = new DeclareData();
        DeclareBase base = (DeclareBase)this.getById(id);
        if (base.getIfLeadersTrain() == null || !base.getIfLeadersTrain().booleanValue()) {
            base.setIfLeadersTrain(this.superviseCertificateService.haveMainEffectiveCertByCid(base.getCid()));
        }
        if (base.getIfManagersTrain() == null || !base.getIfManagersTrain().booleanValue()) {
            base.setIfManagersTrain(this.superviseCertificateService.haveHseManageEffectiveCertByCid(base.getCid()));
        }
        info.setBase(base);
        info.setCheck(this.declareCheckService.getDeclareCheckByDecId(id));
        info.setHarm(this.declareHarmService.getDeclareHarmByDecId(id));
        info.setHealth(this.declareHealthService.getDeclareHealthByDecId(id));
        info.setProductList(this.declareProductService.getDeclareProductListByDecId(id));
        return info;
    }

    public CompanyDeclareInfo getCompanyDeclareInfo(Long cid) {
        return ((DeclareBaseMapper)this.dao).getCompanyDeclareInfo(cid);
    }

    public List<Long> getTrainCidListByYear(Long areaId, Byte level, Integer year) {
        return ((DeclareBaseMapper)this.dao).getTrainCidListBy(areaId, level, year);
    }

    public Boolean getHavaDecInfoByCidAndYear(Long cid) {
        int num = this.declareInfoService.getDeclareNumByCidAndYear(cid, null);
        if (num > 0) {
            return true;
        }
        DeclareBase base = new DeclareBase();
        base.setCid(cid);
        List list = ((DeclareBaseMapper)this.dao).select(base);
        if (list != null && list.size() > 0) {
            return true;
        }
        return false;
    }

    public Boolean getDeclareLastDetail(Long cid) {
        int i = ((DeclareBaseMapper)this.dao).getDeclareLastDetail(cid);
        return i > 0;
    }

    public WandaDeclare getLastOneWandaDeclareByCid(Long cid) {
        List<WandaDeclare> list = ((DeclareBaseMapper)this.dao).getWandaDeclareListByCid(cid);
        if (list != null && list.size() > 0 && !list.isEmpty() && StringUtils.isNotEmpty((String)list.get(0).getDeclareYear())) {
            String s = list.get(0).getDeclareYear() + "-01-01 10:10:00";
            Date date = DateUtil.getDate((String)s, (String)"yyyy-MM-dd HH:mm:ss");
            list.get(0).setLoadTime(date);
            return list.get(0);
        }
        return null;
    }
}

