/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.dataChange;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.health.supervise.dao.dataChange.DataChangeInfoMapper;
import cn.smarthse.modules.health.supervise.entity.company.CompanyHarmCollectModel;
import cn.smarthse.modules.health.supervise.entity.company.CompanyMajorInduCollectModel;
import cn.smarthse.modules.health.supervise.entity.dataChange.DataChangeInfo;
import cn.smarthse.modules.health.supervise.enums.DataChangeTypeEnum;
import cn.smarthse.modules.health.supervise.service.check.ISuperviseCheckThirdHomeService;
import cn.smarthse.modules.health.supervise.service.company.IThirdCompanyService;
import cn.smarthse.modules.health.supervise.service.dataChange.IDataChangeInfoService;
import cn.smarthse.modules.health.supervise.service.harmFactorDeclare.IDeclareInfoService;
import cn.smarthse.modules.health.supervise.service.hccheckplan.IHcCheckAreaThirdStatService;
import cn.smarthse.modules.health.supervise.service.trainPlan.ISuperviseTrainPlanService;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class DataChangeServiceImpl
extends BaseServiceImpl<DataChangeInfoMapper, DataChangeInfo>
implements IDataChangeInfoService {
    @Autowired
    ISuperviseCheckThirdHomeService superviseCheckThirdHomeService;
    @Autowired
    IDeclareInfoService declareInfoService;
    @Autowired
    IHcCheckAreaThirdStatService hcCheckAreaThirdStatService;
    @Autowired
    IThirdCompanyService thirdCompanyService;
    @Autowired
    ISuperviseTrainPlanService superviseTrainPlanService;
    @DubboReference
    private ICheckPlanService checkPlanService;

    @Transactional(readOnly=false)
    public DataChangeInfo getByAreaIdAndType(Integer year, Long areaId, Byte areaLevel, Byte dataChangeType, Byte ownLevel) {
        DataChangeInfo dataChangeInfo = this.getData(areaId, dataChangeType, ownLevel);
        dataChangeInfo = this.diffData(dataChangeInfo, areaId, areaLevel, dataChangeType, year, ownLevel);
        return dataChangeInfo;
    }

    @Transactional(readOnly=false)
    public List<DataChangeInfo> getList(Integer year, Long areaId, Byte areaLevel, Byte ownLevel) {
        DataChangeTypeEnum[] types;
        List<DataChangeInfo> list = this.getListData(areaId, null, ownLevel);
        ArrayList<DataChangeInfo> result = new ArrayList<DataChangeInfo>();
        for (DataChangeTypeEnum type : types = DataChangeTypeEnum.values()) {
            if (!type.getDisplayFlag()) continue;
            DataChangeInfo data = this.findInList(list, type.getCode());
            data = this.diffData(data, areaId, areaLevel, type.getCode(), year, ownLevel);
            result.add(data);
        }
        return result;
    }

    @Transactional(readOnly=false)
    public DataChangeInfo getDiseaserChange(Long areaId, Byte areaLevel, Integer year, Byte ownLevel) {
        return this.getByAreaIdAndType(year, areaId, areaLevel, DataChangeTypeEnum.DISEASERS.getCode(), ownLevel);
    }

    @Transactional(readOnly=false)
    public DataChangeInfo getCheckRateChange(Long areaId, Byte areaLevel, Integer year, Byte ownLevel) {
        return this.getByAreaIdAndType(year, areaId, areaLevel, DataChangeTypeEnum.CHECK.getCode(), ownLevel);
    }

    private DataChangeInfo diffData(DataChangeInfo dataChangeInfo, Long areaId, Byte areaLevel, Byte dataChangeType, Integer year, Byte ownLevel) {
        Date now;
        if (dataChangeInfo == null) {
            String data = this.getDataByType(areaId, areaLevel, dataChangeType, year, ownLevel);
            DataChangeInfo newData = this.addData(data, areaId, dataChangeType, ownLevel);
            return newData;
        }
        Date updateTime = dataChangeInfo.getUpdateTime();
        boolean isSameDayFlag = DateUtils.isSameDay((Date)updateTime, (Date)(now = new Date()));
        if (isSameDayFlag) {
            return dataChangeInfo;
        }
        String data = this.getDataByType(areaId, areaLevel, dataChangeType, year, ownLevel);
        if (dataChangeInfo.getNowData().equals(data)) {
            this.updateDataUpdateTime(dataChangeInfo);
            return dataChangeInfo;
        }
        DataChangeInfo updateData = this.updateData(dataChangeInfo, data);
        return updateData;
    }

    private DataChangeInfo findInList(List<DataChangeInfo> list, Byte code) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (DataChangeInfo l : list) {
            if (!code.equals(l.getDataType())) continue;
            return l;
        }
        return null;
    }

    private DataChangeInfo getData(Long areaId, Byte code, Byte ownLevel) {
        List<DataChangeInfo> list = this.getListData(areaId, code, ownLevel);
        return list == null || list.isEmpty() ? null : list.get(0);
    }

    private List<DataChangeInfo> getListData(Long areaId, Byte code, Byte ownLevel) {
        Example example = new Example(DataChangeInfo.class);
        Example.Criteria criteria = example.createCriteria().andEqualTo("areaId", (Object)areaId).andEqualTo("dataType", (Object)code).andEqualTo("isValid", (Object)true);
        if (ownLevel != null) {
            criteria.andEqualTo("ownLevel", (Object)ownLevel);
        } else {
            criteria.andIsNull("ownLevel");
        }
        List list = ((DataChangeInfoMapper)this.dao).selectByExample(example);
        return list;
    }

    private String getDataByType(Long areaId, Byte areaLevel, Byte dataChangeType, Integer year, Byte ownLevel) {
        Date thisYearBeginTime = DateUtils.getYearFirstDay((int)year);
        Date thisYearEndTime = DateUtils.getYearLastDay((int)year);
        Date lastYearEndTime = DateUtils.getYearLastDay((int)(year - 1));
        Date lastThreeYearBeginTime = DateUtils.getDistanceDate((Date)thisYearBeginTime, (int)1, (int)-3);
        if (DataChangeTypeEnum.CHECK_THIS_YEAR.getCode().equals(dataChangeType)) {
            return "" + this.superviseCheckThirdHomeService.checkComNumByDate(thisYearBeginTime, thisYearEndTime, areaId, areaLevel, ownLevel);
        }
        if (DataChangeTypeEnum.CHECK_LAST_THREE_YEARS.getCode().equals(dataChangeType)) {
            return "" + this.superviseCheckThirdHomeService.checkComNumByDate(lastThreeYearBeginTime, thisYearEndTime, areaId, areaLevel, ownLevel);
        }
        if (DataChangeTypeEnum.CHECK_TOTAL.getCode().equals(dataChangeType)) {
            return "" + this.superviseCheckThirdHomeService.checkComNumByDate(null, null, areaId, areaLevel, ownLevel);
        }
        if (DataChangeTypeEnum.DISEASERS.getCode().equals(dataChangeType)) {
            Integer diseasers = this.superviseCheckThirdHomeService.diseasers(year, areaId, areaLevel, ownLevel);
            return diseasers == null ? "" : String.valueOf(diseasers);
        }
        if (DataChangeTypeEnum.COMPANY.getCode().equals(dataChangeType)) {
            Integer companyNumByAreaId = this.thirdCompanyService.countCompanyNumByAreaId(areaId, areaLevel, ownLevel);
            return companyNumByAreaId == null ? "" : String.valueOf(companyNumByAreaId);
        }
        if (DataChangeTypeEnum.KEYCOMPANY.getCode().equals(dataChangeType)) {
            CompanyMajorInduCollectModel companyMajorInduCollectModel = this.thirdCompanyService.collectCompanyMajorIndu(areaId, ownLevel == null ? null : Integer.valueOf(ownLevel.intValue()));
            if (companyMajorInduCollectModel != null) {
                return String.valueOf(companyMajorInduCollectModel.getTotal());
            }
        } else if (DataChangeTypeEnum.KEYHARM.getCode().equals(dataChangeType)) {
            CompanyHarmCollectModel companyHarmCollectModel = this.thirdCompanyService.countCompanyHarm(areaId, ownLevel == null ? null : Integer.valueOf(ownLevel.intValue()));
            if (companyHarmCollectModel != null) {
                return String.valueOf(companyHarmCollectModel.getTotal());
            }
        } else {
            Integer checkCount;
            if (DataChangeTypeEnum.HARMER.getCode().equals(dataChangeType)) {
                Integer personCount = this.hcCheckAreaThirdStatService.getWorkHarmStaffCountByAreaAndYear(areaId.toString(), areaLevel, year, ownLevel);
                return personCount == null ? "" : String.valueOf(personCount);
            }
            if (DataChangeTypeEnum.HCCHECK.getCode().equals(dataChangeType)) {
                Integer checkCount2 = this.checkPlanService.countComNumByYearByArea(areaId, areaLevel, year, ownLevel);
                Integer totalCount = this.thirdCompanyService.countCompanyNumByAreaId(areaId, areaLevel, ownLevel);
                if (checkCount2 != null && totalCount != null) {
                    return String.valueOf(new BigDecimal((double)(checkCount2 * 100) / (double)totalCount.intValue()).setScale(1, 4)) + "%";
                }
                return "0.0%";
            }
            if (DataChangeTypeEnum.TRAIN_TOTAL.getCode().equals(dataChangeType)) {
                Integer trainNum = this.superviseTrainPlanService.getTrainCompanyNumByAreaAndTime(areaId, areaLevel, null, null, ownLevel);
                return "" + trainNum;
            }
            if (DataChangeTypeEnum.TRAIN_LAST_THREE_YEARS.getCode().equals(dataChangeType)) {
                int trainNum = this.superviseTrainPlanService.getTrainCompanyNumByAreaAndTime(areaId, areaLevel, lastThreeYearBeginTime, lastYearEndTime, ownLevel);
                return "" + trainNum;
            }
            if (DataChangeTypeEnum.TRAIN_THIS_YEAR.getCode().equals(dataChangeType)) {
                int trainNum = this.superviseTrainPlanService.getTrainCompanyNumByAreaAndTime(areaId, areaLevel, thisYearBeginTime, thisYearEndTime, ownLevel);
                return "" + trainNum;
            }
            if (DataChangeTypeEnum.DECLEAR_TOTAL.getCode().equals(dataChangeType)) {
                int decNum = this.declareInfoService.getDeclareCompanyNumByAreaAndTime(areaId, areaLevel, null, null, ownLevel);
                return "" + decNum;
            }
            if (DataChangeTypeEnum.DECLEAR_LAST_THREE_YEARS.getCode().equals(dataChangeType)) {
                int decNum = this.declareInfoService.getDeclareCompanyNumByAreaAndTime(areaId, areaLevel, lastThreeYearBeginTime, lastYearEndTime, ownLevel);
                return "" + decNum;
            }
            if (DataChangeTypeEnum.DECLEAR_THIS_YEAR.getCode().equals(dataChangeType)) {
                int decNum = this.declareInfoService.getDeclareCompanyNumByAreaAndTime(areaId, areaLevel, thisYearBeginTime, thisYearEndTime, ownLevel);
                return "" + decNum;
            }
            if (DataChangeTypeEnum.HCCHECK_TOTAL.getCode().equals(dataChangeType)) {
                Integer checkCount3 = this.checkPlanService.countComNumByYearByArea(areaId, areaLevel, null, ownLevel);
                if (checkCount3 != null) {
                    return "" + checkCount3;
                }
            } else if (DataChangeTypeEnum.HCCHECK_LAST_THREE_YEARS.getCode().equals(dataChangeType)) {
                Integer checkCount4 = this.checkPlanService.countComNumByTimeRangeByArea(areaId, areaLevel, DateUtil.getFromDate((Date)lastThreeYearBeginTime), DateUtil.getFromDate((Date)lastYearEndTime), ownLevel);
                if (checkCount4 != null) {
                    return "" + checkCount4;
                }
            } else if (DataChangeTypeEnum.HCCHECK_THIS_YEAR.getCode().equals(dataChangeType) && (checkCount = this.checkPlanService.countComNumByYearByArea(areaId, areaLevel, year, ownLevel)) != null) {
                return "" + checkCount;
            }
        }
        return "";
    }

    private DataChangeInfo addData(String data, Long areaId, Byte code, Byte ownLevel) {
        DataChangeInfo dataChangeInfo = new DataChangeInfo();
        Date now = new Date();
        dataChangeInfo.setAreaId(areaId);
        dataChangeInfo.setDataType(code);
        dataChangeInfo.setDataTypeName(DataChangeTypeEnum.getName((Byte)code));
        dataChangeInfo.setLastData(data);
        dataChangeInfo.setNowData(data);
        dataChangeInfo.setCreateTime(now);
        dataChangeInfo.setUpdateTime(now);
        dataChangeInfo.setDataChangeTime(now);
        dataChangeInfo.setIsValid(Boolean.valueOf(true));
        dataChangeInfo.setOwnLevel(ownLevel);
        return this.add(dataChangeInfo);
    }

    private DataChangeInfo updateData(DataChangeInfo data, String newData) {
        Date now = new Date();
        data.setLastData(data.getNowData());
        data.setNowData(newData);
        data.setUpdateTime(now);
        data.setDataChangeTime(now);
        ((DataChangeInfoMapper)this.dao).updateByPrimaryKey(data);
        return data;
    }

    private DataChangeInfo updateDataUpdateTime(DataChangeInfo data) {
        Date now = new Date();
        data.setUpdateTime(now);
        ((DataChangeInfoMapper)this.dao).updateByPrimaryKey(data);
        return data;
    }

    private String getParentCodeByAreaIdAndLevel(String areaId, Byte level) {
        String parentCode = "";
        if (level == 1) {
            parentCode = areaId.substring(0, 2);
        } else if (level == 2) {
            parentCode = areaId.substring(0, 4);
        } else if (level == 3) {
            parentCode = areaId.substring(0, 6);
        } else if (level == 4) {
            parentCode = areaId.substring(0, 9);
        }
        return parentCode;
    }

    @Transactional(readOnly=false)
    public DataChangeInfo getTrainRateChange(Long areaId, Byte areaLevel, Integer year, Byte ownLevel) {
        return this.getByAreaIdAndType(year, areaId, areaLevel, DataChangeTypeEnum.TRAIN.getCode(), ownLevel);
    }

    public DataChangeInfo getDecalreRateChange(Long areaId, Byte areaLevel, Integer declareNum, Byte ownLevel) {
        return this.getByAreaIdAndType(declareNum, areaId, areaLevel, DataChangeTypeEnum.DECLEAR.getCode(), ownLevel);
    }

    public DataChangeInfo getCompanyChange(Long areaId, Byte areaLevel, Integer year, Byte ownLevel) {
        return this.getByAreaIdAndType(year, areaId, areaLevel, DataChangeTypeEnum.COMPANY.getCode(), ownLevel);
    }

    public DataChangeInfo getMajorInduChange(Long areaId, Byte areaLevel, Integer year, Byte ownLevel) {
        return this.getByAreaIdAndType(year, areaId, areaLevel, DataChangeTypeEnum.KEYCOMPANY.getCode(), ownLevel);
    }

    public DataChangeInfo getHarmChange(Long areaId, Byte areaLevel, Integer year, Byte ownLevel) {
        return this.getByAreaIdAndType(year, areaId, areaLevel, DataChangeTypeEnum.KEYHARM.getCode(), ownLevel);
    }
}

