/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.companyoutpack;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.enums.CompanySizeEnum;
import cn.smarthse.modules.datacentre.model.companyoutpack.CompanyOutpackSearchModel;
import cn.smarthse.modules.datacentre.model.companyoutpack.OutpackRelationDto;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.supervise.dao.companyoutpack.CompanyOutpackRelationMapper;
import cn.smarthse.modules.health.supervise.entity.companyChange.CompanyChangeInfoDetail;
import cn.smarthse.modules.health.supervise.entity.companyoutpack.CompanyOutpackRelation;
import cn.smarthse.modules.health.supervise.model.companyChange.CompanyChangeChooseModel;
import cn.smarthse.modules.health.supervise.model.companyChange.CompanyChangeSearchModel;
import cn.smarthse.modules.health.supervise.service.companyoutpack.ICompanyOutpackService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.snowflake.IdWorker;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class CompanyOutpackServiceImpl
extends BaseServiceImpl<CompanyOutpackRelationMapper, CompanyOutpackRelation>
implements ICompanyOutpackService {
    @Resource
    private CompanyOutpackRelationMapper companyOutpackRelationMapper;
    @Autowired
    private DataSourceTransactionManager txManager;
    @Autowired
    protected IdWorker idworker;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;

    @Transactional(readOnly=false)
    public int delOutpackRelation(Long workId) {
        OutpackRelationDto outpackRelation = new OutpackRelationDto();
        outpackRelation.setWorkId(workId);
        return this.updateOutpackRelation(outpackRelation, null);
    }

    @Transactional(readOnly=false)
    public int updateOutpackRelation(OutpackRelationDto outpackRelation, Long loginStaffId) {
        if (outpackRelation != null && outpackRelation.getWorkId() != null) {
            Long workId = outpackRelation.getWorkId();
            Long beLongCid = outpackRelation.getBeLongCid();
            if (beLongCid != null) {
                CompanyOutpackRelation relation = new CompanyOutpackRelation();
                relation.setSourceId(workId);
                relation.setOutpackCid(beLongCid);
                relation.setRealCid(outpackRelation.getRealCid());
                relation.setCreateBy(loginStaffId);
                relation.setUpdateDate(new Date());
                relation.setIsValid(Boolean.valueOf(true));
                relation.setId(Long.valueOf(((BaseServiceImpl)this).idworker.nextId()));
                this.logger.debug("\u4f20\u5165\u5b9e\u4f53\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)relation));
                return this.companyOutpackRelationMapper.insert(relation);
            }
        }
        return 0;
    }

    @Transactional(readOnly=false)
    public int updateOutpackRelationBatch(List<OutpackRelationDto> outpackRelationList, Long loginStaffId) {
        if (CollectionUtils.isNotEmpty(outpackRelationList)) {
            ArrayList<Long> sourceList = new ArrayList<Long>();
            ArrayList<CompanyOutpackRelation> companyOutpackRelationList = new ArrayList<CompanyOutpackRelation>();
            for (OutpackRelationDto outpackRelationDto : outpackRelationList) {
                sourceList.add(outpackRelationDto.getWorkId());
                Long beLongCid = outpackRelationDto.getBeLongCid();
                if (beLongCid == null) continue;
                CompanyOutpackRelation relation = new CompanyOutpackRelation();
                relation.setSourceId(outpackRelationDto.getWorkId());
                relation.setOutpackCid(beLongCid);
                relation.setRealCid(outpackRelationDto.getRealCid());
                relation.setCreateBy(loginStaffId);
                relation.setCreateDate(new Date());
                relation.setIsValid(Boolean.valueOf(true));
                companyOutpackRelationList.add(relation);
            }
            if (CollectionUtils.isNotEmpty(sourceList)) {
                Example relationE = new Example(CompanyOutpackRelation.class);
                relationE.createCriteria().andIn("sourceId", sourceList);
                this.companyOutpackRelationMapper.deleteByExample(relationE);
            }
            if (CollectionUtils.isNotEmpty(companyOutpackRelationList)) {
                return this.saveOutpackRelationBatch(companyOutpackRelationList);
            }
        }
        return 0;
    }

    public Long getIdByName(String name) {
        CompanySuperviseSearchModel searchModel = new CompanySuperviseSearchModel();
        searchModel.setName(name);
        searchModel.setCompanyType(Integer.valueOf(2));
        List<CompanySuperviseModel> companySuperviseModels = this.companyOutpackRelationMapper.listSimpleCompanyInfo(searchModel);
        if (CollectionUtils.isNotEmpty(companySuperviseModels)) {
            return companySuperviseModels.get(0).getId();
        }
        return null;
    }

    public String getNameById(Long id) {
        CompanySuperviseSearchModel searchModel = new CompanySuperviseSearchModel();
        searchModel.setId(id);
        List<CompanySuperviseModel> companySuperviseModels = this.companyOutpackRelationMapper.listSimpleCompanyInfo(searchModel);
        if (CollectionUtils.isNotEmpty(companySuperviseModels)) {
            return companySuperviseModels.get(0).getName();
        }
        return null;
    }

    public List<CompanySuperviseModel> listCompanyOutpackInfo(CompanyOutpackSearchModel searchModel) {
        return this.companyOutpackRelationMapper.listCompanyOutpackInfo(searchModel, null);
    }

    public List<CompanySuperviseModel> listLaborDispatchUnitInfo(CompanyOutpackSearchModel searchModel) {
        if (searchModel.getAreaId() != null) {
            Byte areaLevel = this.companyOutpackRelationMapper.getAreaLevel(searchModel.getAreaId());
            searchModel.setAreaLevel(areaLevel);
        }
        return this.companyOutpackRelationMapper.listCompanyOutpackInfo(searchModel, "OC");
    }

    public List<CompanySuperviseModel> listCompanyOutpackInfoHis(CompanySuperviseSearchModel searchModel) {
        List<CompanySuperviseModel> companySuperviseModelList;
        AreaModel areaModel;
        Page localPage = PageHelper.getLocalPage();
        int pageNum = 0;
        int pageSize = 0;
        if (localPage != null) {
            pageNum = localPage.getPageNum();
            pageSize = localPage.getPageSize();
            localPage.clear();
        }
        if (searchModel.getAreaId() != null && searchModel.getAreaLevel() == null && (areaModel = this.sysAreaProvideService.getAreaById(searchModel.getAreaId())) != null) {
            searchModel.setAreaLevel(areaModel.getLevel());
        }
        if (searchModel.getOrgAreaId() != null && searchModel.getOrgAreaLevel() == null && (areaModel = this.sysAreaProvideService.getAreaById(searchModel.getOrgAreaId())) != null) {
            searchModel.setOrgAreaLevel(areaModel.getLevel());
        }
        if (localPage != null) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
        }
        if (CollectionUtils.isNotEmpty(companySuperviseModelList = this.companyOutpackRelationMapper.listCompanyOutpackInfoHis(searchModel))) {
            for (CompanySuperviseModel companySuperviseModel : companySuperviseModelList) {
                companySuperviseModel.setTingDetailName(">");
                if (!NumberUtils.isNumber((String)companySuperviseModel.getScale())) continue;
                companySuperviseModel.setScaleName(CompanySizeEnum.getName((Integer)Integer.parseInt(companySuperviseModel.getScale())));
            }
        }
        return companySuperviseModelList;
    }

    public PageInfo<CompanySuperviseModel> pageCompanyOutpackInfoHis(JqGridParam gridParam, CompanySuperviseSearchModel searchModel) {
        PageHelper.startPage((int)gridParam.getPage(), (int)gridParam.getRows());
        List<CompanySuperviseModel> superviseModelList = this.listCompanyOutpackInfoHis(searchModel);
        PageInfo page = new PageInfo(superviseModelList);
        return page;
    }

    public PageInfo<CompanySuperviseModel> pageCompanyOutpackInfo(JqGridParam gridParam, CompanyOutpackSearchModel searchModel, String oc, Byte areaLevelByte, Boolean isCurrent) {
        AreaModel areaById;
        if (searchModel.getAreaLevel() == null && "OC".equals(oc)) {
            Byte areaLevel = this.companyOutpackRelationMapper.getAreaLevel(searchModel.getAreaId());
            searchModel.setAreaLevel(areaLevel);
        }
        if (areaLevelByte != null && (areaLevelByte == 1 || areaLevelByte == 2)) {
            searchModel.setBelongType(Integer.valueOf(areaLevelByte.byteValue()));
        } else {
            searchModel.setBelongType(Integer.valueOf(0));
        }
        if (searchModel.getAreaId() != null && (areaById = this.sysAreaProvideService.getAreaById(searchModel.getAreaId())) != null) {
            if (areaById.getLevel() != null && (areaById.getLevel() == 1 || areaById.getLevel() == 2)) {
                searchModel.setBelongType(Integer.valueOf(areaById.getLevel().byteValue()));
            } else {
                searchModel.setBelongType(Integer.valueOf(0));
            }
        }
        PageHelper.startPage((int)gridParam.getPage(), (int)gridParam.getRows());
        List<CompanySuperviseModel> companySuperviseModelList = this.companyOutpackRelationMapper.listCompanyOutpackInfo(searchModel, oc);
        PageInfo page = new PageInfo(companySuperviseModelList);
        return page;
    }

    private int saveOutpackRelationBatch(List<CompanyOutpackRelation> companyOutpackRelationList) {
        int pointsDataLimit = 100;
        int listSize = companyOutpackRelationList.size();
        int maxSize = listSize - 1;
        int n = 0;
        ArrayList<CompanyOutpackRelation> newList = new ArrayList<CompanyOutpackRelation>();
        for (int i = 0; i < companyOutpackRelationList.size(); ++i) {
            newList.add(companyOutpackRelationList.get(i));
            if (pointsDataLimit != newList.size() && i != maxSize) continue;
            int count = this.companyOutpackRelationMapper.insertCompanyOutpackRelationBatch(newList);
            n += count;
            newList.clear();
        }
        return n;
    }

    public int countOutPackById(Long outpackCid) {
        Example e = new Example(CompanyOutpackRelation.class);
        e.createCriteria().andEqualTo("outpackCid", (Object)outpackCid).andEqualTo("isValid", (Object)true);
        return this.companyOutpackRelationMapper.selectCountByExample(e);
    }

    public Integer getAreaOcNum(Long areaId) {
        Integer ocNum = this.companyOutpackRelationMapper.selectAreaOcNum(areaId);
        return ocNum;
    }

    public PageInfo<CompanySuperviseModel> getPageAreaOCInfo(JqGridParam param, CompanySuperviseSearchModel companySearchVo) {
        return null;
    }

    public Long getOutpackCompanyChooseCount(CompanyChangeSearchModel searchVo, Integer companyType) {
        if (searchVo.getSearchAreaId() != null && searchVo.getSearchAreaId() != 0L) {
            Byte searchAreaLevel = this.companyOutpackRelationMapper.getAreaLevel(searchVo.getSearchAreaId());
            searchVo.setSearchAreaLevel(searchAreaLevel);
        }
        int size = ((CompanyOutpackRelationMapper)this.dao).getOutpackCompanyChooseList(searchVo, companyType).size();
        return size;
    }

    public PageInfo<CompanyChangeChooseModel> getOutpackCompanyChooseList(JqGridParam param, CompanyChangeSearchModel searchVo, Integer companyType) {
        if (searchVo.getSearchAreaId() != null && searchVo.getSearchAreaId() != 0L) {
            Byte searchAreaLevel = this.companyOutpackRelationMapper.getAreaLevel(searchVo.getSearchAreaId());
            searchVo.setSearchAreaLevel(searchAreaLevel);
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows(), (boolean)false);
        List<CompanyChangeChooseModel> list = ((CompanyOutpackRelationMapper)this.dao).getOutpackCompanyChooseList(searchVo, companyType);
        return new PageInfo(list);
    }

    public CompanyChangeInfoDetail getOutpackCompanyChangeInfoDetailWithComInfo(Long id) {
        if (Objects.isNull(id)) {
            return null;
        }
        CompanyChangeInfoDetail info = ((CompanyOutpackRelationMapper)this.dao).getOutpackCompanyChangeInfoDetailWithComInfo(id);
        return info;
    }

    public Integer getCompanyChangeInfoDetailType(Long changeInfoId, Long cid) {
        Integer changeType = ((CompanyOutpackRelationMapper)this.dao).selectCompanyChangeInfoDetailType(changeInfoId, cid);
        return changeType;
    }

    @Transactional
    public void modifyOutpackCompanyInfoById(Integer companyType, Long cid) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        try {
            ((CompanyOutpackRelationMapper)this.dao).updateOutpackCompanyInfoById(companyType, cid);
            this.txManager.commit(status);
        }
        catch (Exception e) {
            this.txManager.rollback(status);
            e.printStackTrace();
        }
    }

    public String queryChooseMapSpliceAreaName(Long chooseMapAreaId) throws Exception {
        if (chooseMapAreaId == null || chooseMapAreaId == 0L) {
            return "\u56fd\u5bb6";
        }
        String chooseMapAreaName = this.companyOutpackRelationMapper.queryChooseMapSpliceAreaName(chooseMapAreaId);
        return StringUtils.isBlank((CharSequence)chooseMapAreaName) ? "\u56fd\u5bb6" : chooseMapAreaName;
    }
}

