/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.companyChange;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.supervise.dao.companyChange.CompanyChangeInfoVictimsHistoryMapper;
import cn.smarthse.modules.health.supervise.entity.companyChange.CompanyChangeInfo;
import cn.smarthse.modules.health.supervise.entity.companyChange.CompanyChangeInfoVictimsHistory;
import cn.smarthse.modules.health.supervise.model.companyChange.CompanyChangeSearchModel;
import cn.smarthse.modules.health.supervise.service.companyChange.ICompanyChangeInfoVictimsHistoryService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@DubboService
public class CompanyChangeInfoVictimsHistoryServiceImpl
extends BaseServiceImpl<CompanyChangeInfoVictimsHistoryMapper, CompanyChangeInfoVictimsHistory>
implements ICompanyChangeInfoVictimsHistoryService {
    public JqGridData<CompanyChangeInfo> getVictimsChangeInfoList(JqGridParam gparam, CompanyChangeSearchModel searchVo) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<CompanyChangeInfo> list = ((CompanyChangeInfoVictimsHistoryMapper)this.dao).getVictimsCompanyChangeInfoList(searchVo);
        return new JqGridData((Page)list, gparam);
    }

    public List<Integer> getYearList(CompanyChangeSearchModel searchVo) {
        int lastYear;
        List<Integer> yearList = ((CompanyChangeInfoVictimsHistoryMapper)this.dao).getYearList(searchVo);
        if (!yearList.contains(lastYear = LocalDateTime.now().getYear() - 1)) {
            yearList.add(lastYear);
        }
        return yearList;
    }

    @Transactional
    public void batchSaveCompanyChangeInfoVictimsHistory(List<CompanyChangeInfoVictimsHistory> changeInfoVictimsHistories) {
        if (CollUtil.isNotEmpty(changeInfoVictimsHistories)) {
            this.batchUpdateOrInsert(changeInfoVictimsHistories, CompanyChangeInfoVictimsHistoryMapper.class, (item, mapper) -> ((CompanyChangeInfoVictimsHistoryMapper)this.dao).insert(item));
        }
    }

    public JqGridData<CompanyChangeInfoVictimsHistory> getViewVictimsListData(JqGridParam gparam, CompanyChangeSearchModel searchVo) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<CompanyChangeInfoVictimsHistory> list = this.getViewVictimsList(searchVo);
        return new JqGridData((Page)list, gparam);
    }

    public List<CompanyChangeInfoVictimsHistory> getViewVictimsList(CompanyChangeSearchModel searchVo) {
        return ((CompanyChangeInfoVictimsHistoryMapper)this.dao).getViewVictimsListData(searchVo);
    }
}

