/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.companyChange;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.companyChange.v3.model.vo.CompanyChangeVictimsL3DataVo;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeV3Rec;
import cn.smarthse.modules.health.enums.home.grade.CompanyGradeEnum;
import cn.smarthse.modules.health.enums.home.grade.GradeSourceEnum;
import cn.smarthse.modules.health.fcyth.dao.FcythTbcCompanyMapper;
import cn.smarthse.modules.health.fcyth.entity.FcythTbcCompany;
import cn.smarthse.modules.health.fcyth.service.IFcythTbcCompanyClueService;
import cn.smarthse.modules.health.supervise.dao.companyChange.CompanyChangeInfoMapper;
import cn.smarthse.modules.health.supervise.entity.companyChange.CompanyChangeInfo;
import cn.smarthse.modules.health.supervise.entity.companyChange.CompanyChangeInfoDetail;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeTypeEnum;
import cn.smarthse.modules.health.supervise.model.companyChange.CompanyChangeChooseModel;
import cn.smarthse.modules.health.supervise.model.companyChange.CompanyChangeSearchModel;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RecService;
import cn.smarthse.modules.health.supervise.service.companyChange.ICompanyChangeInfoService;
import cn.smarthse.modules.health.supervise.vo.companyChange.CompanyChangeEnterpriseVo;
import cn.smarthse.modules.health.supervise.vo.companyChange.CompanyChangeTypeUnconfirmedInfoVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional(readOnly=true)
@DubboService
public class CompanyChangeInfoServiceImpl
extends BaseServiceImpl<CompanyChangeInfoMapper, CompanyChangeInfo>
implements ICompanyChangeInfoService {
    @Autowired
    private FcythTbcCompanyMapper tbcCompanyMapper;
    @Autowired
    private IFcythTbcCompanyClueService fcythTbcCompanyClueService;
    @Autowired
    private ICompanyGradeV3RecService companyGradeV3RecService;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;

    public Integer getBackNumByArea(Integer type, Long areaId, Byte areaLevel, Integer status) {
        return ((CompanyChangeInfoMapper)this.dao).getBackNumByArea(type, areaId, areaLevel, status);
    }

    public Map<String, Integer> getCompanyDetailStatusNumsByChangeId(Long changeId) {
        List<CompanyChangeInfoDetail> list = ((CompanyChangeInfoMapper)this.dao).getCompanyDetailStatusNumsByChangeId(changeId);
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyMap();
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (CompanyChangeInfoDetail infoDetail : list) {
            String key = "detailStatusNum" + infoDetail.getDetailStatus();
            map.put(key, map.getOrDefault(key, 0) + 1);
        }
        return map;
    }

    public Map<String, Integer> getCompanyDetailStatusNumsByChangeId5(Long areaId, Byte areaLevel) {
        List<CompanyChangeInfoDetail> list = ((CompanyChangeInfoMapper)this.dao).getCompanyDetailStatusNumsByChangeId5(areaId, areaLevel);
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyMap();
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (CompanyChangeInfoDetail infoDetail : list) {
            String key = "detailStatusNum" + infoDetail.getDetailStatus();
            map.put(key, map.getOrDefault(key, 0) + 1);
        }
        return map;
    }

    public Map<String, Integer> getNewCompanyCountInDifferentStatus(Long regionId, Byte regionLevel) {
        List<CompanyChangeInfoDetail> detailList = ((CompanyChangeInfoMapper)this.dao).getNewCompanyChangeDetailList(regionId, regionLevel);
        return detailList.stream().collect(Collectors.toMap(infoDetail -> "detailStatusNum" + infoDetail.getDetailStatus(), infoDetail -> 1, Integer::sum));
    }

    public Boolean getRemainingAuditQuantity(Long changeInfoId) {
        Map<Integer, Integer> map = ((CompanyChangeInfoMapper)this.dao).getRemainingAuditQuantity(changeInfoId);
        return CollUtil.isEmpty(map) || map.keySet().stream().noneMatch(i -> i == 0 || i == 1);
    }

    public PageInfo<CompanyChangeInfo> getCompanyChangeInfoList(JqGridParam gparam, CompanyChangeSearchModel param) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        EnumSet<CompanyChangeTypeEnum[]> readOnlyTypeViewers = EnumSet.of(CompanyChangeTypeEnum.delete, new CompanyChangeTypeEnum[]{CompanyChangeTypeEnum.crossMigration, CompanyChangeTypeEnum.ocStateChange, CompanyChangeTypeEnum.victimsGE3, CompanyChangeTypeEnum.victimsL3, CompanyChangeTypeEnum.comToNonMedicalRadiology, CompanyChangeTypeEnum.nonMedicalRadiologyToCom});
        CompanyChangeTypeEnum changeType = CompanyChangeTypeEnum.getEnum((Integer)param.getChangeType());
        param.setReadOnlySubChangeApprovalViewer(Boolean.valueOf(readOnlyTypeViewers.contains(changeType)));
        List<CompanyChangeInfo> list = ((CompanyChangeInfoMapper)this.dao).getCompanyChangeInfoList(param);
        if (CompanyChangeTypeEnum.victimsL3.getCode().equals(param.getChangeType())) {
            list.stream().peek(i -> {
                CompanyChangeVictimsL3DataVo dataVo = ((CompanyChangeInfoMapper)this.dao).getVictimsL3DataVo(i.getAreaId(), i.getAreaLevel());
                if (Objects.nonNull(dataVo)) {
                    i.setIsVictimsL3ExceedsHalf(Boolean.valueOf((double)dataVo.getIsVictimsL3Num().intValue() >= (double)dataVo.getIsDecNum().intValue() * 0.3));
                }
            }).collect(Collectors.toList());
        }
        if (Objects.equals(CompanyChangeTypeEnum.ocStateChange.getCode(), param.getChangeType()) || Objects.equals(CompanyChangeTypeEnum.ocAndComStateChange.getCode(), param.getChangeType())) {
            for (CompanyChangeInfo change : list) {
                if (Objects.equals(CompanyChangeTypeEnum.ocStateChange.getCode(), change.getChangeType())) {
                    change.setOption(Integer.valueOf(1));
                }
                if (!Objects.equals(CompanyChangeTypeEnum.ocChangToEmployUnit.getCode(), change.getChangeType())) continue;
                change.setOption(Integer.valueOf(2));
            }
        }
        return new PageInfo(list);
    }

    public PageInfo<CompanyChangeInfo> getNewCompanyChangeInfoList(JqGridParam pageParam, CompanyChangeSearchModel companyParam) {
        Page newCompanyPage = PageHelper.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        List<CompanyChangeInfo> newCompanyList = ((CompanyChangeInfoMapper)this.dao).getNewCompanyChangeInfoList(companyParam);
        return new PageInfo((List)newCompanyPage);
    }

    public List<CompanyChangeTypeUnconfirmedInfoVo> getChangeTypeUnconfirmedList(Long regionId, Byte regionLevel, List<Integer> changeTypeList) {
        return ((CompanyChangeInfoMapper)this.dao).getChangeTypeUnconfirmedList(regionId, regionLevel, changeTypeList);
    }

    public List<CompanyChangeTypeUnconfirmedInfoVo> getClueTypeUnconfirmedList(Long regionId, Byte regionLevel, List<Integer> changeTypeList, Byte systemDeploymentSource) {
        return ((CompanyChangeInfoMapper)this.dao).getClueTypeUnconfirmedList(regionId, regionLevel, changeTypeList, systemDeploymentSource);
    }

    public Long getIntoLocalUnconfirmedNum(Long regionId, Byte regionLevel) {
        return ((CompanyChangeInfoMapper)this.dao).getIntoLocalUnconfirmedNum(regionId, regionLevel);
    }

    public List<Long> getIntoLocalOrgIdListByChangeId(Long changeId) {
        return ((CompanyChangeInfoMapper)this.dao).getIntoLocalOrgIdListByChangeId(changeId);
    }

    public PageInfo<CompanyChangeChooseModel> getCompanyChooseList(JqGridParam gparam, CompanyChangeSearchModel param) {
        List<CompanyChangeChooseModel> list;
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows(), (boolean)false);
        if (Objects.equals(param.getChangeType(), CompanyChangeTypeEnum.victimsGE3.getCode()) || Objects.equals(param.getChangeType(), CompanyChangeTypeEnum.victimsL3.getCode())) {
            if (Objects.equals(param.getChangeType(), CompanyChangeTypeEnum.victimsGE3.getCode())) {
                param.setReversalChangeType(CompanyChangeTypeEnum.victimsL3.getCode());
            } else {
                param.setReversalChangeType(CompanyChangeTypeEnum.victimsGE3.getCode());
            }
            param.setYear(Integer.valueOf(LocalDateTime.now().getYear()));
            list = ((CompanyChangeInfoMapper)this.dao).getVictimsCompanyChooseList(param);
        } else {
            list = ((CompanyChangeInfoMapper)this.dao).getCompanyChooseList(param);
            this.judgementInClueTag(list);
            this.judgeDustForbiddenExit(param, list);
            this.postSetCompanyGradeInfo(param, list);
        }
        return new PageInfo(list);
    }

    public PageInfo<CompanyChangeChooseModel> getChooseNewCompanyList(JqGridParam pageParam, CompanyChangeSearchModel companyParam) {
        Page newCompanyPage = PageHelper.startPage((int)pageParam.getPage(), (int)pageParam.getRows(), (boolean)Boolean.FALSE);
        List<CompanyChangeChooseModel> newCompanyList = ((CompanyChangeInfoMapper)this.dao).getChooseNewCompanyList(companyParam);
        return new PageInfo((List)newCompanyPage);
    }

    private void judgementInClueTag(List<CompanyChangeChooseModel> companyChangeList) {
        if (CollUtil.isEmpty(companyChangeList)) {
            return;
        }
        List changeCidList = companyChangeList.stream().map(CompanyChangeChooseModel::getCid).collect(Collectors.toList());
        Example example = new Example(FcythTbcCompany.class);
        example.createCriteria().andIn("cid", changeCidList).andEqualTo("isValid", (Object)Boolean.TRUE).andEqualTo("state", (Object)0);
        List dbCompanyList = this.tbcCompanyMapper.selectByExample(example);
        companyChangeList.forEach(c -> {
            Long changeCid = c.getCid();
            boolean isInDb = dbCompanyList.stream().anyMatch(d -> Objects.equals(changeCid, d.getCid()));
            if (isInDb) {
                c.setAlreadyInClue(Integer.valueOf(1));
            }
        });
    }

    private void judgeDustForbiddenExit(CompanyChangeSearchModel param, List<CompanyChangeChooseModel> companyList) {
        if (CompanyChangeTypeEnum.getEnum((Integer)param.getChangeType()) != CompanyChangeTypeEnum.removeDustImportantCompany) {
            return;
        }
        List cidList = companyList.stream().map(CompanyChangeChooseModel::getCid).collect(Collectors.toList());
        List forbiddenCidList = this.fcythTbcCompanyClueService.getCanNotExitCid(cidList);
        if (forbiddenCidList.isEmpty()) {
            return;
        }
        Set classACidList = Optional.ofNullable(this.companyGradeV3RecService.getGradeByCids(forbiddenCidList)).orElse(Collections.emptyList()).stream().filter(g -> Objects.equals(Convert.toByte((Object)g.getGrade()), CompanyGradeEnum.CLASSA.getValue())).map(CompanyGradeV3Rec::getCid).collect(Collectors.toSet());
        companyList.forEach(company -> {
            if (forbiddenCidList.contains(company.getCid()) && !classACidList.contains(company.getCid())) {
                company.setIsDustForbiddenExit(Boolean.TRUE);
            }
        });
    }

    private void postSetCompanyGradeInfo(CompanyChangeSearchModel param, List<CompanyChangeChooseModel> companyList) {
        if (CompanyChangeTypeEnum.getEnum((Integer)param.getChangeType()) != CompanyChangeTypeEnum.changeToClassC) {
            return;
        }
        for (CompanyChangeChooseModel company : companyList) {
            GradeSourceEnum gradeSource;
            CompanyGradeEnum grade = CompanyGradeEnum.getEnum((Byte)company.getGrade());
            if (grade != null) {
                company.setGradeName(grade.getName());
            }
            if ((gradeSource = GradeSourceEnum.getEnum((Integer)Convert.toInt((Object)company.getGradeSource()))) == null) continue;
            company.setGradeSourceName(gradeSource.getName());
        }
    }

    public Long getCompanyChooseCount(CompanyChangeSearchModel param) {
        Long l;
        if (Objects.equals(param.getChangeType(), CompanyChangeTypeEnum.victimsGE3.getCode()) || Objects.equals(param.getChangeType(), CompanyChangeTypeEnum.victimsL3.getCode())) {
            if (Objects.equals(param.getChangeType(), CompanyChangeTypeEnum.victimsGE3.getCode())) {
                param.setReversalChangeType(CompanyChangeTypeEnum.victimsL3.getCode());
            } else {
                param.setReversalChangeType(CompanyChangeTypeEnum.victimsGE3.getCode());
            }
            param.setYear(Integer.valueOf(LocalDateTime.now().getYear()));
            l = ((CompanyChangeInfoMapper)this.dao).getVictimsCompanyChooseCount(param);
        } else {
            l = ((CompanyChangeInfoMapper)this.dao).getCompanyChooseCount(param);
        }
        return l;
    }

    public Long getChooseNewCompanyListCount(CompanyChangeSearchModel companyParam) {
        return ((CompanyChangeInfoMapper)this.dao).getChooseNewCompanyListCount(companyParam);
    }

    public Boolean checkHaveSubCompany(Long changeId) {
        if (Objects.isNull(changeId)) {
            return false;
        }
        Integer i = ((CompanyChangeInfoMapper)this.dao).getHaveSubCompanyList(changeId);
        return Objects.nonNull(i) && i > 0;
    }

    public Boolean checkHaveSubCompanyWithNoConflict(Long changeId) {
        if (Objects.isNull(changeId)) {
            return false;
        }
        List<CompanyChangeChooseModel> toChangeCidTypeList = ((CompanyChangeInfoMapper)this.dao).getNeedChangeTypeAndCidById(changeId);
        if (CollectionUtils.isNotEmpty(toChangeCidTypeList)) {
            Map<Long, String> toChangeCidTypeMap = toChangeCidTypeList.stream().collect(Collectors.toMap(CompanyChangeChooseModel::getCid, CompanyChangeChooseModel::getChangeType, (a, b) -> a));
            List<CompanyChangeChooseModel> inChangeCidTypeList = ((CompanyChangeInfoMapper)this.dao).getChangingTypeByCidList(toChangeCidTypeMap.keySet());
            if (CollectionUtils.isEmpty(inChangeCidTypeList)) {
                return false;
            }
            HashMap<Integer, Set<Integer>> needJudgeTypes = new HashMap<Integer, Set<Integer>>();
            for (Map.Entry<Long, String> toChangeCidTypeEntry : toChangeCidTypeMap.entrySet()) {
                Long toChangeCid = toChangeCidTypeEntry.getKey();
                Integer toChangeType = Integer.parseInt(toChangeCidTypeEntry.getValue());
                Set nowChangeTypeSet = inChangeCidTypeList.stream().filter(o -> Objects.equals(toChangeCid, o.getCid())).map(o -> Integer.parseInt(o.getChangeType())).collect(Collectors.toSet());
                if (nowChangeTypeSet.isEmpty()) continue;
                Set latestChangeTypeSet = (Set)needJudgeTypes.get(toChangeType);
                if (CollectionUtils.isEmpty((Collection)latestChangeTypeSet)) {
                    needJudgeTypes.put(toChangeType, nowChangeTypeSet);
                    continue;
                }
                latestChangeTypeSet.addAll(nowChangeTypeSet);
                needJudgeTypes.put(toChangeType, latestChangeTypeSet);
            }
            if (!needJudgeTypes.isEmpty()) {
                List<Map<String, Long>> noConflictList = ((CompanyChangeInfoMapper)this.dao).getNoConflictInfo();
                if (CollectionUtils.isEmpty(noConflictList)) {
                    return true;
                }
                ArrayList<Map<Long, Long>> noConflictProList = new ArrayList<Map<Long, Long>>();
                for (Map<String, Long> noConflictMap : noConflictList) {
                    HashMap<Long, Long> noConflictProMap = new HashMap<Long, Long>();
                    Long needToChangeType = noConflictMap.get("needToChangeType");
                    Long changingType = noConflictMap.get("changingType");
                    noConflictProMap.put(needToChangeType, changingType);
                    noConflictProList.add(noConflictProMap);
                }
                return ((CompanyChangeInfoMapper)this.dao).isChangeTypeConflict(needJudgeTypes, noConflictProList);
            }
        }
        return false;
    }

    public Map<Integer, Integer> getCompanyNumsGroupByBusinessState(Long changeId) {
        return ((CompanyChangeInfoMapper)this.dao).getCompanyNumsGroupByBusinessState(changeId);
    }

    public List<CompanyChangeInfoDetail> getCompanyIsFormalProcess(Long changeId, Long cid) {
        return ((CompanyChangeInfoMapper)this.dao).getCompanyIsFormalProcess(changeId, cid);
    }

    public List<CompanyChangeInfoDetail> getCompanyIsFormalProcessByCidList(Long changeId, List<Long> cidList) {
        return ((CompanyChangeInfoMapper)this.dao).getCompanyIsFormalProcessByCidList(changeId, cidList);
    }

    public List<Long> getCompanyCidIsVictimsByCidList(Integer year, Integer changeType, List<Long> cidList) {
        return ((CompanyChangeInfoMapper)this.dao).getCompanyCidIsVictimsByCidList(year, changeType, cidList);
    }

    public PageInfo<CompanyChangeEnterpriseVo> getChangeEnterpriseList(JqGridParam gparam, CompanyChangeSearchModel searchVo) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows(), (boolean)gparam.getCount());
        List<CompanyChangeEnterpriseVo> list = ((CompanyChangeInfoMapper)this.dao).getChangeEnterpriseList(searchVo);
        if (CollUtil.isNotEmpty(list) && Boolean.TRUE.equals(gparam.getCount())) {
            for (CompanyChangeEnterpriseVo enterpriseVo : list) {
                if (!StrUtil.isNotBlank((CharSequence)enterpriseVo.getFileIds())) continue;
                List fileModels = this.sysFileProvideService.getListByIds(enterpriseVo.getFileIds());
                enterpriseVo.setFiles(fileModels);
            }
        }
        return new PageInfo(list);
    }

    public List<Integer> getYearList(CompanyChangeSearchModel searchVo) {
        int lastYear;
        List<Integer> yearList = ((CompanyChangeInfoMapper)this.dao).getYearList(searchVo);
        if (!yearList.contains(lastYear = LocalDateTime.now().getYear() - 1)) {
            yearList.add(lastYear);
        }
        return yearList;
    }
}

