/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.companyChange;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.enums.home.grade.CompanyGradeEnum;
import cn.smarthse.modules.health.enums.home.grade.GradeSourceEnum;
import cn.smarthse.modules.health.supervise.dao.companyChange.CompanyChangeInfoDetailMapper;
import cn.smarthse.modules.health.supervise.entity.companyChange.CompanyChangeInfo;
import cn.smarthse.modules.health.supervise.entity.companyChange.CompanyChangeInfoDetail;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogEnum;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeConfirmTypeEnum;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeDetailStatusEnum;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeStatusEnum;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeTypeEnum;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeWorkStartEnum;
import cn.smarthse.modules.health.supervise.model.companyChange.CompanyChangeAddModel;
import cn.smarthse.modules.health.supervise.model.companyChange.CompanyChangeChooseModel;
import cn.smarthse.modules.health.supervise.model.companyChange.CompanyChangeImportModel;
import cn.smarthse.modules.health.supervise.model.companyChange.CompanyChangeSearchModel;
import cn.smarthse.modules.health.supervise.model.companyChange.CompanyChangeWorkMode;
import cn.smarthse.modules.health.supervise.service.companyChange.ICompanyChangeInfoDetailService;
import cn.smarthse.modules.health.supervise.service.companyChange.ICompanyChangeInfoService;
import cn.smarthse.modules.health.supervise.service.operate.IWorkOperateLogService;
import cn.smarthse.modules.health.supervise.vo.companyChange.CompanyChangeAutoChangeVo;
import cn.smarthse.modules.health.supervise.vo.companyChange.CompanyChangeConfirmedByJurisdictionExportDto;
import cn.smarthse.modules.health.supervise.vo.companyChange.CompanyChangeInfoDetailWithDraftVo;
import cn.smarthse.modules.platform.model.AreaModel;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional(readOnly=true)
@DubboService
public class CompanyChangeInfoDetailServiceImpl
extends BaseServiceImpl<CompanyChangeInfoDetailMapper, CompanyChangeInfoDetail>
implements ICompanyChangeInfoDetailService {
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @Autowired
    private IWorkOperateLogService workOperateLogService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @Autowired
    private ICompanyChangeInfoService companyChangeInfoService;

    public List<CompanyChangeInfoDetail> getCompanyChangeInfoDetailListData(Long changeId, Integer changeType, String keyWord, Integer isBackEdit) {
        List<CompanyChangeInfoDetail> list = ((CompanyChangeInfoDetailMapper)this.dao).getCompanyChangeInfoDetailListData(changeId, changeType, keyWord, isBackEdit);
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        CompanyChangeInfoDetailServiceImpl.postSetCompanyGradeInfo(changeType, list);
        return list.stream().filter(i -> !(Objects.equals(i.getDetailStatus(), CompanyChangeDetailStatusEnum.CONFIRMED.getCode()) && i.getConfirmTime().getYear() == LocalDateTime.now().getYear() || Objects.equals(i.getDetailStatus(), CompanyChangeDetailStatusEnum.PENDING_CONFIRMATION.getCode()) && Objects.equals(i.getChangeInfoId(), changeId) && Objects.equals(i.getStatus(), CompanyChangeStatusEnum.RETURNED.getCode()))).collect(Collectors.toList());
    }

    public static void postSetCompanyGradeInfo(Integer changeType, List<CompanyChangeInfoDetail> companyList) {
        if (CompanyChangeTypeEnum.getEnum((Integer)changeType) != CompanyChangeTypeEnum.changeToClassC) {
            return;
        }
        if (CollUtil.isEmpty(companyList)) {
            return;
        }
        for (CompanyChangeInfoDetail company : companyList) {
            GradeSourceEnum gradeSource;
            CompanyGradeEnum grade = CompanyGradeEnum.getEnum((Byte)company.getGrade());
            if (grade != null) {
                company.setGradeName(grade.getName());
            }
            if ((gradeSource = GradeSourceEnum.getEnum((Integer)Convert.toInt((Object)company.getGradeSource()))) == null) continue;
            company.setGradeSourceName(gradeSource.getName());
        }
    }

    public PageInfo<CompanyChangeInfoDetail> getCompanyChangeInfoDetailList(JqGridParam gparam, CompanyChangeSearchModel searchVo) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<CompanyChangeInfoDetail> list = ((CompanyChangeInfoDetailMapper)this.dao).getCompanyChangeInfoDetailList(searchVo);
        return new PageInfo(list);
    }

    public PageInfo<CompanyChangeInfoDetail> getVictimsCompanyChangeInfoDetailList(JqGridParam gparam, CompanyChangeSearchModel searchVo) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<CompanyChangeInfoDetail> list = ((CompanyChangeInfoDetailMapper)this.dao).getVictimsCompanyChangeInfoDetailList(searchVo);
        return new PageInfo(list);
    }

    public PageInfo<CompanyChangeInfoDetail> getListWorkAndConfirmedByJurisdictionDetailList(JqGridParam gparam, CompanyChangeSearchModel searchVo) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<CompanyChangeInfoDetail> list = ((CompanyChangeInfoDetailMapper)this.dao).getListWorkAndConfirmedByJurisdictionDetailList(searchVo);
        return new PageInfo(list);
    }

    public PageInfo<CompanyChangeInfoDetail> getNewCompanyPageInDifferentStatus(JqGridParam pageParam, CompanyChangeSearchModel companyParam) {
        Page newCompanyPage = PageHelper.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        List<CompanyChangeInfoDetail> newCompanyList = ((CompanyChangeInfoDetailMapper)this.dao).getNewCompanyListInDifferentStatus(companyParam);
        return new PageInfo((List)newCompanyPage);
    }

    @Transactional
    public CompanyChangeInfoDetail addCompanyToChange(CompanyChangeAddModel companyChangeAddModel) {
        Long cid = companyChangeAddModel.getCid();
        Long changeId = companyChangeAddModel.getChangeId();
        Long areaId = companyChangeAddModel.getAreaId();
        Integer isTransProvincial = companyChangeAddModel.getIsTransProvincial();
        Integer changeType = companyChangeAddModel.getChangeType();
        Long updateBy = companyChangeAddModel.getUpdateBy();
        if (isTransProvincial == null) {
            isTransProvincial = 0;
        }
        if (areaId == null) {
            areaId = 0L;
        }
        if (cid != null && changeId != null) {
            Example example = new Example(CompanyChangeInfoDetail.class);
            example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("changeInfoId", (Object)changeId).andEqualTo("isValid", (Object)true);
            CompanyChangeInfoDetail info = (CompanyChangeInfoDetail)((CompanyChangeInfoDetailMapper)this.dao).selectOneByExample(example);
            CompanySuperviseModel companySuperviseModel = this.companyProvideBySuperviseService.getCompanyInfoById(cid);
            if (info != null) {
                Integer changeType2 = info.getChangeType();
                info.setBusinessStatus(companySuperviseModel.getBusinessState());
                if (changeType2.equals(CompanyChangeTypeEnum.crossMigration.getCode()) || changeType2.equals(CompanyChangeTypeEnum.intraMigration.getCode()) || changeType2.equals(CompanyChangeTypeEnum.districtMigration.getCode())) {
                    info.setTransferBeforeAreaId(companySuperviseModel.getAreaDetailId());
                    info.setTransferAreaId(areaId);
                    info.setIsTransProvincial(isTransProvincial);
                }
                info.setUpdateBy(updateBy);
                info.setUpdateDate(new Date());
                this.update(info);
            } else {
                info = new CompanyChangeInfoDetail();
                info.setChangeInfoId(changeId);
                info.setChangeType(changeType);
                info.setCid(cid);
                info.setDetailStatus(CompanyChangeDetailStatusEnum.DRAFT.getCode());
                info.setBusinessStatus(companySuperviseModel.getBusinessState());
                if (changeType.equals(CompanyChangeTypeEnum.crossMigration.getCode()) || changeType.equals(CompanyChangeTypeEnum.intraMigration.getCode()) || changeType.equals(CompanyChangeTypeEnum.districtMigration.getCode())) {
                    info.setTransferBeforeAreaId(companySuperviseModel.getAreaDetailId());
                    info.setTransferAreaId(Long.valueOf(isTransProvincial == 0 ? areaId : 0L));
                    info.setIsTransProvincial(isTransProvincial);
                }
                info.setCreateBy(updateBy);
                info.setCreateDate(new Date());
                info = this.add(info);
            }
            return info;
        }
        return null;
    }

    @Transactional
    public Integer addBatchCompanyToChangeFromExcel(List<CompanyChangeImportModel> list, Long changeId, Integer changeType, Long updateBy) {
        if (CollUtil.isEmpty(list)) {
            return 0;
        }
        List<CompanyChangeInfoDetail> oldList = this.getCompanyChangeInfoDetailByChangeId(changeId);
        if (CollUtil.isNotEmpty(oldList)) {
            Set oldCidList = oldList.stream().map(CompanyChangeInfoDetail::getCid).collect(Collectors.toSet());
            list = list.stream().filter(model -> !oldCidList.contains(model.getCid())).collect(Collectors.toList());
        }
        ArrayList<CompanyChangeInfoDetail> rst = new ArrayList<CompanyChangeInfoDetail>(list.size());
        Date now = new Date();
        for (CompanyChangeImportModel model2 : list) {
            CompanyChangeInfoDetail info = new CompanyChangeInfoDetail();
            info.setId(Long.valueOf(this.idworker.nextId()));
            info.setChangeInfoId(changeId);
            if (Objects.equals(changeType, CompanyChangeTypeEnum.ocStateChange.getCode()) || Objects.equals(changeType, CompanyChangeTypeEnum.ocAndComStateChange.getCode()) || Objects.equals(changeType, CompanyChangeTypeEnum.ocChangToEmployUnit.getCode()) || Objects.equals(changeType, CompanyChangeTypeEnum.ocChangToEmployAndOcUnit.getCode())) {
                info.setChangeType(model2.getCompanyType());
            } else {
                info.setChangeType(changeType);
            }
            info.setCid(model2.getCid());
            info.setDetailStatus(CompanyChangeDetailStatusEnum.DRAFT.getCode());
            info.setBusinessStatus(model2.getBusinessStatus());
            if (changeType.equals(CompanyChangeTypeEnum.crossMigration.getCode()) || changeType.equals(CompanyChangeTypeEnum.intraMigration.getCode()) || changeType.equals(CompanyChangeTypeEnum.districtMigration.getCode())) {
                info.setTransferBeforeAreaId(model2.getTransferBeforeAreaId());
                info.setTransferAreaId(model2.getTransferAreaId());
                info.setIsTransProvincial(model2.getIsTransProvincial());
            }
            info.setCreateBy(updateBy);
            info.setCreateDate(now);
            info.setIsValid(Global.TRUE);
            rst.add(info);
        }
        return this.batchUpdateOrInsert(rst, CompanyChangeInfoDetailMapper.class, (item, mapper) -> mapper.insertSelective(item));
    }

    @Deprecated
    @Transactional
    public Integer addCompanyChangeInfoFromExcel(List<CompanyChangeImportModel> list, Integer changeType, Long updateBy) {
        for (CompanyChangeImportModel info : list) {
            CompanyChangeAddModel companyChangeAddModel = new CompanyChangeAddModel();
            companyChangeAddModel.setCid(info.getCid());
            companyChangeAddModel.setChangeId(info.getChangeId());
            companyChangeAddModel.setAreaId(info.getTransferAreaId());
            companyChangeAddModel.setIsTransProvincial(info.getIsTransProvincial());
            companyChangeAddModel.setChangeType(info.getCompanyType() == null ? changeType : Integer.valueOf(info.getCompanyType()));
            companyChangeAddModel.setUpdateBy(updateBy);
            this.addCompanyToChange(companyChangeAddModel);
        }
        return list.size();
    }

    @Transactional
    public void removeCompanyToChange(Long cid, Long changeId) {
        if (Objects.nonNull(cid) && Objects.nonNull(changeId)) {
            Example example = new Example(CompanyChangeInfoDetail.class);
            example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("changeInfoId", (Object)changeId).andEqualTo("isValid", (Object)Global.TRUE);
            ((CompanyChangeInfoDetailMapper)this.dao).deleteByExample(example);
        }
    }

    public CompanyChangeInfoDetail getCompanyChangeInfoDetailWithComInfo(Long id, Integer changeType) {
        if (Objects.isNull(id)) {
            return null;
        }
        CompanyChangeInfoDetail company = ((CompanyChangeInfoDetailMapper)this.dao).getCompanyChangeInfoDetailWithComInfo(id, changeType);
        CompanyChangeInfoDetailServiceImpl.postSetCompanyGradeInfo(changeType, CollUtil.toList((Object[])new CompanyChangeInfoDetail[]{company}));
        return company;
    }

    @Transactional
    public void updateDetailStatus(Long changeInfoId, Long cid, Integer detailStatus, Integer confirmType) {
        if (Objects.nonNull(changeInfoId) && Objects.nonNull(cid) && Objects.nonNull(detailStatus)) {
            Example example = new Example(CompanyChangeInfoDetail.class);
            example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("changeInfoId", (Object)changeInfoId).andEqualTo("isValid", (Object)Global.TRUE);
            CompanyChangeInfoDetail infoDetail = new CompanyChangeInfoDetail();
            infoDetail.setDetailStatus(detailStatus);
            infoDetail.setConfirmType(confirmType);
            infoDetail.setConfirmTime(LocalDateTime.now());
            ((CompanyChangeInfoDetailMapper)this.dao).updateByExampleSelective(infoDetail, example);
        }
    }

    @Transactional
    public void batchUpdateDetailStatus(Long changeInfoId, List<Long> cids, Integer detailStatus, Integer confirmType) {
        ((CompanyChangeInfoDetailMapper)this.dao).batchUpdateDetailStatus(changeInfoId, cids, detailStatus, confirmType);
    }

    @Transactional
    public void updateDetailStatusExcludeConfirmed(Long changeInfoId) {
        if (Objects.nonNull(changeInfoId)) {
            Example example = new Example(CompanyChangeInfoDetail.class);
            example.createCriteria().andEqualTo("changeInfoId", (Object)changeInfoId).andNotEqualTo("detailStatus", (Object)CompanyChangeDetailStatusEnum.CONFIRMED.getCode()).andEqualTo("isValid", (Object)Global.TRUE);
            CompanyChangeInfoDetail infoDetail = new CompanyChangeInfoDetail();
            infoDetail.setDetailStatus(CompanyChangeDetailStatusEnum.PENDING_CONFIRMATION.getCode());
            infoDetail.setUpdateDate(new Date());
            ((CompanyChangeInfoDetailMapper)this.dao).updateByExampleSelective(infoDetail, example);
            Example example2 = new Example(CompanyChangeInfoDetail.class);
            example2.createCriteria().andEqualTo("changeInfoId", (Object)changeInfoId).andNotEqualTo("detailStatus", (Object)CompanyChangeDetailStatusEnum.CONFIRMED.getCode()).andEqualTo("isValid", (Object)Global.TRUE).andIsNull("workCountdownStart");
            CompanyChangeInfoDetail infoDetail2 = new CompanyChangeInfoDetail();
            infoDetail2.setWorkCountdownStart(LocalDateTime.now());
            infoDetail2.setWorkStart(CompanyChangeWorkStartEnum.no.getCode());
            infoDetail2.setConfirmType(CompanyChangeConfirmTypeEnum.no.getCode());
            ((CompanyChangeInfoDetailMapper)this.dao).updateByExampleSelective(infoDetail2, example2);
        }
    }

    public List<CompanyChangeInfoDetail> getDataExcludeConfirmed(Long changeInfoId) {
        if (Objects.isNull(changeInfoId)) {
            return Collections.emptyList();
        }
        Example example = new Example(CompanyChangeInfoDetail.class);
        example.createCriteria().andEqualTo("changeInfoId", (Object)changeInfoId).andNotEqualTo("detailStatus", (Object)CompanyChangeDetailStatusEnum.CONFIRMED.getCode()).andEqualTo("isValid", (Object)Global.TRUE);
        return ((CompanyChangeInfoDetailMapper)this.dao).selectByExample(example);
    }

    public CompanyChangeInfoDetail getOneCompanyChangeInfoDetail(Long changInfoId, Long cid) {
        if (Objects.isNull(changInfoId) && Objects.isNull(cid)) {
            return null;
        }
        Example example = new Example(CompanyChangeInfoDetail.class);
        example.createCriteria().andEqualTo("changeInfoId", (Object)changInfoId).andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)Global.TRUE);
        return (CompanyChangeInfoDetail)((CompanyChangeInfoDetailMapper)this.dao).selectOneByExample(example);
    }

    public List<CompanyChangeInfoDetail> getListCompanyChangeInfoDetail(Long changInfoId, List<Long> cidList) {
        if (Objects.isNull(changInfoId) && CollUtil.isEmpty(cidList)) {
            return null;
        }
        Example example = new Example(CompanyChangeInfoDetail.class);
        example.createCriteria().andEqualTo("changeInfoId", (Object)changInfoId).andIn("cid", cidList).andEqualTo("isValid", (Object)Global.TRUE);
        return ((CompanyChangeInfoDetailMapper)this.dao).selectByExample(example);
    }

    public List<CompanyChangeInfo> getCompanyChangeInfoConfirmedByJurisdiction(Long areaId, Byte level) {
        return ((CompanyChangeInfoDetailMapper)this.dao).getCompanyChangeInfoConfirmedByJurisdiction(areaId, level);
    }

    public List<CompanyChangeConfirmedByJurisdictionExportDto> exportConfirmedByJurisdiction(Long areaId, Byte level, Integer detailStatus) {
        return ((CompanyChangeInfoDetailMapper)this.dao).exportConfirmedByJurisdiction(areaId, level, detailStatus);
    }

    public List<CompanyChangeInfoDetail> getCompanyChangeInfoDetailListByChangeInfoId(Long changeInfoId, Integer changeType) {
        if (Objects.isNull(changeInfoId) || Objects.isNull(changeType)) {
            return Collections.emptyList();
        }
        return ((CompanyChangeInfoDetailMapper)this.dao).getCompanyChangeInfoDetailListByChangeInfoId(changeInfoId, changeType);
    }

    public List<CompanyChangeInfoDetail> getCompanyChangeInfoDetailListByParams(CompanyChangeTypeEnum changeTypeEnum, Long changeInfoId, List<Integer> detailStatusList) {
        if (changeTypeEnum == null || changeInfoId == null || CollUtil.isEmpty(detailStatusList)) {
            throw new HealthException("\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        Example example = new Example(CompanyChangeInfoDetail.class);
        example.createCriteria().andEqualTo("isValid", (Object)Boolean.TRUE).andEqualTo("changeInfoId", (Object)changeInfoId).andEqualTo("changeType", (Object)changeTypeEnum.getCode()).andIn("detailStatus", detailStatusList);
        return ((CompanyChangeInfoDetailMapper)this.dao).selectByExample(example);
    }

    public List<String> getAlreadyFcythCompanyByChangeId(Long changeId) {
        if (changeId == null) {
            throw new HealthException("\u53d8\u66f4id\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        return ((CompanyChangeInfoDetailMapper)this.dao).getAlreadyFcythCompanyByChangeId(changeId);
    }

    public List<Company> getChangCompanyInfoByChangeId(Long changeId) {
        if (changeId == null) {
            throw new HealthException("\u53d8\u66f4id\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        return ((CompanyChangeInfoDetailMapper)this.dao).getChangCompanyInfoByChangeId(changeId);
    }

    public Map<Integer, Integer> getCompanyNumsGroupByRedundantBusinessState(Long changeId) {
        if (Objects.isNull(changeId)) {
            return Collections.emptyMap();
        }
        return ((CompanyChangeInfoDetailMapper)this.dao).getCompanyNumsGroupByRedundantBusinessState(changeId);
    }

    public List<CompanyChangeChooseModel> export2hr(Long changeId, Integer detailStatus) {
        if (Objects.isNull(changeId)) {
            return Collections.emptyList();
        }
        return ((CompanyChangeInfoDetailMapper)this.dao).export2hr(changeId, detailStatus);
    }

    @Transactional
    public Boolean workStartByManuOrAuto(CompanyChangeWorkMode changeBaseMode) {
        if (StrUtil.isBlank((CharSequence)changeBaseMode.getIds())) {
            return Global.FALSE;
        }
        List idList = StringUtils.parseToLongList((String)changeBaseMode.getIds());
        changeBaseMode.setIdList(idList);
        return ((CompanyChangeInfoDetailMapper)this.dao).workStartByManuOrAuto(changeBaseMode);
    }

    public List<CompanyChangeInfoDetail> needAutoDataList() {
        return ((CompanyChangeInfoDetailMapper)this.dao).needAutoDataList();
    }

    @Transactional
    public Integer needChangeWorkStart(HashSet<Long> ids) {
        return ((CompanyChangeInfoDetailMapper)this.dao).needChangeWorkStart(ids);
    }

    @Transactional
    public Integer needChangeConfirm(HashSet<Long> ids) {
        return ((CompanyChangeInfoDetailMapper)this.dao).needChangeConfirm(ids);
    }

    public PageInfo<CompanyChangeAutoChangeVo> getAutoChangeList(JqGridParam gparam, CompanyChangeSearchModel searchVo) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<CompanyChangeAutoChangeVo> rst = ((CompanyChangeInfoDetailMapper)this.dao).getAutoChangeList(searchVo);
        return new PageInfo(rst);
    }

    public List<CompanyChangeAutoChangeVo> getAutoChangeAllList(CompanyChangeSearchModel searchVo) {
        return ((CompanyChangeInfoDetailMapper)this.dao).getAutoChangeList(searchVo);
    }

    public List<CompanyChangeInfoDetail> getCompanyChangeInfoDetailByChangeId(Long changeId) {
        if (Objects.isNull(changeId)) {
            return Collections.emptyList();
        }
        Example example = new Example(CompanyChangeInfoDetail.class);
        example.createCriteria().andEqualTo("changeInfoId", (Object)changeId).andEqualTo("isValid", (Object)Boolean.TRUE);
        return this.getListByExample(example);
    }

    @Transactional
    public Integer delCompanyProcessByCid(Long cid, String name, Long areaId, Long userId, String fullName) {
        if (Objects.isNull(cid) || StrUtil.isBlank((CharSequence)name) || Objects.isNull(areaId)) {
            throw new HealthException("\u53c2\u6570\u5f02\u5e38");
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        linkedList.add(CompanyChangeTypeEnum.crossMigration.getCode());
        linkedList.add(CompanyChangeTypeEnum.intraMigration.getCode());
        linkedList.add(CompanyChangeTypeEnum.districtMigration.getCode());
        Example example = new Example(CompanyChangeInfoDetail.class);
        example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("cid", (Object)cid).andIn("changeType", linkedList);
        List companyChangeInfoDetails = ((CompanyChangeInfoDetailMapper)this.dao).selectByExample(example);
        if (CollUtil.isNotEmpty((Collection)companyChangeInfoDetails)) {
            List workIdList = companyChangeInfoDetails.stream().map(CompanyChangeInfoDetail::getChangeInfoId).collect(Collectors.toList());
            AreaModel area = this.sysAreaProvideService.getAreaById(areaId);
            if (CollUtil.isNotEmpty(workIdList) && Objects.nonNull(area)) {
                this.workOperateLogService.ignoreUseWorkIdList(workIdList, WorkOperateLogEnum.companyChange.getTypeVal(), "\u8be5\u4f01\u4e1a\u5df2\u88ab\u8fc1\u79fb\u81f3" + area.getCityName() + area.getAreaName() + area.getStreetName(), userId, fullName, cid);
            }
        }
        CompanyChangeInfoDetail companyChangeInfoDetail = new CompanyChangeInfoDetail();
        companyChangeInfoDetail.setIsValid(Global.FALSE);
        companyChangeInfoDetail.setUpdateBy(userId);
        int i = ((CompanyChangeInfoDetailMapper)this.dao).updateByExampleSelective(companyChangeInfoDetail, example);
        Long changeInfoId = ((CompanyChangeInfoDetail)companyChangeInfoDetails.get(0)).getChangeInfoId();
        CompanyChangeInfo companyChangeInfo = (CompanyChangeInfo)this.companyChangeInfoService.getById(changeInfoId);
        if (this.companyChangeInfoService.getRemainingAuditQuantity(changeInfoId).booleanValue()) {
            companyChangeInfo.setStatus(CompanyChangeStatusEnum.STOPPED.getCode());
            this.companyChangeInfoService.update((Object)companyChangeInfo, userId);
        }
        return i;
    }

    public Integer isHaveTransProvincialData(Long changeId) {
        if (Objects.isNull(changeId)) {
            throw new HealthException("\u53c2\u6570\u5f02\u5e38");
        }
        Example example = new Example(CompanyChangeInfoDetail.class);
        example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("isTransProvincial", (Object)1).andEqualTo("changeInfoId", (Object)changeId);
        List listByExample = this.getListByExample(example);
        return CollUtil.isNotEmpty(listByExample) ? 1 : 0;
    }

    @Transactional
    public Integer delByChangeInfoId(Long changeId) {
        if (Objects.isNull(changeId)) {
            throw new HealthException("\u53c2\u6570\u5f02\u5e38");
        }
        CompanyChangeInfoDetail companyChangeInfoDetail = new CompanyChangeInfoDetail();
        companyChangeInfoDetail.setIsValid(Global.FALSE);
        Example example = new Example(CompanyChangeInfoDetail.class);
        example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("changeInfoId", (Object)changeId);
        return ((CompanyChangeInfoDetailMapper)this.dao).updateByExampleSelective(companyChangeInfoDetail, example);
    }

    public List<CompanyChangeInfoDetailWithDraftVo> getCompanyChangeInfoDetailWithDraftVoList(List<Long> cidList, Integer changeType) {
        return ((CompanyChangeInfoDetailMapper)this.dao).getCompanyChangeInfoDetailWithDraftVoList(cidList, changeType);
    }
}

