/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.companyChange;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.supervise.dao.companyChange.CompanyChangeInfoDetailReturnLogMapper;
import cn.smarthse.modules.health.supervise.entity.companyChange.CompanyChangeInfoDetailReturnLog;
import cn.smarthse.modules.health.supervise.service.companyChange.ICompanyChangeInfoDetailReturnLogService;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional(readOnly=true)
@DubboService
public class CompanyChangeInfoDetailReturnLogServiceImpl
extends BaseServiceImpl<CompanyChangeInfoDetailReturnLogMapper, CompanyChangeInfoDetailReturnLog>
implements ICompanyChangeInfoDetailReturnLogService {
    @Transactional
    public Integer batchInsertReturnLogs(List<CompanyChangeInfoDetailReturnLog> data) {
        return CollUtil.isEmpty(data) ? 0 : ((CompanyChangeInfoDetailReturnLogMapper)this.dao).insertListData(data);
    }

    @Transactional
    public Integer addresubmissionTime(Long changeId, List<Long> cidList) {
        if (Objects.isNull(changeId) && CollUtil.isEmpty(cidList)) {
            return 0;
        }
        List<Long> needChangeResultLogIds = ((CompanyChangeInfoDetailReturnLogMapper)this.dao).getNeedChangeResultLogIds(changeId, cidList);
        if (CollUtil.isEmpty(needChangeResultLogIds)) {
            return 0;
        }
        Example example = new Example(CompanyChangeInfoDetailReturnLog.class);
        example.createCriteria().andIn("id", needChangeResultLogIds).andEqualTo("isValid", (Object)true);
        CompanyChangeInfoDetailReturnLog log = new CompanyChangeInfoDetailReturnLog();
        log.setResubmissionTime(LocalDateTime.now());
        return ((CompanyChangeInfoDetailReturnLogMapper)this.dao).updateByExampleSelective(log, example);
    }

    public List<CompanyChangeInfoDetailReturnLog> getOneCompanyReturnLogsData(Long changeId, Long cid, Long changeInfoDetailId, Boolean flag) {
        Example example = new Example(CompanyChangeInfoDetailReturnLog.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)1);
        if (Objects.isNull(flag)) {
            flag = false;
        }
        if (flag.booleanValue()) {
            criteria.andIsNotNull("resubmissionTime");
        }
        if (Objects.nonNull(changeId) && Objects.nonNull(cid)) {
            criteria.andEqualTo("changeInfoId", (Object)changeId).andEqualTo("cid", (Object)cid);
        } else {
            criteria.andEqualTo("changeInfoDetailId", (Object)changeInfoDetailId);
        }
        return ((CompanyChangeInfoDetailReturnLogMapper)this.dao).selectByExample(example);
    }
}

