/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.company.impl.newcompany;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.enums.CompanyGradeReasonEnum;
import cn.smarthse.modules.datacentre.model.NewCompanyContent;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.health.bx.entity.BxLastMonthZybSummary;
import cn.smarthse.modules.health.bx.service.IBxLastMonthZybSummaryService;
import cn.smarthse.modules.health.supervise.service.company.INewCompanyService;
import cn.smarthse.modules.health.supervise.service.company.impl.newcompany.NewCompanyProvideCommonService;
import cn.smarthse.modules.health.supervise.service.sys.ISysUserThirdService;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="newCompanyProvideZybService")
public class NewCompanyProvideZybService
extends NewCompanyProvideCommonService
implements INewCompanyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewCompanyProvideZybService.class);
    @DubboReference
    private IBxLastMonthZybSummaryService zybSummaryService;
    @Autowired
    private ISysUserThirdService sysUserThirdService;

    public boolean preHandle(NewCompanyContent content) throws Exception {
        CompanySuperviseModel companyInfo = content.getCompanyInfo();
        companyInfo.setIsDec(Boolean.valueOf(true));
        companyInfo.setIsDecCurrentYear(Boolean.valueOf(true));
        companyInfo.setIsDecOld(Boolean.valueOf(true));
        companyInfo.setGradeReason(CompanyGradeReasonEnum.ZYB_RISK_PUSH.getValue());
        return true;
    }

    @Transactional(readOnly=false)
    public void afterCompletion(NewCompanyContent content) {
        List dbUserList;
        CompanySuperviseModel companyParam = content.getCompanyInfo();
        if (companyParam != null && Objects.equals(companyParam.getStorageReason(), CompanyGradeReasonEnum.ZYB_RISK_PUSH.getValue()) && StringUtils.isNotBlank((CharSequence)companyParam.getDataSourceId())) {
            BxLastMonthZybSummary zybSummary = new BxLastMonthZybSummary();
            zybSummary.setId(Convert.toLong((Object)companyParam.getDataSourceId()));
            zybSummary.setCompanyId(companyParam.getCid());
            this.zybSummaryService.saveOrUpdateData(Arrays.asList(zybSummary));
        }
        if (CollUtil.isEmpty((Collection)(dbUserList = this.sysUserThirdService.getUserManager(content.getCompanyInfo().getCid())))) {
            this.sysUserThirdService.createSysUser((List)ListUtil.toList((Object[])new Long[]{content.getCompanyInfo().getCid()}), content.getLoginStaffId());
        }
    }
}

