/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.company.impl.newcompany;

import cn.hutool.core.text.CharSequenceUtil;
import cn.smarthse.modules.datacentre.model.NewCompanyContent;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.ImportCompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.ImportCompanySuperviseResultModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.supervise.service.company.INewCompanyService;
import java.util.Collection;
import java.util.List;
import javax.cn.smarthse.modules.health.exception.HealthException;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public abstract class NewCompanyProvideCommonService
implements INewCompanyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewCompanyProvideCommonService.class);
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyService;
    @Autowired
    private RedissonClient redissonClient;

    public void basicCheck(CompanySuperviseModel companyParam) {
        if (companyParam == null) {
            throw new HealthException("\u4f01\u4e1a\u4fe1\u606f\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (companyParam.getAreaId() == null) {
            throw new HealthException("\u884c\u653f\u533a\u5212\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (CharSequenceUtil.isBlank((CharSequence)companyParam.getUnifiedSocialCc())) {
            throw new HealthException("\u4fe1\u7528\u4ee3\u7801\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (CharSequenceUtil.isBlank((CharSequence)companyParam.getName())) {
            throw new HealthException("\u4f01\u4e1a\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        Integer storageReason = companyParam.getStorageReason();
        if (storageReason == null) {
            throw new HealthException("\u8bf7\u6307\u5b9a\u5206\u7c7b\u4f01\u4e1a\u5165\u5e93\u539f\u56e0\uff01");
        }
        if (companyParam.getCompanyType() == null) {
            throw new HealthException("\u4f01\u4e1a\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (companyParam.getDataSource() == null) {
            throw new HealthException("\u4f01\u4e1a\u6765\u6e90\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (companyParam.getRegisterType() == null) {
            throw new HealthException("\u4f01\u4e1a\u6ce8\u518c\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (companyParam.getIndustryCategory() == null) {
            throw new HealthException("\u4f01\u4e1a\u884c\u4e1a\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NewCompanyContent saveOrUpdateNewCompany(NewCompanyContent content) throws Exception {
        if (content == null) {
            throw new HealthException("content\u5fc5\u586b\u9879\u4e3a\u7a7a");
        }
        CompanySuperviseModel companyInfo = content.getCompanyInfo();
        String lockName = "NewCompanyProvideCommonService:saveOrUpdateNewCompanylock:" + companyInfo.getName() + ":" + companyInfo.getUnifiedSocialCc() + ":" + companyInfo.getCompanyType();
        RLock lock = this.redissonClient.getLock(lockName);
        if (lock.tryLock()) {
            try {
                if (!this.preHandle(content)) {
                    log.error("preHandle \u4f01\u4e1a\u4fe1\u606f\u6821\u9a8c\u4e0d\u901a\u8fc7");
                    throw new HealthException("\u4f01\u4e1a\u4fe1\u606f\u6821\u9a8c\u4e0d\u901a\u8fc7");
                }
                this.basicCheck(content.getCompanyInfo());
                ImportCompanySuperviseResultModel importCompanySuperviseResultModel = this.companyService.batchAddCompany(List.of(companyInfo), Boolean.valueOf(true));
                List errorList = importCompanySuperviseResultModel.getErrorList();
                if (CollectionUtils.isNotEmpty((Collection)errorList)) {
                    ImportCompanySuperviseModel importCompanySuperviseModel = (ImportCompanySuperviseModel)errorList.get(0);
                    throw new HealthException(importCompanySuperviseModel.getErrorInfo());
                }
                List succList = importCompanySuperviseResultModel.getSuccList();
                if (CollectionUtils.isNotEmpty((Collection)succList)) {
                    ImportCompanySuperviseModel importCompanySuperviseModel = (ImportCompanySuperviseModel)succList.get(0);
                    CompanySuperviseModel cr = new CompanySuperviseModel();
                    BeanUtils.copyProperties((Object)importCompanySuperviseModel, (Object)cr);
                    content.setCompanyInfo(cr);
                }
                this.afterCompletion(content);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("NewCompanyProvideCommonService:saveOrUpdateNewCompany\u9501\u83b7\u53d6\u5931\u8d25\uff0c lockName:{}", (Object)lockName);
        }
        return content;
    }
}

