/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.company.impl.newcompany;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.smarthse.modules.datacentre.enums.CompanyDataSourceEnum;
import cn.smarthse.modules.datacentre.enums.CompanyGradeReasonEnum;
import cn.smarthse.modules.datacentre.model.NewCompanyContent;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.health.supervise.service.company.INewCompanyService;
import cn.smarthse.modules.health.supervise.service.company.impl.newcompany.NewCompanyProvideCommonService;
import cn.smarthse.modules.health.supervise.service.sys.ISysUserThirdService;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="newCompanyOuterService")
public class NewCompanyOuterService
extends NewCompanyProvideCommonService
implements INewCompanyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewCompanyOuterService.class);
    @Autowired
    private ISysUserThirdService sysUserThirdService;

    public boolean preHandle(NewCompanyContent content) throws Exception {
        CompanySuperviseModel companyInfo = content.getCompanyInfo();
        companyInfo.setCompanyType(Integer.valueOf(1));
        companyInfo.setIsDec(Boolean.valueOf(true));
        companyInfo.setIsDecCurrentYear(Boolean.valueOf(true));
        companyInfo.setIsDecOld(Boolean.valueOf(true));
        companyInfo.setDataSource(CompanyDataSourceEnum.OUTSYSTEM_ADD.getValue());
        companyInfo.setStorageReason(CompanyGradeReasonEnum.ZYB_RISK_PUSH.getValue());
        return true;
    }

    @Transactional(readOnly=false)
    public void afterCompletion(NewCompanyContent content) {
        if (content == null || content.getCompanyInfo() == null || content.getCompanyInfo().getId() == null) {
            log.error("\u65b0\u589e\u4f01\u4e1a\u65e0id\u53c2\u6570");
            return;
        }
        List dbUserList = this.sysUserThirdService.getUserManager(content.getCompanyInfo().getId());
        if (CollUtil.isEmpty((Collection)dbUserList)) {
            this.sysUserThirdService.createSysUser((List)ListUtil.toList((Object[])new Long[]{content.getCompanyInfo().getId()}), content.getLoginStaffId());
        }
    }
}

