/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.company.impl.grade;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.NumberUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.supervise.CompanyGradeModelV3;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.company.service.ICompanyBusinessTableService;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyInfo;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeHisV3;
import cn.smarthse.modules.health.entity.base.company.grade.MicroComGradeStaticModel;
import cn.smarthse.modules.health.entity.base.company.grade.MicroCompanyGradeV3;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.enums.check.v3221.PhyPhcCheckTypeEnum;
import cn.smarthse.modules.health.enums.home.grade.CompanyGradeEnum;
import cn.smarthse.modules.health.enums.selfjudge.HazardsExposureRiskLevelEnum;
import cn.smarthse.modules.health.enums.selfjudge.HazardsRiskClassifyEnum;
import cn.smarthse.modules.health.enums.selfjudge.JudgeResultLevelEnum;
import cn.smarthse.modules.health.param.CompanyBusinessTableParam;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicCommandService;
import cn.smarthse.modules.health.supervise.dao.company.grade.MicroCompanyGradeV3Mapper;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.model.grade.CompanyGradeChangeClassc;
import cn.smarthse.modules.health.supervise.model.grade.GradeV3CollectModel;
import cn.smarthse.modules.health.supervise.model.home.microcom.ComSelfStaticData;
import cn.smarthse.modules.health.supervise.model.home.microcom.ComSelfStaticParam;
import cn.smarthse.modules.health.supervise.model.keyFactory.RiskStateTable;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.company.grade.IMicroCompanyGradeV3RefreshService;
import cn.smarthse.modules.health.supervise.service.company.grade.IMicroCompanyGradeV3Service;
import cn.smarthse.modules.health.supervise.service.company.impl.grade.GradeUtils;
import cn.smarthse.modules.health.supervise.vo.workPerfor.MicroComGradeStaticsSearchVo;
import cn.smarthse.modules.health.vo.base.company.gradev3.ComBusinessCountVo;
import cn.smarthse.modules.health.vo.base.company.gradev3.CompanyGradeVoV314;
import cn.smarthse.modules.health.vo.base.company.gradev3.GradeSearchV314;
import cn.smarthse.modules.health.vo.summary.ReformSearchVo;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.modules.sys.enumd.SystemDeploymentSourceEnum;
import cn.smarthse.services.hfi.api.entity.riskev.MicroCompanyRiskExposeEvaluate;
import cn.smarthse.services.hfi.api.service.riskev.IMicroCompanyRiskExposeEvaluateService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class MicroCompanyGradeV3ServiceImpl
extends BaseServiceImpl<MicroCompanyGradeV3Mapper, MicroCompanyGradeV3>
implements IMicroCompanyGradeV3Service {
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaProvideService;
    @Autowired
    protected ICompanyBusinessTableService businessTableService;
    @Autowired(required=false)
    RedisClient redisClient;
    @DubboReference
    private IMicroCompanyRiskExposeEvaluateService riskExposeEvaluateService;
    @DubboReference
    private IReformItemBasicCommandService itemBasicCommandService;
    @DubboReference
    private IOrganizationService organizationService;
    @Autowired
    private IMicroCompanyGradeV3RefreshService companyGradeV3RefreshService;
    private static final String CACHE_NAME = "MicroCompanyGradeV3ServiceImpl";

    public List<CompanyGradeModelV3> selectMicroCompanyList(List<Long> cids) {
        return ((MicroCompanyGradeV3Mapper)this.dao).selectMicroCompanyList(cids);
    }

    public List<CompanyGradeChangeClassc> selectGradeChangeClassc(@Param(value="cidList") List<Long> cidList) {
        return ((MicroCompanyGradeV3Mapper)this.dao).selectGradeChangeClassc(cidList);
    }

    public List<MicroComGradeStaticModel> listMicroComGrade(MicroComGradeStaticsSearchVo searchVo) {
        List<MicroComGradeStaticModel> recordList = ((MicroCompanyGradeV3Mapper)this.dao).pageMicroComGrade(searchVo);
        if (CollectionUtils.isNotEmpty(recordList)) {
            List cidList = recordList.stream().filter(Objects::nonNull).map(MicroComGradeStaticModel::getCid).collect(Collectors.toList());
            ReformSearchVo reformSearch = new ReformSearchVo();
            reformSearch.setCidList(cidList);
            reformSearch.setIsCompleted(Boolean.valueOf(false));
            List<Byte> byteList = List.of((byte)3, (byte)4, (byte)5, (byte)24, (byte)10, (byte)11, (byte)12, (byte)13, (byte)14, (byte)15, (byte)16, (byte)17, (byte)18);
            reformSearch.setGenerationSources(byteList);
            List basicList = this.itemBasicCommandService.getReformItemBasicList(reformSearch);
            Map<Long, List<ReformItemBasic>> basicListMap = basicList.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(ReformItemBasic::getCid));
            for (MicroComGradeStaticModel microComGradeStaticModel : recordList) {
                microComGradeStaticModel.setGradeLevelName(CompanyGradeEnum.getName(microComGradeStaticModel.getGradeLevel() == null ? null : Byte.valueOf(microComGradeStaticModel.getGradeLevel().byteValue())));
                microComGradeStaticModel.setJudgeLevelName(JudgeResultLevelEnum.getNameByCode((Integer)microComGradeStaticModel.getJudgeLevel()));
                microComGradeStaticModel.setRiskLevelName(HazardsExposureRiskLevelEnum.getNameByCode((Integer)microComGradeStaticModel.getRiskLevel()));
                if (basicListMap.containsKey(microComGradeStaticModel.getCid())) {
                    long riskNum = basicListMap.get(microComGradeStaticModel.getCid()).stream().map(ReformItemBasic::getGenerationSource).distinct().count();
                    microComGradeStaticModel.setRiskNum(Integer.valueOf(Math.toIntExact(riskNum)));
                    continue;
                }
                microComGradeStaticModel.setRiskNum(Integer.valueOf(0));
            }
        }
        return recordList;
    }

    public PageInfo<MicroComGradeStaticModel> pageMicroComGrade(JqGridParam jParam, MicroComGradeStaticsSearchVo searchVo) {
        if (searchVo.getAreaId() == null) {
            return PageInfo.emptyPageInfo();
        }
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        List<MicroComGradeStaticModel> recordList = this.listMicroComGrade(searchVo);
        return new PageInfo(recordList);
    }

    public int insertGrades(List<MicroCompanyGradeV3> gradeList) {
        if (CollectionUtils.isNotEmpty(gradeList)) {
            gradeList.forEach(g -> g.setId(Long.valueOf(this.idworker.nextId())));
            return ((MicroCompanyGradeV3Mapper)this.dao).insertGrades(gradeList);
        }
        return 0;
    }

    @Transactional(readOnly=false)
    public int insertGradeHiss(List<CompanyGradeHisV3> gradeList) {
        if (CollectionUtils.isNotEmpty(gradeList)) {
            return ((MicroCompanyGradeV3Mapper)this.dao).insertGradeHiss(gradeList);
        }
        return 0;
    }

    public PageInfo<CompanyGradeVoV314> categoryResultListData(JqGridParam param, GradeSearchV314 search) {
        Long orgId;
        Organization organization;
        if (StringUtils.isNotEmpty((String)search.getOrganizationId()) && (organization = this.organizationService.getOrgById(orgId = Long.valueOf(Long.parseLong(search.getOrganizationId())))) != null && organization.getSysArea() != null) {
            int level = organization.getSysArea().getLevel().intValue();
            if (level == 1 || level == 2) {
                search.setCalcBelongType(Integer.valueOf(level));
            } else {
                search.setCalcBelongType(Integer.valueOf(0));
            }
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows(), (boolean)false);
        List<CompanyGradeVoV314> companyGradeVoV314s = ((MicroCompanyGradeV3Mapper)this.dao).categoryResultListData(search);
        if (CollectionUtils.isNotEmpty(companyGradeVoV314s)) {
            this.settingData(companyGradeVoV314s, search.getOrgAreaLevel());
        }
        PageInfo page = new PageInfo(companyGradeVoV314s);
        return page;
    }

    public ComBusinessCountVo getBusinessStateComCount(GradeSearchV314 search) {
        Long orgId;
        Organization organization;
        if (StringUtils.isNotEmpty((String)search.getOrganizationId()) && (organization = this.organizationService.getOrgById(orgId = Long.valueOf(Long.parseLong(search.getOrganizationId())))) != null && organization.getSysArea() != null) {
            int level = organization.getSysArea().getLevel().intValue();
            if (level == 1 || level == 2) {
                search.setCalcBelongType(Integer.valueOf(level));
            } else {
                search.setCalcBelongType(Integer.valueOf(0));
            }
        }
        return ((MicroCompanyGradeV3Mapper)this.dao).getBusinessStateComCount(search);
    }

    public MicroCompanyGradeV3 getCompanyGradeV3ByCid(Long cid) {
        if (cid == null) {
            return null;
        }
        Example e = new Example(MicroCompanyGradeV3.class);
        e.createCriteria().andEqualTo("cid", (Object)cid);
        e.createCriteria().andEqualTo("isValid", (Object)true);
        MicroCompanyGradeV3 companyGradeV3 = (MicroCompanyGradeV3)this.getOneByExample(e);
        if (companyGradeV3 == null) {
            this.companyGradeV3RefreshService.refreshCompanyGradeByCid(cid, null);
        }
        return companyGradeV3;
    }

    public List<CompanyGradeVoV314> exportCaegoryListDataV32(GradeSearchV314 search) {
        List<CompanyGradeVoV314> companyGradeVoV314s;
        Long orgId;
        Organization organization;
        if (StringUtils.isNotEmpty((String)search.getOrganizationId()) && (organization = this.organizationService.getOrgById(orgId = Long.valueOf(Long.parseLong(search.getOrganizationId())))) != null && organization.getSysArea() != null) {
            int level = organization.getSysArea().getLevel().intValue();
            if (level == 1 || level == 2) {
                search.setCalcBelongType(Integer.valueOf(level));
            } else {
                search.setCalcBelongType(Integer.valueOf(0));
            }
        }
        if (CollectionUtils.isNotEmpty(companyGradeVoV314s = ((MicroCompanyGradeV3Mapper)this.dao).exportCaegoryListDataV32(search))) {
            for (int i = 0; i < companyGradeVoV314s.size(); ++i) {
                CompanyGradeVoV314 companyGradeVoV314 = companyGradeVoV314s.get(i);
                companyGradeVoV314.setInx((long)(i + 1));
                Integer evaluateCheckState = companyGradeVoV314.getEvaluateCheckState();
                Integer riskCheckState = companyGradeVoV314.getRiskCheckState();
                Integer jugdeCheckState = companyGradeVoV314.getJugdeCheckState();
                if (!(Objects.equals(evaluateCheckState, 1) && Objects.equals(riskCheckState, 1) && Objects.equals(jugdeCheckState, 1))) {
                    companyGradeVoV314.setGrade(Integer.valueOf(0));
                    companyGradeVoV314.setGradeName("\u672a\u8bc4\u4f30");
                }
                Object lastPhyOrgDate = DateUtils.formatDate((Date)companyGradeVoV314.getLastPhyOrgDate());
                if (StringUtils.isBlank((CharSequence)lastPhyOrgDate)) {
                    companyGradeVoV314.setLastPhyOrgDateStr("");
                } else {
                    if (companyGradeVoV314.getPhyType() != null) {
                        String name = PhyPhcCheckTypeEnum.getName((Byte)companyGradeVoV314.getPhyType().byteValue());
                        lastPhyOrgDate = (String)lastPhyOrgDate + "(" + name + ")";
                    }
                    companyGradeVoV314.setLastPhyOrgDateStr((String)lastPhyOrgDate);
                }
                companyGradeVoV314.setLastCheckOrgDateStr(DateUtils.formatDate((Date)companyGradeVoV314.getLastCheckOrgDate()));
                if (StringUtils.isNotBlank((CharSequence)companyGradeVoV314.getLastCheckOrgDateStr()) && StringUtils.isBlank((CharSequence)companyGradeVoV314.getLastCheckOrgName())) {
                    companyGradeVoV314.setLastCheckOrgDateStr("");
                }
                if (!StringUtils.isNotBlank((CharSequence)companyGradeVoV314.getLastPhyOrgDateStr()) || !StringUtils.isBlank((CharSequence)companyGradeVoV314.getLastPhyOrgName())) continue;
                companyGradeVoV314.setLastPhyOrgDateStr("");
            }
        }
        return companyGradeVoV314s;
    }

    public List<ComplianceCompanyInfo> listMicroReformRemainDateInfo(List<Long> cids) {
        return ((MicroCompanyGradeV3Mapper)this.dao).listMicroReformRemainDateInfo(cids);
    }

    public List<GradeV3CollectModel> collectCompanyGradeByCateGory(GradeV3CollectModel param, boolean fillCateGory) {
        List victimsCaseList;
        Long areaId;
        AreaModel areaModel;
        if (param.getCateGory() == null) {
            return Collections.emptyList();
        }
        if (StringUtils.isBlank((CharSequence)param.getGradeSource())) {
            param.setGradeSource("1,2,3,4,5,6,7,8,9");
        }
        if (param.getAreaId() != null && param.getAreaLevel() == null && (areaModel = this.areaProvideService.getAreaById(areaId = param.getAreaId())) != null) {
            param.setAreaLevel(areaModel.getLevel());
        }
        param.setYear(Integer.valueOf(DateUtils.getGradeYear()));
        if (param.getOrgAreaLevel() > 2) {
            param.setOnlyThislevel(Boolean.valueOf(true));
        }
        param.setCalcBelongType(GradeUtils.caclBelongType(param.getAreaLevel()));
        String victimsCase = param.getVictimsCase();
        if (StringUtils.isNotBlank((CharSequence)victimsCase) && CollectionUtils.isNotEmpty((Collection)(victimsCaseList = CommonUtil.str2LongList((String)victimsCase, (String)",")))) {
            List distinctList = victimsCaseList.stream().distinct().collect(Collectors.toList());
            List victimsCaseSortList = ListUtil.sort(distinctList, (o1, o2) -> {
                if (o1 > o2) {
                    return 1;
                }
                return -1;
            });
            param.setVictimsCase(StringUtils.join((Iterable)victimsCaseSortList, (String)","));
        }
        List collectModels = (List)this.redisClient.get(CACHE_NAME, "collectCompanyGradeByCateGory:" + param.hashCode(), 1800L, () -> {
            List<GradeV3CollectModel> collectModelList = ((MicroCompanyGradeV3Mapper)this.dao).collectCompanyGradeByCateGory2(param);
            this.handleNoCheckData(collectModelList, param.getCateGory());
            if (fillCateGory) {
                Integer cateGoryParam = param.getCateGory();
                this.fillCateGroy(collectModelList, cateGoryParam, param.getContainUnEvaluate());
            }
            return collectModelList;
        });
        return collectModels;
    }

    private void handleNoCheckData(List<GradeV3CollectModel> collectModelList, Integer cateGoryParam) {
        if (Objects.equals(cateGoryParam, 4)) {
            return;
        }
        if (CollectionUtils.isNotEmpty(collectModelList)) {
            Optional<GradeV3CollectModel> gradeV3CollectModel = null;
            gradeV3CollectModel = Objects.equals(cateGoryParam, 1) ? collectModelList.stream().filter(f -> Objects.equals(f.getCateGory(), 0)).findFirst() : collectModelList.stream().filter(f -> Objects.equals(f.getCheckState(), 0)).findFirst();
            GradeV3CollectModel noEvaluateMode = null;
            if (gradeV3CollectModel.isPresent()) {
                noEvaluateMode = gradeV3CollectModel.get();
                collectModelList.remove(noEvaluateMode);
            } else {
                noEvaluateMode = new GradeV3CollectModel(cateGoryParam, Integer.valueOf(0), Integer.valueOf(0));
            }
            noEvaluateMode.setCateGory(Integer.valueOf(0));
            Iterator<GradeV3CollectModel> iterator = collectModelList.iterator();
            while (iterator.hasNext()) {
                GradeV3CollectModel next = iterator.next();
                if (Objects.equals(next.getCheckState(), 0) || Objects.equals(next.getCheckState(), -1) || Objects.equals(next.getCheckState(), 2) || Objects.equals(next.getCheckState(), 3)) {
                    noEvaluateMode.addValue(next.getValue());
                    iterator.remove();
                }
                if (!Objects.equals(next.getCheckState(), 1) || !Objects.equals(next.getCateGory(), 0)) continue;
                iterator.remove();
            }
            collectModelList.add(noEvaluateMode);
        }
    }

    private void fillCateGroy(List<GradeV3CollectModel> collectModelList, Integer cateGoryParam, Boolean containUnEvaluate) {
        Set cateGroySet = collectModelList.stream().map(GradeV3CollectModel::getCateGory).collect(Collectors.toSet());
        switch (cateGoryParam) {
            case 1: {
                if (!containUnEvaluate.booleanValue()) {
                    Stream<GradeV3CollectModel> gradeV3CollectModelStream = collectModelList.stream().filter(c -> c.getCateGory() == 0);
                    Optional<GradeV3CollectModel> nopartitionModel = collectModelList.stream().filter(c -> c.getCateGory() == 0).findFirst();
                    GradeV3CollectModel nopartition = null;
                    if (nopartitionModel.isPresent()) {
                        nopartition = nopartitionModel.get();
                        collectModelList.remove(nopartition);
                    } else {
                        nopartition = new GradeV3CollectModel(cateGoryParam, Integer.valueOf(0), Integer.valueOf(0));
                    }
                    Iterator<GradeV3CollectModel> iterator = collectModelList.iterator();
                    while (iterator.hasNext()) {
                        GradeV3CollectModel next = iterator.next();
                        if (!Objects.equals(next.getCheckState(), 0) && !Objects.equals(next.getCateGory(), 0)) continue;
                        nopartition.addValue(next.getValue());
                        iterator.remove();
                    }
                    collectModelList.add(nopartition);
                }
                for (HazardsRiskClassifyEnum value : HazardsRiskClassifyEnum.values()) {
                    if (cateGroySet.contains(value.getCode())) continue;
                    collectModelList.add(new GradeV3CollectModel(cateGoryParam, value.getCode(), Integer.valueOf(0)));
                }
                break;
            }
            case 2: {
                for (HazardsExposureRiskLevelEnum value : HazardsExposureRiskLevelEnum.values()) {
                    if (cateGroySet.contains(value.getCode())) continue;
                    collectModelList.add(new GradeV3CollectModel(cateGoryParam, value.getCode(), Integer.valueOf(0)));
                }
                break;
            }
            case 3: {
                for (JudgeResultLevelEnum value : JudgeResultLevelEnum.values()) {
                    if (cateGroySet.contains(value.getCode())) continue;
                    collectModelList.add(new GradeV3CollectModel(cateGoryParam, value.getCode(), Integer.valueOf(0)));
                }
                break;
            }
        }
    }

    private void settingData(List<CompanyGradeVoV314> list, Byte loginAreaLevle) {
        if (CollectionUtils.isNotEmpty(list)) {
            for (CompanyGradeVoV314 g : list) {
                String[] split;
                MicroCompanyRiskExposeEvaluate ev;
                if (g == null) continue;
                String industryCategoryName = g.getIndustryCategoryName();
                if (StringUtils.isNotBlank((CharSequence)industryCategoryName)) {
                    List strings = CommonUtil.str2list((String)industryCategoryName);
                    Set validInduSet = strings.stream().filter(f -> Objects.equals(f, "\u77ff\u5c71") || Objects.equals(f, "\u5efa\u6750") || Objects.equals(f, "\u5316\u5de5") || Objects.equals(f, "\u51b6\u91d1")).collect(Collectors.toSet());
                    if (CollectionUtils.isNotEmpty(validInduSet)) {
                        g.setIsImpIndustry(Byte.valueOf("1"));
                        g.setIndustryCategoryName(StringUtils.join(validInduSet, (String)","));
                    } else {
                        g.setIsImpIndustry(Byte.valueOf("0"));
                        g.setIndustryCategoryName("");
                    }
                } else {
                    g.setIsImpIndustry(Byte.valueOf("0"));
                    g.setIndustryCategoryName("");
                }
                Date evaluateUpdateDate = g.getEvaluateUpdateDate();
                Date jugdeUpdateDate = g.getJugdeUpdateDate();
                Date riskUpdateDate = g.getRiskUpdateDate();
                Date maxDate = DateUtils.getMaxDate((Date[])new Date[]{evaluateUpdateDate, jugdeUpdateDate, riskUpdateDate});
                g.setDataUpdateTime(DateUtils.formatDateTime((Date)maxDate));
                Integer belongType = g.getBelongType();
                if (Objects.equals(loginAreaLevle, (byte)1) && !Objects.equals(belongType, 1)) {
                    g.setCanAudit(Boolean.valueOf(false));
                } else if (Objects.equals(loginAreaLevle, (byte)2) && !Objects.equals(belongType, 2)) {
                    g.setCanAudit(Boolean.valueOf(false));
                }
                Object workAddress = g.getWorkAddress();
                if (StringUtils.isNotEmpty((String)workAddress)) {
                    workAddress = StringUtils.concatStr((String)"", (String[])new String[]{g.getCityName(), g.getAreaName(), g.getStreetName()}) + (String)workAddress;
                    g.setWorkAddress((String)workAddress);
                }
                if (g.getIsExistRadioactivity() == null || !g.getIsExistRadioactivity().booleanValue() || g.getRiskId() == null || (ev = (MicroCompanyRiskExposeEvaluate)this.riskExposeEvaluateService.getById((Serializable)g.getRiskId())) == null || !StringUtils.isNotEmpty((String)ev.getRedundantSourceTablesIds()) || (split = ev.getRedundantSourceTablesIds().split(",")).length != 2) continue;
                List collect = Arrays.stream(split).map(Long::parseLong).collect(Collectors.toList());
                List infoList = this.riskExposeEvaluateService.getInfoList(collect);
                for (MicroCompanyRiskExposeEvaluate temp : infoList) {
                    if (temp.getWandaZywsCheckId() == null) {
                        g.setRiskId1(temp.getId());
                        continue;
                    }
                    g.setRiskId2(temp.getId());
                }
                g.setTableType(Integer.valueOf(2));
            }
        }
    }

    @Transactional(readOnly=false)
    public void validCompanyState(MicroCompanyGradeV3 companyGradeV3, Integer evaluateCheckState, Integer judgeCheckState, Integer riskCheckState) {
        if (companyGradeV3 == null && companyGradeV3.getCid() == null) {
            return;
        }
        Long cid = companyGradeV3.getCid();
        if (companyGradeV3.getId() == null) {
            Example e = new Example(MicroCompanyGradeV3.class);
            e.createCriteria().andEqualTo("cid", (Object)cid);
            e.createCriteria().andEqualTo("isValid", (Object)true);
            companyGradeV3 = (MicroCompanyGradeV3)this.getOneByExample(e);
        }
        if (companyGradeV3 == null) {
            this.companyGradeV3RefreshService.refreshCompanyGradeByCid(cid, null);
        } else {
            Integer evaluateCheckState1 = companyGradeV3.getEvaluateCheckState();
            Integer riskCheckState1 = companyGradeV3.getRiskCheckState();
            Integer jugdeCheckState = companyGradeV3.getJugdeCheckState();
            boolean refreshFlag = false;
            if (evaluateCheckState != null && !Objects.equals(evaluateCheckState, evaluateCheckState1)) {
                refreshFlag = true;
            }
            if (riskCheckState != null && !Objects.equals(riskCheckState, riskCheckState1)) {
                refreshFlag = true;
            }
            if (judgeCheckState != null && !Objects.equals(judgeCheckState, jugdeCheckState)) {
                refreshFlag = true;
            }
            if (refreshFlag) {
                this.companyGradeV3RefreshService.refreshCompanyGradeByCid(cid, null);
            }
        }
    }

    private void calcSelfRate(ComSelfStaticData data) {
        if (data != null) {
            Long comtotal = data.getComtotal();
            if (comtotal == null || Objects.equals(0L, comtotal)) {
                data.setFinishSelfRate("0%");
                data.setNoFinishSelfRate("0%");
            }
            Long finishSelfNum = data.getFinishSelfNum();
            String finishSelfRate = NumberUtil.div((Number)finishSelfNum, (Number)comtotal, (int)4).multiply(new BigDecimal(100)).stripTrailingZeros().toPlainString();
            String nofinishSelfRate = NumberUtil.div((Number)data.getNoFinishSelfNum(), (Number)comtotal, (int)4).multiply(new BigDecimal(100)).stripTrailingZeros().toPlainString();
            data.setFinishSelfRate(finishSelfRate + "%");
            data.setNoFinishSelfRate(nofinishSelfRate + "%");
        }
    }

    public ComSelfStaticData comstaticdata(ComSelfStaticParam param) {
        ComSelfStaticData comstaticdata = ((MicroCompanyGradeV3Mapper)this.dao).comstaticdata(param);
        this.calcSelfRate(comstaticdata);
        return comstaticdata;
    }

    public List<ComSelfStaticData> listComstaticdata(ComSelfStaticParam param) {
        List<ComSelfStaticData> comSelfStaticData = ((MicroCompanyGradeV3Mapper)this.dao).listComstaticdata(param);
        CompanyBusinessTableParam riskStatTableParam = new CompanyBusinessTableParam().setAreaId(param.getAreaId()).setLevel(param.getAreaLevel()).setSystemDeploymentSource(SystemDeploymentSourceEnum.YUE_CHENG.getCode());
        List<RiskStateTable> riskStateTable = Objects.equals(param.getAreaLevel(), 4) ? List.of(this.businessTableService.headDataByRiskStatTable(riskStatTableParam)) : this.businessTableService.listDataByRiskStatTable(riskStatTableParam);
        Map<Long, Integer> riskUnMap = riskStateTable.stream().filter(item -> item != null && item.getAreaId() != null && item.getExistRiskComNum() != null).collect(Collectors.toMap(RiskStateTable::getAreaId, RiskStateTable::getExistRiskComNum));
        Map<Long, Integer> riskFinishMap = riskStateTable.stream().filter(item -> item != null && item.getAreaId() != null && item.getIsDefuseComNum() != null).collect(Collectors.toMap(RiskStateTable::getAreaId, RiskStateTable::getIsDefuseComNum));
        if (CollectionUtils.isNotEmpty(comSelfStaticData)) {
            for (ComSelfStaticData comstaticdata : comSelfStaticData) {
                this.calcSelfRate(comstaticdata);
                comstaticdata.setFinishRiskNum(riskFinishMap.get(comstaticdata.getAreaId()));
                comstaticdata.setNoFinishRiskNum(riskUnMap.get(comstaticdata.getAreaId()));
            }
        }
        return comSelfStaticData;
    }

    public int delCompanyGradeV3ByCid(List<Long> cids) {
        Example e = new Example(MicroCompanyGradeV3.class);
        e.createCriteria().andIn("cid", cids);
        int i = ((MicroCompanyGradeV3Mapper)this.dao).deleteByExample(e);
        return i;
    }
}

