/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.company.impl.grade;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.entity.base.company.grade.MicroCompanyGradeV3Rec;
import cn.smarthse.modules.health.supervise.dao.company.grade.MicroCompanyGradeV3RecMapper;
import cn.smarthse.modules.health.supervise.service.company.grade.IMicroCompanyGradeV3RecService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class MicroCompanyGradeV3RecServiceImpl
extends BaseServiceImpl<MicroCompanyGradeV3RecMapper, MicroCompanyGradeV3Rec>
implements IMicroCompanyGradeV3RecService {
    public List<MicroCompanyGradeV3Rec> listAllCompanyGradeRec(List<Long> cids) {
        List<MicroCompanyGradeV3Rec> companyGradeV3Recs = ((MicroCompanyGradeV3RecMapper)this.dao).listAllCompanyGradeRec(cids);
        return companyGradeV3Recs;
    }

    public MicroCompanyGradeV3Rec getGradeRecByCid(Long cid) {
        if (cid == null) {
            return null;
        }
        Example e = new Example(MicroCompanyGradeV3Rec.class);
        e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        List listByExample = this.getListByExample(e);
        if (CollectionUtils.isNotEmpty(listByExample)) {
            MicroCompanyGradeV3Rec gradeV3Rec = (MicroCompanyGradeV3Rec)listByExample.get(0);
            if (!Objects.equals(gradeV3Rec.getCheckState(), 1)) {
                gradeV3Rec.setJudgeLevel(Integer.valueOf(0));
                gradeV3Rec.setRiskLevel(Integer.valueOf(0));
            }
            return gradeV3Rec;
        }
        return null;
    }

    @Transactional(readOnly=false)
    public int batchSaveCompanyGradeV3Rec(List<MicroCompanyGradeV3Rec> gradeV3RecList) {
        if (CollectionUtils.isEmpty(gradeV3RecList)) {
            return 0;
        }
        int pointsDataLimit = 1000;
        int listSize = gradeV3RecList.size();
        int maxSize = listSize - 1;
        int n = 0;
        ArrayList<MicroCompanyGradeV3Rec> newList = new ArrayList<MicroCompanyGradeV3Rec>();
        for (int i = 0; i < gradeV3RecList.size(); ++i) {
            MicroCompanyGradeV3Rec gradeV3Rec = gradeV3RecList.get(i);
            gradeV3Rec.setId(Long.valueOf(this.idworker.nextId()));
            newList.add(gradeV3Rec);
            if (pointsDataLimit != newList.size() && i != maxSize) continue;
            int count = ((MicroCompanyGradeV3RecMapper)this.dao).insertGrades(newList);
            n += count;
            newList.clear();
        }
        return n;
    }

    @Transactional(readOnly=false)
    public int batchupdateCompanyGradeV3Rec(List<MicroCompanyGradeV3Rec> gradeV3RecList) {
        if (CollectionUtils.isEmpty(gradeV3RecList)) {
            return 0;
        }
        int pointsDataLimit = 1000;
        int listSize = gradeV3RecList.size();
        int maxSize = listSize - 1;
        int n = 0;
        ArrayList<MicroCompanyGradeV3Rec> newList = new ArrayList<MicroCompanyGradeV3Rec>();
        for (int i = 0; i < gradeV3RecList.size(); ++i) {
            newList.add(gradeV3RecList.get(i));
            if (pointsDataLimit != newList.size() && i != maxSize) continue;
            int count = ((MicroCompanyGradeV3RecMapper)this.dao).updateGrades(newList);
            n += count;
            newList.clear();
        }
        return n;
    }

    public List<MicroCompanyGradeV3Rec> getGradeByCids(List<Long> cids) {
        if (CollectionUtils.isEmpty(cids)) {
            return null;
        }
        Example e = new Example(MicroCompanyGradeV3Rec.class);
        e.createCriteria().andIn("cid", cids).andEqualTo("isValid", (Object)true);
        e.selectProperties(new String[]{"grade", "occType", "cid"});
        List<MicroCompanyGradeV3Rec> resultList = this.getListByExample(e);
        return resultList;
    }
}

