/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.company.impl.grade;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.PhoneUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.log.DebugUtils;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProviderWelinkService;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeWorkProgress;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeWorkProgressStage;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeWorkProgressStageV2;
import cn.smarthse.modules.health.supervise.dao.company.grade.CompanyGradeV3WorkProcessMapper;
import cn.smarthse.modules.health.supervise.entity.sys.Param;
import cn.smarthse.modules.health.supervise.model.grade.VictimLess3ReportModel;
import cn.smarthse.modules.health.supervise.model.grade.VictimLess3ReportParam;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeWorkProgressService;
import cn.smarthse.modules.health.supervise.service.sys.IParamService;
import cn.smarthse.modules.health.supervise.vo.workPerfor.WorkProgressStatisticSearchVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.xxl.job.core.context.XxlJobHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class CompanyGradeV3WorkProgressServiceImpl
extends BaseServiceImpl<CompanyGradeV3WorkProcessMapper, CompanyGradeWorkProgress>
implements ICompanyGradeWorkProgressService {
    private static final String CACHE_NAME = "supervisesystem:gradeworkProgress";
    private static final String LT3VICTIMS_THRESHOLD_CACHENAME = "CompanyGradeV3WorkProgressServiceImpl:lt3victims_threshold_smssender";
    @Autowired
    private RedisClient redisClient;
    @DubboReference
    private IParamService paramService;
    @DubboReference
    private ISMSProviderWelinkService smsProvider;

    @Transactional(readOnly=false)
    public void collectWorkProcess() {
        this.collectWorkProcessStage2024();
    }

    @Transactional(readOnly=false)
    public synchronized void collectWorkProcessStage2024() {
        boolean gradeEndTime = CommonUtil.gradeEndTime();
        if (Objects.equals(gradeEndTime, true)) {
            XxlJobHelper.log((String)"\u5206\u7c7b\u7ed3\u7b97\u8fc7\u671f\uff0c \u4e0d\u518d\u8fdb\u884c\u8ba1\u7b97..", (Object[])new Object[0]);
            return;
        }
        List<CompanyGradeWorkProgressStageV2> dbWorkProgressStages = ((CompanyGradeV3WorkProcessMapper)this.dao).listWorkProcessStage2024();
        List<CompanyGradeWorkProgressStageV2> collectWorkProcessList = ((CompanyGradeV3WorkProcessMapper)this.dao).collectWorkProcessAreaId2024();
        Map<Object, Object> dbWorkProgressHashMap = new HashMap();
        if (CollectionUtils.isNotEmpty(dbWorkProgressStages)) {
            dbWorkProgressHashMap = dbWorkProgressStages.stream().collect(Collectors.toMap(k -> k.getAreaId().toString() + k.getThisLevel().toString(), v -> v, (v1, v2) -> v2));
        }
        ArrayList<CompanyGradeWorkProgressStageV2> addworkProgressList = new ArrayList<CompanyGradeWorkProgressStageV2>();
        ArrayList<CompanyGradeWorkProgressStageV2> updateworkProgressList = new ArrayList<CompanyGradeWorkProgressStageV2>();
        for (CompanyGradeWorkProgressStageV2 newProcessStage : collectWorkProcessList) {
            if (newProcessStage.getGradeFinishRate() >= 100.0) {
                newProcessStage.setStage(Integer.valueOf(1));
            } else {
                newProcessStage.setStage(Integer.valueOf(0));
            }
            String key = newProcessStage.getAreaId().toString() + newProcessStage.getThisLevel().toString();
            if (dbWorkProgressHashMap.containsKey(key)) {
                CompanyGradeWorkProgressStageV2 dbProcessStage = (CompanyGradeWorkProgressStageV2)dbWorkProgressHashMap.get(key);
                dbProcessStage.setStage(newProcessStage.getStage());
                dbProcessStage.setGradeFinishRate(newProcessStage.getGradeFinishRate());
                dbProcessStage.setGradeSelfRate(newProcessStage.getGradeSelfRate());
                dbProcessStage.setFinishNum(newProcessStage.getFinishNum());
                dbProcessStage.setSelfNum(newProcessStage.getSelfNum());
                dbProcessStage.setTotalNum(newProcessStage.getTotalNum());
                dbProcessStage.setUpdateDate(new Date());
                updateworkProgressList.add(dbProcessStage);
                continue;
            }
            newProcessStage.setId(Long.valueOf(this.idworker.nextId()));
            addworkProgressList.add(newProcessStage);
        }
        try {
            this.handBatch(addworkProgressList, l -> ((CompanyGradeV3WorkProcessMapper)this.dao).insertWorkProcessStage2024((List<CompanyGradeWorkProgressStageV2>)l));
            this.handBatch(updateworkProgressList, l -> ((CompanyGradeV3WorkProcessMapper)this.dao).updateWorkProcessStage2024((List<CompanyGradeWorkProgressStageV2>)l));
        }
        catch (Exception e) {
            this.logger.error("collectWorkProcessStage \u65b9\u6cd5\u51fa\u9519\uff1a", (Throwable)e);
        }
    }

    @Transactional(readOnly=false)
    public synchronized void collectWorkProcessStage() {
        Integer currStage = CommonUtil.currStage();
        if (currStage == null) {
            XxlJobHelper.log((String)"\u5206\u7c7b\u7ed3\u7b97\u8fc7\u671f\uff0c \u4e0d\u518d\u8fdb\u884c\u8ba1\u7b97..", (Object[])new Object[0]);
            return;
        }
        List<CompanyGradeWorkProgressStage> dbWorkProgressStages = ((CompanyGradeV3WorkProcessMapper)this.dao).listWorkProcessStage();
        List<CompanyGradeWorkProgressStage> collectWorkProcessList = ((CompanyGradeV3WorkProcessMapper)this.dao).collectWorkProcessAreaId2();
        Map<Object, Object> dbWorkProgressHashMap = new HashMap();
        if (CollectionUtils.isNotEmpty(dbWorkProgressStages)) {
            dbWorkProgressHashMap = dbWorkProgressStages.stream().collect(Collectors.toMap(k -> k.getAreaId().toString() + k.getThisLevel().toString(), v -> v, (v1, v2) -> v2));
        }
        ArrayList<CompanyGradeWorkProgressStage> addworkProgressList = new ArrayList<CompanyGradeWorkProgressStage>();
        ArrayList<CompanyGradeWorkProgressStage> updateworkProgressList = new ArrayList<CompanyGradeWorkProgressStage>();
        for (CompanyGradeWorkProgressStage newProcessStage : collectWorkProcessList) {
            if (Objects.equals(currStage, 1)) {
                if (newProcessStage.getGradeFinishRate() <= 30.0) {
                    newProcessStage.setStage1(Integer.valueOf(0));
                } else {
                    newProcessStage.setStage1(Integer.valueOf(1));
                }
            } else if (Objects.equals(currStage, 2)) {
                if (newProcessStage.getGradeFinishRate() <= 70.0) {
                    newProcessStage.setStage2(Integer.valueOf(0));
                } else {
                    newProcessStage.setStage2(Integer.valueOf(1));
                }
            } else if (Objects.equals(currStage, 3)) {
                if (newProcessStage.getGradeFinishRate() >= 80.0 && newProcessStage.getGradeSelfRate() >= 100.0) {
                    newProcessStage.setStage3(Integer.valueOf(1));
                } else {
                    newProcessStage.setStage3(Integer.valueOf(0));
                }
            }
            String key = newProcessStage.getAreaId().toString() + newProcessStage.getThisLevel().toString();
            if (dbWorkProgressHashMap.containsKey(key)) {
                CompanyGradeWorkProgressStage dbProcessStage = (CompanyGradeWorkProgressStage)dbWorkProgressHashMap.get(key);
                if (Objects.equals(currStage, 1)) {
                    dbProcessStage.setStage1(newProcessStage.getStage1());
                } else if (Objects.equals(currStage, 2)) {
                    dbProcessStage.setStage2(newProcessStage.getStage2());
                } else if (Objects.equals(currStage, 3)) {
                    dbProcessStage.setStage3(newProcessStage.getStage3());
                }
                dbProcessStage.setGradeFinishRate(newProcessStage.getGradeFinishRate());
                dbProcessStage.setGradeSelfRate(newProcessStage.getGradeSelfRate());
                dbProcessStage.setFinishNum(newProcessStage.getFinishNum());
                dbProcessStage.setSelfNum(newProcessStage.getSelfNum());
                dbProcessStage.setTotalNum(newProcessStage.getTotalNum());
                updateworkProgressList.add(dbProcessStage);
                continue;
            }
            newProcessStage.setId(Long.valueOf(this.idworker.nextId()));
            addworkProgressList.add(newProcessStage);
        }
        try {
            this.handBatch(addworkProgressList, l -> ((CompanyGradeV3WorkProcessMapper)this.dao).insertWorkProcessStage((List<CompanyGradeWorkProgressStage>)l));
            this.handBatch(updateworkProgressList, l -> ((CompanyGradeV3WorkProcessMapper)this.dao).updateWorkProcessStage((List<CompanyGradeWorkProgressStage>)l));
        }
        catch (Exception e) {
            this.logger.error("collectWorkProcessStage \u65b9\u6cd5\u51fa\u9519\uff1a", (Throwable)e);
        }
    }

    private static double calcRate(Integer num, Integer totalNum) {
        if (num == null || num == 0 || totalNum == null || totalNum == 0) {
            return 0.0;
        }
        return BigDecimal.valueOf(num.intValue()).divide(BigDecimal.valueOf(totalNum.intValue()), 2, RoundingMode.HALF_UP).doubleValue();
    }

    private String generateKey(CompanyGradeWorkProgress k) {
        Long areaId = k.getAreaId();
        Integer dataYear = k.getDataYear();
        String keyIndu = k.getKeyIndu();
        Integer grade = k.getGrade();
        if (grade == null) {
            grade = 0;
        }
        Object key = "";
        if (areaId != null) {
            key = (String)key + areaId.toString();
        }
        if (dataYear != null) {
            key = (String)key + dataYear.toString();
        }
        key = (String)key + grade;
        key = (String)key + keyIndu;
        return key;
    }

    private int handBatch(List dataList, Function<List, Integer> consumer) {
        int pointsDataLimit = 1000;
        int listSize = dataList.size();
        int maxSize = listSize - 1;
        int n = 0;
        ArrayList newList = new ArrayList();
        for (int i = 0; i < dataList.size(); ++i) {
            newList.add(dataList.get(i));
            if (pointsDataLimit != newList.size() && i != maxSize) continue;
            int count = consumer.apply(newList);
            n += count;
            newList.clear();
        }
        return n;
    }

    public List<CompanyGradeWorkProgress> listWorkProcess2(WorkProgressStatisticSearchVo searchVo) {
        if (searchVo.getDataRange() == null) {
            searchVo.setDataRange(Byte.valueOf((byte)1));
        }
        List<CompanyGradeWorkProgress> workProgressList = null;
        workProgressList = Objects.equals(searchVo.getQueryGradeBak(), "2023") ? ((CompanyGradeV3WorkProcessMapper)this.dao).searchWorkProcess3Bak(searchVo) : (Objects.equals(searchVo.getQueryGradeBak(), "20240223") ? ((CompanyGradeV3WorkProcessMapper)this.dao).searchWorkProcess3Bak20240223(searchVo) : (Objects.equals(searchVo.getQueryGradeBak(), "20240701") ? ((CompanyGradeV3WorkProcessMapper)this.dao).searchWorkProcess3Bak20240701(searchVo) : (Objects.equals(searchVo.getQueryGradeBak(), "20241231") ? ((CompanyGradeV3WorkProcessMapper)this.dao).searchWorkProcess3Bak20241231(searchVo) : (Objects.equals(searchVo.getQueryGradeBak(), "20250630") ? ((CompanyGradeV3WorkProcessMapper)this.dao).searchWorkProcess3Bak20250630(searchVo) : (Objects.equals(searchVo.getQueryGradeBak(), "20251231") ? ((CompanyGradeV3WorkProcessMapper)this.dao).searchWorkProcess3Bak20251231(searchVo) : ((CompanyGradeV3WorkProcessMapper)this.dao).searchWorkProcess3(searchVo))))));
        if (CollectionUtils.isNotEmpty(workProgressList)) {
            for (CompanyGradeWorkProgress companyGradeWorkProgress : workProgressList) {
                Integer gradeTotalNum = companyGradeWorkProgress.getThan2gradeTotalNum();
                if (gradeTotalNum != null && Objects.equals(gradeTotalNum, 0)) {
                    companyGradeWorkProgress.setGradeSelfRate("-");
                    companyGradeWorkProgress.setGradeRiskRate("-");
                    companyGradeWorkProgress.setStageName("-");
                } else {
                    companyGradeWorkProgress.setGradeSelfRate(companyGradeWorkProgress.getGradeSelfRate() + "%");
                    companyGradeWorkProgress.setGradeRiskRate(companyGradeWorkProgress.getGradeRiskRate() + "%");
                }
                int gradeClassaNum = companyGradeWorkProgress.getGradeClassaNum() == null ? 0 : companyGradeWorkProgress.getGradeClassaNum();
                int gradeClassbNum = companyGradeWorkProgress.getGradeClassbNum() == null ? 0 : companyGradeWorkProgress.getGradeClassbNum();
                int gradeClasscNum = companyGradeWorkProgress.getGradeClasscNum() == null ? 0 : companyGradeWorkProgress.getGradeClasscNum();
                int classTotal = gradeClassaNum + gradeClassbNum + gradeClasscNum;
                if (classTotal != 0 && gradeClasscNum != 0) {
                    BigDecimal total = new BigDecimal("" + classTotal);
                    BigDecimal res = new BigDecimal("" + gradeClasscNum).divide(total, 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
                    companyGradeWorkProgress.setClasscRate(res.doubleValue());
                }
                if (!Objects.equals(companyGradeWorkProgress.getAreaLevel(), 4)) continue;
                companyGradeWorkProgress.setStage(null);
            }
        }
        return workProgressList;
    }

    public PageInfo<CompanyGradeWorkProgress> pageWorkProcess2(JqGridParam param, WorkProgressStatisticSearchVo searchVo) {
        if (param.getRows() > 1) {
            PageHelper.startPage((int)param.getPage(), (int)param.getRows());
            List<CompanyGradeWorkProgress> list = this.listWorkProcess2(searchVo);
            PageInfo page = new PageInfo(list);
            return page;
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows(), (boolean)false);
        List<CompanyGradeWorkProgress> list = this.listWorkProcess2(searchVo);
        PageInfo page = new PageInfo(list);
        return page;
    }

    public CompanyGradeWorkProgressStage getWorkProcessStage(CompanyGradeWorkProgressStage param) {
        if (param == null) {
            return null;
        }
        return ((CompanyGradeV3WorkProcessMapper)this.dao).getWorkProcessStage(param);
    }

    public PageInfo<VictimLess3ReportModel> pageVictimLess3ReportData(JqGridParam page, VictimLess3ReportParam param) {
        PageHelper.startPage((int)page.getPage(), (int)page.getRows());
        List<VictimLess3ReportModel> list = ((CompanyGradeV3WorkProcessMapper)this.dao).collectVictimLess3ReportData(param);
        PageInfo pageR = new PageInfo(list);
        return pageR;
    }

    public List<VictimLess3ReportModel> listVictimLess3ReportData(VictimLess3ReportParam param) {
        return ((CompanyGradeV3WorkProcessMapper)this.dao).collectVictimLess3ReportData(param);
    }

    public VictimLess3ReportModel countVictimLess3ReportData(VictimLess3ReportParam param) {
        List<VictimLess3ReportModel> victimLess3ReportModels = ((CompanyGradeV3WorkProcessMapper)this.dao).collectVictimLess3ReportData(param);
        if (CollectionUtils.isNotEmpty(victimLess3ReportModels)) {
            return victimLess3ReportModels.get(0);
        }
        return null;
    }

    public void victimLess3RateRemind(boolean nowSendSms) {
        Object lt3VictimsThresholdCache;
        Param lt3VictimsTel;
        this.logger.info("\u63a5\u5bb3\u4eba\u6570\uff1c3\u4eba\u4f01\u4e1a\u5360\u6bd4\u7edf\u8ba1\u5f00\u59cb-->" + DateUtils.formatDateTime((Date)new Date()));
        VictimLess3ReportParam param = new VictimLess3ReportParam();
        param.setOrgAreaId(Long.valueOf(330000000000L));
        param.setOrgAreaLevel(Byte.valueOf((byte)1));
        param.setParentVirtualAreaId(null);
        param.setIsShowArea(Boolean.valueOf(true));
        DebugUtils.error((String)("\u63a5\u5bb3\u4eba\u6570\uff1c3\u4eba\u4f01\u4e1a\u5360\u6bd4\u7edf\u8ba1\u8c03\u8bd5" + DateUtils.formatDateTime((Date)new Date())), (Object[])new Object[0]);
        Map byKeyListAndArea = this.paramService.getMapByKeyListAndArea(IParamService.smsLt3ParamKeyList, Long.valueOf(330000000000L));
        if (MapUtils.isEmpty((Map)byKeyListAndArea)) {
            XxlJobHelper.log((String)"\u672a\u8bbe\u7f6e\u9608\u503c\u4e0e\u63d0\u9192\u7684\u624b\u673a\u53f7", (Object[])new Object[0]);
            return;
        }
        Param lt3VictimsThreshold = (Param)byKeyListAndArea.get("lt3_victims_threshold");
        if (lt3VictimsThreshold == null || !NumberUtil.isNumber((CharSequence)lt3VictimsThreshold.getParamValue())) {
            XxlJobHelper.log((String)"\u9608\u503c\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef", (Object[])new Object[0]);
        }
        if ((lt3VictimsTel = (Param)byKeyListAndArea.get("lt3_victims_tel")) == null || !PhoneUtil.isPhone((CharSequence)lt3VictimsTel.getParamValue())) {
            XxlJobHelper.log((String)"\u9608\u503c\u63d0\u9192\u624b\u673a\u53f7\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef", (Object[])new Object[0]);
        }
        if ((lt3VictimsThresholdCache = this.redisClient.hget(LT3VICTIMS_THRESHOLD_CACHENAME, "lt3VictimsThreshold")) == null || !Objects.equals(lt3VictimsThresholdCache.toString(), lt3VictimsThreshold.getParamValue())) {
            this.redisClient.hset(LT3VICTIMS_THRESHOLD_CACHENAME, "lt3VictimsThreshold", (Object)lt3VictimsThreshold.getParamValue());
            this.redisClient.hset(LT3VICTIMS_THRESHOLD_CACHENAME, "sendCount", (Object)0);
        }
        int sendCount = (Integer)this.redisClient.hget(LT3VICTIMS_THRESHOLD_CACHENAME, "sendCount");
        List<VictimLess3ReportModel> victimLess3RateList = this.listVictimLess3ReportData(param);
        List<Object> vl3ModelList = new ArrayList();
        if (CollectionUtils.isNotEmpty(victimLess3RateList)) {
            vl3ModelList = victimLess3RateList.stream().filter(f -> f.getLess3Rate() != null && f.getLess3Rate() >= Double.valueOf(lt3VictimsThreshold.getParamValue())).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(vl3ModelList)) {
            int size = vl3ModelList.size();
            String areaName = ((VictimLess3ReportModel)vl3ModelList.get(0)).getAreaName();
            String dateformat = DateUtils.format((Date)new Date(), (String)"yyyy\u5e74MM\u6708dd\u65e5");
            String content = StrUtil.format((CharSequence)"\u3010\u6d59\u6c5f\u7701\u75be\u63a7\u5c40\u3011{}\u7b49{}\u4e2a\u533a\u53bf\uff0c{}\u63a5\u5bb3\u4eba\u6570\uff1c3\u4eba\u4f01\u4e1a\u5360\u6bd4\u8d85\u8fc7{}", (Object[])new Object[]{areaName, size, dateformat, lt3VictimsThreshold.getParamValue()});
            if (nowSendSms) {
                this.smsProvider.singleSendSms(lt3VictimsTel.getParamValue(), content);
            } else {
                if (sendCount > 0) {
                    this.logger.error("\u63a5\u5bb3\u4eba\u6570<3\u5360\u6bd4\u63d0\u9192\u5df2\u7ecf\u53d1\u9001\u8fc7\u77ed\u4fe1\u4e86\uff0c \u672c\u6b21\u4e0d\u7528\u53d1\u9001");
                    XxlJobHelper.log((String)"\u63a5\u5bb3\u4eba\u6570<3\u5360\u6bd4\u63d0\u9192\u5df2\u7ecf\u53d1\u9001\u8fc7\u77ed\u4fe1\u4e86\uff0c \u672c\u6b21\u4e0d\u7528\u53d1\u9001", (Object[])new Object[0]);
                    return;
                }
                HashMap<String, String> contentMap = new HashMap<String, String>();
                contentMap.put(lt3VictimsTel.getParamValue(), content);
                LocalTime start = LocalTime.of(8, 0);
                LocalTime end = LocalTime.of(20, 0);
                this.smsProvider.sendOrDelaySms(contentMap, start, end, Byte.valueOf((byte)1));
                this.redisClient.hset(LT3VICTIMS_THRESHOLD_CACHENAME, "sendCount", (Object)(sendCount + 1));
            }
        } else {
            this.redisClient.hset(LT3VICTIMS_THRESHOLD_CACHENAME, "sendCount", (Object)0);
        }
        this.logger.info("\u63a5\u5bb3\u4eba\u6570\uff1c3\u4eba\u4f01\u4e1a\u5360\u6bd4\u7edf\u8ba1\u7ed3\u675f-->" + DateUtils.formatDateTime((Date)new Date()));
    }

    public static void main(String[] args) {
        String content = StrUtil.format((CharSequence)"\u3010\u6d59\u6c5f\u7701\u75be\u63a7\u5c40\u3011{}\u7b49{}\u4e2a\u533a\u53bf\uff0c{}\u63a5\u5bb3\u4eba\u6570\uff1c3\u4eba\u4f01\u4e1a\u5360\u6bd4\u8d85\u8fc7{}", (Object[])new Object[]{"\u676d\u5dde\u5e02", 1, "2025-02-12", 47});
        System.out.println(content);
    }
}

