/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.company.impl.grade;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Pair;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.modules.datacentre.enums.CompanyOccTypeEnum;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.entity.base.company.CompanyGradeHis;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeHisV3;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeV3;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeV3FinishLog;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeWorkProgress;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeWorkProgressStage;
import cn.smarthse.modules.health.entity.base.company.grade.vo.CompanyGradeVoV3;
import cn.smarthse.modules.health.entity.base.company.grade.vo.GradeSearchV311;
import cn.smarthse.modules.health.entity.base.selfjudge.ClassifySelfExaminationRecord;
import cn.smarthse.modules.health.entity.base.selfjudge.CompanyHsePreventionControlSelfJudge;
import cn.smarthse.modules.health.entity.base.selfjudge.SelfInspectionRiskAssessmentReportInfo;
import cn.smarthse.modules.health.entity.sys.SysArea;
import cn.smarthse.modules.health.enums.check.v3221.PhyPhcCheckTypeEnum;
import cn.smarthse.modules.health.enums.selfjudge.HazardsExposureRiskLevelEnum;
import cn.smarthse.modules.health.enums.selfjudge.HazardsRiskClassifyEnum;
import cn.smarthse.modules.health.enums.selfjudge.JudgeResultLevelEnum;
import cn.smarthse.modules.health.model.gradechangelog.GradeV3ChangeLog;
import cn.smarthse.modules.health.service.base.selfjudge.ICompanyHsePreventionControlSelfJudgeService;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionRiskAssessmentReportInfoService;
import cn.smarthse.modules.health.supervise.dao.company.grade.CompanyGradeV3Mapper;
import cn.smarthse.modules.health.supervise.dao.company.grade.CompanyGradeV3TempMapper;
import cn.smarthse.modules.health.supervise.dao.company.grade.CompanyGradeV3WorkProcessMapper;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.entity.company.grade.CompanyGradeV3CollectVo;
import cn.smarthse.modules.health.supervise.model.AreaGradeNumModel;
import cn.smarthse.modules.health.supervise.model.grade.CompanyGradeChangeClassc;
import cn.smarthse.modules.health.supervise.model.grade.GradeDryingProInfoModel;
import cn.smarthse.modules.health.supervise.model.grade.GradeDryingProInfoSearchForm;
import cn.smarthse.modules.health.supervise.model.grade.GradeProgressRankModel;
import cn.smarthse.modules.health.supervise.model.grade.GradeV3AreaSearchForm;
import cn.smarthse.modules.health.supervise.model.grade.GradeV3CollectAreaModel;
import cn.smarthse.modules.health.supervise.model.grade.GradeV3CollectAreaParam;
import cn.smarthse.modules.health.supervise.model.grade.GradeV3CollectModel;
import cn.smarthse.modules.health.supervise.model.home.v3223.homeIndex.CreditSuperviseComplianceVo;
import cn.smarthse.modules.health.supervise.model.home.v3223.homeIndex.HomeEnergyEfficiencyVo;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RefreshService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3Service;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeWorkProgressService;
import cn.smarthse.modules.health.supervise.service.company.impl.grade.CompanyGradeV3CollectService;
import cn.smarthse.modules.health.supervise.service.company.impl.grade.CompanyGradeV3HisDataHandleService;
import cn.smarthse.modules.health.supervise.service.company.impl.grade.GradeUtils;
import cn.smarthse.modules.health.supervise.service.statistics.ICompanyClassCCountService;
import cn.smarthse.modules.health.supervise.vo.statistics.CompanyClassCCountModel;
import cn.smarthse.modules.health.supervise.vo.workPerfor.WorkProgressStatisticSearchVo;
import cn.smarthse.modules.health.vo.base.company.gradev3.ComBusinessCountVo;
import cn.smarthse.modules.health.vo.base.company.gradev3.CompanyGradeVoV314;
import cn.smarthse.modules.health.vo.base.company.gradev3.GradeSearchV314;
import cn.smarthse.modules.health.vo.work.HomeIndexSearchVo;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class CompanyGradeV3ServiceImpl
extends BaseServiceImpl<CompanyGradeV3Mapper, CompanyGradeV3>
implements ICompanyGradeV3Service {
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaProvideService;
    @Autowired
    private ICompanyGradeV3RefreshService companyGradeV3RefreshService;
    @Autowired
    private CompanyGradeV3TempMapper companyGradeV3TempMapper;
    @Autowired
    private ICompanyGradeWorkProgressService gradeWorkProgressService;
    @Autowired
    private ICompanyClassCCountService companyClassCCountService;
    @DubboReference
    private IOrganizationService organizationService;
    @Autowired
    private CompanyGradeV3HisDataHandleService hisDataHandleService;
    @DubboReference
    private ISelfInspectionRiskAssessmentReportInfoService selfInspectionRiskAssessmentReportInfoService;
    @DubboReference
    private IRiskExposeEvaluateService riskExposeEvaluateService;
    @DubboReference
    private ICompanyHsePreventionControlSelfJudgeService selfJudgeService;
    @Autowired
    private CompanyGradeV3WorkProcessMapper workProcessMapper;
    @Autowired
    private CompanyGradeV3CollectService gradeV3CollectService;
    @Autowired(required=false)
    DataSourceTransactionManager transactionManager;
    @Autowired(required=false)
    RedisClient redisClient;
    @Autowired
    private CompanyGradeV3ServiceImpl companyGradeV3Service;
    private static final String CACHE_NAME = "CompanyGradeV3ServiceImpl";

    public int insertGrades(List<CompanyGradeV3> gradeList) {
        if (CollectionUtils.isNotEmpty(gradeList)) {
            gradeList.forEach(g -> g.setId(Long.valueOf(this.idworker.nextId())));
            return ((CompanyGradeV3Mapper)this.dao).insertGrades(gradeList);
        }
        return 0;
    }

    @Transactional(readOnly=false)
    public int insertGradeChangeLog(List<GradeV3ChangeLog> gradeList) {
        if (CollectionUtils.isNotEmpty(gradeList)) {
            gradeList.forEach(g -> g.setId(Long.valueOf(this.idworker.nextId())));
            return ((CompanyGradeV3Mapper)this.dao).insertGradeChangeLog(gradeList);
        }
        return 0;
    }

    @Transactional(readOnly=false)
    public int insertGradeHiss(List<CompanyGradeHisV3> gradeList) {
        if (CollectionUtils.isNotEmpty(gradeList)) {
            return ((CompanyGradeV3Mapper)this.dao).insertGradeHiss(gradeList);
        }
        return 0;
    }

    public void delGradeHiss() {
        ((CompanyGradeV3Mapper)this.dao).delGradeHiss();
    }

    public int insertGradeFinishLog(List<CompanyGradeV3FinishLog> gradeList) {
        if (CollectionUtils.isNotEmpty(gradeList)) {
            gradeList.forEach(g -> {
                if (g.getId() == null) {
                    g.setId(Long.valueOf(this.idworker.nextId()));
                }
            });
            return ((CompanyGradeV3Mapper)this.dao).insertGradeFinishLog(gradeList);
        }
        return 0;
    }

    public List<CompanyGradeV3FinishLog> getGradeFinishLogList(Long cid, Integer year) {
        return ((CompanyGradeV3Mapper)this.dao).getGradeFinishLogList(cid, year);
    }

    public List<CompanyGradeV3> listAllCompanyGrade(Long cid) {
        return ((CompanyGradeV3Mapper)this.dao).listAllCompanyGrade(cid);
    }

    public CompanyGradeV3 getCompanyGradeV3ByCid(Long cid) {
        if (cid == null) {
            return null;
        }
        Example e = new Example(CompanyGradeV3.class);
        e.createCriteria().andEqualTo("cid", (Object)cid);
        e.createCriteria().andEqualTo("isValid", (Object)true);
        CompanyGradeV3 companyGradeV3 = (CompanyGradeV3)this.getOneByExample(e);
        if (companyGradeV3 == null) {
            this.companyGradeV3RefreshService.refreshCompanyGradeByCid(cid, null);
        }
        return companyGradeV3;
    }

    public CompanyGradeV3 getCompanyGradeV3BySelfId(Long selfId) {
        Example e = new Example(CompanyGradeV3.class);
        e.createCriteria().andEqualTo("selfId", (Object)selfId);
        e.createCriteria().andEqualTo("isValid", (Object)true);
        CompanyGradeV3 companyGradeV3 = (CompanyGradeV3)this.getOneByExample(e);
        return companyGradeV3;
    }

    public CompanyGradeV3 getCompanyGradeV3ByEvaluateId(Long evaluateId) {
        Example e = new Example(CompanyGradeV3.class);
        e.createCriteria().andEqualTo("evaluateId", (Object)evaluateId);
        e.createCriteria().andEqualTo("isValid", (Object)true);
        CompanyGradeV3 companyGradeV3 = (CompanyGradeV3)this.getOneByExample(e);
        return companyGradeV3;
    }

    public CompanyGradeV3 getCompanyGradeV3ByRiskId(Long riskId) {
        Example e = new Example(CompanyGradeV3.class);
        e.createCriteria().andEqualTo("riskId", (Object)riskId);
        e.createCriteria().andEqualTo("isValid", (Object)true);
        CompanyGradeV3 companyGradeV3 = (CompanyGradeV3)this.getOneByExample(e);
        return companyGradeV3;
    }

    public int delCompanyGradeV3ByCid(List<Long> cids) {
        Example e = new Example(CompanyGradeV3.class);
        if (CollectionUtils.isNotEmpty(cids)) {
            e.createCriteria().andIn("cid", cids);
        }
        int i = ((CompanyGradeV3Mapper)this.dao).deleteByExample(e);
        return i;
    }

    public void truncateCompanyGradeV3() {
        ((CompanyGradeV3Mapper)this.dao).truncateCompanyGradeV3();
    }

    public int delCompanyGradeV3() {
        Example e = new Example(CompanyGradeV3.class);
        return ((CompanyGradeV3Mapper)this.dao).deleteByExample(e);
    }

    public List<GradeV3CollectModel> collectCompanyGradeByCateGory(GradeV3CollectModel param, boolean fillCateGory) {
        List victimsCaseList;
        Long areaId;
        AreaModel areaModel;
        if (param.getCateGory() == null) {
            return Collections.emptyList();
        }
        if (StringUtils.isBlank((CharSequence)param.getGradeSource())) {
            param.setGradeSource("2");
        }
        if (param.getAreaId() != null && param.getAreaLevel() == null && (areaModel = this.areaProvideService.getAreaById(areaId = param.getAreaId())) != null) {
            param.setAreaLevel(areaModel.getLevel());
        }
        param.setYear(Integer.valueOf(DateUtils.getGradeYear()));
        if (param.getOrgAreaLevel() > 2) {
            param.setOnlyThislevel(Boolean.valueOf(true));
        }
        param.setCalcBelongType(GradeUtils.caclBelongType(param.getAreaLevel()));
        String victimsCase = param.getVictimsCase();
        if (StringUtils.isNotBlank((CharSequence)victimsCase) && CollectionUtils.isNotEmpty((Collection)(victimsCaseList = CommonUtil.str2LongList((String)victimsCase, (String)",")))) {
            List distinctList = victimsCaseList.stream().distinct().collect(Collectors.toList());
            List victimsCaseSortList = ListUtil.sort(distinctList, (o1, o2) -> {
                if (o1 > o2) {
                    return 1;
                }
                return -1;
            });
            param.setVictimsCase(StringUtils.join((Iterable)victimsCaseSortList, (String)","));
        }
        List collectModels = (List)this.redisClient.get(CACHE_NAME, "collectCompanyGradeByCateGory:" + param.hashCode(), 1800L, () -> {
            List<GradeV3CollectModel> collectModelList = ((CompanyGradeV3Mapper)this.dao).collectCompanyGradeByCateGory2(param);
            this.handleNoCheckData(collectModelList, param.getCateGory());
            if (fillCateGory) {
                Integer cateGoryParam = param.getCateGory();
                this.fillCateGroy(collectModelList, cateGoryParam, param.getContainUnEvaluate());
            }
            if (Objects.equals(param.getCateGory(), 1) && Objects.equals(param.getDataYear(), 2)) {
                List listByAreaIds = this.companyClassCCountService.getListByAreaIds(Arrays.asList(param.getAreaId()), param.getContainUnEvaluate(), param.getContainLess3Result());
                for (GradeV3CollectModel gradeV3CollectModel : collectModelList) {
                    CompanyClassCCountModel companyClassCCountModel;
                    if (!Objects.equals(gradeV3CollectModel.getCateGory(), 3) || !CollectionUtils.isNotEmpty((Collection)listByAreaIds) || (companyClassCCountModel = (CompanyClassCCountModel)listByAreaIds.get(0)) == null) continue;
                    if (companyClassCCountModel.getNowTotal() - companyClassCCountModel.getLastYearTotal() > 0) {
                        gradeV3CollectModel.setClasscUp(Boolean.valueOf(true));
                        continue;
                    }
                    if (companyClassCCountModel.getNowTotal() - companyClassCCountModel.getLastYearTotal() >= 0) continue;
                    gradeV3CollectModel.setClasscUp(Boolean.valueOf(false));
                }
            }
            return collectModelList;
        });
        return collectModels;
    }

    private void handleNoCheckData(List<GradeV3CollectModel> collectModelList, Integer cateGoryParam) {
        if (Objects.equals(cateGoryParam, 4)) {
            return;
        }
        if (CollectionUtils.isNotEmpty(collectModelList)) {
            Optional<GradeV3CollectModel> gradeV3CollectModel = null;
            gradeV3CollectModel = Objects.equals(cateGoryParam, 1) ? collectModelList.stream().filter(f -> Objects.equals(f.getCateGory(), 0)).findFirst() : collectModelList.stream().filter(f -> Objects.equals(f.getCheckState(), 0)).findFirst();
            GradeV3CollectModel noEvaluateMode = null;
            if (gradeV3CollectModel.isPresent()) {
                noEvaluateMode = gradeV3CollectModel.get();
                collectModelList.remove(noEvaluateMode);
            } else {
                noEvaluateMode = new GradeV3CollectModel(cateGoryParam, Integer.valueOf(0), Integer.valueOf(0));
            }
            noEvaluateMode.setCateGory(Integer.valueOf(0));
            Iterator<GradeV3CollectModel> iterator = collectModelList.iterator();
            while (iterator.hasNext()) {
                GradeV3CollectModel next = iterator.next();
                if (Objects.equals(next.getCheckState(), 0) || Objects.equals(next.getCheckState(), -1) || Objects.equals(next.getCheckState(), 2) || Objects.equals(next.getCheckState(), 3)) {
                    noEvaluateMode.addValue(next.getValue());
                    iterator.remove();
                }
                if (!Objects.equals(next.getCheckState(), 1) || !Objects.equals(next.getCateGory(), 0)) continue;
                iterator.remove();
            }
            collectModelList.add(noEvaluateMode);
        }
    }

    private void fillCateGroy(List<GradeV3CollectModel> collectModelList, Integer cateGoryParam, Boolean containUnEvaluate) {
        Set cateGroySet = collectModelList.stream().map(GradeV3CollectModel::getCateGory).collect(Collectors.toSet());
        switch (cateGoryParam) {
            case 1: {
                if (!containUnEvaluate.booleanValue()) {
                    Stream<GradeV3CollectModel> stream = collectModelList.stream().filter(c -> c.getCateGory() == 0);
                    Optional<GradeV3CollectModel> nopartitionModel = collectModelList.stream().filter(c -> c.getCateGory() == 0).findFirst();
                    GradeV3CollectModel nopartition = null;
                    if (nopartitionModel.isPresent()) {
                        nopartition = nopartitionModel.get();
                        collectModelList.remove(nopartition);
                    } else {
                        nopartition = new GradeV3CollectModel(cateGoryParam, Integer.valueOf(0), Integer.valueOf(0));
                    }
                    Iterator<GradeV3CollectModel> iterator = collectModelList.iterator();
                    while (iterator.hasNext()) {
                        GradeV3CollectModel next = iterator.next();
                        if (!Objects.equals(next.getCheckState(), 0) && !Objects.equals(next.getCateGory(), 0)) continue;
                        nopartition.addValue(next.getValue());
                        iterator.remove();
                    }
                    collectModelList.add(nopartition);
                }
                for (HazardsRiskClassifyEnum value : HazardsRiskClassifyEnum.values()) {
                    if (cateGroySet.contains(value.getCode())) continue;
                    collectModelList.add(new GradeV3CollectModel(cateGoryParam, value.getCode(), Integer.valueOf(0)));
                }
                break;
            }
            case 2: {
                for (HazardsExposureRiskLevelEnum value : HazardsExposureRiskLevelEnum.values()) {
                    if (cateGroySet.contains(value.getCode())) continue;
                    collectModelList.add(new GradeV3CollectModel(cateGoryParam, value.getCode(), Integer.valueOf(0)));
                }
                break;
            }
            case 3: {
                for (JudgeResultLevelEnum value : JudgeResultLevelEnum.values()) {
                    if (cateGroySet.contains(value.getCode())) continue;
                    collectModelList.add(new GradeV3CollectModel(cateGoryParam, value.getCode(), Integer.valueOf(0)));
                }
                break;
            }
            case 4: {
                Optional<GradeV3CollectModel> optional = collectModelList.stream().filter(c -> c.getCateGory() == 4).findFirst();
                GradeV3CollectModel nopartition = null;
                if (optional.isPresent()) {
                    nopartition = optional.get();
                    collectModelList.remove(nopartition);
                } else {
                    nopartition = new GradeV3CollectModel(cateGoryParam, Integer.valueOf(4), Integer.valueOf(0));
                }
                Iterator<GradeV3CollectModel> iterator = collectModelList.iterator();
                while (iterator.hasNext()) {
                    GradeV3CollectModel next = iterator.next();
                    if (!Objects.equals(next.getCateGory(), 3)) continue;
                    nopartition.addValue(next.getValue());
                    iterator.remove();
                }
                collectModelList.add(nopartition);
                for (CompanyOccTypeEnum value : CompanyOccTypeEnum.values()) {
                    if (cateGroySet.contains(value.getCode())) continue;
                    collectModelList.add(new GradeV3CollectModel(cateGoryParam, value.getCode(), Integer.valueOf(0)));
                }
                break;
            }
        }
    }

    public List<CompanyGradeVoV3> caegoryListDataV311(GradeSearchV311 search) {
        List<Object> result = new ArrayList();
        result = Objects.equals(search.getType(), 1) ? ((CompanyGradeV3Mapper)this.dao).caegoryListDataV311PageInfo(search) : ((CompanyGradeV3Mapper)this.dao).caegoryListDataV311PageInfo(search);
        return result;
    }

    public List<CompanyGradeVoV314> caegoryListDataV314(GradeSearchV314 search) {
        List<CompanyGradeVoV314> companyGradeVoV314s = ((CompanyGradeV3Mapper)this.dao).caegoryListDataV314PageInfo(search);
        if (CollectionUtils.isNotEmpty(companyGradeVoV314s)) {
            for (CompanyGradeVoV314 companyGradeVoV314 : companyGradeVoV314s) {
                Date evaluateUpdateDate = companyGradeVoV314.getEvaluateUpdateDate();
                Date jugdeUpdateDate = companyGradeVoV314.getJugdeUpdateDate();
                Date riskUpdateDate = companyGradeVoV314.getRiskUpdateDate();
                Date maxDate = DateUtils.getMaxDate((Date[])new Date[]{evaluateUpdateDate, jugdeUpdateDate, riskUpdateDate});
                companyGradeVoV314.setDataUpdateTime(DateUtils.formatDateTime((Date)maxDate));
            }
        }
        return companyGradeVoV314s;
    }

    public List<CompanyGradeVoV314> caegoryListDataV3142(GradeSearchV314 search) {
        List<CompanyGradeVoV314> companyGradeVoV314s = ((CompanyGradeV3Mapper)this.dao).caegoryListDataV314PageInfo2(search);
        if (CollectionUtils.isNotEmpty(companyGradeVoV314s)) {
            this.settingData(companyGradeVoV314s, search.getOrgAreaLevel());
        }
        return companyGradeVoV314s;
    }

    private void settingData(List<CompanyGradeVoV314> list, Byte loginAreaLevle) {
        if (CollectionUtils.isNotEmpty(list)) {
            for (CompanyGradeVoV314 g : list) {
                String[] split;
                RiskExposeEvaluate ev;
                if (g == null) continue;
                String industryCategoryName = g.getIndustryCategoryName();
                if (StringUtils.isNotBlank((CharSequence)industryCategoryName)) {
                    List strings = CommonUtil.str2list((String)industryCategoryName);
                    Set validInduSet = strings.stream().filter(f -> Objects.equals(f, "\u77ff\u5c71") || Objects.equals(f, "\u5efa\u6750") || Objects.equals(f, "\u5316\u5de5") || Objects.equals(f, "\u51b6\u91d1")).collect(Collectors.toSet());
                    if (CollectionUtils.isNotEmpty(validInduSet)) {
                        g.setIsImpIndustry(Byte.valueOf("1"));
                        g.setIndustryCategoryName(StringUtils.join(validInduSet, (String)","));
                    } else {
                        g.setIsImpIndustry(Byte.valueOf("0"));
                        g.setIndustryCategoryName("");
                    }
                } else {
                    g.setIsImpIndustry(Byte.valueOf("0"));
                    g.setIndustryCategoryName("");
                }
                Date evaluateUpdateDate = g.getEvaluateUpdateDate();
                Date jugdeUpdateDate = g.getJugdeUpdateDate();
                Date riskUpdateDate = g.getRiskUpdateDate();
                Date maxDate = DateUtils.getMaxDate((Date[])new Date[]{evaluateUpdateDate, jugdeUpdateDate, riskUpdateDate});
                g.setDataUpdateTime(DateUtils.formatDateTime((Date)maxDate));
                Integer belongType = g.getBelongType();
                if (Objects.equals(loginAreaLevle, (byte)1) && !Objects.equals(belongType, 1)) {
                    g.setCanAudit(Boolean.valueOf(false));
                } else if (Objects.equals(loginAreaLevle, (byte)2) && !Objects.equals(belongType, 2)) {
                    g.setCanAudit(Boolean.valueOf(false));
                }
                Object workAddress = g.getWorkAddress();
                if (StringUtils.isNotEmpty((String)workAddress)) {
                    workAddress = StringUtils.concatStr((String)"", (String[])new String[]{g.getCityName(), g.getAreaName(), g.getStreetName()}) + (String)workAddress;
                    g.setWorkAddress((String)workAddress);
                }
                if (g.getIsExistRadioactivity() == null || !g.getIsExistRadioactivity().booleanValue() || g.getRiskId() == null || (ev = (RiskExposeEvaluate)this.riskExposeEvaluateService.getById((Serializable)g.getRiskId())) == null || !StringUtils.isNotEmpty((String)ev.getRedundantSourceTablesIds()) || (split = ev.getRedundantSourceTablesIds().split(",")).length != 2) continue;
                List collect = Arrays.stream(split).map(Long::parseLong).collect(Collectors.toList());
                List infoList = this.riskExposeEvaluateService.getInfoList(collect);
                for (RiskExposeEvaluate temp : infoList) {
                    if (temp.getWandaZywsCheckId() == null) {
                        g.setRiskId1(temp.getId());
                        continue;
                    }
                    g.setRiskId2(temp.getId());
                }
                g.setTableType(Integer.valueOf(2));
            }
        }
    }

    public List<CompanyGradeVoV314> exportCaegoryListDataV314(GradeSearchV314 search) {
        List<CompanyGradeVoV314> companyGradeVoV314s = ((CompanyGradeV3Mapper)this.dao).exportCaegoryListDataV314(search);
        if (CollectionUtils.isNotEmpty(companyGradeVoV314s)) {
            for (int i = 0; i < companyGradeVoV314s.size(); ++i) {
                CompanyGradeVoV314 companyGradeVoV314 = companyGradeVoV314s.get(i);
                companyGradeVoV314.setInx((long)(i + 1));
            }
        }
        return companyGradeVoV314s;
    }

    public List<CompanyGradeVoV314> exportCaegoryListDataV32(GradeSearchV314 search) {
        List<CompanyGradeVoV314> companyGradeVoV314s;
        Long orgId;
        Organization organization;
        if (StringUtils.isNotEmpty((String)search.getOrganizationId()) && (organization = this.organizationService.getOrgById(orgId = Long.valueOf(Long.parseLong(search.getOrganizationId())))) != null && organization.getSysArea() != null) {
            int level = organization.getSysArea().getLevel().intValue();
            if (level == 1 || level == 2) {
                search.setCalcBelongType(Integer.valueOf(level));
            } else {
                search.setCalcBelongType(Integer.valueOf(0));
            }
        }
        if (CollectionUtils.isNotEmpty(companyGradeVoV314s = ((CompanyGradeV3Mapper)this.dao).exportCaegoryListDataV32(search))) {
            for (int i = 0; i < companyGradeVoV314s.size(); ++i) {
                CompanyGradeVoV314 companyGradeVoV314 = companyGradeVoV314s.get(i);
                companyGradeVoV314.setInx((long)(i + 1));
                Integer evaluateCheckState = companyGradeVoV314.getEvaluateCheckState();
                Integer riskCheckState = companyGradeVoV314.getRiskCheckState();
                Integer jugdeCheckState = companyGradeVoV314.getJugdeCheckState();
                if (!(Objects.equals(evaluateCheckState, 1) && Objects.equals(riskCheckState, 1) && Objects.equals(jugdeCheckState, 1))) {
                    companyGradeVoV314.setGrade(Integer.valueOf(0));
                    companyGradeVoV314.setGradeName("\u672a\u8bc4\u4f30");
                }
                Object lastPhyOrgDate = DateUtils.formatDate((Date)companyGradeVoV314.getLastPhyOrgDate());
                if (StringUtils.isBlank((CharSequence)lastPhyOrgDate)) {
                    companyGradeVoV314.setLastPhyOrgDateStr("");
                } else {
                    if (companyGradeVoV314.getPhyType() != null) {
                        String name = PhyPhcCheckTypeEnum.getName((Byte)companyGradeVoV314.getPhyType().byteValue());
                        lastPhyOrgDate = (String)lastPhyOrgDate + "(" + name + ")";
                    }
                    companyGradeVoV314.setLastPhyOrgDateStr((String)lastPhyOrgDate);
                }
                companyGradeVoV314.setLastCheckOrgDateStr(DateUtils.formatDate((Date)companyGradeVoV314.getLastCheckOrgDate()));
                if (StringUtils.isNotBlank((CharSequence)companyGradeVoV314.getLastCheckOrgDateStr()) && StringUtils.isBlank((CharSequence)companyGradeVoV314.getLastCheckOrgName())) {
                    companyGradeVoV314.setLastCheckOrgDateStr("");
                }
                if (!StringUtils.isNotBlank((CharSequence)companyGradeVoV314.getLastPhyOrgDateStr()) || !StringUtils.isBlank((CharSequence)companyGradeVoV314.getLastPhyOrgName())) continue;
                companyGradeVoV314.setLastPhyOrgDateStr("");
            }
        }
        return companyGradeVoV314s;
    }

    private void settingState(CompanyGradeVoV314 companyGradeVoV314) {
        Integer occType = companyGradeVoV314.getOccType();
        Long selfId = companyGradeVoV314.getSelfId();
        Long riskId = companyGradeVoV314.getRiskId();
        Long evaluateId = companyGradeVoV314.getEvaluateId();
        Integer riskCheckState = companyGradeVoV314.getRiskCheckState();
        Integer jugdeCheckState = companyGradeVoV314.getJugdeCheckState();
        String riskClassifyName = companyGradeVoV314.getRiskClassifyName();
        Integer pickupCount = companyGradeVoV314.getPickupCount();
        if (pickupCount != null && pickupCount < 3) {
            return;
        }
        if (Objects.equals(companyGradeVoV314.getCompanyType(), 2)) {
            return;
        }
        Integer creditSupervise = companyGradeVoV314.getCreditSupervise();
        if (Objects.equals(creditSupervise, 1)) {
            companyGradeVoV314.setGrade(Integer.valueOf(1));
            return;
        }
        if (occType != null && (occType == 0 || occType == 2)) {
            if (selfId != null && riskId != null || Objects.equals(riskCheckState, -1) || Objects.equals(jugdeCheckState, -1)) {
                if (selfId != null && riskId != null && evaluateId != null && !Objects.equals(riskCheckState, -1) && !Objects.equals(jugdeCheckState, -1)) {
                    if (this.gradeV3CollectService.containsSuspendReformDec(companyGradeVoV314.getCid())) {
                        Integer gradeByOccType = this.gradeV3CollectService.getGradeByOccType(occType);
                        int max = cn.hutool.core.util.NumberUtil.max((int[])new int[]{companyGradeVoV314.getRiskClassify(), gradeByOccType});
                        companyGradeVoV314.setGrade(Integer.valueOf(max));
                        return;
                    }
                    companyGradeVoV314.setGrade(companyGradeVoV314.getRiskClassify());
                } else {
                    companyGradeVoV314.setGrade(Integer.valueOf(0));
                }
            }
        } else if (selfId != null && riskId != null && evaluateId != null && !Objects.equals(riskCheckState, -1) && !Objects.equals(jugdeCheckState, -1)) {
            companyGradeVoV314.setGrade(companyGradeVoV314.getRiskClassify());
        } else {
            companyGradeVoV314.setGrade(Integer.valueOf(0));
        }
    }

    public List<CompanyGradeVoV314> exportCaegoryListDataV314Temp(GradeSearchV314 search) {
        List<CompanyGradeVoV314> companyGradeVoV314s = this.companyGradeV3TempMapper.exportCaegoryListDataV314Temp(search);
        if (CollectionUtils.isNotEmpty(companyGradeVoV314s)) {
            for (int i = 0; i < companyGradeVoV314s.size(); ++i) {
                CompanyGradeVoV314 companyGradeVoV314 = companyGradeVoV314s.get(i);
                companyGradeVoV314.setInx((long)(i + 1));
            }
        }
        return companyGradeVoV314s;
    }

    public List<AreaGradeNumModel> listAreaGradeInfo(GradeV3AreaSearchForm form) {
        List areaIdList;
        List listByAreaIds;
        form.setYear(Integer.valueOf(DateUtils.getGradeYear()));
        if (Objects.equals(form.getGradeLevel(), 1) || Objects.equals(form.getGradeLevel(), 2) || Objects.equals(form.getGradeLevel(), 3)) {
            return ((CompanyGradeV3Mapper)this.dao).listAreaGradeInfoByabc(form);
        }
        if (Objects.equals(form.getGradeLevel(), 4)) {
            form.setGroupByType(form.getGradeLevel());
            form.setGradeLevel(null);
        } else {
            if (Objects.equals(form.getGradeLevel(), 5) || Objects.equals(form.getGradeLevel(), 7)) {
                form.setGroupByType(form.getGradeLevel());
                form.setGradeLevel(null);
                return ((CompanyGradeV3Mapper)this.dao).listAreaGradeInfo2(form);
            }
            if (Objects.equals(form.getGradeLevel(), 6)) {
                form.setGroupByType(Integer.valueOf(6));
                form.setGradeLevel(null);
                form.setCheckState(Integer.valueOf(0));
            }
        }
        List<AreaGradeNumModel> areaGradeNumModels = ((CompanyGradeV3Mapper)this.dao).listAreaGradeInfo(form);
        if (Objects.equals(form.getGradeLevel(), 3) && CollectionUtils.isNotEmpty(areaGradeNumModels) && CollectionUtils.isNotEmpty((Collection)(listByAreaIds = this.companyClassCCountService.getListByAreaIds(areaIdList = areaGradeNumModels.stream().map(AreaGradeNumModel::getId).collect(Collectors.toList()), null, form.getContainLess3Result())))) {
            Map<Long, CompanyClassCCountModel> classcCountMap = listByAreaIds.stream().collect(Collectors.toMap(k -> k.getAreaId(), v -> v, (v1, v2) -> v1));
            for (AreaGradeNumModel areaGradeNumModel : areaGradeNumModels) {
                Long areaId = areaGradeNumModel.getId();
                if (!classcCountMap.containsKey(areaId)) continue;
                CompanyClassCCountModel companyClassCCountModel = classcCountMap.get(areaId);
                if (companyClassCCountModel.getChangeCount() > 0) {
                    areaGradeNumModel.setIsUp(Boolean.valueOf(true));
                }
                areaGradeNumModel.setChangeNum(companyClassCCountModel.getChangeCount());
                areaGradeNumModel.setChangeRate(companyClassCCountModel.getChangeRate());
            }
        }
        return areaGradeNumModels;
    }

    public GradeDryingProInfoModel gradeDryingProInfo(GradeDryingProInfoSearchForm search) {
        List dryingProInfoModelList;
        search.setGroupBy(search.getAreaLevel());
        Long areaId = search.getAreaId();
        Byte areaLevel = search.getAreaLevel();
        Integer orderBy = search.getOrderBy();
        search.setOrderBy(null);
        Integer dataYear = search.getDataYear();
        GradeDryingProInfoModel result = new GradeDryingProInfoModel();
        AreaModel areaModel = this.areaProvideService.getAreaById(areaId);
        search.setBelongType(GradeUtils.caclBelongType(areaModel.getLevel()));
        if (search.getOrgAreaLevel() > 2) {
            search.setOnlyThislevel(Boolean.valueOf(true));
        }
        if (CollectionUtils.isEmpty((Collection)(dryingProInfoModelList = (List)this.redisClient.get(CACHE_NAME, "dryingProInfoModelList:" + search.hashCode(), 180L, () -> {
            List<GradeDryingProInfoModel> gradeDryingProInfoModels = ((CompanyGradeV3Mapper)this.dao).gradeDryingProInfo(search);
            return gradeDryingProInfoModels;
        }, search.getEnableCache() == null ? true : search.getEnableCache())))) {
            GradeDryingProInfoModel re = new GradeDryingProInfoModel();
            re.setFinishRate(0.0);
            Integer targetFinishRate = GradeUtils.getFinishRateStageTarget();
            re.setStageTaget(targetFinishRate + "%");
            re.setSelfRate(0.0);
            re.setStageFinish(Boolean.valueOf(false));
            return re;
        }
        this.calcRateAndOder(dryingProInfoModelList, orderBy, areaId, search);
        result = (GradeDryingProInfoModel)dryingProInfoModelList.get(0);
        Integer belongType = null;
        if (Objects.equals(areaLevel, (byte)2)) {
            belongType = 1;
            proviOrder = this.getProviOrder(areaModel, orderBy, search);
            result.setProviRank("" + proviOrder);
        } else if (Objects.equals(areaLevel, (byte)3)) {
            belongType = 2;
            proviOrder = this.getProviOrder(areaModel, orderBy, search);
            result.setProviRank("" + proviOrder);
            int cityOrder = this.getCityOrder(areaModel, orderBy, search);
            result.setCityRank("" + cityOrder);
        }
        if (!Objects.equals(dataYear, 2)) {
            GradeProgressRankModel gradeProgressRankModel;
            boolean loadRank = false;
            if (Objects.equals(areaLevel, (byte)2) && search.getOnlyThislevel() == null) {
                loadRank = true;
            } else if (Objects.equals(areaLevel, (byte)3) && Objects.equals(search.getOnlyThislevel(), true)) {
                loadRank = true;
            }
            if (loadRank && (gradeProgressRankModel = this.getGradeProgressRankModel(areaId, belongType, orderBy, dataYear)) != null) {
                result.setCloseCityRank((String)(gradeProgressRankModel.getCityrank() == null ? "" : "" + gradeProgressRankModel.getCityrank()));
                result.setCloseProviRank((String)(gradeProgressRankModel.getProvirank() == null ? "" : "" + gradeProgressRankModel.getProvirank()));
            }
            CompanyGradeWorkProgressStage stage = new CompanyGradeWorkProgressStage();
            stage.setAreaId(areaId);
            if (Objects.equals(search.getOnlyThislevel(), true)) {
                stage.setThisLevel(Integer.valueOf(1));
            } else {
                stage.setThisLevel(Integer.valueOf(2));
            }
            CompanyGradeWorkProgressStage workProcessStage = this.workProcessMapper.getWorkProcessStage(stage);
            if (workProcessStage != null) {
                BigDecimal finishRate = NumberUtil.div((Number)workProcessStage.getFinishNum(), (Number)workProcessStage.getTotalNum(), (int)4, (RoundingMode)RoundingMode.HALF_UP).multiply(new BigDecimal("100"));
                BigDecimal selfRate = NumberUtil.div((Number)workProcessStage.getSelfNum(), (Number)workProcessStage.getTotalNum(), (int)4, (RoundingMode)RoundingMode.HALF_UP).multiply(new BigDecimal("100"));
                result.setCloseFinishRate(finishRate.doubleValue());
                result.setCloseSelfRate(selfRate.doubleValue());
            }
        }
        if (Objects.equals(search.getIsFcImportanceCompany(), 1)) {
            result.setCityRank("");
            result.setProviRank("");
            result.setCloseCityRank("");
            result.setCloseProviRank("");
        }
        return result;
    }

    private int getCityOrder(AreaModel areaModel, Integer orderBy, GradeDryingProInfoSearchForm search) {
        GradeDryingProInfoSearchForm proviSearch = new GradeDryingProInfoSearchForm();
        proviSearch.setAreaId(null);
        proviSearch.setAreaLevel(null);
        proviSearch.setOrgAreaId(areaModel.getCityId());
        proviSearch.setOrgAreaLevel(Byte.valueOf((byte)2));
        proviSearch.setDataYear(search.getDataYear());
        proviSearch.setGroupBy(areaModel.getLevel());
        proviSearch.setOnlyThislevel(search.getOnlyThislevel());
        proviSearch.setBelongType(GradeUtils.caclBelongType(areaModel.getLevel()));
        List proviGryingProList = (List)this.redisClient.get(CACHE_NAME, "getCityOrder:" + proviSearch.hashCode(), 180L, () -> {
            List<GradeDryingProInfoModel> gradeDryingProInfoModels = ((CompanyGradeV3Mapper)this.dao).gradeDryingProInfo(proviSearch);
            return gradeDryingProInfoModels;
        });
        int cityOrder = this.calcRateAndOder(proviGryingProList, orderBy, areaModel.getId(), search);
        return cityOrder;
    }

    private int getProviOrder(AreaModel areaModel, Integer orderBy, GradeDryingProInfoSearchForm search) {
        GradeDryingProInfoSearchForm proviSearch = new GradeDryingProInfoSearchForm();
        proviSearch.setAreaId(null);
        proviSearch.setAreaLevel(null);
        proviSearch.setOrderBy(null);
        proviSearch.setOrgAreaId(areaModel.getProvinceId());
        proviSearch.setOrgAreaLevel(Byte.valueOf((byte)1));
        proviSearch.setGroupBy(areaModel.getLevel());
        proviSearch.setDataYear(search.getDataYear());
        proviSearch.setOnlyThislevel(search.getOnlyThislevel());
        proviSearch.setBelongType(GradeUtils.caclBelongType(areaModel.getLevel()));
        List proviGryingProList = (List)this.redisClient.get(CACHE_NAME, "getProviOrder:" + proviSearch.hashCode(), 180L, () -> {
            List<GradeDryingProInfoModel> gradeDryingProInfoModels = ((CompanyGradeV3Mapper)this.dao).gradeDryingProInfo(proviSearch);
            return gradeDryingProInfoModels;
        });
        int cityOrder = this.calcRateAndOder(proviGryingProList, orderBy, areaModel.getId(), search);
        return cityOrder;
    }

    private int calcRateAndOder(List<GradeDryingProInfoModel> proviGryingProList, Integer orderBy, Long areaId, GradeDryingProInfoSearchForm search) {
        if (CollectionUtils.isNotEmpty(proviGryingProList)) {
            proviGryingProList = proviGryingProList.stream().filter(f -> f.getAreaid() != null).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(proviGryingProList)) {
            return 0;
        }
        for (GradeDryingProInfoModel gradeDryingProInfoModel : proviGryingProList) {
            BigDecimal finishRate = NumberUtil.div((Number)gradeDryingProInfoModel.getFinishNum(), (Number)gradeDryingProInfoModel.getAnum(), (int)4, (RoundingMode)RoundingMode.HALF_UP).multiply(new BigDecimal("100"));
            gradeDryingProInfoModel.setFinishRate(finishRate.doubleValue());
            Integer targetFinishRate = GradeUtils.getFinishRateStageTarget();
            gradeDryingProInfoModel.setStageTaget(targetFinishRate + "%");
            BigDecimal selfRate = NumberUtil.div((Number)gradeDryingProInfoModel.getSelfNum(), (Number)gradeDryingProInfoModel.getAnum(), (int)4, (RoundingMode)RoundingMode.HALF_UP).multiply(new BigDecimal("100"));
            gradeDryingProInfoModel.setSelfRate(selfRate.doubleValue());
            Integer stage = CommonUtil.currStage();
            Boolean onlyThislevel = search.getOnlyThislevel();
            CompanyGradeWorkProgressStage param = new CompanyGradeWorkProgressStage();
            param.setAreaId(gradeDryingProInfoModel.getAreaid());
            if (onlyThislevel == null) {
                param.setThisLevel(Integer.valueOf(2));
            } else if (onlyThislevel.booleanValue()) {
                param.setThisLevel(Integer.valueOf(1));
            }
            gradeDryingProInfoModel.setStageFinish(Boolean.valueOf(false));
            CompanyGradeWorkProgressStage workProcessStage = this.gradeWorkProgressService.getWorkProcessStage(param);
            if (workProcessStage == null) continue;
            if (stage == null) {
                gradeDryingProInfoModel.setStageFinish(Boolean.valueOf(Objects.equals(workProcessStage.getStage3(), 1)));
                continue;
            }
            if (stage == 1) {
                gradeDryingProInfoModel.setStageFinish(Boolean.valueOf(Objects.equals(workProcessStage.getStage1(), 1)));
                continue;
            }
            if (stage == 2) {
                gradeDryingProInfoModel.setStageFinish(Boolean.valueOf(Objects.equals(workProcessStage.getStage2(), 1)));
                continue;
            }
            if (stage != 3) continue;
            gradeDryingProInfoModel.setStageFinish(Boolean.valueOf(Objects.equals(workProcessStage.getStage3(), 1)));
        }
        List<Object> result = new ArrayList();
        result = Objects.equals(orderBy, 2) ? proviGryingProList.stream().sorted(Comparator.comparing(GradeDryingProInfoModel::getSelfRate).reversed().thenComparing(GradeDryingProInfoModel::getAreaid)).collect(Collectors.toList()) : proviGryingProList.stream().sorted(Comparator.comparing(GradeDryingProInfoModel::getFinishRate).reversed().thenComparing(GradeDryingProInfoModel::getAreaid)).collect(Collectors.toList());
        boolean bl = true;
        for (int i = 0; i < result.size(); ++i) {
            int n;
            GradeDryingProInfoModel gradeDryingProInfoModel = (GradeDryingProInfoModel)result.get(i);
            double rate = 0.0;
            double preRate = 0.0;
            if (Objects.equals(orderBy, 2)) {
                rate = gradeDryingProInfoModel.getSelfRate();
                if (i > 0) {
                    preRate = ((GradeDryingProInfoModel)result.get(i - 1)).getSelfRate();
                }
            } else {
                rate = gradeDryingProInfoModel.getFinishRate();
                if (i > 0) {
                    preRate = ((GradeDryingProInfoModel)result.get(i - 1)).getFinishRate();
                }
            }
            if (i > 0 && rate != preRate) {
                n = i + 1;
            }
            if (!Objects.equals(gradeDryingProInfoModel.getAreaid(), areaId)) continue;
            return n;
        }
        return 0;
    }

    public PageInfo<CompanyGradeVoV3> caegoryListDataV311PageInfo(JqGridParam param, GradeSearchV311 search) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<CompanyGradeVoV3> list = this.caegoryListDataV311(search);
        PageInfo page = new PageInfo(list);
        return page;
    }

    public PageInfo<CompanyGradeVoV314> caegoryListDataV314PageInfo(JqGridParam param, GradeSearchV314 search) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<CompanyGradeVoV314> list = this.caegoryListDataV314(search);
        PageInfo page = new PageInfo(list);
        return page;
    }

    public PageInfo<CompanyGradeVoV314> caegoryListDataV314PageInfo2(JqGridParam param, GradeSearchV314 search) {
        Long orgId;
        Organization organization;
        PageHelper.startPage((int)param.getPage(), (int)param.getRows(), (boolean)false);
        if (StringUtils.isNotEmpty((String)search.getOrganizationId()) && (organization = this.organizationService.getOrgById(orgId = Long.valueOf(Long.parseLong(search.getOrganizationId())))) != null && organization.getSysArea() != null) {
            int level = organization.getSysArea().getLevel().intValue();
            if (level == 1 || level == 2) {
                search.setCalcBelongType(Integer.valueOf(level));
            } else {
                search.setCalcBelongType(Integer.valueOf(0));
            }
        }
        List<CompanyGradeVoV314> list = this.caegoryListDataV3142(search);
        PageInfo page = new PageInfo(list);
        return page;
    }

    public PageInfo<CompanyGradeHis> pageCompanyGradeHisList(JqGridParam param, CompanyGradeHis search) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<CompanyGradeHis> companyGradeHisList = ((CompanyGradeV3Mapper)this.dao).getCompanyGradeHisList(search);
        PageInfo page = new PageInfo(companyGradeHisList);
        return page;
    }

    public long countWaitCheck(GradeSearchV314 search) {
        return ((CompanyGradeV3Mapper)this.dao).countWaitCheck(search);
    }

    public long countNoEvaluate(GradeSearchV314 search) {
        return ((CompanyGradeV3Mapper)this.dao).countNoEvaluate(search);
    }

    public long collectCompanyGradeV3Rec(GradeSearchV314 search) {
        return ((CompanyGradeV3Mapper)this.dao).collectCompanyGradeV3Rec(search);
    }

    public CompanyGradeV3CollectVo collectGradeV3Info(GradeSearchV314 search) {
        search.setGradeYear(Integer.valueOf(DateUtils.getGradeYear()));
        CompanyGradeV3CollectVo collectWorkTipsInfo = ((CompanyGradeV3Mapper)this.dao).collectWorkTipsInfo(search);
        return collectWorkTipsInfo;
    }

    @Transactional(readOnly=false)
    public void validCompanyState(CompanyGradeV3 companyGradeV3, Integer evaluateCheckState, Integer judgeCheckState, Integer riskCheckState) {
        if (companyGradeV3 == null && companyGradeV3.getCid() == null) {
            return;
        }
        Long cid = companyGradeV3.getCid();
        if (companyGradeV3.getId() == null) {
            Example e = new Example(CompanyGradeV3.class);
            e.createCriteria().andEqualTo("cid", (Object)cid);
            e.createCriteria().andEqualTo("isValid", (Object)true);
            companyGradeV3 = (CompanyGradeV3)this.getOneByExample(e);
        }
        if (companyGradeV3 == null) {
            this.companyGradeV3RefreshService.refreshCompanyGradeByCid(cid, null);
        } else {
            Integer evaluateCheckState1 = companyGradeV3.getEvaluateCheckState();
            Integer riskCheckState1 = companyGradeV3.getRiskCheckState();
            Integer jugdeCheckState = companyGradeV3.getJugdeCheckState();
            boolean refreshFlag = false;
            if (evaluateCheckState != null && !Objects.equals(evaluateCheckState, evaluateCheckState1)) {
                refreshFlag = true;
            }
            if (riskCheckState != null && !Objects.equals(riskCheckState, riskCheckState1)) {
                refreshFlag = true;
            }
            if (judgeCheckState != null && !Objects.equals(judgeCheckState, jugdeCheckState)) {
                refreshFlag = true;
            }
            if (refreshFlag) {
                this.companyGradeV3RefreshService.refreshCompanyGradeByCid(cid, null);
            }
        }
    }

    public List<GradeV3CollectAreaModel> collectGradeCaseInfo(GradeV3CollectAreaParam param) {
        Integer caseType = param.getCaseType();
        AreaModel area = param.getArea();
        String order = param.getSort();
        if (caseType == null || area == null || area.getId() == null || area.getLevel() == null) {
            return Collections.emptyList();
        }
        if (StringUtils.isBlank((CharSequence)order)) {
            order = "desc";
        }
        param.setSort(order);
        param.setOnlyThislevel(null);
        if (caseType == 2 || caseType == 3) {
            if (area != null && area.getLevel() != null && area.getLevel() > 1) {
                param.setOnlyThislevel(Boolean.valueOf(true));
            }
            return ((CompanyGradeV3Mapper)this.dao).collectGradeCaseInfo(param);
        }
        if (caseType == 4) {
            return ((CompanyGradeV3Mapper)this.dao).collectGradeCaseSelfInfo(param);
        }
        if (caseType == 5) {
            return ((CompanyGradeV3Mapper)this.dao).collectPreYearGradeCaseSelfInfo(param);
        }
        return Collections.emptyList();
    }

    public String collectGradeCaseSelfInfoByAreaId(Long areaId, Integer year, Boolean onlyThislevel, Byte systemDeploymentSource, Integer isFcyth) {
        if (areaId == null) {
            return "-";
        }
        AreaModel areaById = this.areaProvideService.getAreaById(areaId);
        if (areaById == null) {
            return "-";
        }
        List<GradeV3CollectAreaModel> gradeV3CollectAreaModels = ((CompanyGradeV3Mapper)this.dao).collectGradeCaseSelfInfoByAreaId(areaById, 1, year, onlyThislevel, systemDeploymentSource, isFcyth);
        if (CollectionUtils.isNotEmpty(gradeV3CollectAreaModels)) {
            GradeV3CollectAreaModel gradeV3CollectAreaModel = gradeV3CollectAreaModels.get(0);
            String value = gradeV3CollectAreaModel.getValue();
            return value;
        }
        return "-";
    }

    public String collectGradeCaseSelfInfoByAreaIdBackup(AreaModel areaModel, Integer year, Boolean onlyThislevel) {
        if (areaModel == null) {
            return "-";
        }
        List<GradeV3CollectAreaModel> gradeV3CollectAreaModels = ((CompanyGradeV3Mapper)this.dao).collectGradeCaseSelfInfoByAreaIdBackup(areaModel, 1, year, onlyThislevel);
        if (CollectionUtils.isNotEmpty(gradeV3CollectAreaModels)) {
            GradeV3CollectAreaModel gradeV3CollectAreaModel = gradeV3CollectAreaModels.get(0);
            String value = gradeV3CollectAreaModel.getValue();
            return value;
        }
        return "-";
    }

    public Map<Long, String> collectGradeCaseSelfInfoByParentId(Long parentId, Integer year, Boolean onlyThislevel, Byte systemDeploymentSource, Integer isFcyth) {
        if (parentId == null) {
            return MapUtils.EMPTY_MAP;
        }
        AreaModel areaById = this.areaProvideService.getAreaById(parentId);
        if (areaById == null) {
            return MapUtils.EMPTY_MAP;
        }
        GradeV3CollectAreaParam param = new GradeV3CollectAreaParam();
        param.setArea(areaById);
        param.setDataYear(Integer.valueOf(1));
        param.setGradeYear(year);
        param.setOnlyThislevel(onlyThislevel);
        param.setSystemDeploymentSource(systemDeploymentSource);
        param.setIsFcyth(isFcyth);
        List<GradeV3CollectAreaModel> gradeV3CollectAreaModels = ((CompanyGradeV3Mapper)this.dao).collectGradeCaseSelfInfo(param);
        if (CollectionUtils.isNotEmpty(gradeV3CollectAreaModels)) {
            Map<Long, String> collect = gradeV3CollectAreaModels.stream().collect(Collectors.toMap(k -> k.getAreaId(), v -> v.getValue()));
            return collect;
        }
        return MapUtils.EMPTY_MAP;
    }

    public Map<Long, String> collectGradeCaseSelfInfoByParentIdBackup(AreaModel areaModel, Integer year, Boolean onlyThislevel) {
        if (areaModel == null) {
            return MapUtils.EMPTY_MAP;
        }
        GradeV3CollectAreaParam param = new GradeV3CollectAreaParam();
        param.setArea(areaModel);
        param.setDataYear(Integer.valueOf(1));
        param.setGradeYear(year);
        param.setOnlyThislevel(onlyThislevel);
        List<GradeV3CollectAreaModel> gradeV3CollectAreaModels = ((CompanyGradeV3Mapper)this.dao).collectGradeCaseSelfInfoBackup(param);
        if (CollectionUtils.isNotEmpty(gradeV3CollectAreaModels)) {
            Map<Long, String> collect = gradeV3CollectAreaModels.stream().collect(Collectors.toMap(k -> k.getAreaId(), v -> v.getValue()));
            return collect;
        }
        return MapUtils.EMPTY_MAP;
    }

    public List<GradeV3CollectAreaModel> collectStreetGradeCaseSelfInfo(Long areaId, Integer year, Boolean onlyThislevel, List<Long> streetList, Byte systemDeploymentSource, Integer isFcyth) {
        if (areaId == null) {
            return Collections.emptyList();
        }
        AreaModel areaById = this.areaProvideService.getAreaById(areaId);
        if (areaById == null) {
            return Collections.emptyList();
        }
        List<GradeV3CollectAreaModel> gradeV3CollectAreaModels = ((CompanyGradeV3Mapper)this.dao).collectStreetGradeCaseSelfInfo(areaById, year, "", onlyThislevel, streetList, systemDeploymentSource, isFcyth);
        return gradeV3CollectAreaModels;
    }

    public List<GradeV3CollectAreaModel> collectStreetGradeCaseSelfInfoBackup(AreaModel areaModel, Integer year, Boolean onlyThislevel, List<Long> streetList) {
        if (areaModel == null) {
            return Collections.emptyList();
        }
        List<GradeV3CollectAreaModel> gradeV3CollectAreaModels = ((CompanyGradeV3Mapper)this.dao).collectStreetGradeCaseSelfInfoBackup(areaModel, 1, year, "", onlyThislevel, streetList);
        return gradeV3CollectAreaModels;
    }

    public ComBusinessCountVo getBusinessStateComCount(GradeSearchV314 search) {
        Long orgId;
        Organization organization;
        if (StringUtils.isNotEmpty((String)search.getOrganizationId()) && (organization = this.organizationService.getOrgById(orgId = Long.valueOf(Long.parseLong(search.getOrganizationId())))) != null && organization.getSysArea() != null) {
            int level = organization.getSysArea().getLevel().intValue();
            if (level == 1 || level == 2) {
                search.setCalcBelongType(Integer.valueOf(level));
            } else {
                search.setCalcBelongType(Integer.valueOf(0));
            }
        }
        return ((CompanyGradeV3Mapper)this.dao).getBusinessStateComCount(search);
    }

    public List<ComBusinessCountVo> getBusinessStateComCountBatch(GradeSearchV314 search) {
        Long orgId;
        Organization organization;
        if (StringUtils.isNotEmpty((String)search.getOrganizationId()) && (organization = this.organizationService.getOrgById(orgId = Long.valueOf(Long.parseLong(search.getOrganizationId())))) != null && organization.getSysArea() != null) {
            int level = organization.getSysArea().getLevel().intValue();
            if (level == 1 || level == 2) {
                search.setCalcBelongType(Integer.valueOf(level));
            } else {
                search.setCalcBelongType(Integer.valueOf(0));
            }
        }
        return ((CompanyGradeV3Mapper)this.dao).getBusinessStateComCountBatch(search);
    }

    public ComBusinessCountVo getBusinessStateComCountToHome(GradeSearchV314 search) {
        return ((CompanyGradeV3Mapper)this.dao).getBusinessStateComCountToHome(search);
    }

    public Set<Long> getComCidToHome(GradeSearchV314 search) {
        return ((CompanyGradeV3Mapper)this.dao).getComCidToHome(search);
    }

    public PageInfo<CompanyGradeWorkProgress> pageWorkProcess(JqGridParam param, WorkProgressStatisticSearchVo searchVo) {
        return this.gradeWorkProgressService.pageWorkProcess2(param, searchVo);
    }

    public List<CompanyGradeWorkProgress> listWorkProcess(WorkProgressStatisticSearchVo searchVo) {
        return this.gradeWorkProgressService.listWorkProcess2(searchVo);
    }

    public void handGradeHisData() {
        this.hisDataHandleService.handGradeHisData();
    }

    @Transactional(readOnly=false)
    public Integer saveClassifySelfExaminationRecord(List<ClassifySelfExaminationRecord> recordList) {
        if (CollectionUtils.isNotEmpty(recordList)) {
            for (ClassifySelfExaminationRecord item : recordList) {
                if (item == null) continue;
                item.setId(Long.valueOf(this.idworker.nextId()));
                item.setCreateTime(new Date());
                item.setUpdateTime(new Date());
            }
            return ((CompanyGradeV3Mapper)this.dao).saveClassifySelfExaminationRecord(recordList);
        }
        return 0;
    }

    public PageInfo<ClassifySelfExaminationRecord> pageClassifySelfExaminationRecord(JqGridParam param, ClassifySelfExaminationRecord searchVo) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<ClassifySelfExaminationRecord> recordList = ((CompanyGradeV3Mapper)this.dao).selectClassifySelfExaminationRecord(searchVo);
        return new PageInfo(recordList);
    }

    @Transactional(readOnly=false)
    public void saveClassifySelfExaminationRecordByEvaluationId(Long evaluationId) {
        ClassifySelfExaminationRecord recordBySelfJude;
        ArrayList<ClassifySelfExaminationRecord> recordList = new ArrayList<ClassifySelfExaminationRecord>();
        SelfInspectionRiskAssessmentReportInfo report = (SelfInspectionRiskAssessmentReportInfo)this.selfInspectionRiskAssessmentReportInfoService.getById(evaluationId);
        if (report == null || report.getStatus() != 4) {
            return;
        }
        CompanyHsePreventionControlSelfJudge selfJudge = (CompanyHsePreventionControlSelfJudge)this.selfJudgeService.getById(report.getSelfReportId());
        CompanyHsePreventionControlSelfJudge selfJudgeOld = (CompanyHsePreventionControlSelfJudge)this.selfJudgeService.getById(report.getSelfReportOldId());
        RiskExposeEvaluate riskExposeEvaluate = (RiskExposeEvaluate)this.riskExposeEvaluateService.getById((Serializable)report.getExposureReportId());
        RiskExposeEvaluate riskExposeEvaluateOld = (RiskExposeEvaluate)this.riskExposeEvaluateService.getById((Serializable)report.getExposureReportOldId());
        if (report.getReportFromYear() == null) {
            this.saveClassifySelfExaminationRecord(this.getDirtyData(report.getId(), "\u81ea\u67e5\u8868ReportFromYear\u4e3a\u7a7a"));
            return;
        }
        if (report.getReportFromYear() == 1) {
            ClassifySelfExaminationRecord recordByRisk = this.getRecordByRisk(riskExposeEvaluate, riskExposeEvaluateOld, report, "1", 1, false);
            recordBySelfJude = this.getRecordBySelfJude(selfJudge, selfJudgeOld, report, "1", 2, false);
            if (recordByRisk != null && recordBySelfJude != null) {
                recordList.add(recordByRisk);
                recordList.add(recordBySelfJude);
            } else {
                this.saveClassifySelfExaminationRecord(this.getDirtyData(report.getId(), "\u5b9a\u671f->risk\u6216self\u4e3a\u7a7a"));
                return;
            }
        }
        if (report.getReportFromYear() == 2) {
            SelfInspectionRiskAssessmentReportInfo beforeReport = (SelfInspectionRiskAssessmentReportInfo)this.selfInspectionRiskAssessmentReportInfoService.getById(report.getChangeFromId());
            if (beforeReport == null) {
                this.saveClassifySelfExaminationRecord(this.getDirtyData(report.getId(), "\u53d8\u66f4->\u65e0\u4ee5\u524d\u7684\u53d8\u66f4\u8868id"));
                return;
            }
            if (report.getChangeReason() == null) {
                this.saveClassifySelfExaminationRecord(this.getDirtyData(report.getId(), "\u53d8\u66f4->\u65e0\u53d8\u66f4\u539f\u56e0"));
                return;
            }
            if (report.getChangeReason().contains("1")) {
                ClassifySelfExaminationRecord recordListByRisk = this.getRecordByRisk(riskExposeEvaluate, riskExposeEvaluateOld, report, "2", 1, true);
                if (recordListByRisk != null) {
                    recordList.add(recordListByRisk);
                } else {
                    this.saveClassifySelfExaminationRecord(this.getDirtyData(report.getId(), "\u53d8\u66f4risk->risk\u4e3a\u7a7a"));
                    return;
                }
            }
            if (report.getChangeReason().contains("2")) {
                recordBySelfJude = this.getRecordBySelfJude(selfJudge, selfJudgeOld, report, "3", 2, true);
                if (recordBySelfJude != null) {
                    recordList.add(recordBySelfJude);
                } else {
                    this.saveClassifySelfExaminationRecord(this.getDirtyData(report.getId(), "\u53d8\u66f4self->self\u4e3a\u7a7a"));
                    return;
                }
            }
        }
        Integer record = this.saveClassifySelfExaminationRecord(recordList);
    }

    public void handSelfAndRiskData() {
        this.logger.info("\u7ba1\u7406\u72b6\u51b5\u7b49\u7ea7\u548c\u98ce\u9669\u7b49\u7ea7\u5386\u53f2\u8bb0\u5f55\u8f6c\u6362\u5f00\u59cb");
        Date date = new Date();
        List<Long> reportIdList = ((CompanyGradeV3Mapper)this.dao).getAllNeedHandSelfAndRiskData();
        for (int a = 0; a < reportIdList.size(); a += 100) {
            int length = a + 100;
            if (length > reportIdList.size()) {
                length = reportIdList.size();
            }
            List<Long> newReportIdList = reportIdList.subList(a, length);
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setPropagationBehavior(3);
            TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
            try {
                newReportIdList.forEach(this::saveClassifySelfExaminationRecordByEvaluationId);
                this.transactionManager.commit(status);
                continue;
            }
            catch (Exception e) {
                this.transactionManager.rollback(status);
                e.printStackTrace();
                System.out.println("\u5931\u8d25\u7684\u8fd9\u4e00\u767e\u6761\u662f\uff1a" + String.valueOf(newReportIdList));
            }
        }
        this.logger.info("\u7ba1\u7406\u72b6\u51b5\u7b49\u7ea7\u548c\u98ce\u9669\u7b49\u7ea7\u5386\u53f2\u8bb0\u5f55\u8f6c\u6362\u7ed3\u675f\uff0c\u5e76\u4e14\u5f00\u59cb\u65f6\u95f4" + String.valueOf(date) + ",\u7ed3\u675f\u65f6\u95f4" + String.valueOf(new Date()));
    }

    public ClassifySelfExaminationRecord getRecordByRisk(RiskExposeEvaluate riskExposeEvaluate, RiskExposeEvaluate riskExposeEvaluateOld, SelfInspectionRiskAssessmentReportInfo report, String changeReason, Integer changeType, Boolean falge) {
        if (riskExposeEvaluate != null && riskExposeEvaluate.getIsValid().booleanValue() && riskExposeEvaluate.getReportStatus() == 4) {
            ClassifySelfExaminationRecord record = new ClassifySelfExaminationRecord();
            record.setCid(report.getCid());
            record.setChangeReason(changeReason);
            record.setChangeTime(report.getUpdateDate());
            if (riskExposeEvaluateOld != null && riskExposeEvaluateOld.getIsValid().booleanValue() && riskExposeEvaluateOld.getReportStatus() == 4) {
                if (falge.booleanValue() && Objects.equals(riskExposeEvaluate.getRiskLevel(), riskExposeEvaluateOld.getRiskLevel())) {
                    return null;
                }
                record.setBeforeState(riskExposeEvaluateOld.getRiskLevel());
            }
            record.setAfterState(riskExposeEvaluate.getRiskLevel());
            record.setChangeType(changeType);
            record.setSourceId(report.getId());
            record.setIsValid(Boolean.valueOf(true));
            return record;
        }
        return null;
    }

    public ClassifySelfExaminationRecord getRecordBySelfJude(CompanyHsePreventionControlSelfJudge selfJudge, CompanyHsePreventionControlSelfJudge selfJudgeOld, SelfInspectionRiskAssessmentReportInfo report, String changeReason, Integer changeType, Boolean falge) {
        if (selfJudge != null && selfJudge.getIsValid().booleanValue() && selfJudge.getStatus() == 4) {
            ClassifySelfExaminationRecord record = new ClassifySelfExaminationRecord();
            record.setCid(report.getCid());
            record.setChangeReason(changeReason);
            record.setChangeTime(report.getUpdateDate());
            if (selfJudge.getJudgeLevel() == null) {
                return null;
            }
            record.setAfterState(Integer.valueOf(selfJudge.getJudgeLevel().intValue()));
            if (selfJudgeOld != null && selfJudgeOld.getJudgeLevel() != null && selfJudgeOld.getIsValid().booleanValue() && selfJudgeOld.getStatus() == 4) {
                if (falge.booleanValue() && selfJudge.getJudgeLevel() != null && Objects.equals(selfJudge.getJudgeLevel().intValue(), selfJudgeOld.getJudgeLevel().intValue())) {
                    return null;
                }
                record.setBeforeState(Integer.valueOf(selfJudgeOld.getJudgeLevel().intValue()));
            }
            record.setChangeType(changeType);
            record.setSourceId(report.getId());
            record.setIsValid(Boolean.valueOf(true));
            return record;
        }
        return null;
    }

    public List<ClassifySelfExaminationRecord> getDirtyData(Long sourceId, String changeReason) {
        ArrayList<ClassifySelfExaminationRecord> list = new ArrayList<ClassifySelfExaminationRecord>();
        ClassifySelfExaminationRecord record = new ClassifySelfExaminationRecord();
        record.setChangeReason(changeReason);
        record.setSourceId(sourceId);
        record.setIsValid(Boolean.valueOf(false));
        list.add(record);
        return list;
    }

    public Integer getBusinessStateComCountV322(GradeSearchV314 search) {
        List<Long> collect = this.getSuperviseCidList(search);
        if (CollectionUtils.isEmpty(collect)) {
            return 0;
        }
        return collect.size();
    }

    public ComBusinessCountVo getBusinessStateComCountToHomeV322(GradeSearchV314 search) {
        ComBusinessCountVo vo = new ComBusinessCountVo();
        List<Long> superviseCidList = this.getSuperviseCidList(search);
        List<Long> newComList = ((CompanyGradeV3Mapper)this.dao).getNewComData(search);
        superviseCidList.addAll(newComList);
        List collect = superviseCidList.stream().distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            vo.setTotalCount(Integer.valueOf(collect.size()));
        }
        return vo;
    }

    private List<Long> getSuperviseCidList(GradeSearchV314 search) {
        List<Long> needGradeData = ((CompanyGradeV3Mapper)this.dao).getAllNeedGradeData(search);
        return needGradeData.stream().distinct().collect(Collectors.toList());
    }

    public List<CompanyGradeWorkProgress> collectClasscImpIndu(WorkProgressStatisticSearchVo search) {
        return ((CompanyGradeV3Mapper)this.dao).collectClasscImpIndu(search);
    }

    public HomeEnergyEfficiencyVo getCompanyClassifyRate(HomeIndexSearchVo searchVo, HomeEnergyEfficiencyVo efficiencyVo) {
        WorkProgressStatisticSearchVo statisticSearchVo = new WorkProgressStatisticSearchVo().setDataRange(Byte.valueOf((byte)1)).setAreaId(Long.valueOf(330000000000L)).setAreaLevel(Byte.valueOf((byte)1)).setOrgAreaId(Long.valueOf(330000000000L)).setOrgAreaLevel(Byte.valueOf((byte)1)).setAreaName("\u6d59\u6c5f\u7701").setParentId(Long.valueOf(330000000000L)).setPareaLevel(Byte.valueOf((byte)1)).setChildData(Boolean.valueOf(true)).setContainByIndu(Boolean.valueOf(false)).setContainLess3Result(Boolean.valueOf(true)).setThisLevel(Boolean.valueOf(false)).setOnlyLaborDispatch(Integer.valueOf(0)).setFilterZero(Boolean.valueOf(true)).setQueryGradeBak("2023");
        List<CompanyGradeWorkProgress> list = this.listWorkProcess(statisticSearchVo);
        if (CollectionUtils.isEmpty(list)) {
            return efficiencyVo;
        }
        List sortList = list.parallelStream().filter(Objects::nonNull).sorted(Comparator.comparing(CompanyGradeWorkProgress::getGradeFinishRate).reversed()).collect(Collectors.toList());
        int score = sortList.size();
        int rank = 1;
        int flag = 1;
        double previous = 1000.0;
        for (CompanyGradeWorkProgress item : sortList) {
            if (item == null) continue;
            if (previous > item.getGradeFinishRate()) {
                rank = flag;
                score = sortList.size() - flag + 1;
            }
            if (searchVo.getChooseAreaId().equals(item.getAreaId())) {
                efficiencyVo.setRate1(String.valueOf(item.getGradeFinishRate()));
                efficiencyVo.setRank1(Integer.valueOf(rank));
                efficiencyVo.setScore1(String.valueOf(score));
                efficiencyVo.setRate8(item.getGradeSelfRate());
                break;
            }
            previous = item.getGradeFinishRate();
            ++flag;
        }
        return efficiencyVo;
    }

    public void workProcessRankTask() {
        List<AreaModel> sysList = ((CompanyGradeV3Mapper)this.dao).getProcessAreas();
        ArrayList<GradeProgressRankModel> resultList = new ArrayList<GradeProgressRankModel>();
        int[] orderArr = new int[]{1, 2};
        for (AreaModel areaModel : sysList) {
            Byte areaLevel = areaModel.getLevel();
            for (int orderBy : orderArr) {
                int proviOrder;
                GradeDryingProInfoSearchForm search = new GradeDryingProInfoSearchForm();
                search.setDataYear(Integer.valueOf(1));
                search.setOrderBy(Integer.valueOf(orderBy));
                search.setAreaId(areaModel.getId());
                search.setAreaLevel(areaModel.getLevel());
                search.setOrgAreaId(areaModel.getId());
                search.setOrgAreaLevel(areaModel.getLevel());
                search.setEnableCache(Boolean.valueOf(true));
                if (Objects.equals(areaLevel, (byte)2)) {
                    search.setOnlyThislevel(null);
                    proviOrder = this.getProviOrder(areaModel, orderBy, search);
                    GradeProgressRankModel gradeProgressRankModel = this.geneGradeProgressRankModel(areaModel.getId(), proviOrder, null, orderBy, 1);
                    resultList.add(gradeProgressRankModel);
                    continue;
                }
                if (!Objects.equals(areaLevel, (byte)3)) continue;
                search.setOnlyThislevel(Boolean.valueOf(true));
                proviOrder = this.getProviOrder(areaModel, orderBy, search);
                int cityOrder = this.getCityOrder(areaModel, orderBy, search);
                GradeProgressRankModel gradeProgressRankModel = this.geneGradeProgressRankModel(areaModel.getId(), proviOrder, cityOrder, orderBy, 2);
                resultList.add(gradeProgressRankModel);
            }
        }
        this.companyGradeV3Service.saveGradeProgressRankModel(resultList);
    }

    private GradeProgressRankModel geneGradeProgressRankModel(Long areaId, Integer proviRank, Integer cityRank, Integer orderBy, Integer belongType) {
        GradeProgressRankModel result = new GradeProgressRankModel();
        result.setId(Long.valueOf(this.idworker.nextId()));
        result.setAreaId(areaId);
        result.setCityrank(cityRank);
        result.setOrderBy(orderBy);
        result.setBelongType(belongType);
        result.setProvirank(proviRank);
        result.setCreateDate(new Date());
        result.setIsValid(Boolean.valueOf(true));
        return result;
    }

    @Transactional(readOnly=false)
    public void saveGradeProgressRankModel(List<GradeProgressRankModel> resultList) {
        if (CollectionUtils.isEmpty(resultList)) {
            return;
        }
        ((CompanyGradeV3Mapper)this.dao).delGradeProgressRankModel();
        List partition = ListUtil.partition(resultList, (int)100);
        for (List gradeProgressRankModels : partition) {
            ((CompanyGradeV3Mapper)this.dao).saveGradeProgressRankModel(gradeProgressRankModels);
        }
    }

    public GradeProgressRankModel getGradeProgressRankModel(Long areaId, Integer belongType, Integer orderBy, Integer dataYear) {
        if (areaId == null || belongType == null || orderBy == null) {
            return null;
        }
        if (dataYear == null) {
            dataYear = 1;
        }
        GradeProgressRankModel param = new GradeProgressRankModel();
        param.setAreaId(areaId);
        param.setBelongType(belongType);
        param.setOrderBy(orderBy);
        return ((CompanyGradeV3Mapper)this.dao).getGradeProgressRankModel(param);
    }

    public List<SysArea> listArea(SysArea param) {
        return this.workProcessMapper.listArea(param);
    }

    public Set<Long> getSuspendCidSet(Long cid) {
        return ((CompanyGradeV3Mapper)this.dao).getSuspendCid(cid);
    }

    public List<Long> countGradeSourceCidList(GradeSearchV314 search) {
        return ((CompanyGradeV3Mapper)this.dao).countGradeSourceCidList(search);
    }

    @Deprecated
    public Pair<Long, Long> getCreditSuperviseComplianceCount(GradeSearchV314 searchParam) {
        if (searchParam == null) {
            return new Pair((Object)0L, (Object)0L);
        }
        Pair<Long, Long> countValue = ((CompanyGradeV3Mapper)this.dao).getCreditSuperviseComplianceCount(searchParam);
        if (countValue == null) {
            return new Pair((Object)0L, (Object)0L);
        }
        return new Pair((Object)((Long)countValue.getKey()), (Object)Convert.toLong((Object)countValue.getValue()));
    }

    public CreditSuperviseComplianceVo getCreditSuperviseComplianceCountNew(GradeSearchV314 searchParam) {
        if (searchParam == null) {
            return new CreditSuperviseComplianceVo();
        }
        return ((CompanyGradeV3Mapper)this.dao).getCreditSuperviseComplianceCountNew(searchParam);
    }

    public List<CompanyGradeV3> getGradeByCids(List<Long> cids) {
        if (CollectionUtils.isEmpty(cids)) {
            return null;
        }
        Example e = new Example(CompanyGradeV3.class);
        e.createCriteria().andIn("cid", cids).andEqualTo("isValid", (Object)true);
        e.selectProperties(new String[]{"grade", "cid"});
        List<CompanyGradeV3> resultList = this.getListByExample(e);
        return resultList;
    }

    public List<CompanyGradeChangeClassc> selectGradeChangeClassc(List<Long> cidList) {
        return ((CompanyGradeV3Mapper)this.dao).selectGradeChangeClassc(cidList);
    }

    public List<Long> listAllDecCids() {
        return ((CompanyGradeV3Mapper)this.dao).listAllDecCids();
    }

    @Transactional(readOnly=false)
    public void delCompanyGradeV3ById(List<Long> gradeIdList) {
        if (CollectionUtils.isEmpty(gradeIdList)) {
            return;
        }
        Example e = new Example(CompanyGradeV3.class);
        e.createCriteria().andIn("id", gradeIdList);
        int i = ((CompanyGradeV3Mapper)this.dao).deleteByExample(e);
    }
}

